#include <DFPlayer_Mini_Mp3.h>
#include <SoftwareSerial.h>

// Создаём программный UART на пинах 10 (RX), 11 (TX) для DFPlayer Mini
SoftwareSerial mp3Serial(10, 11); // RX, TX

int lastHour;

void setup() {
  Serial.begin(9600);    // Для связи с ESP32 (через аппаратный RX/TX)
  mp3Serial.begin(9600); // Для связи с DFPlayer Mini
  
  mp3_set_serial(mp3Serial); // Указываем библиотеке порт для MP3
  delay(100);                // Пауза для инициализации
  mp3_set_volume(10);        // Установите желаемую громкость (0-30)
  
  Serial.println("Arduino Uno MP3 Controller готов.");
  Serial.println("Ожидание команды от ESP32...");
}

void loop() {
  if (Serial.available()) {
    int receivedHour = Serial.parseInt(); // Читаем число из сериал-порта
    
    // Проверяем, что число в допустимом диапазоне (1-12)
    if (receivedHour >= 1 && receivedHour <= 12 and receivedHour != lastHour) {
      Serial.print("Получен час: ");
      Serial.println(receivedHour);
      
      mp3_play(receivedHour);
      lastHour = receivedHour;
    }
  }
}
