// spas.h - массив изображения Спасской башни для ESP32
#ifndef SPAS_H
#define SPAS_H

#include <Arduino.h>

// Размеры изображения в пикселях
#define IMG_WIDTH  240
#define IMG_HEIGHT 320
#define IMG_PIXELS 76800  // 240 * 320

// МАССИВ ИЗОБРАЖЕНИЯ В ФОРМАТЕ RGB565
// ЗАМЕНИТЕ ЭТУ ЗАГЛУШКУ НА ВАШИ 76800 ЗНАЧЕНИЙ!
const uint16_t spasskaya_tower[IMG_PIXELS] PROGMEM = {
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0800, 0x0021, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022, 
	0x0022, 0x0822, 0x0822, 0x0822, 0x0842, 0x0842, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0022, 0x0022, 
	0x0042, 0x0842, 0x0842, 0x0842, 0x0842, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 
	0x0002, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0000, 0x3103, 0x2904, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022, 0x0022, 0x0022, 
	0x0822, 0x0022, 0x0822, 0x0822, 0x0842, 0x0842, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0000, 0x28c2, 0x20a2, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022, 0x0022, 0x0022, 
	0x0822, 0x0022, 0x0822, 0x0822, 0x0842, 0x0842, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0000, 0x1820, 0x1821, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0822, 0x0822, 0x0822, 0x0842, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0021, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 
	0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0800, 0x2840, 0x2882, 0x0801, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022, 
	0x0022, 0x0022, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 
	0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0800, 0x3881, 0x40e3, 0x0821, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022, 
	0x0001, 0x0022, 0x0022, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x1000, 0x3040, 0x38a1, 0x1021, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022, 
	0x0001, 0x0001, 0x0022, 0x0022, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0002, 0x0002, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0000, 
	0x1820, 0x2840, 0x3060, 0x1841, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 
	0x0001, 0x0002, 0x0022, 0x0022, 0x0022, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0842, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x1041, 0x28a3, 0x1841, 0x1020, 0x1000, 0x1001, 0x0801, 0x0800, 0x0800, 
	0x1800, 0x2000, 0x3881, 0x1841, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0022, 0x0022, 0x0022, 0x0822, 0x0822, 0x0822, 0x0822, 0x0842, 0x0842, 0x0842, 0x0842, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0021, 0x0021, 0x0021, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 0x0002, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 
	0x0000, 0x0001, 0x0001, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0820, 0x28a2, 0x38a2, 0x3081, 0x40e2, 0x40c3, 0x3061, 0x3081, 0x2861, 
	0x2020, 0x2820, 0x3040, 0x1840, 0x2062, 0x1841, 0x1001, 0x0801, 0x0801, 0x0821, 0x0801, 0x0821, 0x0822, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0021, 0x0022, 0x0822, 0x0822, 0x0822, 0x0842, 0x0842, 0x0842, 0x0842, 0x0842, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0021, 0x0021, 0x0021, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0021, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022, 0x0022, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 
	0x0000, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x2020, 0x2840, 0x3881, 0x48c3, 0x48c2, 0x5923, 0x5924, 
	0x3881, 0x2820, 0x38a1, 0x3081, 0x3082, 0x3061, 0x3082, 0x3082, 0x40c2, 0x40e3, 0x2061, 0x28c3, 0x20c4, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022, 0x0822, 0x0822, 0x0822, 0x0842, 0x0842, 0x0842, 0x0842, 0x0842, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0021, 0x0021, 0x0021, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 
	0x0000, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1800, 0x3881, 0x3061, 0x2820, 0x3840, 0x50e3, 
	0x40c2, 0x3040, 0x3881, 0x3040, 0x3881, 0x3861, 0x3861, 0x3881, 0x3861, 0x3081, 0x2862, 0x1021, 0x0801, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022, 0x0022, 0x0822, 0x0822, 0x0822, 0x0842, 0x0842, 0x0842, 0x0842, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0021, 0x0021, 0x0021, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 
	0x0000, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0000, 0x0800, 0x1800, 0x3061, 0x50e2, 0x4081, 0x3041, 
	0x3020, 0x50c2, 0x4881, 0x3040, 0x2820, 0x3861, 0x3020, 0x3041, 0x2861, 0x1000, 0x0801, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0842, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0021, 0x0021, 0x0021, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0021, 0x0021, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 
	0x0000, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x2020, 0x40a1, 0x48a1, 0x4061, 
	0x4081, 0x4880, 0x4060, 0x4081, 0x3860, 0x40a2, 0x38a2, 0x2841, 0x1021, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0822, 0x0822, 0x0822, 0x0822, 0x0842, 0x0842, 0x0842, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0021, 0x0021, 0x0021, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0021, 0x0021, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0800, 0x1000, 0x3040, 0x4861, 
	0x3840, 0x48a1, 0x3861, 0x3020, 0x50c2, 0x3081, 0x1000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0022, 0x0022, 0x0822, 0x0822, 0x0822, 0x0822, 0x0842, 0x0842, 0x0842, 0x0842, 0x0842, 0x0842, 
	0x0022, 0x0022, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x1000, 0x3840, 0x4061, 
	0x3860, 0x48c2, 0x3041, 0x2000, 0x4061, 0x40a1, 0x1041, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0022, 0x0022, 0x0822, 0x0822, 0x0022, 0x0022, 0x0822, 0x0022, 0x0842, 0x0842, 0x0042, 0x0042, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0842, 0x0842, 0x0842, 0x0842, 0x0842, 0x0022, 0x0022, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0000, 0x2820, 0x50a1, 0x3840, 
	0x3861, 0x3840, 0x3882, 0x2820, 0x3820, 0x5102, 0x30a2, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0021, 0x0021, 0x0021, 0x0021, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0842, 0x0842, 0x0842, 0x0842, 0x0842, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x1820, 0x4881, 0x4060, 0x3881, 
	0x3861, 0x5102, 0x38a2, 0x2841, 0x3060, 0x4060, 0x48e2, 0x1841, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0021, 0x0021, 0x0021, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0842, 0x0842, 0x0842, 0x0842, 0x0842, 0x0842, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0000, 0x3061, 0x48c2, 0x3061, 0x2881, 
	0x1800, 0x5962, 0x2081, 0x1820, 0x3061, 0x4080, 0x48a1, 0x30c2, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0002, 0x0022, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0842, 0x0842, 0x0842, 0x0842, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x1020, 0x4902, 0x30a2, 0x1000, 0x0000, 
	0x1820, 0x6182, 0x20a2, 0x0000, 0x0800, 0x2020, 0x48c2, 0x4103, 0x1021, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 0x0002, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0021, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0842, 0x0842, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x2082, 0x28c2, 0x0800, 0x0000, 0x0000, 
	0x1820, 0x6181, 0x20a2, 0x0000, 0x0000, 0x0800, 0x2040, 0x4123, 0x3104, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0021, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0842, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0000, 0x0000, 0x0001, 0x0000, 
	0x2040, 0x69c2, 0x28c2, 0x0000, 0x0001, 0x0000, 0x0000, 0x1841, 0x20c3, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 
	0x0001, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 
	0x0842, 0x0842, 0x0842, 0x0022, 0x0022, 0x0842, 0x0842, 0x0022, 0x0022, 0x0022, 0x0022, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0000, 
	0x1800, 0x71c1, 0x3901, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 
	0x0001, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 
	0x0842, 0x0842, 0x0842, 0x0022, 0x0022, 0x0842, 0x0842, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 0x0822, 0x0842, 0x0822, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0800, 
	0x69e3, 0xab24, 0x9327, 0x28e3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0001, 
	0x0001, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 
	0x0842, 0x0842, 0x0842, 0x0022, 0x0842, 0x0842, 0x0842, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0843, 0x0843, 0x0843, 0x0843, 0x0822, 0x0022, 
	0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0820, 
	0x69e3, 0x9a42, 0x92a5, 0x3104, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 
	0x0022, 0x0842, 0x0842, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 0x0022, 0x0843, 0x0843, 0x0843, 0x0842, 0x0842, 0x0022, 0x0022, 
	0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0001, 0x0001, 0x0001, 0x0000, 
	0x2000, 0x7982, 0x7a25, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0842, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0842, 0x0022, 0x0002, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 0x0842, 0x0842, 0x0842, 0x0842, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 0x0021, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022, 0x0022, 0x0800, 
	0x3060, 0x69a3, 0x7246, 0x0820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0842, 0x0022, 0x0002, 0x0022, 0x0022, 
	0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0842, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 
	0x0022, 0x0022, 0x0022, 0x0021, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0021, 0x0021, 0x0001, 
	0x2860, 0x4080, 0x5142, 0x1041, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x2061, 0x3060, 0x4901, 0x1882, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0042, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0800, 
	0x2020, 0x2000, 0x3860, 0x2082, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x2060, 
	0x5961, 0x7203, 0x8264, 0x61e4, 0x1041, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 0x4102, 
	0x8a84, 0x92a4, 0xa304, 0x9348, 0x20a3, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 0x0022, 0x0042, 
	0x0043, 0x0042, 0x0042, 0x0042, 0x0842, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x2020, 
	0x69a3, 0x48a1, 0x79a2, 0x6a05, 0x0821, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022, 0x0022, 0x0022, 0x0042, 
	0x0043, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0042, 0x0842, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0022, 0x0001, 0x2840, 
	0x9b08, 0x5964, 0x8203, 0x8ae8, 0x3145, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0021, 0x0022, 0x0022, 0x0021, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 0x0042, 0x0043, 
	0x0843, 0x0863, 0x0843, 0x0843, 0x0843, 0x0043, 0x0042, 0x0842, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x1842, 0x4924, 
	0x38a1, 0x2861, 0x2840, 0x4103, 0x3125, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 0x0043, 0x0043, 
	0x0843, 0x0043, 0x0043, 0x0043, 0x0843, 0x0042, 0x0042, 0x0842, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x1021, 0x30c3, 
	0x1800, 0x1000, 0x1800, 0x1800, 0x0801, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022, 0x0022, 0x0042, 0x0043, 0x0043, 
	0x0043, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0842, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0002, 0x0000, 0x1000, 
	0x38c1, 0x2861, 0x40c1, 0x5984, 0x1800, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022, 0x0842, 0x0842, 0x0842, 0x0842, 
	0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x1021, 0x2860, 
	0x9b27, 0x7a46, 0x69a3, 0xa348, 0x6a46, 0x28e4, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022, 0x0842, 0x0843, 0x0843, 0x0843, 
	0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0000, 0x5183, 0x61c5, 
	0x5142, 0x5143, 0x3880, 0x4901, 0x7aa7, 0x4186, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0842, 0x0843, 0x0843, 0x0843, 
	0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0822, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0000, 0x59a4, 0x5185, 
	0x1800, 0x1000, 0x1000, 0x1000, 0x2040, 0x1042, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0842, 0x0842, 0x0842, 0x0842, 
	0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0822, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x1000, 0x2020, 
	0x40e2, 0x1840, 0x1820, 0x4963, 0x2881, 0x0800, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0822, 0x0842, 0x0842, 
	0x0842, 0x0842, 0x0842, 0x0842, 0x0842, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0801, 0x1000, 0x2880, 
	0xbc2a, 0x6a26, 0x40c1, 0xccac, 0x7205, 0x59c5, 0x20a2, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0842, 0x0842, 0x0842, 0x0842, 0x0842, 0x0842, 0x0842, 0x0842, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x1841, 0x7246, 0x38e1, 
	0x7a85, 0x59a5, 0x3860, 0x7a05, 0x5942, 0xa3eb, 0x41a6, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 
	0x0002, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0842, 0x0842, 0x0842, 0x0842, 0x0842, 0x0842, 0x0842, 0x0022, 0x0022, 0x0022, 0x0001, 0x30c2, 0x9348, 0x30a2, 
	0x1000, 0x1000, 0x1000, 0x1800, 0x2000, 0x4122, 0x18a2, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0842, 0x0842, 0x0842, 0x0842, 0x0842, 0x0842, 0x0842, 0x0022, 0x0022, 0x0022, 0x0002, 0x1021, 0x2060, 0x1800, 
	0x2020, 0x0800, 0x0800, 0x3081, 0x3081, 0x1000, 0x0800, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 0x0042, 0x0042, 0x0042, 
	0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0842, 0x0842, 0x0842, 0x0842, 0x0842, 0x0842, 0x0022, 0x0842, 0x0842, 0x0822, 0x1001, 0x0800, 0x4102, 
	0x9b89, 0x30e3, 0x1000, 0xa389, 0x9b4a, 0x2020, 0x2081, 0x0842, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 0x0022, 0x0843, 0x0043, 0x0042, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0022, 0x0022, 0x0022, 0x0842, 0x0842, 0x0842, 0x0842, 0x0022, 0x0022, 0x0842, 0x0022, 0x0800, 0x4923, 0x4123, 0x40e1, 
	0xbc4b, 0x51a5, 0x1800, 0x8aa5, 0x8aa7, 0x5122, 0x9bac, 0x2904, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0822, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0822, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0800, 0x8ae7, 0x7a87, 0x1000, 
	0x2860, 0x2041, 0x1000, 0x2000, 0x2800, 0x40c1, 0x7aa8, 0x20c3, 0x0002, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0822, 0x0842, 0x0843, 
	0x0843, 0x0043, 0x0843, 0x0843, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0043, 0x0843, 
	0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0022, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0801, 0x30a1, 0x2881, 0x1000, 
	0x0800, 0x0800, 0x0800, 0x1000, 0x2000, 0x1800, 0x1800, 0x1042, 0x0823, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0042, 
	0x0042, 0x0043, 0x0043, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0042, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x1021, 0x0800, 0x0800, 0x38e1, 
	0x7286, 0x20a2, 0x0000, 0x4143, 0x9328, 0x38e2, 0x1000, 0x1021, 0x0822, 0x0823, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0042, 0x0042, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 0x0001, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x2082, 0x3902, 0x0800, 0x69e4, 
	0xd50d, 0x3964, 0x0000, 0x59c4, 0xcc8c, 0x5964, 0x38a1, 0x7ac9, 0x20a3, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 
	0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0042, 
	0x0042, 0x0042, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0000, 0x51a5, 0x9bca, 0x1840, 0x2860, 
	0x5183, 0x1861, 0x0000, 0x2020, 0x48c1, 0x2820, 0x5143, 0x9b8b, 0x28a3, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0042, 
	0x0043, 0x0043, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0022, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x3902, 0x51a3, 0x1820, 0x0800, 
	0x0800, 0x0800, 0x0000, 0x0800, 0x1000, 0x1800, 0x2020, 0x30a1, 0x1862, 0x0822, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0042, 0x0043, 0x0043, 0x0863, 0x0863, 0x0863, 0x0842, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0042, 
	0x0043, 0x0043, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0002, 0x0821, 0x2882, 0x1000, 0x1000, 0x38a1, 
	0x4122, 0x1020, 0x0000, 0x1000, 0x4102, 0x5184, 0x1820, 0x1000, 0x1001, 0x0822, 0x0023, 0x0022, 0x0022, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0042, 0x0043, 0x0843, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0843, 0x0843, 0x0843, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0002, 0x0001, 0x0001, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0002, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0042, 0x0042, 0x0022, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0002, 0x0801, 0x2020, 0x0800, 0x0800, 0x9307, 
	0xccad, 0x30e3, 0x0000, 0x2040, 0xb429, 0xb40b, 0x2040, 0x2881, 0x51a5, 0x1842, 0x0023, 0x0023, 0x0022, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0043, 0x0843, 0x0843, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0843, 0x0843, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 
	0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x1000, 0x7a66, 0x4144, 0x0800, 0x5942, 
	0x8286, 0x2081, 0x0000, 0x1800, 0x6182, 0x5942, 0x2000, 0x61c4, 0xac0d, 0x20a2, 0x0002, 0x0023, 0x0022, 0x0002, 0x0002, 0x0001, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 
	0x0043, 0x0843, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0843, 0x0843, 0x0843, 0x0823, 0x0022, 0x0002, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 
	0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0022, 0x0042, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 0x0001, 0x0002, 0x0001, 0x1840, 0x82c8, 0x4144, 0x1000, 0x1800, 
	0x1800, 0x0800, 0x0000, 0x0800, 0x1000, 0x2000, 0x1800, 0x3060, 0x4943, 0x2082, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 
	0x0043, 0x0843, 0x0863, 0x0863, 0x0863, 0x0863, 0x0843, 0x0843, 0x0842, 0x0843, 0x0843, 0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0042, 0x0043, 0x0043, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 0x0001, 0x0002, 0x0001, 0x2062, 0x1820, 0x1000, 0x1820, 0x3080, 
	0x2860, 0x0800, 0x0000, 0x0800, 0x2020, 0x40e1, 0x2060, 0x1000, 0x1800, 0x1042, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 
	0x0042, 0x0043, 0x0043, 0x0843, 0x0843, 0x0843, 0x0043, 0x0843, 0x0842, 0x0842, 0x0043, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x2041, 0x1000, 0x0000, 0x1800, 0xabc8, 
	0xabea, 0x1861, 0x0000, 0x0800, 0x6a04, 0xdd4e, 0x6226, 0x0800, 0x2040, 0x2062, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0042, 0x0022, 
	0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0043, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0022, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x4102, 0x49a4, 0x0800, 0x1800, 0x92c5, 
	0x9307, 0x1040, 0x0000, 0x0800, 0x5142, 0x9327, 0x4123, 0x1000, 0x6a04, 0x8b6a, 0x1042, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 
	0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x7a86, 0x9bab, 0x0820, 0x1000, 0x2800, 
	0x2820, 0x0800, 0x0000, 0x0800, 0x1000, 0x2000, 0x2020, 0x1820, 0x5982, 0x7aa7, 0x1042, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0043, 0x0022, 0x0022, 0x0002, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x1841, 0x40c1, 0x2860, 0x1000, 0x1800, 0x2000, 
	0x1800, 0x0800, 0x0000, 0x0000, 0x1000, 0x2000, 0x2840, 0x1820, 0x1800, 0x2020, 0x1042, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0042, 0x0022, 0x0002, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0042, 0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x1842, 0x2041, 0x0800, 0x0800, 0x2860, 0x9b47, 
	0x7246, 0x1020, 0x0000, 0x0000, 0x1820, 0x9b88, 0xa3eb, 0x1861, 0x1000, 0x1800, 0x1021, 0x0802, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0043, 0x0843, 0x0043, 0x0042, 0x0022, 
	0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 
	0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0022, 0x0022, 0x0022, 0x0042, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x1800, 0x3080, 0x0820, 0x0800, 0x38a0, 0xbbe8, 
	0x9307, 0x1041, 0x0000, 0x0000, 0x2020, 0xa367, 0x9307, 0x1860, 0x0800, 0x5183, 0x6247, 0x0822, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0042, 
	0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0042, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0042, 0x0022, 0x0022, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x4102, 0xb42b, 0x2903, 0x0000, 0x2020, 0x4060, 
	0x4902, 0x0820, 0x0000, 0x0000, 0x1000, 0x3020, 0x3080, 0x1840, 0x1000, 0x7223, 0x938b, 0x1062, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0042, 
	0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0842, 0x0042, 0x0042, 0x0042, 0x0042, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0042, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 0x0042, 0x0043, 0x0043, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x1001, 0x4901, 0x6a24, 0x1881, 0x0800, 0x1800, 0x2000, 
	0x1000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x1800, 0x1020, 0x1840, 0x2860, 0x30c2, 0x1042, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0043, 0x0043, 0x0042, 0x0042, 
	0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 0x0043, 0x0843, 0x0043, 0x0843, 0x0043, 0x0043, 0x0043, 0x0042, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0863, 0x0863, 0x0843, 0x0043, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x1821, 0x40e2, 0x1000, 0x0000, 0x0800, 0x3080, 0x69e3, 
	0x38e2, 0x0000, 0x0000, 0x0000, 0x0000, 0x38c1, 0x9328, 0x4143, 0x1020, 0x0800, 0x1000, 0x0821, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0042, 
	0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0043, 0x0043, 0x0042, 0x0042, 
	0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0001, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 0x0843, 0x0843, 0x0843, 0x0863, 0x0863, 0x0843, 0x0043, 0x0043, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0884, 0x0883, 0x0863, 0x0863, 0x0863, 0x0043, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0801, 0x2840, 0x0800, 0x0000, 0x0000, 0x5162, 0xdd4c, 
	0x82a7, 0x0800, 0x0000, 0x0000, 0x0000, 0x61a2, 0xdcec, 0x7287, 0x0820, 0x0820, 0x2880, 0x28c1, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 
	0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0843, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0043, 0x0043, 0x0042, 0x0042, 
	0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0043, 0x0843, 0x0843, 0x0863, 0x0843, 0x0043, 0x0043, 0x0022, 
	0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x1084, 0x1084, 0x1084, 0x1084, 0x0883, 0x0883, 0x0863, 0x0863, 0x0842, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x1820, 0x7a86, 0x3103, 0x0000, 0x0800, 0x3060, 0x6982, 
	0x5943, 0x0800, 0x0000, 0x0000, 0x0000, 0x3040, 0x5901, 0x38c1, 0x0820, 0x0800, 0x7223, 0x9baa, 0x0842, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0843, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0043, 0x0042, 0x0042, 0x0042, 0x0042, 
	0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0043, 0x0843, 0x0863, 0x0843, 0x0843, 0x0843, 0x0042, 
	0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x10a4, 0x10a4, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1083, 0x0863, 0x0822, 0x0022, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x2840, 0xab88, 0x49a5, 0x0000, 0x0020, 0x2000, 0x3020, 
	0x2840, 0x0800, 0x0000, 0x0000, 0x0000, 0x1000, 0x1800, 0x2040, 0x1040, 0x1000, 0x48e1, 0x6a26, 0x1062, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 
	0x0042, 0x0042, 0x0042, 0x0843, 0x0843, 0x0843, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0843, 0x0843, 0x0042, 0x0042, 0x0042, 
	0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0043, 0x0843, 0x0843, 0x0843, 0x0843, 0x0043, 
	0x0023, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x1083, 0x1083, 0x1083, 0x1083, 0x1083, 0x1083, 0x1083, 0x1084, 0x1084, 0x1084, 0x0863, 0x0843, 0x0002, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0801, 0x3881, 0x48a0, 0x1840, 0x0020, 0x0820, 0x2840, 0x40a0, 
	0x2020, 0x0000, 0x0000, 0x0000, 0x0000, 0x1800, 0x5141, 0x61c3, 0x2081, 0x0820, 0x1000, 0x2061, 0x1062, 0x0001, 0x0002, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 
	0x0022, 0x0022, 0x0043, 0x0843, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0042, 0x0042, 0x0843, 0x0843, 0x0042, 0x0042, 0x0042, 
	0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x1083, 0x1083, 0x1083, 0x1083, 0x1083, 0x1083, 0x1084, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0863, 0x0022, 0x0022, 0x0002, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0800, 0x38c2, 0x1820, 0x0800, 0x0840, 0x0000, 0x4922, 0xc449, 
	0x7246, 0x0820, 0x0000, 0x0000, 0x0000, 0x2040, 0xbbe7, 0xc46a, 0x3903, 0x0820, 0x1020, 0x1800, 0x1000, 0x0001, 0x0001, 0x0002, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0042, 0x0043, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 
	0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0863, 0x0843, 0x0022, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0800, 0x40e2, 0x2081, 0x0000, 0x0020, 0x0800, 0x40e0, 0xa326, 
	0x7226, 0x0800, 0x0000, 0x0000, 0x0000, 0x1800, 0x6162, 0x69c3, 0x2081, 0x0020, 0x0800, 0x5982, 0x72c8, 0x0842, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 
	0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x1084, 0x0863, 0x0843, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x1000, 0x9b28, 0x7ac8, 0x0000, 0x0000, 0x0820, 0x2820, 0x3840, 
	0x2840, 0x0800, 0x0000, 0x0000, 0x0000, 0x1000, 0x2000, 0x3040, 0x1860, 0x0840, 0x0800, 0x69e3, 0x8b08, 0x1042, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 
	0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x1084, 0x0863, 0x0863, 0x0843, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x2020, 0x71e4, 0x51a4, 0x0000, 0x0000, 0x0820, 0x2020, 0x2820, 
	0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x2020, 0x38a0, 0x2060, 0x0840, 0x0820, 0x2040, 0x38e2, 0x1883, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0023, 0x0022, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 
	0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0002, 
	0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x1084, 0x1084, 0x1084, 0x0863, 0x0863, 
	0x0022, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x3082, 0x3060, 0x1000, 0x0820, 0x0020, 0x0800, 0x5162, 0x9b67, 
	0x4103, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5942, 0xcc6a, 0x72a6, 0x0820, 0x0840, 0x1020, 0x1020, 0x0801, 0x0002, 0x0002, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0042, 
	0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 
	0x10a4, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x10a4, 0x10a4, 0x1084, 0x1084, 0x1084, 0x0884, 0x0863, 0x0863, 
	0x0843, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x2020, 0x1820, 0x0000, 0x0840, 0x0040, 0x0800, 0x6a03, 0xcc6a, 
	0x6a27, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x5142, 0xbba7, 0x6a45, 0x0840, 0x0840, 0x1040, 0x30c1, 0x3944, 0x0822, 0x0001, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x0884, 0x0884, 0x0883, 0x0863, 0x0843, 
	0x0023, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0000, 0x4943, 0x6a46, 0x0800, 0x0020, 0x0020, 0x0820, 0x3040, 0x50c0, 
	0x38a1, 0x0800, 0x0000, 0x0000, 0x0000, 0x0020, 0x1800, 0x3840, 0x30a0, 0x1040, 0x0840, 0x1000, 0x7264, 0xa3eb, 0x1042, 0x0001, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x1084, 0x1083, 0x1083, 0x1083, 0x1083, 0x1083, 0x1083, 0x1084, 0x0884, 0x0884, 0x0884, 0x0884, 0x0863, 0x0863, 0x0043, 0x0043, 
	0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0000, 0x7205, 0xbc4c, 0x1861, 0x0000, 0x0020, 0x0820, 0x2020, 0x2800, 
	0x1800, 0x0800, 0x0000, 0x0000, 0x0020, 0x0020, 0x0800, 0x2000, 0x2860, 0x1040, 0x0840, 0x0820, 0x4901, 0x69e5, 0x1882, 0x0002, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x1084, 0x1084, 0x1084, 0x1084, 0x1083, 0x1083, 0x1083, 0x0884, 0x0884, 0x0883, 0x0863, 0x0863, 0x0863, 0x0863, 0x0043, 0x0023, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x2061, 0x48e1, 0x4102, 0x0820, 0x0020, 0x0020, 0x0800, 0x40e1, 0x69e4, 
	0x2881, 0x0000, 0x0000, 0x0000, 0x0020, 0x0000, 0x1000, 0x6a03, 0x9327, 0x3102, 0x0040, 0x0840, 0x1000, 0x1820, 0x1862, 0x0002, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0022, 0x0042, 0x0043, 0x0043, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0042, 0x0043, 0x0042, 
	0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1063, 0x0863, 0x0883, 0x0863, 0x0863, 0x0863, 0x0043, 0x0043, 0x0043, 0x0022, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0043, 0x0023, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x2061, 0x2861, 0x0800, 0x0820, 0x0840, 0x0020, 0x0800, 0x7a23, 0xd48a, 
	0x59c5, 0x0000, 0x0000, 0x0000, 0x0020, 0x0000, 0x1800, 0x9b46, 0xcc8b, 0x4163, 0x0040, 0x0840, 0x1020, 0x1000, 0x0800, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0022, 0x0843, 0x0863, 0x0843, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0042, 0x0043, 0x0043, 0x0043, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0843, 0x0043, 0x0043, 0x0023, 0x0022, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 
	0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 
	0x0002, 0x0022, 0x0022, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x1800, 0x3081, 0x0800, 0x0040, 0x0840, 0x0020, 0x1000, 0x40a0, 0x71c2, 
	0x4123, 0x0000, 0x0020, 0x0020, 0x0020, 0x0000, 0x0800, 0x3860, 0x5921, 0x30c1, 0x0840, 0x0840, 0x1000, 0x59a3, 0x72a7, 0x0841, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 
	0x0022, 0x0023, 0x0843, 0x0863, 0x0843, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0042, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0043, 0x0043, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0843, 0x0843, 0x0043, 0x0023, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0042, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x4942, 0xb40a, 0x3103, 0x0000, 0x0020, 0x0020, 0x0820, 0x2000, 0x2800, 
	0x1820, 0x0020, 0x0020, 0x0020, 0x0020, 0x0000, 0x0000, 0x1800, 0x2820, 0x1840, 0x0840, 0x0820, 0x1000, 0x7a24, 0x9b69, 0x1862, 
	0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x0022, 0x0043, 0x0863, 0x0863, 0x0843, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0042, 0x0042, 0x0043, 0x0042, 
	0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0042, 0x0043, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0843, 0x0843, 0x0043, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0023, 0x0023, 0x0043, 0x0022, 0x0042, 0x0042, 0x0043, 0x0043, 0x0043, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0800, 0x4901, 0x92e7, 0x28e3, 0x0000, 0x0020, 0x0840, 0x0820, 0x3080, 0x40a1, 
	0x1020, 0x0020, 0x0040, 0x0020, 0x0020, 0x0020, 0x0000, 0x2020, 0x5962, 0x4122, 0x0840, 0x0860, 0x1020, 0x2820, 0x38c1, 0x1862, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0043, 0x0043, 0x0863, 0x0863, 0x0843, 0x0043, 0x0042, 0x0042, 0x0042, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0043, 0x0043, 
	0x0042, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0042, 0x0043, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0843, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0843, 0x0043, 0x0043, 0x0043, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 0x0022, 0x0022, 0x0043, 
	0x0042, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x2082, 0x40c2, 0x1800, 0x0800, 0x0840, 0x0040, 0x0020, 0x1000, 0x92e6, 0xc40a, 
	0x3103, 0x0000, 0x0040, 0x0840, 0x0820, 0x0000, 0x0000, 0x5162, 0xdccb, 0x9368, 0x1060, 0x0840, 0x0840, 0x1000, 0x1800, 0x1021, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0043, 
	0x0843, 0x0043, 0x0843, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0843, 0x0043, 
	0x0042, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 0x0042, 0x0043, 0x0863, 0x0843, 
	0x0043, 0x0042, 0x0022, 0x0022, 0x0043, 0x0843, 0x0843, 0x0843, 0x0843, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0002, 0x0022, 0x0043, 
	0x0042, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x1820, 0x2840, 0x0800, 0x0000, 0x0020, 0x0040, 0x0000, 0x1000, 0x8244, 0xb368, 
	0x3923, 0x0020, 0x0020, 0x1881, 0x3964, 0x0820, 0x0800, 0x40c1, 0x9244, 0x69e4, 0x1060, 0x0840, 0x0840, 0x1000, 0x2060, 0x3102, 
	0x0821, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0843, 0x0843, 0x0043, 0x0843, 0x0043, 
	0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0042, 0x0042, 0x0043, 0x0863, 
	0x0843, 0x0022, 0x0022, 0x0022, 0x0043, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0023, 0x0023, 0x0023, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0042, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x1820, 0x61c4, 0x28a2, 0x0000, 0x0020, 0x0040, 0x0020, 0x1020, 0x2800, 0x3040, 
	0x1840, 0x0820, 0x0000, 0x2881, 0x7aa7, 0x2060, 0x0800, 0x1800, 0x3020, 0x3080, 0x1060, 0x0840, 0x0840, 0x1000, 0x7224, 0xabea, 
	0x20a3, 0x0001, 0x0001, 0x0001, 0x0001, 0x0821, 0x3964, 0x1083, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0042, 0x0043, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0043, 0x0042, 
	0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0042, 0x0042, 0x0042, 0x0863, 
	0x0863, 0x0042, 0x0042, 0x0843, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0884, 0x0863, 0x0863, 0x0863, 0x1064, 0x0843, 0x0022, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0043, 
	0x0043, 0x0843, 0x0843, 0x0043, 0x0043, 0x0042, 0x0043, 0x0043, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0801, 0x1882, 0x0021, 0x0001, 0x0001, 0x0000, 0x2860, 0xbc0a, 0x6247, 0x0000, 0x0020, 0x0020, 0x0840, 0x1020, 0x2820, 0x2000, 
	0x1020, 0x0820, 0x30a1, 0x69a3, 0xab48, 0x6a05, 0x1041, 0x1000, 0x2840, 0x3080, 0x1840, 0x0841, 0x0840, 0x1000, 0x5101, 0x6a04, 
	0x2082, 0x0001, 0x0001, 0x0001, 0x0001, 0x0800, 0x6226, 0x20a3, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 
	0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x0022, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0043, 0x0043, 0x0043, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 
	0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0042, 0x0042, 0x0042, 0x0043, 
	0x0883, 0x0863, 0x0863, 0x0863, 0x1084, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x18a4, 0x10a4, 0x0863, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 
	0x0023, 0x0843, 0x0843, 0x0843, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x1020, 0x4145, 0x0821, 0x0001, 0x0001, 0x1021, 0x48e1, 0x6163, 0x30e2, 0x0000, 0x0040, 0x0020, 0x0020, 0x1000, 0x7a44, 0x8265, 
	0x1861, 0x1040, 0x59a4, 0x69a3, 0x6961, 0x6a25, 0x41a5, 0x1800, 0x8284, 0xbc4a, 0x4163, 0x0000, 0x0840, 0x0820, 0x1000, 0x2020, 
	0x20a2, 0x0001, 0x0001, 0x0001, 0x0001, 0x1000, 0x5163, 0x3925, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x0022, 0x0022, 0x0042, 0x0042, 0x0042, 0x0042, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 
	0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0042, 0x0042, 
	0x10a4, 0x10a4, 0x1084, 0x10a4, 0x18c5, 0x18c5, 0x18c5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18c5, 0x18c5, 
	0x1084, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0042, 0x0043, 0x0042, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0023, 0x0843, 0x0843, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x1840, 0x4943, 0x1042, 0x0001, 0x0001, 0x1820, 0x4902, 0x1800, 0x0800, 0x0020, 0x0040, 0x0040, 0x0020, 0x1820, 0xb387, 0xcc2a, 
	0x30e2, 0x0800, 0x3080, 0x3860, 0x5962, 0x40e1, 0x4984, 0x2000, 0x8a84, 0xd46a, 0x5184, 0x0000, 0x0820, 0x0820, 0x0800, 0x1000, 
	0x1000, 0x0001, 0x0001, 0x0001, 0x0001, 0x1000, 0x6a25, 0x4185, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0042, 0x0042, 0x0043, 0x0043, 0x0043, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 
	0x0042, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 
	0x18a4, 0x18c4, 0x18c4, 0x18c5, 0x18c5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18c5, 
	0x18c5, 0x1084, 0x0843, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0023, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x2041, 0x59c5, 0x20c4, 0x0001, 0x0001, 0x1020, 0x2880, 0x1000, 0x0000, 0x0020, 0x0020, 0x0040, 0x0020, 0x1820, 0x50e1, 0x6963, 
	0x2081, 0x1020, 0x38e1, 0x48c1, 0x71e4, 0x4921, 0x3902, 0x1800, 0x3840, 0x58e1, 0x30a1, 0x0840, 0x0020, 0x0820, 0x0800, 0x4122, 
	0x51c5, 0x0842, 0x0001, 0x0001, 0x0001, 0x0800, 0x5984, 0x3944, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 
	0x0043, 0x0043, 0x0043, 0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0043, 0x0043, 0x0042, 0x0042, 0x0042, 
	0x18c4, 0x18c4, 0x18c4, 0x18c5, 0x18c5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18c5, 0x18c5, 0x18c5, 0x18c5, 0x18a4, 
	0x18c4, 0x10a4, 0x0863, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x1000, 0x5185, 0x1883, 0x0001, 0x0001, 0x1020, 0x82a7, 0x59e5, 0x0000, 0x0020, 0x0040, 0x0040, 0x0020, 0x1020, 0x2000, 0x2800, 
	0x1040, 0x0820, 0x4122, 0x5121, 0x61c3, 0x5162, 0x4163, 0x1040, 0x1800, 0x2000, 0x1840, 0x0840, 0x0040, 0x0020, 0x0800, 0x7a45, 
	0xabeb, 0x28c3, 0x0001, 0x0001, 0x0001, 0x0800, 0x5164, 0x3944, 0x0001, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0843, 
	0x0043, 0x0043, 0x0043, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 
	0x10a4, 0x10a4, 0x18c4, 0x18c4, 0x18c5, 0x18e5, 0x18e5, 0x18e5, 0x18c5, 0x18c5, 0x18c5, 0x18c5, 0x18c5, 0x18c5, 0x18c4, 0x18a4, 
	0x10a4, 0x10a4, 0x1084, 0x0863, 0x0042, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x1000, 0x5144, 0x1862, 0x0001, 0x0001, 0x1820, 0xb3ca, 0x9329, 0x0020, 0x0020, 0x0020, 0x0020, 0x0000, 0x1820, 0x4942, 0x38c1, 
	0x0800, 0x0000, 0x4142, 0x51a2, 0x5182, 0x4962, 0x4184, 0x1020, 0x2020, 0x59e4, 0x4983, 0x0820, 0x0020, 0x0020, 0x0800, 0x3060, 
	0x5143, 0x38e4, 0x0001, 0x0001, 0x0001, 0x1020, 0x4942, 0x3923, 0x0823, 0x0002, 0x0001, 0x1862, 0x1063, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0043, 0x0042, 0x0042, 0x0022, 0x0042, 0x0042, 0x0042, 0x0042, 0x0842, 0x0843, 
	0x0843, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0043, 0x0023, 0x0043, 0x0042, 0x0042, 0x0022, 0x0022, 0x0042, 0x0042, 
	0x10a4, 0x10a4, 0x10a4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18a4, 
	0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x0883, 0x0863, 0x0863, 0x0043, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x3103, 0x20e4, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x30a1, 0x61a3, 0x3924, 0x0001, 0x0800, 0x38c2, 0x40c1, 0x30a1, 0x0020, 0x0020, 0x0020, 0x0020, 0x0000, 0x30a1, 0xcccb, 0xa389, 
	0x1840, 0x0000, 0x30e1, 0x59c3, 0x51c3, 0x5a04, 0x3964, 0x0000, 0x40c1, 0xdd0b, 0xac2b, 0x1861, 0x0000, 0x0000, 0x0800, 0x0800, 
	0x1800, 0x2062, 0x0001, 0x0001, 0x0001, 0x1840, 0x61e3, 0x5a05, 0x1063, 0x0022, 0x0001, 0x3924, 0x3146, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0002, 0x0002, 0x0001, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0022, 0x0022, 0x0042, 0x0042, 0x0843, 0x0843, 0x0042, 0x0843, 
	0x0863, 0x0843, 0x0843, 0x0843, 0x0042, 0x0042, 0x0042, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0022, 0x0022, 0x0042, 0x0042, 
	0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18a4, 0x18a4, 0x18a4, 0x18a4, 0x10a4, 
	0x1084, 0x1084, 0x1084, 0x0884, 0x0884, 0x0884, 0x0884, 0x0864, 0x0843, 0x0023, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0000, 0x4144, 0x3124, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x30c1, 0x69c3, 0x4164, 0x0001, 0x1020, 0x59a5, 0x1800, 0x0000, 0x0820, 0x0020, 0x0020, 0x0020, 0x0000, 0x2840, 0x9ae6, 0x8265, 
	0x1840, 0x0000, 0x1860, 0x59c4, 0x38e1, 0x4163, 0x3123, 0x0000, 0x3020, 0x7a03, 0x6a04, 0x1861, 0x0000, 0x0020, 0x0000, 0x0800, 
	0x1820, 0x28c1, 0x0822, 0x0002, 0x0002, 0x1020, 0x51a2, 0x59e4, 0x0843, 0x0022, 0x0801, 0x28a2, 0x20a4, 0x0001, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0042, 0x0843, 0x0843, 0x0843, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0843, 0x0843, 0x0843, 0x0043, 0x0843, 0x0843, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0042, 
	0x10a4, 0x10a3, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x18c4, 0x18c4, 0x18a4, 0x18a4, 0x10a4, 0x18a4, 0x18a4, 0x18a4, 0x10a4, 0x1084, 
	0x1084, 0x1084, 0x1084, 0x0884, 0x0884, 0x0883, 0x0883, 0x0863, 0x0043, 0x0043, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x38a1, 0x30e3, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x2080, 0x6a04, 0x4164, 0x0001, 0x0800, 0x4103, 0x2881, 0x0000, 0x0000, 0x0000, 0x0020, 0x0020, 0x0020, 0x1820, 0x3820, 0x3060, 
	0x0820, 0x0000, 0x1840, 0x38e1, 0x2860, 0x28a1, 0x18a1, 0x0000, 0x1000, 0x1800, 0x2840, 0x1840, 0x0000, 0x0000, 0x0000, 0x0800, 
	0x6a04, 0xa3ea, 0x28a3, 0x1083, 0x0022, 0x1020, 0x51a2, 0x51e5, 0x1043, 0x0003, 0x0001, 0x30c2, 0x20c4, 0x0001, 0x0022, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0042, 0x0843, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0843, 0x0843, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x10a4, 0x10a3, 0x10a3, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x18c4, 0x18a4, 0x18a4, 0x18a4, 0x18a4, 0x18a4, 0x10a4, 0x10a4, 0x10a4, 
	0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0884, 0x0883, 0x0883, 0x0863, 0x0043, 0x0043, 0x0023, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x5144, 0x4986, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 
	0x2060, 0x51a3, 0x2903, 0x0001, 0x0800, 0x6a05, 0x7a87, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2820, 0x2020, 
	0x0000, 0x0000, 0x1020, 0x4942, 0x51a3, 0x4983, 0x20a1, 0x0000, 0x0800, 0x1820, 0x3080, 0x1000, 0x0820, 0x0000, 0x0000, 0x0800, 
	0x5162, 0x82e6, 0x30e3, 0x20e3, 0x0821, 0x0800, 0x28c1, 0x3102, 0x0842, 0x0043, 0x0001, 0x30e2, 0x3145, 0x0022, 0x0042, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0043, 0x0043, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 0x0043, 0x0043, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0042, 0x0043, 0x0043, 0x0843, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x10a3, 0x1083, 0x1083, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x18c4, 0x18c4, 0x18a4, 0x18c4, 0x18a4, 0x18a4, 0x18a4, 0x18a4, 0x10a4, 
	0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x0884, 0x0863, 0x0043, 0x0023, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0801, 0x40c1, 0x3903, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 
	0x1820, 0x2060, 0x1060, 0x0020, 0x0000, 0x3922, 0x4123, 0x0000, 0x0000, 0x0020, 0x0000, 0x0000, 0x0000, 0x2040, 0x8a86, 0x59c4, 
	0x0000, 0x0000, 0x1020, 0x61c3, 0x59a3, 0x59e4, 0x3102, 0x0800, 0x0800, 0x59a3, 0xb3ea, 0x5185, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0800, 0x1020, 0x1040, 0x0820, 0x0000, 0x0000, 0x0800, 0x1880, 0x0842, 0x0023, 0x0821, 0x30a1, 0x3944, 0x0843, 0x0043, 0x0042, 
	0x0042, 0x0022, 0x0022, 0x0042, 0x0043, 0x0043, 0x0043, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0863, 0x0043, 
	0x0043, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0043, 0x0843, 0x0843, 0x0843, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0043, 0x0043, 0x0043, 
	0x1083, 0x1083, 0x1083, 0x10a3, 0x10a4, 0x10a4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c5, 0x18c4, 
	0x18c4, 0x18c4, 0x18c4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0863, 0x0843, 0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x1021, 0x7204, 0x6206, 0x0022, 0x0002, 0x0002, 0x0002, 0x0800, 
	0x30c1, 0x4162, 0x2101, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x30a1, 0x9b07, 0x6a46, 
	0x0840, 0x0000, 0x30c1, 0x61c4, 0x40c1, 0x5162, 0x4983, 0x1840, 0x1000, 0x6182, 0xb3c9, 0x7267, 0x0800, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x20a0, 0x51c2, 0x28e3, 0x0002, 0x0821, 0x4122, 0x6a47, 0x0863, 0x0023, 0x0042, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0043, 
	0x0042, 0x0042, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0022, 0x0043, 0x0843, 0x0843, 0x0843, 0x0043, 0x0043, 0x0042, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0042, 0x0043, 0x0843, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x1083, 0x1083, 0x1083, 0x10a4, 0x10a4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18e5, 0x18e5, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 
	0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c5, 0x18c5, 0x10a4, 0x1084, 0x0884, 0x0863, 0x0042, 0x0022, 0x0022, 0x0023, 0x0023, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0003, 0x1021, 0x6162, 0x59a5, 0x0823, 0x0002, 0x0002, 0x0002, 0x1020, 
	0x4941, 0x59e2, 0x49a3, 0x0820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2040, 0x1840, 
	0x0800, 0x2880, 0x5982, 0x5963, 0x2820, 0x40c0, 0x61c3, 0x4142, 0x1820, 0x1800, 0x2820, 0x2041, 0x0800, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4120, 0x6202, 0x4163, 0x0822, 0x1021, 0x4922, 0x59c5, 0x1063, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0043, 0x0043, 
	0x0042, 0x0042, 0x0022, 0x0022, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0043, 0x0863, 0x0863, 0x0863, 0x0863, 0x0843, 0x0843, 0x0043, 0x0043, 0x0042, 0x0042, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0843, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x10a4, 0x10a4, 0x10a4, 0x18a4, 0x18a4, 0x18c4, 0x18e5, 0x20e5, 0x20e5, 0x20e5, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 
	0x2105, 0x2105, 0x2105, 0x20e5, 0x20e5, 0x20e5, 0x18c5, 0x10a4, 0x1084, 0x0883, 0x0863, 0x0863, 0x0863, 0x0864, 0x0863, 0x0043, 
	0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0801, 0x5122, 0x59c6, 0x0802, 0x0002, 0x0002, 0x0001, 0x2060, 
	0x5161, 0x5162, 0x5183, 0x28e1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 
	0x40e1, 0x6182, 0x69c3, 0x40e2, 0x1800, 0x2840, 0x5141, 0x61a2, 0x4142, 0x2060, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1860, 0x5181, 0x59a1, 0x51a3, 0x1062, 0x0821, 0x38c1, 0x6206, 0x10a3, 0x0843, 0x0863, 
	0x0843, 0x0843, 0x0843, 0x0043, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0043, 
	0x0042, 0x0042, 0x0022, 0x0022, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0043, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0043, 0x0043, 0x0042, 
	0x0042, 0x0042, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0843, 0x0843, 0x0843, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x18a4, 0x18a4, 0x18c4, 0x18c4, 0x18e5, 0x20e5, 0x2105, 0x2105, 0x2105, 0x2105, 0x2125, 0x2125, 0x2125, 0x2125, 0x2125, 0x2105, 
	0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x20e6, 0x18e5, 0x18c5, 0x10a4, 0x1084, 0x0884, 0x0883, 0x0884, 0x0884, 0x0884, 0x0863, 
	0x0043, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0801, 0x51a3, 0x6247, 0x0842, 0x0002, 0x0002, 0x0800, 0x30c0, 
	0x5982, 0x48e1, 0x38a1, 0x49c3, 0x20a1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1040, 0x4942, 
	0x61c3, 0x61a3, 0x5122, 0x2820, 0x1800, 0x1800, 0x3060, 0x5141, 0x59a2, 0x51a3, 0x2901, 0x0820, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x4142, 0x40e2, 0x4900, 0x59a3, 0x20c2, 0x0020, 0x3102, 0x6247, 0x18c3, 0x0043, 0x0863, 
	0x0863, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0043, 
	0x0042, 0x0042, 0x0042, 0x0022, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 
	0x0002, 0x0002, 0x0043, 0x0863, 0x0863, 0x0883, 0x0883, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0843, 0x0843, 0x0043, 0x0043, 0x0043, 0x0042, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0043, 0x0843, 0x0843, 0x0843, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0863, 0x0863, 0x0863, 
	0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18e5, 0x2105, 0x2105, 0x2126, 0x2125, 0x2125, 0x2125, 0x2125, 0x2125, 0x2125, 0x2125, 0x2125, 
	0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x20e5, 0x18e5, 0x18c5, 0x10c5, 0x10a4, 0x10a4, 0x1084, 0x10a4, 0x10a4, 0x10a4, 0x0884, 
	0x0863, 0x0023, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0841, 0x3942, 0x3122, 0x0821, 0x0001, 0x0001, 0x1020, 0x4942, 
	0x5162, 0x3881, 0x2000, 0x4122, 0x51e4, 0x28e2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0000, 0x0000, 0x1020, 0x4962, 0x61c2, 
	0x5962, 0x40c1, 0x2000, 0x2020, 0x2020, 0x2020, 0x2000, 0x2840, 0x40e1, 0x5182, 0x59e3, 0x3942, 0x0820, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x1020, 0x4122, 0x4943, 0x2020, 0x40c0, 0x59a2, 0x3122, 0x0820, 0x1020, 0x20a1, 0x0862, 0x0863, 0x0863, 
	0x0863, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0043, 0x0043, 0x0043, 0x0043, 0x0843, 0x0843, 0x0843, 0x0843, 0x0843, 0x0043, 
	0x0043, 0x0043, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 
	0x0002, 0x0022, 0x0043, 0x0863, 0x0864, 0x0884, 0x0883, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0043, 0x0043, 0x0043, 
	0x0042, 0x0043, 0x0043, 0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0843, 0x0843, 
	0x0843, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0863, 0x0863, 
	0x18c4, 0x18c4, 0x18c4, 0x18e5, 0x2105, 0x2105, 0x2105, 0x2926, 0x2126, 0x2125, 0x2125, 0x2125, 0x2125, 0x2125, 0x2125, 0x2125, 
	0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x18e5, 0x18e5, 0x18c5, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0884, 
	0x0863, 0x0043, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0021, 0x0820, 0x0000, 0x0000, 0x0001, 0x0800, 0x30c1, 0x5182, 
	0x4922, 0x2840, 0x1800, 0x2000, 0x4102, 0x49c4, 0x3123, 0x0020, 0x0000, 0x0000, 0x0020, 0x0000, 0x0000, 0x4141, 0x69e3, 0x5122, 
	0x3040, 0x2000, 0x2020, 0x2040, 0x1820, 0x1820, 0x2020, 0x2000, 0x2000, 0x3880, 0x5161, 0x51e3, 0x3102, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x1020, 0x4942, 0x5163, 0x2840, 0x1800, 0x3880, 0x5961, 0x4982, 0x1881, 0x0000, 0x0000, 0x0041, 0x0883, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0843, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 
	0x0002, 0x0022, 0x0043, 0x0863, 0x0864, 0x0884, 0x0884, 0x0883, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0843, 0x0043, 
	0x0043, 0x0042, 0x0022, 0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0843, 0x0843, 
	0x0843, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0863, 0x0863, 0x0863, 
	0x18c4, 0x18c4, 0x18e5, 0x20e5, 0x2105, 0x2105, 0x2105, 0x2126, 0x2125, 0x2125, 0x2125, 0x2125, 0x2125, 0x2125, 0x2125, 0x2105, 
	0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x18e5, 0x18e5, 0x18e5, 0x18c5, 0x18c5, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0884, 
	0x0863, 0x0863, 0x0042, 0x0022, 0x0022, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0021, 0x0000, 0x0000, 0x0000, 0x0000, 0x1860, 0x5162, 0x5142, 
	0x40c2, 0x1800, 0x2000, 0x2000, 0x1800, 0x2881, 0x49a4, 0x3123, 0x0000, 0x0000, 0x0000, 0x0000, 0x2080, 0x61e3, 0x5962, 0x2840, 
	0x2000, 0x2840, 0x2040, 0x1020, 0x0800, 0x1000, 0x1800, 0x2020, 0x2020, 0x2000, 0x3080, 0x51a2, 0x51c4, 0x1881, 0x0000, 0x0000, 
	0x0000, 0x0800, 0x38e2, 0x4102, 0x2820, 0x2000, 0x1800, 0x2000, 0x4901, 0x5182, 0x3942, 0x0000, 0x0000, 0x0042, 0x0883, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0843, 0x0863, 0x0863, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0022, 0x0043, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0884, 0x0884, 0x0883, 0x0863, 0x0863, 0x0863, 0x0843, 
	0x0043, 0x0043, 0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0043, 0x0043, 
	0x0043, 0x0843, 0x0843, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0863, 0x0863, 0x0863, 
	0x18c4, 0x18c4, 0x18c4, 0x18e5, 0x20e5, 0x2105, 0x2105, 0x2105, 0x2125, 0x2125, 0x2125, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 
	0x2105, 0x2105, 0x2105, 0x20e5, 0x18e5, 0x18e5, 0x18c5, 0x18c4, 0x18c4, 0x18c5, 0x18c5, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0864, 
	0x0863, 0x0043, 0x0042, 0x0022, 0x0042, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0020, 0x0020, 0x0000, 0x1020, 0x4942, 0x5162, 0x4902, 
	0x2020, 0x1800, 0x2020, 0x2020, 0x1800, 0x1000, 0x1840, 0x4184, 0x1882, 0x0000, 0x0000, 0x0000, 0x4121, 0x61e3, 0x3881, 0x2020, 
	0x2861, 0x1820, 0x0800, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x2020, 0x2020, 0x2000, 0x38c0, 0x51e3, 0x3122, 0x0000, 0x0000, 
	0x0000, 0x1860, 0x38c2, 0x2000, 0x2800, 0x2840, 0x2020, 0x1800, 0x3060, 0x5961, 0x49a3, 0x18a1, 0x0000, 0x0042, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0843, 0x0843, 0x0843, 0x0843, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0043, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0884, 0x0884, 0x0883, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0843, 0x0043, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0042, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0863, 0x0863, 0x0863, 
	0x18c4, 0x18c4, 0x18c4, 0x18e5, 0x20e5, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x20e5, 0x20e5, 0x18e5, 
	0x20e5, 0x20e5, 0x18e5, 0x18c4, 0x18c5, 0x18c5, 0x18c4, 0x18c4, 0x18c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x0884, 0x0863, 
	0x0063, 0x0043, 0x0042, 0x0022, 0x0042, 0x0043, 0x0043, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0021, 0x0000, 0x0000, 0x3901, 0x5982, 0x5143, 0x3061, 
	0x1800, 0x2840, 0x2840, 0x1820, 0x1800, 0x1000, 0x0800, 0x28a2, 0x28e3, 0x0000, 0x0000, 0x0800, 0x5182, 0x5183, 0x2020, 0x2861, 
	0x1840, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1800, 0x2040, 0x2020, 0x2020, 0x4982, 0x41a3, 0x0820, 0x0000, 
	0x0000, 0x1861, 0x2040, 0x1800, 0x2840, 0x2860, 0x2860, 0x1800, 0x2000, 0x48e1, 0x51a2, 0x3962, 0x0000, 0x0042, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0843, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0043, 0x0043, 0x0863, 0x0863, 0x0883, 0x0863, 0x0883, 0x0883, 0x0883, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0043, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18e5, 0x20e5, 0x20e5, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x20e5, 0x20e5, 0x18e4, 
	0x18e4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0863, 0x0863, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0021, 0x0000, 0x1060, 0x51a2, 0x5963, 0x40c2, 0x1800, 
	0x2840, 0x3080, 0x2040, 0x1820, 0x1020, 0x1000, 0x0800, 0x1040, 0x20e3, 0x0000, 0x0000, 0x0800, 0x4942, 0x4102, 0x2020, 0x2861, 
	0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1820, 0x2061, 0x1800, 0x3901, 0x49c3, 0x1061, 0x0000, 
	0x0000, 0x1020, 0x1800, 0x1820, 0x2040, 0x2840, 0x2880, 0x2060, 0x1800, 0x3060, 0x5161, 0x4182, 0x1081, 0x0022, 0x0863, 0x0863, 
	0x0843, 0x0863, 0x0863, 0x0863, 0x0843, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 
	0x0042, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0042, 0x0063, 0x0063, 0x0863, 0x0863, 0x0883, 0x0883, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0043, 
	0x0043, 0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0863, 0x0863, 0x0863, 
	0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x20e5, 0x20e5, 0x20e5, 0x20e5, 0x20e5, 0x20e5, 0x20e5, 0x20e5, 0x18e4, 0x18e4, 
	0x18c4, 0x18c4, 0x18c4, 0x18a4, 0x18a4, 0x18a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x0884, 0x0863, 0x0043, 
	0x0043, 0x0043, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0021, 0x0000, 0x30e1, 0x61e3, 0x5943, 0x2020, 0x2000, 
	0x38a1, 0x3080, 0x2040, 0x2040, 0x1820, 0x1000, 0x0800, 0x1000, 0x1040, 0x0000, 0x0000, 0x1020, 0x2860, 0x30a1, 0x2860, 0x1820, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1840, 0x2020, 0x2880, 0x30e1, 0x1880, 0x0800, 
	0x0800, 0x1000, 0x1000, 0x1800, 0x2040, 0x2060, 0x2860, 0x2880, 0x2020, 0x1800, 0x4920, 0x49a2, 0x2902, 0x0021, 0x0863, 0x0043, 
	0x0843, 0x0843, 0x0843, 0x0863, 0x0843, 0x0043, 0x0043, 0x0043, 0x0042, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0042, 
	0x0042, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x0022, 0x0042, 0x0063, 0x0063, 0x0063, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0843, 0x0843, 0x0843, 0x0843, 0x0043, 
	0x0043, 0x0042, 0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0843, 0x0843, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x18a4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18e5, 0x18e5, 0x20e5, 0x20e5, 0x20e5, 0x20e5, 0x20e5, 0x18e4, 0x18c4, 0x18c4, 
	0x18c4, 0x18a4, 0x18a4, 0x18a4, 0x18a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x10a4, 0x10a4, 0x1084, 0x0884, 0x0863, 0x0043, 
	0x0043, 0x0022, 0x0022, 0x0043, 0x0063, 0x0063, 0x0063, 0x0043, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0023, 0x0023, 0x0023, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0002, 0x0001, 0x0800, 0x4162, 0x61e3, 0x40e2, 0x1800, 0x3080, 
	0x38c0, 0x2880, 0x2860, 0x2060, 0x1840, 0x1820, 0x1840, 0x28a0, 0x30a0, 0x28a1, 0x2080, 0x30c0, 0x5141, 0x5162, 0x38c1, 0x1020, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x2060, 0x4101, 0x5141, 0x4962, 0x38c1, 
	0x2860, 0x38e1, 0x38e1, 0x2860, 0x2040, 0x2060, 0x2860, 0x3080, 0x2881, 0x1800, 0x38c0, 0x51a1, 0x3962, 0x0842, 0x0843, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x0022, 0x0042, 0x0043, 0x0063, 0x0063, 0x0863, 0x0863, 0x0863, 0x0843, 0x0843, 0x0843, 0x0843, 0x0043, 0x0843, 0x0043, 0x0043, 
	0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0843, 0x0042, 0x0843, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x18a4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c5, 0x18e5, 0x18e5, 0x18c5, 0x18c5, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 
	0x18c4, 0x18a4, 0x18a4, 0x18a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x10a4, 0x1084, 0x0884, 0x0863, 0x0043, 0x0043, 
	0x0043, 0x0022, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0043, 0x0022, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0001, 0x0820, 0x4982, 0x61c4, 0x3081, 0x1800, 0x38c0, 
	0x30a0, 0x3080, 0x2860, 0x2060, 0x1840, 0x1000, 0x28a1, 0x4962, 0x5161, 0x5162, 0x38a1, 0x38c0, 0x61a1, 0x5982, 0x38c1, 0x1041, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1840, 0x3080, 0x5140, 0x61a1, 0x5962, 0x38a1, 
	0x5141, 0x59a2, 0x51a3, 0x28c1, 0x1820, 0x2040, 0x2040, 0x2860, 0x30a1, 0x1820, 0x2860, 0x51a1, 0x49a2, 0x0841, 0x0022, 0x0043, 
	0x0023, 0x0023, 0x0043, 0x0043, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0063, 0x0863, 0x0843, 0x0843, 0x0843, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0042, 0x0043, 0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x18c4, 0x18a4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c5, 0x18c5, 0x18c5, 0x18c5, 0x18c5, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 
	0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0884, 0x0863, 0x0863, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0000, 0x1040, 0x4982, 0x4963, 0x2020, 0x1820, 0x30a0, 
	0x30a0, 0x2880, 0x2040, 0x1820, 0x0800, 0x0000, 0x0800, 0x3080, 0x61a1, 0x59a2, 0x3081, 0x3060, 0x61c1, 0x61c2, 0x3081, 0x0800, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x2061, 0x2860, 0x4100, 0x69c1, 0x5962, 0x3860, 
	0x5140, 0x61c2, 0x4122, 0x1000, 0x1000, 0x1820, 0x1820, 0x2040, 0x2881, 0x1841, 0x1800, 0x3900, 0x4983, 0x1061, 0x0001, 0x0023, 
	0x0023, 0x0022, 0x0022, 0x0023, 0x0023, 0x0022, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0043, 0x0043, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0042, 0x0042, 0x0042, 0x0042, 0x0043, 0x0863, 0x0863, 0x0863, 0x0883, 
	0x18a4, 0x18a4, 0x18c4, 0x10c4, 0x10c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c5, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x10a4, 0x10a4, 
	0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0884, 0x0884, 0x0884, 0x0883, 0x0863, 0x0043, 0x0063, 0x0063, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0863, 0x0063, 0x0063, 0x0043, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0800, 0x2060, 0x30c0, 0x2880, 0x2020, 0x1800, 0x1820, 
	0x2020, 0x2040, 0x2040, 0x1840, 0x0800, 0x0000, 0x0000, 0x1800, 0x5981, 0x59a2, 0x2881, 0x2840, 0x61c2, 0x61c2, 0x2861, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x1800, 0x4901, 0x69c2, 0x5962, 0x3060, 
	0x5161, 0x61e3, 0x30a1, 0x0800, 0x1000, 0x1820, 0x1800, 0x1820, 0x1820, 0x1000, 0x1820, 0x2860, 0x30c0, 0x2081, 0x0000, 0x0002, 
	0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0863, 0x0863, 0x0863, 
	0x18c4, 0x18a4, 0x18a4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x18a4, 0x18a4, 0x18a4, 0x18a4, 0x18a4, 0x18a4, 0x10a4, 0x10a4, 
	0x10a4, 0x10a4, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x0884, 0x0884, 0x0883, 0x0863, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0023, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0801, 0x1000, 0x30c0, 0x4121, 0x4121, 0x38e1, 0x2861, 0x2881, 
	0x2881, 0x2040, 0x1820, 0x1841, 0x1020, 0x0000, 0x0000, 0x2081, 0x4941, 0x4100, 0x30e1, 0x38a1, 0x4900, 0x4100, 0x2881, 0x0820, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1820, 0x38a0, 0x5120, 0x4921, 0x40e1, 
	0x5141, 0x59a2, 0x30e2, 0x1000, 0x1000, 0x1000, 0x1820, 0x28a1, 0x28a1, 0x2860, 0x30a0, 0x4920, 0x4941, 0x3901, 0x28c2, 0x0822, 
	0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0042, 0x0043, 0x0043, 0x0863, 
	0x18c4, 0x18a4, 0x18a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x18a4, 0x10a4, 0x10a4, 0x1084, 0x1084, 
	0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x0884, 0x0884, 0x0864, 0x0863, 0x0863, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0043, 0x0063, 0x0043, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x1862, 0x30a1, 0x38c0, 0x4920, 0x51a1, 0x4921, 0x3080, 0x30a1, 
	0x38c1, 0x2881, 0x1820, 0x1000, 0x0820, 0x0000, 0x0000, 0x1840, 0x4121, 0x4141, 0x2081, 0x2020, 0x5161, 0x5162, 0x2020, 0x0800, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x3080, 0x61e3, 0x4122, 0x2000, 
	0x4901, 0x4961, 0x28a1, 0x1020, 0x0800, 0x0800, 0x1840, 0x28a1, 0x30a1, 0x3060, 0x38c0, 0x5160, 0x4941, 0x3921, 0x28e3, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0043, 0x0043, 
	0x18a4, 0x18a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x1084, 0x1084, 
	0x1084, 0x1084, 0x1083, 0x0883, 0x0884, 0x0884, 0x0884, 0x0864, 0x0863, 0x0863, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0821, 0x38e2, 0x40e0, 0x4920, 0x61e2, 0x4962, 0x2840, 0x2000, 
	0x1800, 0x1000, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x4142, 0x6224, 0x2881, 0x2000, 0x61c2, 0x61c3, 0x2020, 0x0800, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x3080, 0x6a24, 0x4943, 0x2000, 
	0x5982, 0x6204, 0x1840, 0x0000, 0x0000, 0x0800, 0x0800, 0x1800, 0x2000, 0x2820, 0x4100, 0x59a1, 0x4961, 0x28e2, 0x0822, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0043, 
	0x18a4, 0x18a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x1084, 0x1084, 0x1083, 
	0x1083, 0x1083, 0x1083, 0x1083, 0x0863, 0x0863, 0x0863, 0x0863, 0x0063, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0022, 0x0042, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x2040, 0x4101, 0x5161, 0x59a2, 0x4941, 0x3081, 0x1800, 
	0x1000, 0x0800, 0x0000, 0x0000, 0x0800, 0x0820, 0x0000, 0x0000, 0x4142, 0x6224, 0x30a2, 0x2000, 0x61a2, 0x61e4, 0x2041, 0x0800, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x3080, 0x6a24, 0x4963, 0x2000, 
	0x5982, 0x5a04, 0x1861, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x1800, 0x2840, 0x38c0, 0x5161, 0x59c3, 0x20c3, 0x0001, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0002, 
	0x0002, 0x0002, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x18a4, 0x18a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 
	0x1083, 0x1083, 0x1083, 0x1083, 0x1083, 0x0863, 0x0863, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 
	0x0022, 0x0063, 0x0863, 0x0063, 0x0063, 0x0043, 0x0042, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0003, 0x0023, 0x0023, 0x0022, 0x0002, 0x0003, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x1020, 0x4942, 0x4921, 0x4900, 0x40e1, 0x2861, 0x1800, 
	0x1800, 0x0800, 0x0000, 0x0000, 0x0800, 0x1020, 0x0800, 0x0000, 0x4142, 0x6224, 0x30a2, 0x2000, 0x61a2, 0x69e4, 0x2041, 0x0800, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x3080, 0x6a24, 0x4964, 0x2000, 
	0x5182, 0x6224, 0x1861, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x1800, 0x2000, 0x38a0, 0x5161, 0x4961, 0x28c3, 0x0001, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0863, 0x0843, 0x0001, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x18c4, 0x18c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 
	0x1084, 0x1084, 0x1084, 0x1084, 0x1084, 0x0863, 0x0863, 0x0043, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x0043, 0x0863, 0x0884, 0x0884, 0x0883, 0x0863, 0x0063, 0x0042, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0023, 0x0843, 0x0843, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0043, 0x0042, 0x0022, 0x0042, 0x0043, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x1020, 0x30a0, 0x40c0, 0x61c2, 0x5183, 0x2020, 0x1800, 
	0x1800, 0x1000, 0x0800, 0x0000, 0x0800, 0x1020, 0x0800, 0x0000, 0x3921, 0x6224, 0x30c2, 0x1800, 0x61a2, 0x69e3, 0x2040, 0x0800, 
	0x0841, 0x0000, 0x0000, 0x0000, 0x0841, 0x0821, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x3080, 0x6203, 0x4983, 0x2000, 
	0x5161, 0x6224, 0x1881, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x1800, 0x2000, 0x38c0, 0x6a03, 0x5181, 0x3102, 0x0842, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x18c4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0884, 0x0883, 0x0883, 0x0864, 0x0884, 0x1084, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 
	0x18a4, 0x18a4, 0x18a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0863, 0x0843, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x0043, 0x0863, 0x0884, 0x0883, 0x0884, 0x0884, 0x0863, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0023, 0x0843, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x1840, 0x4101, 0x5141, 0x61e2, 0x59c3, 0x2020, 0x1800, 
	0x1800, 0x1000, 0x0800, 0x0000, 0x0800, 0x1020, 0x1000, 0x0800, 0x3921, 0x6224, 0x30c2, 0x1800, 0x61a1, 0x69e3, 0x2861, 0x0820, 
	0x0841, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x3060, 0x6203, 0x4983, 0x2000, 
	0x5161, 0x6224, 0x2081, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x1800, 0x2000, 0x38a0, 0x6a02, 0x6203, 0x3102, 0x0821, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x18c4, 0x10c4, 0x10c4, 0x10c5, 0x10a4, 0x0884, 0x0883, 0x0863, 0x0843, 0x0843, 0x0864, 0x10a4, 0x10a4, 0x18c4, 0x18c4, 0x18c4, 
	0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c5, 0x18c5, 0x18c4, 0x10a4, 0x1084, 0x0863, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0043, 0x0863, 0x0884, 0x1084, 0x1084, 0x0884, 0x0884, 0x0063, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0023, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0023, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x1000, 0x4141, 0x59c2, 0x61e2, 0x59c4, 0x2820, 0x1800, 
	0x1000, 0x1000, 0x0800, 0x0800, 0x0800, 0x1020, 0x1000, 0x0800, 0x3901, 0x6224, 0x30e2, 0x1800, 0x6181, 0x69e3, 0x2861, 0x0800, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0020, 0x0000, 0x0000, 0x0000, 0x1000, 0x2860, 0x61e3, 0x5183, 0x2020, 
	0x5141, 0x6224, 0x20a2, 0x0000, 0x0000, 0x0800, 0x0800, 0x1000, 0x1800, 0x1800, 0x38a0, 0x6a02, 0x6a43, 0x2903, 0x0001, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0043, 0x0843, 0x0863, 0x0863, 0x0863, 
	0x0043, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10a4, 0x10a4, 0x0884, 0x0863, 0x0043, 0x0043, 0x0863, 0x08a4, 0x10c5, 0x18e5, 0x18e5, 0x18c5, 
	0x18e5, 0x18e5, 0x18e5, 0x20e5, 0x18e5, 0x18e5, 0x18c5, 0x18c5, 0x10a4, 0x10a4, 0x10a4, 0x0883, 0x0043, 0x0022, 0x0002, 0x0023, 
	0x0863, 0x0884, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x0884, 0x0063, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0023, 0x0043, 0x0043, 0x0042, 0x0022, 0x0022, 0x0023, 0x0023, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0000, 0x3921, 0x59c2, 0x6202, 0x59c4, 0x2820, 0x1800, 
	0x1000, 0x1000, 0x0800, 0x0800, 0x0820, 0x0800, 0x0800, 0x0000, 0x3101, 0x6244, 0x30e2, 0x1800, 0x5981, 0x69e3, 0x2061, 0x1000, 
	0x0000, 0x0000, 0x0020, 0x0000, 0x0000, 0x0000, 0x0041, 0x0841, 0x0000, 0x0000, 0x0000, 0x1000, 0x2860, 0x59c3, 0x4984, 0x2000, 
	0x4921, 0x6204, 0x20a2, 0x0000, 0x0000, 0x0800, 0x0800, 0x1000, 0x1800, 0x1800, 0x38a0, 0x6a02, 0x6a44, 0x2924, 0x0001, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0043, 0x0843, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0043, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x10c4, 0x10c4, 0x10c4, 0x10a4, 0x10a4, 0x1084, 0x0883, 0x0863, 0x0843, 0x0043, 0x0043, 0x0884, 0x10c5, 0x18e5, 0x18e5, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18c5, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0884, 0x0843, 0x0843, 
	0x0863, 0x10a4, 0x10c5, 0x18c4, 0x10a4, 0x10a4, 0x0884, 0x0063, 0x0042, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0000, 0x3101, 0x59c2, 0x61e2, 0x59e4, 0x2820, 0x1800, 
	0x1000, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x30c1, 0x6224, 0x30e2, 0x1800, 0x5141, 0x61c3, 0x2881, 0x1000, 
	0x0800, 0x0000, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x2840, 0x59c3, 0x4983, 0x2000, 
	0x4921, 0x6204, 0x20a2, 0x0000, 0x0000, 0x0800, 0x0800, 0x1000, 0x1800, 0x1800, 0x38a0, 0x6a02, 0x6a44, 0x3124, 0x0002, 0x0023, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0043, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0043, 0x0043, 0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0884, 0x0863, 0x0843, 0x0043, 0x0843, 0x0863, 0x10a4, 0x18c5, 0x20e5, 0x20e5, 
	0x20e5, 0x20e5, 0x20e5, 0x18e5, 0x18e5, 0x18c4, 0x18c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x0884, 0x0864, 
	0x0884, 0x1084, 0x10c4, 0x18c4, 0x10a4, 0x1084, 0x0863, 0x0043, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0001, 0x0002, 0x0002, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 0x30e2, 0x59c3, 0x61e2, 0x59e3, 0x2840, 0x1800, 
	0x1000, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x28a1, 0x59e3, 0x28c2, 0x1000, 0x4900, 0x59a2, 0x2861, 0x1820, 
	0x2081, 0x20a2, 0x28a2, 0x28a2, 0x28c2, 0x28c2, 0x28a2, 0x28c2, 0x28c2, 0x20c2, 0x2081, 0x1820, 0x2840, 0x5182, 0x4963, 0x1800, 
	0x40e1, 0x59e4, 0x1882, 0x0000, 0x0000, 0x0800, 0x0800, 0x1000, 0x1800, 0x1800, 0x38a0, 0x6a02, 0x6a44, 0x3145, 0x0002, 0x0843, 
	0x0023, 0x0023, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0001, 0x0002, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0043, 0x0043, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x10a4, 0x10a4, 0x1084, 0x0884, 0x0883, 0x0884, 0x1084, 0x10a4, 0x18a4, 0x18c5, 0x20e5, 0x2105, 
	0x2105, 0x20e5, 0x20e5, 0x18e5, 0x18e5, 0x18e4, 0x18c4, 0x18c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0884, 
	0x0884, 0x0884, 0x10a4, 0x10a4, 0x10a4, 0x0884, 0x0863, 0x0063, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0023, 
	0x0023, 0x0023, 0x0022, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x30e2, 0x59c3, 0x61e2, 0x59e3, 0x2840, 0x1800, 
	0x1000, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x28a0, 0x4141, 0x28a1, 0x2040, 0x40e0, 0x4921, 0x3060, 0x2000, 
	0x2840, 0x2861, 0x2861, 0x3061, 0x3081, 0x3081, 0x3061, 0x3081, 0x3081, 0x2881, 0x2040, 0x1800, 0x2860, 0x4920, 0x4121, 0x2860, 
	0x3080, 0x4942, 0x20a1, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x1800, 0x1800, 0x3080, 0x61e1, 0x6a23, 0x3965, 0x0022, 0x0863, 
	0x0043, 0x0843, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0043, 0x0043, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0063, 0x0043, 0x0043, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x18c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x18c5, 0x18e5, 0x2105, 0x2106, 0x2105, 0x2105, 0x20e5, 
	0x2105, 0x2105, 0x20e5, 0x18e5, 0x18e4, 0x18c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x1084, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0863, 0x0063, 0x0043, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x30e2, 0x59c2, 0x59e2, 0x59e3, 0x2861, 0x1800, 
	0x1000, 0x0800, 0x0800, 0x1841, 0x2081, 0x28a2, 0x2881, 0x2860, 0x38c0, 0x38e0, 0x30a1, 0x38e1, 0x4920, 0x4920, 0x4921, 0x3081, 
	0x2000, 0x2800, 0x2800, 0x2800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x2860, 0x38e0, 0x4900, 0x4941, 0x4922, 
	0x3080, 0x38c0, 0x4121, 0x4143, 0x28c2, 0x1861, 0x1020, 0x1000, 0x1800, 0x1800, 0x3080, 0x61e1, 0x6a23, 0x3965, 0x0022, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0843, 0x0043, 0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0043, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0043, 0x0843, 0x0864, 0x0864, 0x0864, 0x0884, 0x0884, 0x0864, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0063, 0x0063, 0x0043, 0x0043, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0002, 
	0x18c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x18c4, 0x10a4, 0x10a4, 0x18c5, 0x18e5, 0x2105, 0x2106, 0x2126, 0x2105, 0x2105, 
	0x20e5, 0x2105, 0x20e5, 0x18e5, 0x18e4, 0x18c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0864, 0x0864, 0x0063, 0x0043, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0023, 0x0043, 0x0023, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x28c1, 0x51a2, 0x59a1, 0x59c3, 0x2860, 0x1800, 
	0x1820, 0x28c2, 0x30e3, 0x30c2, 0x3081, 0x2840, 0x3060, 0x5142, 0x5141, 0x4921, 0x2840, 0x30a0, 0x59c2, 0x61e2, 0x59a3, 0x3881, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2040, 0x40e0, 0x61a2, 0x61e2, 0x4922, 
	0x3060, 0x4920, 0x59a2, 0x5163, 0x38e2, 0x38e2, 0x3903, 0x30a2, 0x1800, 0x1800, 0x3060, 0x59c1, 0x6203, 0x3965, 0x0022, 0x0023, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0843, 0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0043, 0x0043, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0843, 0x0043, 0x0043, 0x0043, 0x0042, 0x0042, 0x0022, 0x0022, 0x0023, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0864, 0x0863, 0x0863, 0x0864, 0x0863, 0x0863, 0x0863, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0863, 0x0063, 0x0063, 0x0043, 0x0043, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x18c4, 0x10a4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18e5, 0x20e5, 0x2105, 0x2105, 0x2105, 0x2105, 
	0x2105, 0x2105, 0x20e5, 0x18e5, 0x18e4, 0x18c4, 0x18c4, 0x18c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0884, 0x0884, 
	0x0883, 0x0884, 0x0884, 0x0863, 0x0063, 0x0043, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0022, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0023, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x28c1, 0x51a2, 0x4961, 0x4962, 0x2860, 0x1800, 
	0x2020, 0x2861, 0x2841, 0x2020, 0x2000, 0x2000, 0x2820, 0x4921, 0x61a1, 0x59c3, 0x2861, 0x2040, 0x61e1, 0x7a64, 0x5983, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x38c0, 0x6a02, 0x6a23, 0x38c1, 
	0x3060, 0x69e1, 0x7a44, 0x48c1, 0x2000, 0x2800, 0x3041, 0x3061, 0x2000, 0x2000, 0x3060, 0x4940, 0x5182, 0x3965, 0x0022, 0x0843, 
	0x0863, 0x0843, 0x0043, 0x0863, 0x0863, 0x0863, 0x0884, 0x1084, 0x1084, 0x0884, 0x0884, 0x0863, 0x0843, 0x0043, 0x0022, 0x0022, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0043, 0x0042, 0x0042, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0863, 0x0063, 0x0063, 0x0043, 0x0043, 0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 
	0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c5, 0x18e5, 0x20e5, 0x2105, 0x2105, 0x2105, 
	0x20e5, 0x18e5, 0x18e5, 0x18e4, 0x18e4, 0x18c4, 0x10c4, 0x18c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0884, 0x0884, 
	0x0863, 0x0883, 0x0884, 0x0863, 0x0043, 0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0023, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x28a0, 0x4941, 0x4120, 0x40e0, 0x3081, 0x1800, 
	0x2000, 0x2000, 0x2000, 0x1800, 0x2000, 0x2000, 0x1800, 0x3080, 0x6a22, 0x6a03, 0x30a2, 0x1820, 0x59c1, 0x7243, 0x5983, 0x2000, 
	0x2000, 0x2800, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x30a0, 0x6202, 0x6a24, 0x38c1, 
	0x3080, 0x6a01, 0x7a44, 0x48c2, 0x2000, 0x2000, 0x2000, 0x2800, 0x2000, 0x2000, 0x3040, 0x38a0, 0x40e0, 0x3943, 0x1062, 0x0043, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0863, 0x1084, 0x1084, 0x1084, 0x1084, 0x0884, 0x0883, 0x0863, 0x0863, 0x0843, 0x0042, 
	0x0042, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0043, 0x0043, 0x0863, 0x0863, 0x0863, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 
	0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x10a4, 0x10a4, 0x18c4, 0x18c4, 0x18c5, 0x18c4, 0x18c5, 0x20e5, 0x20e5, 0x18e5, 
	0x18e5, 0x18e5, 0x18c4, 0x18c4, 0x18c4, 0x10c4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0884, 
	0x0863, 0x0863, 0x0863, 0x0043, 0x0043, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0022, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0800, 0x30a0, 0x4921, 0x4920, 0x4100, 0x38e2, 0x2840, 
	0x2000, 0x2000, 0x2000, 0x1800, 0x2000, 0x2000, 0x1800, 0x38a0, 0x6202, 0x61e3, 0x28a2, 0x1820, 0x59c2, 0x6a44, 0x5142, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x1800, 0x1800, 0x38c0, 0x6202, 0x6a44, 0x4122, 
	0x2860, 0x61c1, 0x7223, 0x40a1, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2820, 0x38a0, 0x4920, 0x5161, 0x4982, 0x3103, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0883, 0x0884, 0x1084, 0x1084, 0x1084, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 0x0863, 0x0863, 
	0x0863, 0x0043, 0x0042, 0x0022, 0x0022, 0x0002, 0x0002, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0863, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x18c4, 0x18c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x18c4, 0x18c4, 0x18c4, 0x18c5, 0x18c4, 0x18c4, 0x18c5, 0x18c5, 
	0x18c4, 0x18c4, 0x18c4, 0x10a4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0884, 
	0x0884, 0x0863, 0x0043, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0023, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x2081, 0x38c1, 0x5141, 0x61c2, 0x5182, 0x38c1, 0x2020, 
	0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x2000, 0x1800, 0x30a0, 0x59c2, 0x59e3, 0x4103, 0x30c1, 0x59e3, 0x6204, 0x59e5, 0x38c2, 
	0x1800, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x1800, 0x2041, 0x4983, 0x59a3, 0x59a3, 0x4963, 
	0x38e1, 0x59a2, 0x6204, 0x4103, 0x1800, 0x2000, 0x2000, 0x2800, 0x2800, 0x2000, 0x3060, 0x5981, 0x61e2, 0x5982, 0x4143, 0x1063, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0864, 0x1064, 0x1084, 0x1084, 0x0883, 0x0863, 0x0864, 0x0884, 0x0884, 0x0883, 0x0883, 0x0863, 
	0x0863, 0x0863, 0x0063, 0x0043, 0x0042, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0042, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0043, 0x0043, 0x0843, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x18c4, 0x18c4, 0x10a4, 0x18a4, 0x18c4, 0x10a4, 0x10a4, 0x10c4, 0x10c4, 0x10c4, 0x10a4, 0x18c4, 0x10c4, 0x10a4, 0x10c4, 0x10c4, 
	0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x1084, 0x1084, 0x1084, 0x10a4, 0x1084, 0x1084, 0x0884, 
	0x0884, 0x0863, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0023, 0x0043, 0x0063, 0x0063, 0x0043, 0x0043, 
	0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 
	0x0023, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x30e2, 0x38c0, 0x4941, 0x6a43, 0x59e3, 0x28a1, 0x1800, 
	0x2000, 0x2000, 0x1800, 0x1000, 0x1800, 0x1800, 0x2061, 0x3902, 0x4122, 0x3901, 0x30c2, 0x30a1, 0x3060, 0x2860, 0x3081, 0x2881, 
	0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x2841, 0x2820, 0x2820, 0x2840, 
	0x3081, 0x3080, 0x38c1, 0x4944, 0x30a2, 0x1800, 0x2000, 0x2000, 0x2800, 0x2000, 0x2820, 0x5161, 0x6a22, 0x59c3, 0x20a2, 0x0842, 
	0x0863, 0x0863, 0x0863, 0x0883, 0x1084, 0x1084, 0x1084, 0x1084, 0x0884, 0x0884, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0883, 0x0863, 0x0863, 0x0863, 0x0863, 0x0043, 0x0043, 0x0043, 0x0043, 0x0843, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0883, 0x0883, 0x0863, 0x0863, 0x0863, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0043, 0x0043, 0x0863, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x18c4, 0x18a4, 0x18a4, 0x18a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 
	0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x1084, 0x1084, 0x0884, 0x0883, 0x1083, 0x1084, 0x1084, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0863, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x1020, 0x4142, 0x59c2, 0x6223, 0x59e3, 0x28a1, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1000, 0x1800, 0x1800, 0x2861, 0x2861, 0x2000, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2820, 0x2861, 0x2020, 0x1800, 0x2000, 0x2800, 0x2000, 0x2020, 0x4920, 0x6a02, 0x51e4, 0x1883, 0x0843, 
	0x0863, 0x0863, 0x0863, 0x0884, 0x0884, 0x0884, 0x1084, 0x0884, 0x0884, 0x0884, 0x0883, 0x0883, 0x0883, 0x0883, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0883, 0x0863, 0x0863, 0x0863, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0043, 0x0063, 0x0863, 0x0863, 0x0863, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x18c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x1084, 0x1084, 
	0x1084, 0x1084, 0x1084, 0x0884, 0x0884, 0x0884, 0x0883, 0x0883, 0x0884, 0x0883, 0x0883, 0x0884, 0x0884, 0x0884, 0x0883, 0x0863, 
	0x0883, 0x0883, 0x0863, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 
	0x0043, 0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0002, 0x0002, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0000, 0x4143, 0x59e3, 0x59e3, 0x51a3, 0x30c1, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1000, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2000, 
	0x38c1, 0x4142, 0x4122, 0x4142, 0x4943, 0x4983, 0x4963, 0x4963, 0x4163, 0x4143, 0x3902, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2000, 0x2800, 0x3000, 0x2800, 0x2000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2020, 0x4100, 0x61e3, 0x49c5, 0x1042, 0x0843, 
	0x0863, 0x0863, 0x0863, 0x0884, 0x0884, 0x0884, 0x1084, 0x0884, 0x0884, 0x0884, 0x0883, 0x0883, 0x0883, 0x0883, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 0x0043, 0x0063, 0x0063, 0x0063, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x18c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0883, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0884, 0x0883, 0x0883, 0x0883, 
	0x0884, 0x0884, 0x0863, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 
	0x0023, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0000, 0x3101, 0x51c3, 0x51a3, 0x4122, 0x30e2, 0x1820, 
	0x1800, 0x1800, 0x1800, 0x1000, 0x1800, 0x2020, 0x2020, 0x2000, 0x2800, 0x2000, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2000, 
	0x4143, 0x51a4, 0x51a3, 0x59c4, 0x51c4, 0x51c4, 0x49a4, 0x51c4, 0x51c4, 0x49a4, 0x4984, 0x3061, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2000, 0x2800, 0x3000, 0x2800, 0x2820, 0x2020, 0x1800, 0x1800, 0x2000, 0x1820, 0x2881, 0x38c1, 0x4922, 0x49a4, 0x20c4, 0x0843, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x1084, 0x0884, 0x0884, 0x0884, 0x0883, 0x0883, 0x0883, 0x0884, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0043, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x18c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0883, 0x0883, 0x0883, 0x0883, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0863, 0x0863, 0x0883, 0x0883, 
	0x0884, 0x0884, 0x0883, 0x0863, 0x0043, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0023, 0x0043, 0x0023, 0x0043, 
	0x0042, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0821, 0x30e2, 0x30c1, 0x2840, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x2020, 0x2060, 0x28a0, 0x3902, 0x4964, 0x38a2, 0x2000, 0x2800, 0x2000, 0x1800, 0x1800, 0x2800, 0x2800, 0x2800, 0x2000, 
	0x30c2, 0x30e2, 0x30e2, 0x30e2, 0x28a1, 0x28e2, 0x28c2, 0x28e2, 0x28e2, 0x28c2, 0x2081, 0x2861, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2000, 0x2000, 0x2800, 0x2800, 0x40a1, 0x51a3, 0x4101, 0x3080, 0x2840, 0x1800, 0x1800, 0x1800, 0x2800, 0x3061, 0x28e4, 0x1084, 
	0x0863, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 0x0883, 0x0883, 0x0884, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x18a4, 0x10a4, 0x10a4, 0x10a4, 0x10a3, 0x10a3, 0x10a3, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x1083, 0x0883, 0x0883, 0x0883, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0884, 0x0884, 0x0863, 0x0863, 0x0043, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0043, 0x0043, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0043, 
	0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 
	0x0022, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x1021, 0x2020, 0x2000, 0x2000, 0x1800, 0x1800, 0x2880, 
	0x3921, 0x4961, 0x4982, 0x51c3, 0x4982, 0x4122, 0x3081, 0x2000, 0x2800, 0x2000, 0x1800, 0x1800, 0x2000, 0x2800, 0x2800, 0x2000, 
	0x28c2, 0x28c2, 0x28c2, 0x28c2, 0x2081, 0x28c3, 0x20c2, 0x28e3, 0x20a2, 0x20c2, 0x2081, 0x2881, 0x2000, 0x2800, 0x2800, 0x2000, 
	0x2000, 0x2000, 0x2800, 0x3000, 0x3880, 0x5982, 0x61c2, 0x59a2, 0x5162, 0x4101, 0x3060, 0x2000, 0x2800, 0x2800, 0x2020, 0x1083, 
	0x0863, 0x0883, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 0x0883, 0x0883, 0x0884, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0884, 0x0884, 0x0884, 0x0884, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0043, 0x0043, 0x0043, 0x0042, 0x0022, 0x0042, 0x0043, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x18a4, 0x10a4, 0x10a4, 0x10a4, 0x10a3, 0x10a3, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x1083, 0x0883, 0x0883, 0x0883, 
	0x0863, 0x0863, 0x0883, 0x0884, 0x0883, 0x0884, 0x0884, 0x1084, 0x1084, 0x0884, 0x0884, 0x0863, 0x0863, 0x0042, 0x0042, 0x0043, 
	0x0863, 0x0863, 0x0863, 0x0043, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0043, 0x0043, 
	0x0043, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x1000, 0x2000, 0x2000, 0x2800, 0x2000, 0x2840, 0x51a3, 
	0x59e3, 0x51a2, 0x4161, 0x3921, 0x30c0, 0x2880, 0x2840, 0x2000, 0x2800, 0x2000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2800, 0x1800, 
	0x28c2, 0x28c2, 0x20a2, 0x28c2, 0x2082, 0x28e3, 0x20a2, 0x28c3, 0x2082, 0x20c2, 0x2081, 0x2881, 0x2000, 0x2800, 0x2800, 0x2000, 
	0x1800, 0x2000, 0x2800, 0x3000, 0x3060, 0x4900, 0x4920, 0x5161, 0x59a1, 0x61c2, 0x5183, 0x2840, 0x2800, 0x3000, 0x2020, 0x1083, 
	0x1083, 0x0884, 0x0884, 0x0884, 0x0884, 0x1084, 0x1084, 0x0884, 0x0884, 0x0884, 0x0883, 0x0883, 0x0883, 0x0884, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0043, 0x0043, 0x0042, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x18a4, 0x10a4, 0x10a4, 0x10a4, 0x10a3, 0x10a3, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0883, 
	0x0884, 0x0884, 0x0884, 0x1084, 0x1084, 0x10a4, 0x1084, 0x1084, 0x1084, 0x0884, 0x0884, 0x0864, 0x0863, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0863, 0x0863, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0023, 0x0023, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x1000, 0x2000, 0x2000, 0x2800, 0x2000, 0x2020, 0x4101, 
	0x38e0, 0x38c0, 0x30a0, 0x30a0, 0x30c1, 0x30a1, 0x2840, 0x2000, 0x2000, 0x1800, 0x1000, 0x1800, 0x2000, 0x2000, 0x2000, 0x1800, 
	0x2061, 0x2081, 0x2081, 0x2081, 0x1861, 0x20a2, 0x2081, 0x20a2, 0x2061, 0x20a2, 0x2060, 0x2861, 0x2000, 0x2800, 0x2820, 0x2020, 
	0x2020, 0x2000, 0x2800, 0x2800, 0x3040, 0x40e0, 0x4100, 0x4100, 0x4900, 0x4941, 0x4942, 0x3061, 0x2800, 0x3000, 0x2021, 0x1883, 
	0x1083, 0x0884, 0x1084, 0x0884, 0x0884, 0x1084, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 0x0883, 0x0883, 0x0884, 0x0884, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0863, 0x0863, 0x0884, 0x0863, 0x0863, 0x0883, 
	0x0863, 0x0863, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x18a4, 0x10a4, 0x10a4, 0x10a4, 0x18a4, 0x18c4, 0x18c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1083, 0x0883, 
	0x0884, 0x0884, 0x0884, 0x1084, 0x1084, 0x10a4, 0x1084, 0x1084, 0x1084, 0x1084, 0x0884, 0x0864, 0x0863, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0063, 0x0043, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0043, 0x0043, 0x0863, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x1000, 0x1800, 0x2020, 0x2000, 0x2000, 0x2000, 0x4101, 
	0x3080, 0x30a0, 0x30a0, 0x2880, 0x30c0, 0x30c0, 0x2840, 0x2020, 0x2840, 0x30a0, 0x4100, 0x4920, 0x4941, 0x5140, 0x5141, 0x5161, 
	0x4940, 0x4940, 0x5161, 0x5181, 0x5161, 0x5160, 0x4940, 0x5160, 0x5160, 0x5140, 0x5181, 0x5981, 0x5961, 0x5981, 0x59a1, 0x5981, 
	0x61a2, 0x5961, 0x4900, 0x38a0, 0x3060, 0x2840, 0x38a0, 0x4101, 0x4101, 0x4100, 0x38c0, 0x4102, 0x2800, 0x3020, 0x3020, 0x1820, 
	0x1042, 0x0863, 0x0883, 0x0863, 0x0884, 0x0883, 0x0883, 0x1084, 0x1084, 0x1084, 0x1083, 0x1084, 0x0883, 0x0884, 0x0884, 0x0883, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0863, 0x0864, 0x0884, 0x0863, 0x0863, 0x0863, 0x0884, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0043, 0x0043, 0x0023, 0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x18a4, 0x10a3, 0x18a4, 0x18a4, 0x18a4, 0x18c4, 0x18c4, 0x18c4, 0x10a4, 0x10a4, 0x10a4, 0x10a3, 0x10a3, 0x1083, 0x1083, 0x1083, 
	0x0883, 0x0883, 0x0883, 0x0883, 0x1083, 0x1084, 0x1084, 0x1084, 0x1084, 0x0884, 0x0884, 0x0863, 0x0043, 0x0043, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0043, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0022, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0043, 0x0043, 0x0063, 0x0063, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0800, 0x1800, 0x2000, 0x2000, 0x2020, 0x2000, 0x38e1, 
	0x30a0, 0x30a0, 0x2880, 0x2880, 0x2860, 0x2860, 0x3060, 0x40e0, 0x4960, 0x59a1, 0x61c1, 0x61c1, 0x61c1, 0x61c0, 0x61c1, 0x61c1, 
	0x61a0, 0x61c1, 0x61c1, 0x69c1, 0x69c0, 0x69c1, 0x61c1, 0x61c0, 0x69c0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61c0, 0x61c0, 
	0x69c0, 0x69c0, 0x61a1, 0x5960, 0x5141, 0x40e0, 0x3060, 0x3080, 0x38c0, 0x40e0, 0x4101, 0x4102, 0x2800, 0x3020, 0x2820, 0x1820, 
	0x0842, 0x0863, 0x0863, 0x0883, 0x0884, 0x0883, 0x0883, 0x1084, 0x0883, 0x1084, 0x1084, 0x1084, 0x0884, 0x0884, 0x0883, 0x0883, 
	0x0863, 0x0863, 0x0863, 0x0883, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0843, 0x0863, 0x0863, 0x0863, 0x0863, 0x0063, 0x0043, 
	0x0043, 0x0043, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x18a4, 0x10a3, 0x18a4, 0x18a4, 0x18a4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1083, 0x1083, 
	0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x1084, 0x1083, 0x1083, 0x1084, 0x1084, 0x0884, 0x0863, 0x0043, 0x0023, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0023, 0x0003, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 
	0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0800, 0x1800, 0x2000, 0x2000, 0x2020, 0x1800, 0x30c1, 
	0x2880, 0x2860, 0x2840, 0x3080, 0x38c0, 0x4920, 0x5181, 0x5981, 0x59a1, 0x61a1, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61c1, 0x69e2, 
	0x61c1, 0x61c1, 0x61c2, 0x69c1, 0x69c0, 0x69c1, 0x69a2, 0x69a1, 0x69a0, 0x69a1, 0x69c2, 0x61c1, 0x69c1, 0x61c1, 0x69e1, 0x69c0, 
	0x69a0, 0x69c0, 0x7201, 0x7202, 0x69e1, 0x69e2, 0x6181, 0x4900, 0x3880, 0x3060, 0x38c0, 0x38c1, 0x2820, 0x3020, 0x2820, 0x1820, 
	0x0842, 0x0863, 0x0863, 0x0883, 0x0863, 0x0883, 0x0883, 0x1084, 0x0884, 0x1084, 0x1084, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0043, 0x0043, 0x0043, 
	0x0022, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x18c4, 0x18a4, 0x18a4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x1084, 
	0x1083, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0884, 0x0884, 0x0884, 0x0063, 0x0022, 0x0002, 0x0022, 
	0x0022, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0023, 0x0043, 0x0063, 0x0063, 
	0x0063, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 
	0x0043, 0x0023, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0800, 0x1800, 0x2020, 0x2000, 0x1800, 0x1800, 0x2840, 
	0x2860, 0x3080, 0x4100, 0x5161, 0x59a1, 0x59a1, 0x61a1, 0x61a1, 0x61a1, 0x5961, 0x61a0, 0x69a0, 0x69a0, 0x61a1, 0x5141, 0x4080, 
	0x61c2, 0x61c3, 0x40a0, 0x40a0, 0x7202, 0x6162, 0x48a0, 0x5920, 0x69c1, 0x5941, 0x48c0, 0x69c2, 0x7a23, 0x48e0, 0x48e0, 0x69c1, 
	0x6980, 0x6180, 0x6160, 0x6180, 0x69c1, 0x69e1, 0x69c1, 0x69c1, 0x6180, 0x4900, 0x38a0, 0x2840, 0x2000, 0x2800, 0x2820, 0x1820, 
	0x1042, 0x0863, 0x0863, 0x0883, 0x0863, 0x0883, 0x0883, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 
	0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0002, 0x0002, 
	0x18c4, 0x18a4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 
	0x1083, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0863, 0x0883, 0x0884, 0x0863, 0x0043, 0x0023, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0043, 0x0063, 0x0884, 0x0884, 
	0x0864, 0x0863, 0x0023, 0x0002, 0x0002, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0002, 0x0002, 0x0002, 0x0002, 0x0801, 0x1820, 0x2000, 0x2000, 0x2020, 0x3060, 0x40e0, 
	0x5161, 0x5981, 0x59a1, 0x61a1, 0x59a1, 0x61a1, 0x5981, 0x61a1, 0x5961, 0x3880, 0x69c2, 0x69c1, 0x69c1, 0x6a02, 0x3880, 0x2800, 
	0x5981, 0x61c3, 0x2800, 0x3020, 0x61c2, 0x5100, 0x2800, 0x4080, 0x69a2, 0x40a0, 0x2800, 0x5120, 0x7203, 0x4080, 0x3020, 0x69e2, 
	0x7201, 0x71e1, 0x71e2, 0x5920, 0x69c1, 0x7202, 0x7202, 0x69c0, 0x69c0, 0x69c1, 0x61c1, 0x5961, 0x40c0, 0x3040, 0x2800, 0x1820, 
	0x1042, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0863, 0x0864, 0x0864, 0x0864, 0x0864, 0x0864, 0x0884, 0x0884, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x18c4, 0x10a4, 0x10a4, 0x18c4, 0x18c4, 0x18c5, 0x18e5, 0x18e4, 0x18c4, 0x18c4, 0x18c4, 0x18a4, 0x18a4, 0x10a4, 0x10a4, 0x1084, 
	0x0884, 0x0884, 0x0883, 0x0883, 0x0883, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0863, 0x0063, 0x0063, 0x0063, 
	0x0043, 0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0043, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0843, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0022, 0x0022, 0x0022, 0x0023, 0x0002, 0x0002, 0x0002, 0x0022, 0x1021, 0x1800, 0x2860, 0x40c0, 0x4921, 0x5161, 0x5981, 
	0x5981, 0x5980, 0x5980, 0x5981, 0x5981, 0x5161, 0x3880, 0x61a2, 0x5141, 0x2800, 0x5961, 0x69e2, 0x61c2, 0x6a23, 0x40c1, 0x48e1, 
	0x61a2, 0x61c3, 0x4922, 0x5121, 0x61c2, 0x61c3, 0x48e1, 0x5121, 0x69e3, 0x5962, 0x48e1, 0x5141, 0x69e3, 0x5962, 0x48e1, 0x61c2, 
	0x7202, 0x7202, 0x6181, 0x3840, 0x6161, 0x5941, 0x5940, 0x69a1, 0x71e1, 0x69c0, 0x71e0, 0x69c0, 0x69c1, 0x5981, 0x4900, 0x30e1, 
	0x1882, 0x0843, 0x0863, 0x0843, 0x0863, 0x0863, 0x0863, 0x0864, 0x0864, 0x0864, 0x0864, 0x0864, 0x0864, 0x0883, 0x0883, 0x0863, 
	0x0863, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0023, 0x0023, 0x0003, 0x0003, 
	0x0003, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0023, 0x0043, 0x0043, 0x0043, 
	0x18c4, 0x10c4, 0x18c4, 0x18c4, 0x18c5, 0x18c5, 0x18c5, 0x18e5, 0x18c4, 0x18c4, 0x18c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 
	0x0884, 0x0884, 0x0884, 0x0883, 0x0863, 0x0863, 0x0063, 0x0063, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0864, 0x0864, 0x0863, 
	0x0063, 0x0043, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 0x0043, 0x0863, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0863, 0x0043, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0043, 0x0043, 0x0043, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0022, 0x0002, 0x0022, 0x0022, 0x0800, 0x38c0, 0x4961, 0x5140, 0x5140, 0x5980, 0x5980, 
	0x6181, 0x61a1, 0x61a2, 0x40a0, 0x5121, 0x5962, 0x2800, 0x4900, 0x5982, 0x4901, 0x61c3, 0x61c3, 0x5983, 0x5962, 0x5983, 0x61a3, 
	0x59a3, 0x59a4, 0x61a4, 0x5983, 0x61a4, 0x61a4, 0x6183, 0x61a3, 0x61a3, 0x5983, 0x5983, 0x5963, 0x5963, 0x5963, 0x5163, 0x5142, 
	0x5142, 0x6182, 0x69e4, 0x61a2, 0x69a3, 0x4080, 0x48a0, 0x5942, 0x50e0, 0x71e2, 0x71e1, 0x69c0, 0x69e1, 0x61a0, 0x5980, 0x4983, 
	0x28e3, 0x0842, 0x0843, 0x0843, 0x0063, 0x0063, 0x0863, 0x0864, 0x0864, 0x0864, 0x0864, 0x0864, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0023, 0x0023, 0x0003, 0x0003, 
	0x0003, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0843, 0x0863, 0x0863, 
	0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c5, 0x18c5, 0x18c5, 0x18c5, 0x18c5, 0x18c4, 0x10c4, 0x10c4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0863, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0863, 0x0064, 0x0864, 0x0863, 
	0x0063, 0x0043, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0063, 0x0863, 0x0864, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0864, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 
	0x0023, 0x0022, 0x0043, 0x0043, 0x0043, 0x0023, 0x0002, 0x0022, 0x0022, 0x1000, 0x4100, 0x5140, 0x5960, 0x5941, 0x69c2, 0x61a1, 
	0x5121, 0x4900, 0x61e3, 0x2820, 0x40c0, 0x5963, 0x4902, 0x61c4, 0x61c4, 0x5984, 0x40c1, 0x3860, 0x3020, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2820, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x3000, 0x3840, 0x3860, 0x5942, 0x69c4, 0x69a3, 0x5941, 0x5942, 0x48a0, 0x71c2, 0x58e0, 0x71e2, 0x71e2, 0x69e1, 0x61c2, 0x49a4, 
	0x1882, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0863, 0x0864, 0x0864, 0x0864, 0x0863, 0x0863, 0x0863, 0x0863, 0x0063, 0x0063, 
	0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0023, 0x0043, 0x0043, 0x0023, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0864, 0x0864, 0x0863, 
	0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 
	0x0884, 0x0884, 0x0884, 0x0864, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0864, 0x0864, 0x0863, 
	0x0063, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0043, 0x0063, 0x0863, 0x0884, 0x0884, 0x0864, 
	0x0864, 0x0863, 0x0863, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x0022, 0x0043, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 
	0x0023, 0x0023, 0x0043, 0x0043, 0x0063, 0x0043, 0x0022, 0x0043, 0x0022, 0x1000, 0x38c0, 0x5140, 0x5960, 0x5941, 0x40a0, 0x69c2, 
	0x40c0, 0x3060, 0x59a3, 0x4902, 0x5143, 0x5984, 0x5163, 0x40c1, 0x3880, 0x2840, 0x2820, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2800, 0x2820, 
	0x3020, 0x3020, 0x3840, 0x3840, 0x4080, 0x5942, 0x71e3, 0x69a3, 0x5920, 0x6982, 0x4880, 0x6161, 0x50e0, 0x6160, 0x59c2, 0x3943, 
	0x0821, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0864, 0x0864, 0x0884, 
	0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 
	0x0884, 0x0884, 0x0864, 0x0863, 0x0043, 0x0042, 0x0022, 0x0022, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0863, 0x0864, 0x0063, 
	0x0063, 0x0043, 0x0023, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0063, 0x0864, 0x0864, 0x0864, 
	0x0864, 0x0063, 0x0863, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x0022, 0x0043, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0042, 0x0022, 0x1020, 0x40e0, 0x5940, 0x61c1, 0x6162, 0x3820, 0x61a3, 
	0x4901, 0x4901, 0x59a3, 0x5163, 0x40c2, 0x3060, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2020, 0x2020, 
	0x2020, 0x2000, 0x2020, 0x2000, 0x2020, 0x3880, 0x4901, 0x3040, 0x2800, 0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 0x2820, 0x2800, 
	0x2820, 0x3020, 0x3020, 0x3020, 0x3820, 0x3840, 0x48a0, 0x5922, 0x69c3, 0x71e4, 0x50e0, 0x6982, 0x50c0, 0x6161, 0x59a3, 0x1861, 
	0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0864, 0x0884, 0x0884, 
	0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x18c4, 0x18c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 
	0x0884, 0x0884, 0x0863, 0x0063, 0x0043, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 
	0x0063, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0063, 0x0063, 0x0064, 0x0064, 
	0x0864, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0043, 0x0043, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0043, 0x0043, 0x1020, 0x40c0, 0x5120, 0x6181, 0x5962, 0x48e1, 0x61a3, 
	0x5163, 0x4922, 0x38c1, 0x3060, 0x2820, 0x2820, 0x2800, 0x2020, 0x2020, 0x2020, 0x2000, 0x2800, 0x2020, 0x2000, 0x2020, 0x2820, 
	0x2000, 0x2020, 0x1800, 0x2020, 0x38c0, 0x5961, 0x5982, 0x5162, 0x38a0, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2800, 
	0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 0x3840, 0x48a0, 0x5101, 0x6162, 0x71e4, 0x5941, 0x69a1, 0x5a04, 0x1041, 
	0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0864, 0x0864, 
	0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x0884, 
	0x0884, 0x0884, 0x0863, 0x0063, 0x0042, 0x0022, 0x0002, 0x0002, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 
	0x0063, 0x0063, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 
	0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0042, 
	0x0042, 0x0043, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x1000, 0x40c0, 0x48e0, 0x61c3, 0x5983, 0x5122, 0x40e1, 
	0x38a1, 0x3060, 0x2840, 0x2020, 0x2020, 0x2820, 0x2800, 0x2020, 0x2000, 0x2820, 0x2800, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2020, 0x1800, 0x30c1, 0x5182, 0x5981, 0x6181, 0x61a2, 0x59a3, 0x3060, 0x2000, 0x2800, 0x2800, 0x2800, 0x2820, 0x2000, 
	0x2020, 0x2820, 0x3020, 0x3820, 0x3020, 0x3020, 0x3820, 0x3020, 0x3040, 0x3840, 0x4080, 0x48c1, 0x5101, 0x69c3, 0x59e4, 0x0821, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0063, 0x0864, 
	0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x0884, 0x0884, 
	0x0884, 0x0883, 0x0063, 0x0043, 0x0022, 0x0022, 0x0002, 0x0002, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0042, 
	0x0043, 0x0043, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x1000, 0x40e0, 0x40e1, 0x4942, 0x38c1, 0x3060, 0x2840, 
	0x2840, 0x2820, 0x2020, 0x2020, 0x2020, 0x2820, 0x2820, 0x2020, 0x2020, 0x2820, 0x2020, 0x2020, 0x2000, 0x2020, 0x2000, 0x2000, 
	0x2020, 0x2000, 0x1000, 0x4122, 0x5181, 0x5980, 0x5980, 0x5981, 0x59a3, 0x38a1, 0x2000, 0x2800, 0x2820, 0x2820, 0x2820, 0x2020, 
	0x2000, 0x2800, 0x3020, 0x3820, 0x3020, 0x3020, 0x3020, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3040, 0x40c1, 0x51a5, 0x0821, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0042, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0023, 0x0022, 0x0023, 0x0023, 0x0043, 0x0044, 
	0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x08a4, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0063, 0x0043, 0x0043, 0x0022, 0x0022, 0x0002, 0x0002, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 
	0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0022, 0x0002, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0023, 0x0023, 0x0043, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x1000, 0x40e1, 0x4101, 0x3080, 0x2820, 0x2020, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x1800, 0x1800, 0x2020, 0x2000, 0x2020, 0x2820, 0x2820, 0x2820, 0x2020, 0x2000, 0x2020, 0x2000, 0x2020, 
	0x2020, 0x2020, 0x1800, 0x4122, 0x5182, 0x59a1, 0x61c2, 0x61e3, 0x59a3, 0x4102, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 
	0x2000, 0x2800, 0x3820, 0x3820, 0x3020, 0x3020, 0x3040, 0x2020, 0x2820, 0x2820, 0x3040, 0x3020, 0x2800, 0x2820, 0x30e3, 0x0821, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 0x0023, 0x0023, 0x0044, 
	0x10a4, 0x10a4, 0x1084, 0x1084, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x08a4, 0x10a4, 0x08a4, 0x0884, 0x0884, 0x0884, 
	0x0863, 0x0063, 0x0043, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0023, 0x0023, 0x0002, 0x0002, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0042, 0x0022, 0x0022, 0x0022, 0x0042, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x1020, 0x38c1, 0x40c1, 0x2820, 0x2020, 0x2020, 0x2820, 
	0x2820, 0x2000, 0x1820, 0x0800, 0x0800, 0x2020, 0x2000, 0x2000, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2000, 0x2020, 0x2000, 
	0x2000, 0x2000, 0x2020, 0x30c1, 0x4941, 0x5981, 0x5982, 0x5162, 0x4922, 0x38c2, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 
	0x2000, 0x3000, 0x3820, 0x3820, 0x3020, 0x2820, 0x2020, 0x1800, 0x2820, 0x3020, 0x3020, 0x3020, 0x2800, 0x2020, 0x1041, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0002, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0023, 0x0023, 
	0x10c4, 0x1084, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x1084, 0x10a4, 0x10a4, 0x08a4, 0x08a4, 0x0884, 0x0884, 0x0884, 0x0864, 0x0864, 
	0x0043, 0x0043, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0023, 0x0023, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0042, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0063, 0x0043, 0x0063, 0x0863, 0x0863, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0042, 0x1041, 0x28a1, 0x38c2, 0x2820, 0x2000, 0x2820, 0x2820, 
	0x2020, 0x2000, 0x1820, 0x0800, 0x0800, 0x1820, 0x2000, 0x2000, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2000, 0x2020, 0x2000, 
	0x2000, 0x2000, 0x2020, 0x2060, 0x38c0, 0x4961, 0x4941, 0x38e1, 0x2880, 0x2840, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 
	0x2800, 0x3020, 0x3820, 0x3820, 0x3020, 0x2020, 0x1020, 0x1800, 0x2820, 0x3020, 0x3020, 0x3020, 0x2820, 0x1820, 0x0822, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0022, 0x0023, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0003, 0x0003, 
	0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0064, 0x0043, 
	0x0023, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0023, 0x0023, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0042, 0x0022, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0063, 0x0043, 0x0063, 0x0063, 0x0063, 
	0x0063, 0x0863, 0x0863, 0x0864, 0x0884, 0x0863, 0x0863, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0842, 0x1861, 0x30a1, 0x2000, 0x2000, 0x2820, 0x2820, 
	0x2020, 0x2000, 0x1820, 0x0800, 0x1000, 0x2020, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x1800, 0x1800, 0x1820, 0x2880, 0x38e1, 0x3901, 0x30c1, 0x1820, 0x2000, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 
	0x2820, 0x3020, 0x3820, 0x3820, 0x3020, 0x2820, 0x1820, 0x1800, 0x2020, 0x2820, 0x3020, 0x3020, 0x2820, 0x1820, 0x0822, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0022, 0x0023, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x18c5, 0x10c4, 0x10c4, 0x10a4, 0x10a4, 0x1084, 0x1084, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 0x0864, 0x0864, 0x0043, 0x0023, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0023, 0x0043, 0x0043, 0x0063, 0x0864, 0x0864, 0x0864, 0x0864, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0043, 0x0063, 
	0x0063, 0x0063, 0x0863, 0x0884, 0x0884, 0x0863, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0821, 0x2040, 0x2000, 0x2000, 0x2820, 0x2820, 
	0x2820, 0x2020, 0x1820, 0x1000, 0x1800, 0x2020, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x1800, 0x1000, 0x1020, 0x2880, 0x30a0, 0x30a0, 0x30c1, 0x2040, 0x1800, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 
	0x2800, 0x3020, 0x3820, 0x3820, 0x3020, 0x2820, 0x2020, 0x2000, 0x2820, 0x3020, 0x3020, 0x3820, 0x3020, 0x1820, 0x0821, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0003, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x18e5, 0x18c5, 0x10c4, 0x10c4, 0x10a4, 0x1084, 0x1084, 0x0884, 0x0884, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0023, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0022, 0x0023, 0x0043, 0x0063, 0x0864, 0x0884, 0x0884, 0x0864, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0063, 0x0863, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0022, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0821, 0x2040, 0x2000, 0x2000, 0x2800, 0x2820, 
	0x2820, 0x2000, 0x1800, 0x1800, 0x1800, 0x2020, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x1800, 0x1000, 0x1840, 0x3901, 0x4921, 0x4921, 0x4963, 0x2881, 0x1800, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 
	0x2800, 0x3020, 0x3820, 0x3820, 0x3020, 0x3020, 0x2820, 0x2800, 0x2820, 0x3020, 0x3020, 0x3820, 0x3020, 0x2020, 0x1021, 0x0022, 
	0x0022, 0x0042, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x1906, 0x18e5, 0x10e5, 0x10c5, 0x10a4, 0x10a4, 0x0884, 0x0884, 0x0864, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0022, 0x0023, 0x0043, 0x0063, 0x0863, 0x0884, 0x0884, 0x0884, 0x0863, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0022, 0x0022, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x1061, 0x2082, 0x2860, 0x2000, 0x2000, 0x2800, 0x2820, 
	0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 
	0x2020, 0x1800, 0x1000, 0x2060, 0x4942, 0x5142, 0x5121, 0x59c3, 0x30c1, 0x1800, 0x2000, 0x2020, 0x2820, 0x2800, 0x2820, 0x2000, 
	0x2800, 0x3020, 0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 0x3020, 0x2020, 0x1841, 0x1062, 
	0x0862, 0x0042, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x1906, 0x1906, 0x18e5, 0x18e5, 0x18c5, 0x10a5, 0x10a4, 0x0884, 0x0064, 0x0063, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0042, 0x0043, 0x0023, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0023, 0x0023, 0x0043, 0x0063, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0064, 0x0864, 0x0064, 0x0064, 0x0063, 
	0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0821, 0x28c1, 0x4123, 0x30a0, 0x2000, 0x2000, 0x2800, 0x2820, 
	0x2820, 0x2000, 0x2000, 0x2020, 0x2000, 0x2020, 0x1800, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 
	0x1800, 0x1000, 0x1000, 0x2880, 0x5182, 0x5122, 0x4901, 0x6204, 0x3922, 0x1800, 0x1800, 0x2000, 0x2820, 0x2820, 0x2020, 0x2000, 
	0x2800, 0x3020, 0x3820, 0x3020, 0x2820, 0x3020, 0x3020, 0x3820, 0x3020, 0x3020, 0x3020, 0x3820, 0x3020, 0x2820, 0x2881, 0x28e2, 
	0x28e3, 0x1062, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x1906, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10c5, 0x10a4, 0x08a4, 0x0064, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0003, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0022, 0x0043, 0x0043, 0x0863, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0064, 0x0063, 
	0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0022, 0x1040, 0x4101, 0x4101, 0x5141, 0x2860, 0x2000, 0x2800, 0x2820, 
	0x2020, 0x1800, 0x2000, 0x2020, 0x2020, 0x2000, 0x1800, 0x1800, 0x2020, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x1800, 
	0x1800, 0x1000, 0x1020, 0x38e1, 0x61c3, 0x40e1, 0x40e1, 0x6a04, 0x4963, 0x2040, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2000, 
	0x2000, 0x3000, 0x3020, 0x3020, 0x2820, 0x3020, 0x3020, 0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2880, 0x30c1, 
	0x3902, 0x30e3, 0x0842, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x18e5, 0x18e5, 0x18e5, 0x18c5, 0x18c5, 0x10c4, 0x10c5, 0x10a5, 0x0884, 0x0043, 0x0043, 0x0023, 0x0023, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0022, 0x0023, 0x0043, 0x0864, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0864, 0x0064, 0x0063, 
	0x0063, 0x0043, 0x0063, 0x0063, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0022, 
	0x0022, 0x0042, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0022, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x2080, 0x4922, 0x40e0, 0x7225, 0x4103, 0x2000, 0x2020, 0x2000, 
	0x2000, 0x1800, 0x1800, 0x2820, 0x2820, 0x2020, 0x1800, 0x1800, 0x2000, 0x2000, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1000, 0x2060, 0x4942, 0x5163, 0x3881, 0x38a1, 0x5982, 0x59c4, 0x3902, 0x1800, 0x2000, 0x2020, 0x2020, 0x1820, 0x1800, 
	0x2000, 0x3020, 0x3020, 0x3020, 0x2820, 0x3020, 0x3820, 0x3820, 0x3020, 0x2800, 0x3000, 0x3020, 0x3020, 0x2800, 0x2840, 0x30a0, 
	0x40e1, 0x30e2, 0x1042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x10c5, 0x18c5, 0x10c5, 0x10c5, 0x10c4, 0x10c4, 0x10a4, 0x08a4, 0x0884, 0x0063, 0x0063, 0x0043, 0x0043, 0x0023, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0022, 0x0023, 0x0043, 0x0863, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0864, 0x0863, 0x0863, 0x0864, 0x0063, 0x0063, 
	0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x1881, 0x30e1, 0x48c0, 0x61c4, 0x1800, 0x1800, 0x2020, 0x2820, 
	0x2020, 0x1800, 0x1800, 0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1020, 0x1020, 0x30c1, 0x59a3, 0x4902, 0x2820, 0x3040, 0x4901, 0x59c3, 0x4963, 0x2881, 0x1800, 0x1800, 0x1800, 0x1820, 0x1800, 
	0x2020, 0x3020, 0x3020, 0x3000, 0x2820, 0x2820, 0x3020, 0x3020, 0x2820, 0x2800, 0x3020, 0x3020, 0x2820, 0x2820, 0x2040, 0x38c1, 
	0x4921, 0x51a4, 0x1883, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x10c4, 0x18c4, 0x10a4, 0x10a5, 0x10a4, 0x10a4, 0x10a4, 0x08a4, 0x0884, 0x0884, 0x0864, 0x0864, 0x0063, 0x0023, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0023, 0x0043, 0x0023, 0x0023, 0x0023, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0022, 0x0023, 0x0023, 0x0043, 0x0863, 0x0863, 0x0863, 0x0863, 0x0864, 0x0863, 0x0863, 0x0063, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0022, 0x0022, 0x0023, 0x0821, 0x1020, 0x38a0, 0x5183, 0x1800, 0x1800, 0x2020, 0x2020, 
	0x2000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2020, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2020, 0x1820, 0x1000, 0x1020, 0x1000, 
	0x1000, 0x2880, 0x5182, 0x5162, 0x3881, 0x2820, 0x2820, 0x38a1, 0x5162, 0x59a3, 0x4122, 0x2020, 0x1800, 0x1820, 0x1800, 0x1800, 
	0x2000, 0x2800, 0x3000, 0x3020, 0x2800, 0x2820, 0x3020, 0x3020, 0x2820, 0x2800, 0x2820, 0x3020, 0x2820, 0x2020, 0x2040, 0x1820, 
	0x4102, 0x59e5, 0x1883, 0x0022, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x18c4, 0x10a4, 0x10a4, 0x10a5, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x10a4, 0x08a4, 0x08a4, 0x08a4, 0x0884, 0x0043, 0x0023, 0x0022, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 0x0023, 0x0043, 0x0043, 0x0063, 0x0043, 0x0023, 0x0023, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 
	0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0863, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0023, 0x0022, 0x0800, 0x3080, 0x61e5, 0x1800, 0x1800, 0x1820, 0x2020, 
	0x1800, 0x1800, 0x1800, 0x2020, 0x2000, 0x1800, 0x1800, 0x1000, 0x1800, 0x2000, 0x2000, 0x1820, 0x1020, 0x1000, 0x1000, 0x1000, 
	0x2880, 0x4962, 0x5162, 0x40e1, 0x2820, 0x2820, 0x2820, 0x2820, 0x40c1, 0x5982, 0x5182, 0x4101, 0x2040, 0x1820, 0x1020, 0x1000, 
	0x2000, 0x2800, 0x3000, 0x3020, 0x2820, 0x2820, 0x3020, 0x3020, 0x2820, 0x2020, 0x2820, 0x3020, 0x2820, 0x2020, 0x1840, 0x1820, 
	0x38e1, 0x51a4, 0x1862, 0x0022, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x18c5, 0x18a4, 0x18c5, 0x18c5, 0x10c5, 0x10a5, 0x10a5, 0x10a5, 0x10c4, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x1084, 0x0863, 0x0863, 
	0x0843, 0x0043, 0x0023, 0x0002, 0x0002, 0x0023, 0x0043, 0x0043, 0x0063, 0x0064, 0x0043, 0x0043, 0x0023, 0x0003, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 
	0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0042, 0x0022, 0x0043, 0x0042, 0x0820, 0x28a1, 0x6206, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x1800, 0x1800, 0x1000, 0x1800, 0x1800, 0x2000, 0x1820, 0x1020, 0x1000, 0x1020, 0x28a1, 
	0x4962, 0x5162, 0x4102, 0x2840, 0x2820, 0x2800, 0x2820, 0x2820, 0x2840, 0x40e1, 0x5182, 0x5182, 0x3901, 0x2060, 0x1820, 0x1000, 
	0x1800, 0x2800, 0x3020, 0x3020, 0x2820, 0x2820, 0x3020, 0x3020, 0x2820, 0x2000, 0x2820, 0x3020, 0x2820, 0x2020, 0x1840, 0x1820, 
	0x30c0, 0x6206, 0x20a3, 0x0002, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x18e5, 0x18c5, 0x18c5, 0x18e5, 0x18c5, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x2105, 0x2105, 0x2105, 0x2105, 0x18e5, 0x18c5, 0x10c5, 
	0x10a4, 0x0884, 0x0843, 0x0023, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0043, 0x0043, 0x0023, 0x0003, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0043, 0x0023, 0x0042, 0x0820, 0x28a0, 0x6206, 0x1820, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x1820, 0x1800, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1840, 0x30e1, 0x4142, 
	0x4962, 0x38e1, 0x2840, 0x2020, 0x2820, 0x2800, 0x2820, 0x2820, 0x2820, 0x2840, 0x38c1, 0x4942, 0x5182, 0x4122, 0x28a1, 0x1820, 
	0x1800, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x3020, 0x3020, 0x2820, 0x2000, 0x2800, 0x3020, 0x2820, 0x2020, 0x2020, 0x1820, 
	0x38c0, 0x6225, 0x20c3, 0x0022, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2106, 0x2105, 0x18e5, 
	0x18c5, 0x10a4, 0x1084, 0x0863, 0x0043, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 
	0x0063, 0x0063, 0x0064, 0x0064, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0023, 0x0023, 0x0043, 0x0041, 0x0820, 0x30c1, 0x6205, 0x2040, 0x1000, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1820, 0x2861, 0x38e2, 0x4122, 0x4102, 
	0x30a1, 0x3040, 0x2820, 0x3040, 0x3840, 0x3860, 0x3860, 0x3860, 0x3860, 0x3040, 0x3040, 0x38a0, 0x4922, 0x4962, 0x4142, 0x30c1, 
	0x2860, 0x2020, 0x2800, 0x2820, 0x2020, 0x2020, 0x2820, 0x2820, 0x2820, 0x2000, 0x2820, 0x3020, 0x2820, 0x2020, 0x1820, 0x1820, 
	0x38c0, 0x6a45, 0x3103, 0x0822, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0863, 0x0844, 0x0864, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0003, 
	0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0003, 0x0003, 0x0003, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x20e5, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x1905, 
	0x18e5, 0x18c5, 0x10c4, 0x10a4, 0x0883, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0002, 0x0002, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 
	0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 
	0x0002, 0x0002, 0x0002, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0002, 0x0002, 0x0022, 0x0002, 0x0002, 0x0022, 0x0023, 0x0023, 0x0021, 0x1020, 0x4101, 0x6a25, 0x2881, 0x1000, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1000, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1800, 0x1800, 0x1840, 0x28a1, 0x38e1, 0x40e1, 0x38a1, 0x4080, 
	0x48c0, 0x5921, 0x6161, 0x6961, 0x6982, 0x7182, 0x7182, 0x7182, 0x6982, 0x6982, 0x6142, 0x5921, 0x48e1, 0x40e1, 0x4901, 0x4942, 
	0x4102, 0x38a1, 0x2840, 0x2020, 0x2020, 0x2020, 0x2820, 0x2820, 0x2820, 0x2000, 0x2800, 0x2820, 0x2820, 0x2020, 0x2020, 0x2040, 
	0x30a0, 0x6a45, 0x3103, 0x0822, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0063, 0x0063, 0x0864, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0863, 0x0863, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0003, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0003, 0x0003, 0x0003, 
	0x18e5, 0x18e5, 0x20e5, 0x20e5, 0x20e5, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 
	0x18e5, 0x18c5, 0x10c4, 0x10a4, 0x1084, 0x0864, 0x0063, 0x0043, 0x0023, 0x0023, 0x0023, 0x0043, 0x0023, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0063, 
	0x0064, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0023, 0x0020, 0x1020, 0x4941, 0x6a04, 0x28a1, 0x1000, 0x1800, 0x1800, 
	0x1800, 0x1000, 0x1000, 0x1000, 0x1020, 0x1020, 0x1000, 0x0800, 0x1020, 0x2060, 0x28c1, 0x38e1, 0x48e0, 0x5101, 0x5921, 0x6982, 
	0x7a23, 0x8a84, 0x8aa4, 0x8ae5, 0x9305, 0x9305, 0x9325, 0x9326, 0x9305, 0x8ae5, 0x8aa4, 0x8244, 0x71e3, 0x6161, 0x5941, 0x5941, 
	0x5141, 0x4921, 0x38e1, 0x2860, 0x1820, 0x1800, 0x1820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2820, 0x2820, 0x2000, 0x1820, 0x1840, 
	0x38c0, 0x6204, 0x3923, 0x0822, 0x0002, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0063, 0x0863, 0x0864, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0863, 0x0063, 0x0043, 0x0023, 0x0043, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x20e5, 0x18e5, 0x20e5, 0x20e5, 0x20e5, 0x20e5, 0x2105, 0x20e5, 0x20e5, 0x20e5, 0x20e5, 0x20e5, 0x1905, 0x2105, 0x18e5, 0x18e5, 
	0x18e5, 0x18c5, 0x10c4, 0x10a4, 0x10a4, 0x0884, 0x0884, 0x0063, 0x0043, 0x0043, 0x0023, 0x0043, 0x0023, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 
	0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0022, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0002, 0x0022, 0x0000, 0x1840, 0x5181, 0x6a24, 0x28c1, 0x1000, 0x1000, 0x1000, 
	0x1000, 0x1000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1861, 0x30e1, 0x38e1, 0x4900, 0x6961, 0x79e2, 0x8263, 0x8ae5, 
	0x8b25, 0x8b66, 0x8b66, 0x8b87, 0x8ba7, 0x8ba7, 0x93c7, 0x93e8, 0x8bc7, 0x8b87, 0x8b66, 0x8305, 0x7ac5, 0x82a5, 0x8244, 0x79c2, 
	0x6981, 0x5961, 0x4921, 0x3902, 0x2081, 0x1000, 0x1000, 0x1000, 0x1020, 0x1000, 0x1820, 0x2020, 0x2020, 0x1800, 0x1820, 0x1820, 
	0x38c0, 0x6204, 0x4163, 0x0842, 0x0002, 0x0022, 0x0023, 0x0043, 0x0043, 0x0063, 0x0083, 0x0884, 0x0884, 0x0884, 0x10a4, 0x10a4, 
	0x08a4, 0x0884, 0x0884, 0x0884, 0x0863, 0x0063, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x20e5, 0x18e5, 0x18e5, 0x18e5, 0x20e5, 0x18e5, 0x20e5, 0x20e5, 0x20e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 
	0x18c5, 0x10c4, 0x10c4, 0x10a4, 0x10a4, 0x0884, 0x0884, 0x0883, 0x0063, 0x0043, 0x0023, 0x0023, 0x0023, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0000, 0x1860, 0x59a2, 0x6a24, 0x30e2, 0x0800, 0x1000, 0x1000, 
	0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x2060, 0x38c1, 0x4901, 0x5921, 0x79e2, 0x8aa4, 0x8ae5, 0x8325, 0x7b25, 
	0x6ae5, 0x62c5, 0x5a86, 0x5266, 0x5aa6, 0x6b07, 0x6b27, 0x62e7, 0x5286, 0x5a86, 0x5aa6, 0x5aa5, 0x62a5, 0x7327, 0x8b26, 0x8ac5, 
	0x8a84, 0x7a02, 0x6161, 0x5162, 0x3901, 0x2060, 0x0820, 0x0800, 0x0800, 0x0800, 0x1000, 0x1020, 0x1820, 0x1800, 0x1820, 0x1820, 
	0x38c0, 0x6203, 0x49a4, 0x1062, 0x0002, 0x0022, 0x0023, 0x0043, 0x0043, 0x0063, 0x0084, 0x0884, 0x0884, 0x0884, 0x10a4, 0x10a4, 
	0x10a4, 0x0884, 0x08a4, 0x0884, 0x0884, 0x0863, 0x0043, 0x0043, 0x0043, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 
	0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0003, 0x0003, 0x0003, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18c4, 0x10c4, 
	0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x0884, 0x0884, 0x0884, 0x0063, 0x0043, 0x0023, 0x0023, 0x0023, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 
	0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0003, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0000, 0x2060, 0x59a2, 0x6a23, 0x3923, 0x0800, 0x0800, 0x0800, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x2060, 0x38c0, 0x5100, 0x7181, 0x8a43, 0x8ae4, 0x8b46, 0x7b26, 0x62a5, 0x4a45, 
	0x3184, 0x2144, 0x10c3, 0x08a3, 0x31a5, 0x52c7, 0x3a06, 0x2965, 0x0883, 0x08a3, 0x10c4, 0x2144, 0x39c5, 0x4a45, 0x6ae6, 0x8367, 
	0x9366, 0x9305, 0x8243, 0x69a2, 0x5141, 0x3902, 0x1860, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 0x1020, 0x1820, 
	0x38e0, 0x61e2, 0x5a25, 0x18a2, 0x0022, 0x0022, 0x0023, 0x0043, 0x0063, 0x0063, 0x0084, 0x0884, 0x0884, 0x0884, 0x10a4, 0x10a4, 
	0x10a4, 0x0884, 0x0884, 0x0884, 0x0884, 0x0864, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0003, 0x0003, 0x0003, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e4, 0x18c4, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18c5, 0x18c5, 0x10c4, 0x10a4, 
	0x10a4, 0x10a4, 0x10a4, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0063, 0x0043, 0x0022, 0x0022, 0x0022, 0x0023, 0x0022, 0x0022, 
	0x0002, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0023, 0x0043, 0x0043, 
	0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0002, 0x0002, 0x0022, 0x0000, 0x1860, 0x61e2, 0x7243, 0x4163, 0x1840, 0x1840, 0x1840, 
	0x1840, 0x1840, 0x1840, 0x1040, 0x1040, 0x1840, 0x38c0, 0x5900, 0x79a1, 0x92a4, 0x8b05, 0x8366, 0x7346, 0x62e7, 0x3185, 0x1924, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x4226, 0x6328, 0x2985, 0x2165, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x1904, 0x39e5, 0x62c6, 
	0x7b26, 0x9366, 0x9305, 0x8a64, 0x69a2, 0x5162, 0x30a1, 0x2040, 0x2040, 0x2060, 0x1860, 0x2060, 0x2040, 0x2060, 0x2060, 0x2860, 
	0x40e0, 0x61e2, 0x6245, 0x20a2, 0x0022, 0x0023, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0023, 0x0023, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0003, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0003, 0x0003, 0x0003, 
	0x18e5, 0x18e5, 0x18e5, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 0x18c5, 0x18c5, 0x18c5, 0x10c5, 0x10a4, 0x10a4, 
	0x10a4, 0x10a4, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0863, 0x0063, 0x0063, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0002, 0x0022, 0x0022, 0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 
	0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0063, 
	0x0863, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0002, 0x0822, 0x0842, 0x0000, 0x1840, 0x61c2, 0x7243, 0x59a2, 0x4121, 0x4921, 0x4921, 
	0x4121, 0x4121, 0x4121, 0x4121, 0x3901, 0x38a0, 0x50e0, 0x8202, 0x92c4, 0x8b25, 0x8366, 0x62a6, 0x4205, 0x4a67, 0x29a5, 0x31c6, 
	0x1924, 0x0083, 0x0083, 0x0083, 0x2165, 0x31c6, 0x2145, 0x2165, 0x0083, 0x0083, 0x0083, 0x0083, 0x08c4, 0x31a5, 0x2165, 0x10e4, 
	0x4205, 0x7b26, 0x8b66, 0x92e5, 0x8a63, 0x71e2, 0x4900, 0x40e0, 0x4921, 0x5161, 0x4961, 0x4941, 0x4941, 0x4961, 0x5161, 0x5161, 
	0x5140, 0x69e1, 0x6a45, 0x28c2, 0x0822, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0863, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0022, 0x0002, 
	0x0003, 0x0003, 0x0003, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0003, 0x0003, 0x0003, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e4, 0x18c4, 0x18e4, 0x18c4, 0x18c4, 0x18c4, 0x10c4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 
	0x10a4, 0x0884, 0x0884, 0x0883, 0x0884, 0x0863, 0x0863, 0x0063, 0x0063, 0x0063, 0x0043, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0023, 0x0023, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0063, 0x0863, 0x0863, 0x0864, 0x0884, 0x0883, 0x0063, 0x0043, 0x0063, 
	0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0022, 0x2061, 0x41a5, 0x0820, 0x1840, 0x59c2, 0x7243, 0x61e2, 0x61e2, 0x61c2, 0x59a2, 
	0x59a2, 0x59a2, 0x5182, 0x4941, 0x5162, 0x5100, 0x79a1, 0x92e4, 0x9386, 0x7b26, 0x5266, 0x18e4, 0x0083, 0x10e4, 0x31e6, 0x6328, 
	0x6328, 0x10c4, 0x0083, 0x0083, 0x4a87, 0x73a9, 0x29a5, 0x2165, 0x0083, 0x0083, 0x0083, 0x0083, 0x2985, 0x2165, 0x0083, 0x0083, 
	0x0083, 0x2964, 0x6ae6, 0x93c8, 0x9b46, 0x92a4, 0x71c2, 0x5961, 0x59a2, 0x61e3, 0x61e3, 0x59c2, 0x61e3, 0x61c2, 0x59c2, 0x61c2, 
	0x5980, 0x69e1, 0x6a64, 0x3123, 0x0842, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0863, 0x0864, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0864, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0023, 0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0022, 
	0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0023, 0x0043, 0x0044, 0x0864, 0x0864, 0x0864, 0x0064, 0x0043, 0x0043, 0x0043, 0x0023, 
	0x0023, 0x0003, 0x0003, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0003, 0x0003, 0x0003, 
	0x18e5, 0x18e5, 0x18e5, 0x18e4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x10c4, 0x10c4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 
	0x1084, 0x0884, 0x0883, 0x0863, 0x0883, 0x0863, 0x0863, 0x0863, 0x0063, 0x0063, 0x0063, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0023, 0x0023, 0x0023, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0063, 0x0864, 
	0x0864, 0x0884, 0x0884, 0x0883, 0x0883, 0x0883, 0x0883, 0x0884, 0x0883, 0x0884, 0x0884, 0x0884, 0x0884, 0x0863, 0x0863, 0x0043, 
	0x0043, 0x0043, 0x0063, 0x0083, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0043, 0x0043, 0x0043, 0x0063, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0821, 0x4102, 0x940d, 0x1061, 0x1040, 0x59c2, 0x6a43, 0x59c2, 0x4961, 0x4101, 0x38e1, 
	0x4101, 0x4942, 0x4122, 0x3080, 0x48e0, 0x7181, 0x92a4, 0x9ba6, 0x8b86, 0x5265, 0x08a3, 0x0083, 0x0083, 0x0083, 0x4247, 0x7bea, 
	0x31c6, 0x4a87, 0x0083, 0x0083, 0x1945, 0x3a26, 0x39e6, 0x2145, 0x0083, 0x0083, 0x0083, 0x08c4, 0x1104, 0x08c4, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x2124, 0x7347, 0x9c08, 0x9325, 0x9264, 0x69a1, 0x40e0, 0x4122, 0x4983, 0x3901, 0x4122, 0x38e1, 0x30a0, 0x38c0, 
	0x4900, 0x61c1, 0x6a44, 0x28e2, 0x0841, 0x0042, 0x0063, 0x0063, 0x0063, 0x0043, 0x0063, 0x0063, 0x0863, 0x0864, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0064, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0023, 
	0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0043, 0x0864, 0x08a5, 0x10a5, 0x08a4, 0x0884, 0x0884, 0x0884, 0x0864, 0x0063, 
	0x0043, 0x0023, 0x0023, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0003, 0x0003, 0x0003, 
	0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 
	0x0884, 0x0863, 0x0883, 0x0863, 0x0863, 0x0863, 0x0863, 0x0884, 0x0884, 0x0864, 0x0063, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 
	0x0023, 0x0022, 0x0022, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0863, 0x0863, 
	0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0863, 0x0863, 0x0863, 0x0063, 0x0063, 0x0043, 
	0x0043, 0x0043, 0x0063, 0x0064, 0x0063, 0x0063, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 
	0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0842, 0x2060, 0x0820, 0x0000, 0x1040, 0x59a1, 0x6a23, 0x51a2, 0x3901, 0x30e1, 0x28a0, 
	0x28c0, 0x3922, 0x30e2, 0x2860, 0x5920, 0x9263, 0x9b65, 0x93e7, 0x6ae7, 0x2165, 0x0083, 0x0083, 0x0083, 0x0083, 0x2985, 0x5ae8, 
	0x5287, 0x4a87, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x10c4, 0x10c4, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x2964, 0x8387, 0xa428, 0x9ae5, 0x8a64, 0x5161, 0x30c1, 0x30e2, 0x28a1, 0x28c1, 0x2060, 0x1840, 0x28a1, 
	0x4120, 0x59c1, 0x6a64, 0x28e1, 0x0821, 0x0042, 0x0063, 0x0863, 0x0063, 0x0063, 0x0063, 0x0063, 0x0863, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0864, 0x0064, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 0x0023, 
	0x0023, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0864, 0x0884, 0x10a4, 0x10a5, 0x10a5, 0x10a4, 0x10a4, 0x0884, 0x0884, 0x0884, 
	0x0864, 0x0063, 0x0043, 0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0003, 0x0003, 0x0003, 
	0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x0884, 
	0x0884, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0884, 0x0884, 0x0084, 0x0063, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0064, 0x0063, 0x0063, 
	0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0863, 0x0883, 0x0863, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0063, 0x0043, 0x0063, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0023, 0x0023, 0x0023, 0x0022, 
	0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 
	0x0022, 0x0023, 0x0023, 0x0023, 0x0043, 0x0842, 0x1840, 0x0020, 0x0000, 0x1020, 0x51a2, 0x6203, 0x4141, 0x30c1, 0x28c1, 0x20a0, 
	0x28a0, 0x3102, 0x30a1, 0x4080, 0x8202, 0x92c4, 0x9be6, 0x7347, 0x4226, 0x8c2a, 0x0083, 0x0083, 0x0083, 0x0083, 0x08a4, 0x10e4, 
	0x08a4, 0x08a3, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x2165, 0x2145, 0x4a26, 0x93c7, 0xa3c7, 0x9ac4, 0x69a2, 0x3901, 0x28c1, 0x2080, 0x28a1, 0x1860, 0x2081, 0x28c1, 
	0x38e1, 0x59a2, 0x6244, 0x3102, 0x0820, 0x0842, 0x0884, 0x0884, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0084, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0023, 0x0023, 0x0043, 0x0063, 0x0064, 0x0884, 0x0884, 0x1084, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0063, 0x0043, 0x0023, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 0x0003, 0x0003, 0x0023, 
	0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x10c4, 0x10c4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x08a4, 0x0884, 
	0x0884, 0x0863, 0x0863, 0x0863, 0x0043, 0x0863, 0x0863, 0x0884, 0x0884, 0x0084, 0x0063, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 
	0x0063, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0863, 0x0884, 0x0883, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0842, 0x1840, 0x0800, 0x0000, 0x1020, 0x4141, 0x4961, 0x38e1, 0x2081, 0x2060, 0x2080, 
	0x2080, 0x28a0, 0x30a0, 0x50e0, 0x9283, 0x93a7, 0x7b87, 0x5aa7, 0x8c2a, 0x52c7, 0x1924, 0x0083, 0x10e4, 0x2165, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x29a5, 0x39e6, 0x4246, 0x31c6, 0x1904, 0x7327, 0xb488, 0xa325, 0x8223, 0x5141, 0x30c1, 0x28a0, 0x30c1, 0x2060, 0x2060, 0x1840, 
	0x2860, 0x40e0, 0x4101, 0x28a0, 0x0820, 0x0842, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0864, 0x0863, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0064, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0023, 0x0043, 0x0043, 0x0043, 0x0063, 0x0884, 0x0884, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0063, 0x0043, 0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x18c5, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x18c4, 0x10c4, 0x10c4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x0884, 
	0x0884, 0x0863, 0x0863, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0064, 0x0064, 0x0064, 
	0x0064, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0884, 0x0883, 0x0063, 0x0064, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0043, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0043, 0x0043, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0043, 0x0043, 0x0064, 0x0842, 0x2060, 0x1020, 0x0000, 0x1020, 0x38e0, 0x4920, 0x38e1, 0x2040, 0x2060, 0x38e1, 
	0x3901, 0x4101, 0x5120, 0x79a1, 0x92c4, 0x9407, 0x7ba8, 0x52a7, 0x1945, 0x10e4, 0x10c4, 0x4246, 0x8c4a, 0x39e6, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x4a87, 
	0x52c7, 0x1904, 0x10e4, 0x08c4, 0x0883, 0x3185, 0x8bc7, 0xabc6, 0x9284, 0x6982, 0x4901, 0x4101, 0x4121, 0x4102, 0x38e1, 0x2840, 
	0x3060, 0x5141, 0x59a2, 0x3901, 0x0820, 0x0862, 0x0884, 0x08a4, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0064, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 
	0x0023, 0x0023, 0x0043, 0x0043, 0x0063, 0x0864, 0x0884, 0x0884, 0x10a4, 0x10a4, 0x10a4, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x08a4, 0x0884, 0x0064, 0x0043, 0x0043, 0x0023, 0x0023, 0x0003, 0x0002, 0x0002, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10c5, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x08a4, 0x0884, 
	0x0884, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0043, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 
	0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0064, 0x0064, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0842, 0x2860, 0x1861, 0x0000, 0x1020, 0x4941, 0x5981, 0x4921, 0x2040, 0x30a0, 0x4901, 
	0x4901, 0x4901, 0x5900, 0x8a22, 0x9305, 0x8be8, 0x39e5, 0x1904, 0x0083, 0x0083, 0x08a3, 0x3a06, 0x6328, 0x10e4, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x31c5, 
	0x29a5, 0x08a3, 0x0083, 0x0083, 0x0083, 0x08a3, 0x7ba9, 0xbce9, 0xa325, 0x79c2, 0x5121, 0x4901, 0x4921, 0x4922, 0x4102, 0x3081, 
	0x3880, 0x5161, 0x59c2, 0x3901, 0x0820, 0x0863, 0x10a4, 0x10a4, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x08a4, 0x08a4, 
	0x08a4, 0x08a4, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0064, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 
	0x0023, 0x0023, 0x0043, 0x0043, 0x0063, 0x0064, 0x0884, 0x08a4, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0064, 0x0064, 0x0043, 0x0043, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10c4, 0x10c4, 0x10c4, 0x10c5, 0x10c5, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x08a4, 0x0884, 0x0884, 
	0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0064, 0x0064, 0x0064, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 
	0x0042, 0x0043, 0x0063, 0x0063, 0x0063, 0x0064, 0x0884, 0x0864, 0x0063, 0x0063, 0x0043, 0x0043, 0x0042, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0043, 0x0043, 0x0064, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x1042, 0x2860, 0x1881, 0x0000, 0x1020, 0x4920, 0x61a2, 0x4901, 0x2840, 0x30a1, 0x40e2, 
	0x40e1, 0x38a0, 0x5900, 0x92c4, 0xa469, 0x8409, 0x10c4, 0x0083, 0x0083, 0x0083, 0x08a3, 0x1904, 0x1924, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x08c4, 
	0x08c4, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x6b28, 0xb4c9, 0xa345, 0x8223, 0x5101, 0x3880, 0x38a0, 0x38a1, 0x3081, 0x2840, 
	0x2840, 0x5140, 0x61e2, 0x3901, 0x0820, 0x0863, 0x10a4, 0x08a4, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0084, 0x0064, 0x0063, 0x0063, 0x0043, 0x0043, 0x0064, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 0x0002, 0x0023, 0x0023, 0x0003, 0x0002, 0x0002, 0x0022, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0043, 0x0063, 0x0063, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0064, 0x0064, 0x0063, 0x0064, 0x0864, 
	0x0864, 0x0064, 0x0064, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 
	0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10c4, 0x10c4, 0x10c5, 0x10c5, 0x10c4, 0x10a4, 0x10c4, 0x10a4, 0x08a4, 0x0884, 0x0884, 0x0064, 
	0x0063, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0022, 0x0022, 0x0023, 0x0022, 0x0022, 0x0002, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0064, 0x0064, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0042, 
	0x0043, 0x0043, 0x0063, 0x0063, 0x0064, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0863, 0x0063, 0x0043, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0064, 0x0063, 0x0063, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 
	0x0063, 0x0063, 0x0044, 0x0063, 0x0063, 0x1042, 0x3060, 0x2081, 0x0000, 0x0820, 0x4941, 0x69e3, 0x5163, 0x2020, 0x2040, 0x2861, 
	0x2840, 0x3040, 0x6120, 0x9ae4, 0xace9, 0x83ea, 0x0883, 0x0083, 0x0083, 0x0083, 0x0083, 0x08a3, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x4a46, 0xa468, 0xabc6, 0x9285, 0x5101, 0x3040, 0x3020, 0x2840, 0x2840, 0x2020, 
	0x2840, 0x5161, 0x61e2, 0x3922, 0x1020, 0x1063, 0x10a4, 0x08a4, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0002, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0063, 0x0063, 0x0064, 0x0064, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0064, 0x0064, 
	0x0064, 0x0064, 0x0064, 0x0064, 0x0043, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 
	0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10c4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x08a4, 0x0884, 0x0864, 0x0063, 
	0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0022, 0x0023, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0064, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0063, 0x0064, 0x0064, 0x0884, 0x0884, 0x0884, 0x08a4, 0x0884, 0x0884, 0x0884, 0x0863, 0x0063, 0x0043, 0x0043, 
	0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0043, 0x0043, 0x0064, 0x0064, 
	0x0064, 0x0063, 0x0043, 0x0063, 0x0043, 0x1042, 0x3060, 0x20a1, 0x0000, 0x0820, 0x4101, 0x5982, 0x4922, 0x2020, 0x1800, 0x1800, 
	0x1800, 0x2820, 0x6940, 0x9b04, 0xb50a, 0x8c2b, 0x2165, 0x2165, 0x08c4, 0x10c4, 0x31c6, 0x31c6, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x08a3, 0x08c4, 0x08c4, 0x08c4, 0x10e4, 0x2144, 0x8bc8, 0xb448, 0x9ae5, 0x5901, 0x3040, 0x2820, 0x2820, 0x2020, 0x2020, 
	0x2820, 0x4920, 0x59c2, 0x3101, 0x1020, 0x1083, 0x10a4, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0064, 0x0064, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0064, 0x0064, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 
	0x10a4, 0x08a4, 0x0884, 0x0884, 0x0884, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x08a4, 0x0884, 0x0883, 0x0063, 0x0043, 
	0x0023, 0x0023, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0023, 0x0023, 
	0x0023, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0063, 0x0063, 0x0063, 0x0864, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0863, 0x0063, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0064, 0x0064, 0x0043, 0x1063, 0x1083, 0x0043, 0x0064, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x1041, 0x3060, 0x28e2, 0x0000, 0x0800, 0x30c0, 0x5982, 0x40c1, 0x2000, 0x1800, 0x1800, 
	0x1800, 0x2840, 0x6960, 0x9b05, 0xc56b, 0x9cac, 0x5ae8, 0x6b69, 0x1945, 0x2985, 0x8c4a, 0x6b69, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x1104, 0x2165, 0x2165, 0x2165, 0x2985, 0x10e4, 0x7b88, 0xb469, 0x9ae5, 0x5921, 0x3040, 0x2820, 0x2820, 0x2020, 0x2020, 
	0x2000, 0x4921, 0x6203, 0x30e1, 0x0820, 0x1082, 0x10a4, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0064, 0x0063, 0x0043, 0x0023, 0x1883, 0x18c4, 0x0023, 0x0043, 0x0043, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 
	0x10a4, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x08a4, 0x0884, 0x0884, 0x0083, 0x0063, 0x0023, 
	0x0023, 0x0023, 0x0022, 0x0022, 0x0003, 0x0003, 0x0023, 0x0023, 0x0043, 0x0023, 0x0023, 0x0003, 0x0022, 0x0022, 0x0023, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0022, 0x0023, 0x0043, 0x0023, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0063, 0x0064, 0x0864, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 0x0863, 0x0063, 0x0063, 
	0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0002, 0x3944, 0x49c7, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x1041, 0x3880, 0x3922, 0x0000, 0x0800, 0x30c0, 0x61c2, 0x40e2, 0x2000, 0x1820, 0x1800, 
	0x1800, 0x2820, 0x6940, 0x9b05, 0xc58b, 0xa4cc, 0x6b69, 0x7bc9, 0x3a06, 0x4246, 0x9ccb, 0x840a, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x10e4, 0x2145, 0x2145, 0x2145, 0x2165, 0x10e4, 0x7b88, 0xac49, 0x9b06, 0x6142, 0x3060, 0x2840, 0x2820, 0x2020, 0x2020, 
	0x2000, 0x5141, 0x6a44, 0x30e1, 0x0800, 0x18a2, 0x1083, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0864, 
	0x0064, 0x0043, 0x0043, 0x0002, 0x4165, 0x49e7, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 
	0x10a4, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x10a4, 0x10a4, 0x10a4, 0x08a4, 0x0884, 0x0083, 0x0063, 0x0043, 0x0023, 
	0x0023, 0x0023, 0x0003, 0x0002, 0x0003, 0x0003, 0x0023, 0x0023, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0023, 0x0023, 0x0022, 0x0022, 0x0002, 0x0002, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0043, 0x0063, 0x0064, 0x0064, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 
	0x0063, 0x0063, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0884, 0x0884, 0x0084, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0022, 0x4144, 0x4985, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x1021, 0x40a0, 0x51c4, 0x0000, 0x0000, 0x30a0, 0x61e3, 0x4102, 0x2000, 0x1820, 0x1800, 
	0x1800, 0x2020, 0x58e0, 0x9b05, 0xc56a, 0x9c8b, 0x3a06, 0x31c6, 0x31c6, 0x31c6, 0x4a67, 0x52a7, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x08a3, 0x1904, 0x7b87, 0xa3e7, 0x9ae6, 0x6142, 0x3060, 0x3040, 0x2820, 0x2820, 0x2020, 
	0x2000, 0x4941, 0x7264, 0x3101, 0x1020, 0x3123, 0x10a3, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0864, 0x0864, 0x0063, 
	0x0063, 0x0043, 0x0023, 0x0801, 0x4965, 0x3965, 0x0002, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 
	0x10a4, 0x10a4, 0x1084, 0x1084, 0x10a4, 0x0884, 0x0884, 0x0864, 0x0884, 0x08a4, 0x0884, 0x0884, 0x0063, 0x0043, 0x0043, 0x0023, 
	0x0023, 0x0023, 0x0003, 0x0002, 0x0003, 0x0003, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0863, 0x0864, 
	0x0063, 0x0023, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 
	0x0863, 0x0884, 0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x0884, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0083, 
	0x0083, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0083, 0x0083, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0042, 0x3103, 0x3925, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0064, 0x0043, 0x1021, 0x48c0, 0x7aa7, 0x0000, 0x0800, 0x28a0, 0x61e3, 0x4902, 0x2000, 0x1820, 0x1820, 
	0x1000, 0x1800, 0x48a0, 0x9b05, 0xc54a, 0x9429, 0x0883, 0x0083, 0x0083, 0x0083, 0x08a3, 0x08c4, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x39e5, 0x83c8, 0x9b46, 0x9aa5, 0x5922, 0x3040, 0x3040, 0x2820, 0x2820, 0x2020, 
	0x2000, 0x4941, 0x6a64, 0x3902, 0x1020, 0x49a5, 0x18c4, 0x0864, 0x0884, 0x0884, 0x0863, 0x0864, 0x0864, 0x0064, 0x0064, 0x0043, 
	0x0043, 0x0043, 0x0023, 0x0821, 0x30c3, 0x3965, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 
	0x10c4, 0x10a4, 0x10a4, 0x10a5, 0x10a4, 0x0884, 0x0863, 0x0063, 0x0063, 0x0884, 0x0084, 0x0064, 0x0063, 0x0043, 0x0023, 0x0023, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0003, 0x0023, 0x0064, 0x0864, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0063, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0022, 0x0023, 0x0023, 0x0023, 0x0043, 0x0064, 0x0864, 
	0x0884, 0x0884, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x0884, 0x0863, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0863, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x10a4, 0x10a4, 0x10a4, 0x08a4, 0x08a4, 0x0884, 
	0x0884, 0x0883, 0x0884, 0x0884, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0022, 0x28c2, 0x3103, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0044, 0x0043, 0x0841, 0x48a0, 0x9b69, 0x0000, 0x0820, 0x30a0, 0x61e3, 0x4922, 0x2000, 0x1800, 0x1800, 
	0x1000, 0x1800, 0x3880, 0x9ac4, 0xbcc9, 0x9c08, 0x1904, 0x0883, 0x08a3, 0x10c4, 0x29a5, 0x39e6, 0x1904, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x1104, 
	0x2145, 0x10c4, 0x0083, 0x0083, 0x0083, 0x0083, 0x52a7, 0x9449, 0x9325, 0x8a44, 0x48e1, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 
	0x2000, 0x4921, 0x6a44, 0x3922, 0x1820, 0x6246, 0x20e4, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0023, 0x0002, 0x30a1, 0x5184, 0x0822, 0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 
	0x0003, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0003, 0x0003, 
	0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 
	0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 0x0023, 
	0x18c5, 0x10a5, 0x10c5, 0x10c5, 0x10a4, 0x0884, 0x0864, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0022, 0x0022, 
	0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0023, 0x0023, 0x0043, 0x0864, 0x08a4, 0x10a4, 0x10a4, 0x08a4, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0864, 0x0063, 0x0043, 0x0023, 0x0023, 0x0023, 0x0022, 0x0002, 0x0023, 0x0023, 0x0023, 0x0043, 0x0064, 0x0884, 
	0x0884, 0x0884, 0x10a4, 0x10a5, 0x10a5, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x0884, 0x0884, 0x0863, 0x0063, 0x0863, 0x0863, 0x0863, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x10a4, 0x10a4, 0x10a5, 0x10a4, 0x08a4, 0x08a4, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0064, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0821, 0x6a04, 0x8b28, 0x1084, 0x0023, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x1021, 0x48a0, 0xa3a9, 0x0800, 0x0820, 0x30a0, 0x61e3, 0x4922, 0x1800, 0x1820, 0x1800, 
	0x1800, 0x1800, 0x3060, 0x79e2, 0xa345, 0xac68, 0x4a46, 0x10c4, 0x2165, 0x31c5, 0x840a, 0x73a9, 0x6308, 0x08c4, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x4246, 
	0x6b89, 0x31e6, 0x08a4, 0x08c4, 0x08a4, 0x08a3, 0x62e7, 0x9c08, 0x9305, 0x79e3, 0x4081, 0x2800, 0x2820, 0x2820, 0x2020, 0x2020, 
	0x2000, 0x4900, 0x6a43, 0x4121, 0x2040, 0x7b09, 0x2904, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0023, 0x0023, 0x0801, 0x69e4, 0x9b69, 0x18a4, 0x0002, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 
	0x0003, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 
	0x0003, 0x0003, 0x0003, 0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 
	0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 0x0043, 
	0x18e5, 0x18c4, 0x10a4, 0x10a4, 0x0884, 0x0864, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0023, 0x0043, 0x0063, 0x0864, 0x0884, 0x08a4, 0x10a4, 0x08a4, 0x0884, 0x0884, 0x0884, 0x0064, 
	0x0084, 0x0884, 0x0884, 0x0884, 0x0884, 0x0063, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0044, 0x0864, 
	0x0884, 0x1084, 0x10a4, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10a5, 0x10a4, 0x08a4, 0x08a4, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x10a4, 0x10a5, 0x10a4, 0x10a4, 0x10a4, 
	0x10a4, 0x0884, 0x0884, 0x0884, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x1041, 0x6162, 0x7225, 0x1083, 0x0023, 
	0x0043, 0x0043, 0x0043, 0x0063, 0x0043, 0x1021, 0x48c0, 0xa3a9, 0x0000, 0x0820, 0x30a0, 0x61e3, 0x4922, 0x1800, 0x2000, 0x1800, 
	0x1820, 0x1800, 0x2820, 0x5901, 0x9b05, 0xbce9, 0x83a8, 0x2965, 0x52c7, 0x4247, 0x8c4a, 0x5b08, 0x7bc9, 0x31c6, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x2145, 
	0x5ac8, 0x52a7, 0x2145, 0x3a06, 0x2985, 0x2985, 0x7367, 0x9366, 0x92a4, 0x6162, 0x3040, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 
	0x2000, 0x4900, 0x6a23, 0x4142, 0x2040, 0x8329, 0x2905, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0801, 0x40c1, 0x69c4, 0x1063, 0x0002, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 
	0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0002, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 
	0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 
	0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 0x0043, 0x0043, 
	0x2926, 0x2105, 0x18c5, 0x10a5, 0x0884, 0x0043, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0022, 0x0043, 0x0043, 0x0063, 0x0884, 0x08a4, 0x10a4, 0x0884, 0x0864, 0x0864, 0x0864, 0x0063, 
	0x0064, 0x0884, 0x08a4, 0x08a4, 0x0884, 0x0864, 0x0064, 0x0063, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0064, 0x0884, 
	0x0884, 0x10a4, 0x10c4, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10a4, 0x08a4, 0x08a4, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x10a4, 0x10a4, 0x10a4, 
	0x10a4, 0x10a4, 0x0884, 0x0884, 0x0884, 0x0063, 0x0063, 0x0043, 0x0043, 0x0063, 0x0043, 0x0822, 0x3081, 0x40e3, 0x0042, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x1042, 0x40a0, 0x9328, 0x0000, 0x0820, 0x28a0, 0x61e2, 0x4943, 0x1800, 0x2000, 0x2000, 
	0x1800, 0x1820, 0x2000, 0x3860, 0x8a84, 0xac49, 0x8b87, 0x4a46, 0x31c6, 0x52a7, 0x6b48, 0x31e6, 0x08c4, 0x1904, 0x0883, 0x08a3, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x1944, 0x1924, 0x31a5, 0x52a7, 0x29a5, 0x5aa6, 0x8be8, 0x9305, 0x8a44, 0x50e1, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 
	0x2000, 0x48e0, 0x6a23, 0x4942, 0x2040, 0x7ae8, 0x2104, 0x0023, 0x0023, 0x0043, 0x0043, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0022, 0x2861, 0x4923, 0x0823, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 
	0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 
	0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 
	0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 0x0043, 0x0043, 0x0064, 0x0064, 
	0x3167, 0x2947, 0x2946, 0x2126, 0x18e6, 0x10a4, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0043, 0x0064, 0x08a4, 0x10a5, 0x08a4, 0x0884, 0x0864, 0x0864, 0x0863, 
	0x0864, 0x0884, 0x10a4, 0x10a4, 0x08a4, 0x0884, 0x0064, 0x0063, 0x0043, 0x0023, 0x0023, 0x0043, 0x0043, 0x0064, 0x0884, 0x10a5, 
	0x10c5, 0x10c5, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10a4, 0x10a4, 0x08a4, 0x0884, 0x08a4, 0x08a4, 
	0x0884, 0x08a4, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x10a4, 0x10a4, 0x10a4, 
	0x10a4, 0x10c4, 0x10a4, 0x08a4, 0x08a4, 0x0884, 0x0864, 0x0063, 0x0063, 0x0063, 0x0063, 0x0822, 0x28c1, 0x4144, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0842, 0x3060, 0x6a46, 0x0000, 0x0800, 0x28a0, 0x69e3, 0x4943, 0x1800, 0x1800, 0x1820, 
	0x1820, 0x1800, 0x1820, 0x2020, 0x50e1, 0x9ae5, 0xa448, 0x7306, 0x2965, 0x6b48, 0x4a87, 0x1104, 0x0083, 0x0083, 0x2165, 0x4226, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0883, 0x39e6, 0x2985, 0x39e5, 0x7347, 0x8b05, 0x9aa4, 0x7182, 0x3840, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 
	0x2000, 0x40e0, 0x6a03, 0x4962, 0x1840, 0x5a26, 0x18c4, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0044, 0x0022, 0x2081, 0x4164, 0x1084, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0023, 0x0023, 0x0023, 0x0003, 
	0x0003, 0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 
	0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 
	0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 0x0043, 0x0044, 0x0044, 0x0064, 0x0064, 
	0x2966, 0x2947, 0x2947, 0x2947, 0x2127, 0x2126, 0x10c5, 0x0064, 0x0043, 0x0023, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0022, 0x0023, 0x0023, 0x0023, 0x0022, 0x0023, 0x0023, 0x0063, 0x08a4, 0x10c5, 0x10c5, 0x08a4, 0x0864, 0x0863, 0x0863, 
	0x0884, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x08a4, 0x0864, 0x0063, 0x0043, 0x0043, 0x0043, 0x0064, 0x0864, 0x0884, 0x10a5, 0x10c5, 
	0x10c5, 0x10c5, 0x10c4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10c5, 0x10c5, 0x10c5, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x08a4, 0x08a4, 
	0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x10a4, 0x10a4, 
	0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10a4, 0x10a4, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0842, 0x3922, 0x51e5, 0x0884, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0044, 0x0063, 0x0842, 0x2840, 0x4964, 0x0000, 0x0000, 0x28a0, 0x61c2, 0x5163, 0x1820, 0x1800, 0x1820, 
	0x1820, 0x1800, 0x1820, 0x1800, 0x3060, 0x79e2, 0x9b66, 0x9c08, 0x62e7, 0x10e4, 0x08a3, 0x0083, 0x0083, 0x08a4, 0x4226, 0x6b48, 
	0x31a5, 0x31a5, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x2165, 0x840a, 0x6b69, 0x08c4, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x08a3, 0x2985, 0x7326, 0x9387, 0x92e5, 0x8204, 0x48c1, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 0x2000, 
	0x2000, 0x40e1, 0x61c2, 0x5182, 0x1840, 0x3964, 0x1083, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0064, 0x0064, 
	0x0064, 0x0064, 0x0064, 0x0843, 0x30e2, 0x51e5, 0x18a4, 0x0043, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 
	0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0044, 0x0044, 0x0044, 0x0064, 
	0x2146, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x1906, 0x10c5, 0x0884, 0x0864, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0063, 0x0884, 0x08a4, 0x10c5, 0x10a5, 0x0884, 0x0864, 0x0884, 
	0x0884, 0x10a4, 0x10c5, 0x10c5, 0x10c5, 0x08a4, 0x0884, 0x0063, 0x0043, 0x0043, 0x0044, 0x0864, 0x0884, 0x10a4, 0x10a5, 0x10c5, 
	0x10c5, 0x10c4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10a4, 0x10a4, 0x10a4, 0x08a4, 0x08a4, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x10a4, 0x10a4, 0x10c4, 0x10c5, 0x10c5, 0x10c5, 0x10a5, 0x10a4, 0x10a4, 
	0x10a4, 0x10c5, 0x10c5, 0x10a5, 0x10a5, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x0884, 0x0884, 0x1062, 0x4941, 0x6205, 0x18c4, 0x0023, 
	0x0043, 0x0043, 0x0043, 0x0064, 0x0064, 0x0862, 0x2860, 0x30e2, 0x0000, 0x0820, 0x30c0, 0x4900, 0x4922, 0x2861, 0x1800, 0x2000, 
	0x2020, 0x2000, 0x1820, 0x1800, 0x2000, 0x50e1, 0x8a84, 0x9b66, 0x8bc7, 0x5ac7, 0x0083, 0x0083, 0x0083, 0x2165, 0x4a87, 0x3a06, 
	0x3a06, 0x1924, 0x2145, 0x0083, 0x39e6, 0x840a, 0x840a, 0x4a67, 0x0083, 0x0083, 0x08a4, 0x2165, 0x2985, 0x10c4, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x2985, 0x6b06, 0x8ba7, 0x9305, 0x9264, 0x6142, 0x4080, 0x3840, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 
	0x2020, 0x40e0, 0x4920, 0x4941, 0x20a1, 0x20c2, 0x0843, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0064, 0x0064, 0x0064, 
	0x0064, 0x0064, 0x0064, 0x1062, 0x4122, 0x61e4, 0x2904, 0x0844, 0x0064, 0x0044, 0x0044, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0044, 
	0x2126, 0x2105, 0x2105, 0x2106, 0x2105, 0x2105, 0x2105, 0x1905, 0x10e5, 0x10a4, 0x0063, 0x0023, 0x0022, 0x0022, 0x0022, 0x0003, 
	0x0002, 0x0002, 0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0864, 0x08a5, 0x10c5, 0x08a4, 0x0884, 0x0884, 
	0x0884, 0x10a4, 0x10a4, 0x10c5, 0x10a4, 0x0884, 0x0884, 0x0063, 0x0043, 0x0043, 0x0043, 0x0864, 0x0884, 0x08a4, 0x10a5, 0x10a5, 
	0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x08a4, 0x10a4, 0x10c5, 0x10c5, 0x10c5, 0x18c5, 0x18c5, 0x18c5, 0x10c5, 0x10c5, 
	0x10a4, 0x10a4, 0x10a5, 0x10a5, 0x10a5, 0x10c5, 0x10a5, 0x10c5, 0x10a4, 0x10a4, 0x1084, 0x18a2, 0x5161, 0x6204, 0x2905, 0x0043, 
	0x0063, 0x0063, 0x0063, 0x0064, 0x0064, 0x1062, 0x2860, 0x28a1, 0x0000, 0x0800, 0x30c0, 0x5161, 0x4922, 0x2020, 0x1800, 0x1800, 
	0x2000, 0x2000, 0x1800, 0x1800, 0x2040, 0x4921, 0x6141, 0x8a84, 0x9387, 0x8367, 0x5a86, 0x2145, 0x2165, 0x6348, 0x4a67, 0x39e6, 
	0x52a7, 0x08a3, 0x08a4, 0x0083, 0x5ac8, 0x9cab, 0x4226, 0x1104, 0x0083, 0x0083, 0x0083, 0x08a4, 0x08c4, 0x1924, 0x31e6, 0x2145, 
	0x0883, 0x2985, 0x62c6, 0x8346, 0x9305, 0x8a85, 0x6183, 0x48e1, 0x5983, 0x4902, 0x3040, 0x3020, 0x3020, 0x2820, 0x2820, 0x1820, 
	0x2000, 0x40e0, 0x61a1, 0x5182, 0x2060, 0x1041, 0x0043, 0x0023, 0x0043, 0x0043, 0x0023, 0x0043, 0x0043, 0x0064, 0x0064, 0x0064, 
	0x0064, 0x0064, 0x0043, 0x1061, 0x4942, 0x61e3, 0x3945, 0x0864, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 
	0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x2126, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2125, 0x2126, 0x2126, 0x18c5, 0x0864, 0x0043, 0x0023, 0x0003, 0x0003, 0x0003, 
	0x0003, 0x0002, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0064, 0x0864, 0x0884, 0x10a4, 0x10a5, 0x10a5, 0x10a4, 
	0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x08a4, 0x0884, 0x0884, 0x0063, 0x0043, 0x0043, 0x0043, 0x0064, 0x0864, 0x0884, 0x1084, 0x10a4, 
	0x10a5, 0x10c5, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x08a4, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x08a4, 0x10a4, 0x10a4, 0x10c5, 0x10c5, 0x18c5, 0x18c5, 0x18c5, 0x18c5, 0x10c4, 
	0x10c4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10c4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x20a2, 0x5181, 0x59c2, 0x3944, 0x0863, 
	0x0064, 0x0084, 0x0084, 0x0084, 0x0064, 0x1063, 0x2860, 0x20a1, 0x0000, 0x0800, 0x30a0, 0x61c2, 0x5162, 0x1800, 0x1800, 0x1800, 
	0x2000, 0x2000, 0x1820, 0x1800, 0x2040, 0x5162, 0x5142, 0x5121, 0x8a84, 0x9325, 0x8b87, 0x62c6, 0x3a06, 0x52a7, 0x6b69, 0x4a87, 
	0x73a9, 0x0083, 0x0083, 0x0083, 0x5b08, 0xce0e, 0x6b69, 0x08c4, 0x0083, 0x0083, 0x0083, 0x0083, 0x31c6, 0x4267, 0x2165, 0x1924, 
	0x4225, 0x7326, 0x8366, 0x92e5, 0x92a5, 0x61a3, 0x3081, 0x40e1, 0x61e4, 0x5142, 0x3060, 0x3020, 0x2820, 0x2820, 0x2020, 0x1820, 
	0x1800, 0x40e0, 0x69e1, 0x61e3, 0x2060, 0x1041, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0064, 0x0064, 
	0x0064, 0x0064, 0x0063, 0x1881, 0x5161, 0x61c2, 0x51c5, 0x10a4, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2106, 0x2926, 0x2926, 0x2106, 0x18e5, 0x10a5, 0x0884, 0x0044, 0x0023, 0x0023, 
	0x0003, 0x0003, 0x0023, 0x0023, 0x0064, 0x0064, 0x0063, 0x0063, 0x0084, 0x0884, 0x0884, 0x08a4, 0x10a4, 0x10a5, 0x10c5, 0x10c5, 
	0x10a4, 0x10a5, 0x10a5, 0x10a4, 0x0884, 0x0884, 0x0084, 0x0063, 0x0043, 0x0043, 0x0043, 0x0063, 0x0864, 0x0884, 0x0884, 0x10a4, 
	0x10a4, 0x10a4, 0x10a5, 0x10a5, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x08a4, 0x08a4, 0x10c4, 0x10c5, 0x18c5, 0x18c5, 0x18c5, 0x10c4, 0x10c4, 
	0x10c4, 0x10a4, 0x10c4, 0x10a4, 0x10a4, 0x10c4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x1083, 0x28c2, 0x5981, 0x61e2, 0x49a4, 0x0883, 
	0x0084, 0x0884, 0x0884, 0x0884, 0x0884, 0x1062, 0x38a0, 0x28a1, 0x0000, 0x0800, 0x30a0, 0x69e2, 0x5982, 0x2040, 0x1800, 0x1800, 
	0x2000, 0x2000, 0x2020, 0x1800, 0x2840, 0x5981, 0x5162, 0x2860, 0x4901, 0x7a23, 0x9346, 0x8b87, 0x6b06, 0x5286, 0x5ac7, 0x4226, 
	0x29a5, 0x0083, 0x0083, 0x0083, 0x5b08, 0xb56c, 0x7389, 0x39e6, 0x0083, 0x0083, 0x0083, 0x0083, 0x1924, 0x31c5, 0x41e5, 0x5a85, 
	0x7b87, 0x8b87, 0x92e5, 0x8264, 0x6183, 0x2881, 0x1800, 0x38c0, 0x61c2, 0x5962, 0x3860, 0x2820, 0x2820, 0x2020, 0x2020, 0x1820, 
	0x1800, 0x40e0, 0x69e1, 0x6a03, 0x2880, 0x1041, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0063, 0x0064, 0x0063, 0x20a1, 0x61c2, 0x6a03, 0x59e5, 0x18c4, 0x0884, 0x0884, 0x0084, 0x0064, 0x0044, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 
	0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2106, 0x2126, 0x2126, 0x2106, 0x1906, 0x18e5, 0x10c5, 0x0884, 0x0043, 
	0x0023, 0x0003, 0x0023, 0x0023, 0x0043, 0x0064, 0x0063, 0x0063, 0x0084, 0x0884, 0x08a4, 0x10a4, 0x10a4, 0x10a5, 0x10c5, 0x10c5, 
	0x10a4, 0x10a4, 0x10a4, 0x0884, 0x0884, 0x0864, 0x0064, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0864, 0x0864, 0x1084, 
	0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 0x1084, 0x1084, 0x1083, 0x0883, 0x1084, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x08a4, 0x10a4, 0x10a4, 0x10c4, 0x10c5, 0x10c5, 0x10c5, 0x10c4, 0x10a4, 
	0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1083, 0x3102, 0x61e1, 0x7222, 0x59e4, 0x1084, 
	0x0084, 0x0883, 0x0884, 0x08a4, 0x0884, 0x1862, 0x5121, 0x28c1, 0x0000, 0x1020, 0x5181, 0x6a01, 0x69e2, 0x4122, 0x1800, 0x1820, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x38a0, 0x61a1, 0x59a1, 0x4101, 0x2880, 0x38c1, 0x61c2, 0x8ac5, 0x8b46, 0x7b26, 0x62a6, 0x5286, 
	0x3185, 0x18e4, 0x10c3, 0x08a3, 0x2985, 0x4a67, 0x31c6, 0x2165, 0x08a3, 0x08c3, 0x10e3, 0x2124, 0x39e5, 0x5aa5, 0x6b05, 0x8386, 
	0x9366, 0x92c5, 0x7a03, 0x5142, 0x2881, 0x1020, 0x2060, 0x4940, 0x69e1, 0x69e2, 0x48e1, 0x3040, 0x2820, 0x2820, 0x2020, 0x2020, 
	0x2840, 0x5960, 0x7200, 0x7222, 0x4942, 0x1861, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0064, 0x0042, 0x28a1, 0x61e2, 0x7202, 0x6204, 0x2905, 0x0884, 0x08a5, 0x08a5, 0x0885, 0x0064, 0x0044, 0x0043, 0x0043, 
	0x0043, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 
	0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2106, 0x2106, 0x2126, 0x2106, 0x18e5, 0x10a4, 0x0864, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0064, 0x0884, 0x08a4, 0x08a4, 0x10a4, 0x10c5, 0x10a4, 
	0x10a4, 0x10a4, 0x0884, 0x0884, 0x0884, 0x0864, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0063, 0x0064, 0x0864, 0x0884, 0x1084, 
	0x1084, 0x1084, 0x08a4, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 0x18a4, 0x2925, 0x1084, 0x0884, 0x0884, 0x0884, 0x0884, 0x0864, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x1084, 0x10a4, 0x10a4, 0x10a4, 0x10a5, 0x10c5, 0x10c5, 0x10c4, 0x10c4, 
	0x10c4, 0x10c4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10c5, 0x1083, 0x3922, 0x69e1, 0x6a22, 0x5a04, 0x10a4, 
	0x0064, 0x0883, 0x0884, 0x0884, 0x0884, 0x1882, 0x5961, 0x28c1, 0x0000, 0x1840, 0x6a22, 0x6a01, 0x7201, 0x59c4, 0x2020, 0x2880, 
	0x30a1, 0x38c1, 0x30a0, 0x38c0, 0x5961, 0x69e1, 0x69e1, 0x59c2, 0x30e1, 0x0800, 0x2880, 0x5121, 0x6a03, 0x82c5, 0x82c5, 0x7306, 
	0x62c6, 0x4a25, 0x39a4, 0x2964, 0x2944, 0x2944, 0x2964, 0x3164, 0x3984, 0x41e4, 0x4a25, 0x5aa6, 0x7346, 0x8346, 0x8b05, 0x8ae5, 
	0x7a44, 0x6182, 0x40e1, 0x2060, 0x1020, 0x1000, 0x30a0, 0x61c1, 0x7a21, 0x7a22, 0x61a2, 0x4921, 0x4901, 0x4101, 0x4101, 0x38c1, 
	0x3880, 0x69c0, 0x7a20, 0x7a21, 0x6a03, 0x2082, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0064, 0x0842, 0x28c1, 0x6a02, 0x7202, 0x6a24, 0x3125, 0x0864, 0x08a5, 0x08a5, 0x0885, 0x0885, 0x0064, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 
	0x2126, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x20e5, 0x20e5, 0x20e5, 0x20e5, 0x1905, 0x18e5, 0x10c5, 0x10a4, 
	0x0864, 0x0023, 0x0023, 0x0023, 0x0043, 0x0063, 0x0064, 0x0043, 0x0043, 0x0064, 0x0884, 0x0884, 0x0884, 0x0884, 0x10a4, 0x10a4, 
	0x10a4, 0x10a4, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0864, 0x0064, 0x0084, 0x0884, 0x0884, 0x0884, 0x0884, 0x08a4, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0864, 0x0863, 0x0822, 0x30e3, 0x6268, 0x1882, 0x1083, 0x0884, 0x0884, 0x0864, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x08a4, 0x10a4, 0x10a4, 0x10a4, 0x10c5, 0x10c5, 0x10c5, 0x18e5, 0x18c5, 0x10c5, 0x18c5, 
	0x10c4, 0x10c4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a5, 0x1083, 0x4122, 0x69e1, 0x6a01, 0x6224, 0x18e4, 
	0x0064, 0x0084, 0x0884, 0x0084, 0x0884, 0x1862, 0x5940, 0x28a1, 0x0000, 0x1840, 0x6a21, 0x6a00, 0x7221, 0x61e3, 0x2840, 0x4922, 
	0x4942, 0x5182, 0x4942, 0x5141, 0x69e2, 0x7200, 0x7201, 0x69e2, 0x4122, 0x0800, 0x0800, 0x1820, 0x3080, 0x5142, 0x69e3, 0x7264, 
	0x7aa5, 0x72a5, 0x6a85, 0x5a45, 0x5a25, 0x5225, 0x5a24, 0x5a45, 0x6a85, 0x72c5, 0x7b05, 0x8b05, 0x82e5, 0x8264, 0x7203, 0x6183, 
	0x40e1, 0x2860, 0x1820, 0x1000, 0x1000, 0x1000, 0x38c0, 0x69e1, 0x7a21, 0x7a21, 0x7202, 0x61c2, 0x59a2, 0x59c3, 0x5163, 0x4942, 
	0x40c0, 0x69c0, 0x7a20, 0x7a20, 0x7223, 0x2082, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 
	0x0064, 0x0064, 0x0842, 0x30e1, 0x6a02, 0x7201, 0x6a24, 0x3965, 0x0864, 0x0884, 0x0885, 0x0885, 0x0885, 0x0064, 0x0064, 0x0043, 
	0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 
	0x2126, 0x2105, 0x2105, 0x2105, 0x2106, 0x2105, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x18e5, 0x18c5, 0x10c5, 0x10c5, 0x10c5, 0x10a5, 
	0x0884, 0x0064, 0x0043, 0x0064, 0x0884, 0x0884, 0x08a4, 0x08a4, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x10a4, 0x0884, 0x0884, 0x0884, 0x10a4, 0x08a4, 0x08a4, 0x0884, 0x0884, 0x0884, 0x0084, 0x0064, 0x0084, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0863, 0x1042, 0x4165, 0x61c4, 0x7225, 0x59e6, 0x28e4, 0x1884, 0x1084, 0x0884, 0x0884, 
	0x0884, 0x08a4, 0x0884, 0x0884, 0x10a4, 0x10a4, 0x10a5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 
	0x10c4, 0x10c5, 0x10c5, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10a4, 0x10a4, 0x10a5, 0x18a3, 0x4962, 0x69e1, 0x69e1, 0x6a24, 0x2925, 
	0x0064, 0x0084, 0x0084, 0x0884, 0x0884, 0x1062, 0x5920, 0x28a1, 0x0000, 0x1840, 0x6a01, 0x6a00, 0x7221, 0x61c3, 0x3060, 0x4922, 
	0x4901, 0x5183, 0x40e1, 0x4901, 0x69e1, 0x71e0, 0x7200, 0x6a02, 0x4143, 0x0800, 0x0800, 0x0800, 0x0800, 0x1020, 0x2880, 0x40e1, 
	0x5142, 0x5982, 0x61e3, 0x6a04, 0x7244, 0x7264, 0x7264, 0x7a64, 0x7264, 0x7244, 0x6a03, 0x69c2, 0x5962, 0x4922, 0x38c1, 0x2060, 
	0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x40c0, 0x71e1, 0x7a21, 0x7a21, 0x7203, 0x5982, 0x4921, 0x5184, 0x4102, 0x4922, 
	0x40e0, 0x69c0, 0x7a20, 0x7a20, 0x6a23, 0x20a2, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0044, 0x0064, 0x0064, 0x0064, 
	0x0064, 0x0064, 0x0842, 0x3922, 0x6a23, 0x6a01, 0x6a23, 0x4185, 0x0864, 0x0064, 0x0885, 0x0885, 0x0884, 0x0064, 0x0064, 0x0064, 
	0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x2126, 0x2105, 0x2105, 0x2105, 0x2105, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10c5, 0x10c5, 0x10c5, 0x10a5, 0x08a4, 0x0885, 
	0x0884, 0x0064, 0x0044, 0x0864, 0x0884, 0x10a5, 0x10c5, 0x10c5, 0x10c5, 0x10a4, 0x08a4, 0x0884, 0x0864, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x10a4, 0x10a4, 0x10a4, 0x08a4, 0x08a4, 0x0884, 0x0884, 0x0064, 0x0063, 0x0043, 0x0063, 0x0884, 0x0084, 0x0084, 
	0x0064, 0x0064, 0x0084, 0x0884, 0x0864, 0x1883, 0x3903, 0x5123, 0x92a6, 0xab88, 0x7246, 0x5a07, 0x5a49, 0x1084, 0x0863, 0x0884, 
	0x0884, 0x08a4, 0x0884, 0x0884, 0x10a4, 0x10a5, 0x10c5, 0x10c5, 0x18c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c4, 0x10c4, 
	0x10c5, 0x10c4, 0x10c4, 0x10a4, 0x10c4, 0x10c4, 0x10c4, 0x10a4, 0x10a4, 0x10a5, 0x1882, 0x5162, 0x69e1, 0x69e1, 0x6a24, 0x3966, 
	0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x1062, 0x5100, 0x28a2, 0x0000, 0x1840, 0x6201, 0x6a01, 0x7201, 0x61e3, 0x3080, 0x38e2, 
	0x2860, 0x4123, 0x2040, 0x3880, 0x69c1, 0x71e0, 0x7200, 0x6a02, 0x4143, 0x1000, 0x1000, 0x0800, 0x0800, 0x0000, 0x0800, 0x0800, 
	0x1000, 0x1840, 0x2880, 0x40e1, 0x5942, 0x6162, 0x6182, 0x6182, 0x5142, 0x4102, 0x30a1, 0x2060, 0x1820, 0x1000, 0x0800, 0x0800, 
	0x0800, 0x1000, 0x1820, 0x1820, 0x1820, 0x1800, 0x40c0, 0x71e1, 0x7a21, 0x7a21, 0x6a03, 0x4942, 0x30a0, 0x4943, 0x30a1, 0x40e1, 
	0x40e0, 0x69e1, 0x7a20, 0x7a20, 0x6a23, 0x20a2, 0x0023, 0x0044, 0x0043, 0x0043, 0x0064, 0x0044, 0x0044, 0x0064, 0x0064, 0x0084, 
	0x0084, 0x0064, 0x0842, 0x4142, 0x6a02, 0x69e1, 0x6a22, 0x49c5, 0x0884, 0x0064, 0x0084, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 
	0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x2126, 0x2106, 0x1906, 0x1906, 0x2105, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10c5, 0x10c5, 0x10c5, 0x10a4, 0x08a4, 0x08a4, 0x0884, 
	0x0064, 0x0043, 0x0043, 0x0064, 0x0884, 0x10a4, 0x10a5, 0x10a4, 0x10a4, 0x08a4, 0x0884, 0x0063, 0x0043, 0x0864, 0x0884, 0x0864, 
	0x0884, 0x10a4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x08a4, 0x0884, 0x0884, 0x0063, 0x0043, 0x0043, 0x0063, 0x0064, 0x0063, 0x0064, 
	0x0063, 0x0063, 0x0064, 0x0884, 0x0863, 0x1862, 0x82a9, 0x8246, 0x9ac5, 0xab67, 0x8265, 0x7267, 0x3124, 0x1063, 0x1064, 0x0884, 
	0x0884, 0x08a4, 0x0884, 0x0884, 0x10a4, 0x10a4, 0x10a5, 0x10c5, 0x18c5, 0x18c5, 0x10c5, 0x10c5, 0x10a5, 0x10a4, 0x10a4, 0x10c4, 
	0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x18a2, 0x5181, 0x69e1, 0x69e1, 0x6a23, 0x41a6, 
	0x0043, 0x0064, 0x0064, 0x0063, 0x0063, 0x0842, 0x48e0, 0x28c2, 0x0000, 0x1840, 0x6202, 0x6a02, 0x6a02, 0x61e3, 0x30a1, 0x30c2, 
	0x2860, 0x4123, 0x2040, 0x30a0, 0x61c1, 0x7201, 0x7222, 0x6a03, 0x4122, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 
	0x0800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x2040, 0x2060, 0x1840, 0x1000, 0x1000, 0x1000, 0x1000, 
	0x1000, 0x1820, 0x1820, 0x1820, 0x1820, 0x1800, 0x40c0, 0x71e2, 0x7a22, 0x7a22, 0x6a04, 0x4123, 0x28a0, 0x4143, 0x30a1, 0x4922, 
	0x5121, 0x69e2, 0x7a42, 0x7a42, 0x6a24, 0x18a2, 0x0043, 0x0044, 0x0044, 0x0044, 0x0064, 0x0044, 0x0064, 0x0064, 0x0064, 0x0084, 
	0x0084, 0x0064, 0x0842, 0x4962, 0x6a02, 0x7201, 0x7222, 0x51e5, 0x1083, 0x0064, 0x0084, 0x0084, 0x0064, 0x0044, 0x0044, 0x0043, 
	0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x2126, 0x2106, 0x1906, 0x1905, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10c5, 0x10c5, 0x10c4, 0x10a4, 0x10a4, 0x08a4, 0x0884, 0x0884, 
	0x0064, 0x0043, 0x0043, 0x0043, 0x0864, 0x0884, 0x08a4, 0x10a4, 0x0884, 0x0884, 0x0864, 0x0043, 0x0063, 0x0864, 0x0884, 0x0884, 
	0x0884, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x08a4, 0x08a4, 0x0884, 0x0884, 0x0063, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 
	0x0063, 0x0064, 0x0064, 0x0884, 0x0884, 0x1043, 0x3061, 0x8245, 0x9b06, 0x79e3, 0x8a86, 0x6a26, 0x3105, 0x0864, 0x1084, 0x1084, 
	0x0884, 0x1084, 0x0884, 0x08a4, 0x10a4, 0x10a4, 0x10a4, 0x10c5, 0x10c5, 0x18c5, 0x10c5, 0x10c5, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 
	0x10a4, 0x10a4, 0x10a4, 0x10c4, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x20a2, 0x5981, 0x69e1, 0x69e1, 0x6a03, 0x49c6, 
	0x0863, 0x0043, 0x0043, 0x0043, 0x0063, 0x0842, 0x40c0, 0x30e2, 0x0000, 0x1840, 0x61e3, 0x6a24, 0x6a04, 0x61e4, 0x30c2, 0x28a1, 
	0x2061, 0x3924, 0x2081, 0x30c1, 0x61e3, 0x7224, 0x6a24, 0x6205, 0x4103, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x2020, 0x2040, 0x30e1, 0x4142, 0x30a1, 0x1820, 0x1800, 0x1820, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x38a1, 0x69c3, 0x71e3, 0x69e4, 0x59c4, 0x30e2, 0x2061, 0x30e3, 0x2061, 0x4942, 
	0x61c3, 0x6a03, 0x7204, 0x7204, 0x6205, 0x1883, 0x0043, 0x0064, 0x0064, 0x0044, 0x0043, 0x0063, 0x0064, 0x0064, 0x0064, 0x0064, 
	0x0064, 0x0064, 0x1042, 0x4962, 0x7202, 0x71e1, 0x6a22, 0x5a05, 0x18c4, 0x0044, 0x0064, 0x0084, 0x0064, 0x0064, 0x0063, 0x0043, 
	0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x2126, 0x2106, 0x2106, 0x18e5, 0x18e5, 0x18e5, 0x18c5, 0x10c5, 0x10c5, 0x10c5, 0x10a4, 0x10a4, 0x10a4, 0x0884, 0x0884, 0x0864, 
	0x0044, 0x0043, 0x0043, 0x0864, 0x0884, 0x08a4, 0x10a5, 0x0884, 0x0884, 0x0884, 0x0063, 0x0043, 0x0063, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x08a4, 0x0884, 0x0884, 0x0084, 0x0063, 0x0064, 0x0043, 0x0043, 0x0043, 0x0064, 0x0064, 
	0x0064, 0x0064, 0x0063, 0x0063, 0x0864, 0x0843, 0x3924, 0x61e5, 0x7a25, 0x8a85, 0x7204, 0x6207, 0x20e5, 0x0884, 0x1084, 0x10a4, 
	0x10a4, 0x1084, 0x08a4, 0x08a4, 0x10a4, 0x10a4, 0x10c4, 0x10a4, 0x10a5, 0x10c5, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x1084, 
	0x08a4, 0x08a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10c4, 0x10a5, 0x1084, 0x20a2, 0x59a1, 0x69c1, 0x69e2, 0x6a03, 0x51e6, 
	0x1084, 0x0043, 0x0043, 0x0043, 0x0063, 0x0042, 0x30a1, 0x4944, 0x0800, 0x0800, 0x3081, 0x3081, 0x3081, 0x2881, 0x1840, 0x0800, 
	0x0820, 0x1040, 0x0820, 0x30c0, 0x59c3, 0x38a1, 0x2840, 0x3061, 0x2040, 0x1000, 0x1800, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x2040, 0x4922, 0x5162, 0x4902, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x2000, 0x2800, 0x3000, 0x2820, 0x1020, 0x0800, 0x0020, 0x0820, 0x0800, 0x3921, 
	0x59a3, 0x2840, 0x3000, 0x3020, 0x1841, 0x0042, 0x0044, 0x0044, 0x0043, 0x0842, 0x18a3, 0x1063, 0x0044, 0x0064, 0x0064, 0x0064, 
	0x0064, 0x0064, 0x1041, 0x4962, 0x7202, 0x71e1, 0x7202, 0x6204, 0x20e5, 0x0044, 0x0064, 0x0064, 0x0064, 0x0064, 0x0063, 0x0043, 
	0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x2106, 0x2106, 0x2105, 0x18e5, 0x18e5, 0x18e5, 0x18c5, 0x18c5, 0x10c5, 0x10c5, 0x10a4, 0x10a4, 0x0884, 0x0884, 0x0884, 0x0864, 
	0x0864, 0x0864, 0x0884, 0x10c5, 0x10c5, 0x10e5, 0x10a5, 0x0884, 0x08a4, 0x0884, 0x0884, 0x0063, 0x0064, 0x0884, 0x08a4, 0x08a4, 
	0x08a4, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0084, 0x0084, 0x0084, 0x0064, 0x0064, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0863, 0x3125, 0x2082, 0x6a26, 0x8ae7, 0x4122, 0x3966, 0x18c5, 0x0884, 0x10a4, 0x10a5, 
	0x10a5, 0x10a5, 0x10a4, 0x08a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x08a4, 0x08a4, 0x10a4, 
	0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x1084, 0x1063, 0x0864, 0x20c2, 0x61a1, 0x69c1, 0x69e2, 0x69e3, 0x5a06, 
	0x10a4, 0x0043, 0x0063, 0x0063, 0x0064, 0x0863, 0x30c2, 0x4164, 0x0800, 0x2040, 0x40e2, 0x2820, 0x1800, 0x1800, 0x0800, 0x0000, 
	0x0000, 0x0000, 0x0820, 0x3942, 0x59c3, 0x40e2, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2820, 0x4923, 0x3040, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2000, 0x2000, 0x2820, 0x4922, 0x5162, 0x40e2, 0x2800, 0x2000, 0x2000, 0x2000, 
	0x2800, 0x2800, 0x2800, 0x2000, 0x2000, 0x38c1, 0x4902, 0x2800, 0x2800, 0x2800, 0x1020, 0x0020, 0x0020, 0x0000, 0x1040, 0x4182, 
	0x5183, 0x2861, 0x2000, 0x2800, 0x1000, 0x0043, 0x0044, 0x0043, 0x0842, 0x2081, 0x59e5, 0x3104, 0x0843, 0x0064, 0x0064, 0x0064, 
	0x0064, 0x0064, 0x1061, 0x5182, 0x7202, 0x71e1, 0x71e2, 0x6204, 0x2925, 0x0044, 0x0064, 0x0064, 0x0064, 0x0064, 0x0063, 0x0043, 
	0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x2126, 0x2105, 0x2105, 0x18e5, 0x18e5, 0x18c5, 0x18c5, 0x18c5, 0x10c5, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x0884, 0x0884, 
	0x0885, 0x10a5, 0x10c5, 0x18e5, 0x1905, 0x18e5, 0x10c5, 0x10a5, 0x10c5, 0x10c5, 0x10c5, 0x08a4, 0x08a4, 0x10a4, 0x10c5, 0x10c5, 
	0x10a4, 0x10a4, 0x10a4, 0x0884, 0x0884, 0x0884, 0x0084, 0x0064, 0x0064, 0x0064, 0x0064, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0063, 0x0063, 0x0863, 0x0884, 0x0863, 0x1062, 0x4143, 0x6a47, 0x3945, 0x0842, 0x0884, 0x08a5, 0x10a5, 0x10a5, 
	0x10c5, 0x10c5, 0x10c5, 0x10a5, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a5, 0x10a5, 0x08a5, 0x08a4, 0x08a4, 0x08a4, 0x08a4, 
	0x0884, 0x08a4, 0x08a4, 0x08a4, 0x0884, 0x0884, 0x0084, 0x20c3, 0x49c6, 0x0864, 0x28e2, 0x61a1, 0x69c1, 0x69e2, 0x69e2, 0x6226, 
	0x20e5, 0x0043, 0x0063, 0x0063, 0x0064, 0x0863, 0x28a2, 0x3103, 0x0000, 0x38e1, 0x7225, 0x59a4, 0x2861, 0x1800, 0x0800, 0x0000, 
	0x0000, 0x0000, 0x0820, 0x3101, 0x4982, 0x3902, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x40e1, 0x61c4, 0x5964, 
	0x2841, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2000, 0x2000, 0x2000, 0x3080, 0x5121, 0x3860, 0x2800, 0x2800, 0x2000, 0x2000, 
	0x2800, 0x2800, 0x2800, 0x2000, 0x3060, 0x59a2, 0x69e4, 0x48c2, 0x3000, 0x2800, 0x1020, 0x0020, 0x0020, 0x0000, 0x1040, 0x3942, 
	0x4943, 0x2881, 0x1800, 0x2000, 0x1021, 0x0043, 0x0044, 0x0043, 0x1062, 0x5164, 0x61c3, 0x6226, 0x2926, 0x0044, 0x0064, 0x0064, 
	0x0064, 0x0043, 0x1881, 0x59a2, 0x71e2, 0x71e1, 0x71e1, 0x6a03, 0x3965, 0x0043, 0x0064, 0x0044, 0x0064, 0x0063, 0x0063, 0x0043, 
	0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x2105, 0x1905, 0x2105, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10c5, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a5, 
	0x18c5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10c5, 0x10a4, 0x10c4, 0x10c5, 0x10c5, 
	0x10c5, 0x10c5, 0x10a4, 0x08a4, 0x0884, 0x0084, 0x0064, 0x0043, 0x0043, 0x0063, 0x0064, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0063, 0x0864, 0x0864, 0x0884, 0x0884, 0x0884, 0x1863, 0x2860, 0x38a0, 0x1862, 0x0864, 0x08a4, 0x08a4, 0x10a4, 0x10a5, 
	0x10c5, 0x10a5, 0x10c5, 0x10c5, 0x08a4, 0x0884, 0x0884, 0x0884, 0x0884, 0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0064, 0x28a2, 0x7267, 0x10a3, 0x30e2, 0x61c1, 0x69e1, 0x69e1, 0x69e2, 0x6a25, 
	0x2925, 0x0043, 0x0063, 0x0064, 0x0064, 0x0864, 0x2083, 0x20c3, 0x0000, 0x38e1, 0x61a3, 0x4922, 0x2820, 0x1800, 0x0800, 0x0000, 
	0x0020, 0x0020, 0x0800, 0x30c0, 0x59c2, 0x3902, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x4101, 0x6a04, 0x5963, 
	0x2820, 0x2000, 0x2800, 0x2800, 0x2800, 0x2000, 0x2000, 0x2000, 0x2020, 0x40e0, 0x5982, 0x40c1, 0x2800, 0x2800, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2800, 0x2800, 0x3880, 0x5982, 0x6a04, 0x48e2, 0x2800, 0x2800, 0x1020, 0x0020, 0x0020, 0x0000, 0x0820, 0x3921, 
	0x59c4, 0x30c2, 0x1800, 0x2000, 0x1022, 0x0043, 0x0044, 0x0043, 0x0842, 0x4123, 0x69e4, 0x4984, 0x1083, 0x0044, 0x0064, 0x0064, 
	0x0063, 0x0043, 0x2081, 0x61a2, 0x71e2, 0x71e2, 0x71e1, 0x6a02, 0x49a4, 0x1042, 0x0043, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x1905, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18c5, 0x10a4, 0x10c4, 0x18c5, 0x18c5, 0x18c5, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18c5, 0x10c4, 0x10a4, 0x10c4, 0x10c4, 
	0x10c4, 0x10c5, 0x10c5, 0x08a4, 0x0084, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0064, 0x0064, 0x0064, 
	0x0064, 0x0864, 0x0884, 0x0884, 0x0884, 0x0884, 0x0885, 0x1862, 0x6162, 0x8243, 0x4984, 0x1084, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 
	0x10a5, 0x10a5, 0x10c5, 0x10a5, 0x0884, 0x0884, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0884, 0x0884, 0x0084, 0x0884, 0x0064, 
	0x0064, 0x0064, 0x0884, 0x0084, 0x0084, 0x0084, 0x0064, 0x28a2, 0x59a5, 0x18a3, 0x30e1, 0x61a1, 0x69e1, 0x69e1, 0x69e2, 0x6a24, 
	0x3965, 0x0043, 0x0043, 0x0064, 0x0064, 0x0064, 0x0863, 0x1882, 0x0000, 0x3902, 0x7245, 0x3880, 0x2000, 0x1800, 0x0800, 0x0000, 
	0x0020, 0x0040, 0x0820, 0x3922, 0x51c2, 0x4963, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x38a0, 0x69e3, 0x40a1, 
	0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x4101, 0x51a1, 0x59a1, 0x5982, 0x40c2, 0x2800, 0x2000, 0x2800, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x4901, 0x69e4, 0x3841, 0x2800, 0x2800, 0x1020, 0x0020, 0x0020, 0x0000, 0x1040, 0x4162, 
	0x51a3, 0x38c2, 0x1800, 0x2000, 0x1022, 0x0043, 0x0024, 0x0044, 0x0022, 0x2881, 0x6204, 0x3103, 0x0023, 0x0044, 0x0064, 0x0083, 
	0x0063, 0x0022, 0x28a1, 0x61c2, 0x71e2, 0x71e1, 0x71e1, 0x69e2, 0x59c3, 0x3903, 0x18c4, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x1905, 0x18e5, 0x18e5, 0x1905, 0x18e5, 0x18e5, 0x2105, 0x2105, 0x1906, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x20e6, 0x18e5, 0x18e5, 
	0x18e5, 0x2105, 0x2105, 0x2105, 0x1905, 0x1906, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 
	0x10c4, 0x10c4, 0x10c5, 0x0884, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0064, 0x0084, 0x0084, 0x0084, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x2082, 0x6182, 0x79e3, 0x59c4, 0x1084, 0x0884, 0x0884, 0x0884, 0x08a4, 
	0x10a4, 0x10a5, 0x10a5, 0x08a5, 0x0884, 0x0884, 0x0084, 0x0084, 0x0084, 0x0084, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 
	0x0064, 0x0064, 0x0064, 0x0064, 0x0084, 0x0084, 0x0043, 0x30e2, 0x5184, 0x1041, 0x4121, 0x61a1, 0x69e1, 0x69e1, 0x69e1, 0x6a24, 
	0x41a5, 0x0043, 0x0023, 0x0043, 0x0064, 0x0044, 0x0044, 0x0863, 0x0820, 0x3901, 0x6a03, 0x40e2, 0x1800, 0x1000, 0x0000, 0x0000, 
	0x0020, 0x0040, 0x0840, 0x3942, 0x51c2, 0x4963, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x3880, 0x61e2, 0x4902, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2000, 0x2860, 0x5162, 0x59a1, 0x59a1, 0x61a2, 0x5964, 0x2820, 0x2000, 0x2800, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x48e1, 0x69e3, 0x40a1, 0x2800, 0x2800, 0x1020, 0x0020, 0x0020, 0x0020, 0x1060, 0x49a2, 
	0x59c3, 0x4103, 0x2000, 0x2000, 0x1022, 0x0044, 0x0044, 0x0044, 0x0022, 0x30c1, 0x6204, 0x4185, 0x0844, 0x0044, 0x0063, 0x0883, 
	0x0862, 0x1041, 0x28a1, 0x61c2, 0x69e2, 0x71e1, 0x71e1, 0x69e1, 0x69e3, 0x51a4, 0x2904, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x1905, 0x18e5, 0x1905, 0x2105, 0x2106, 0x2106, 0x2126, 0x2126, 0x2106, 0x2106, 0x2106, 0x2106, 0x2106, 0x2106, 0x2106, 0x2105, 
	0x2105, 0x2106, 0x2106, 0x2105, 0x2106, 0x2106, 0x2106, 0x1906, 0x1906, 0x18e5, 0x18e5, 0x18e5, 0x18c5, 0x18c5, 0x18c5, 0x10c5, 
	0x10c4, 0x10c4, 0x10c5, 0x0884, 0x0063, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0064, 0x0064, 0x0064, 0x0084, 0x0084, 0x0084, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x1084, 0x2082, 0x48e1, 0x50e0, 0x4922, 0x10a4, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x08a5, 0x08a5, 0x08a5, 0x0884, 0x0064, 0x0064, 0x0064, 0x0084, 0x0084, 0x0064, 0x0064, 0x0064, 0x0064, 0x0043, 0x0064, 
	0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0043, 0x20a1, 0x30a1, 0x0800, 0x4941, 0x61a1, 0x69e1, 0x69e1, 0x69e1, 0x6a03, 
	0x51c5, 0x0863, 0x0022, 0x0043, 0x0044, 0x0044, 0x0044, 0x0043, 0x0821, 0x3921, 0x6203, 0x59a4, 0x2020, 0x1000, 0x0000, 0x0000, 
	0x0020, 0x0020, 0x1040, 0x4121, 0x59c2, 0x59c4, 0x2041, 0x2000, 0x2000, 0x2000, 0x2000, 0x2820, 0x2000, 0x38c0, 0x59c1, 0x61e4, 
	0x3881, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2000, 0x1800, 0x30a0, 0x5181, 0x59a1, 0x5982, 0x3881, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2820, 0x5982, 0x69e3, 0x5122, 0x2800, 0x2800, 0x1020, 0x0020, 0x0020, 0x0840, 0x1860, 0x5182, 
	0x6a03, 0x4923, 0x1800, 0x2000, 0x1022, 0x0044, 0x0044, 0x0043, 0x0821, 0x4142, 0x61e3, 0x51c5, 0x18a4, 0x0044, 0x0044, 0x0862, 
	0x0841, 0x1061, 0x3901, 0x69c2, 0x69c1, 0x71e1, 0x7201, 0x69c1, 0x6a03, 0x4963, 0x18a2, 0x0022, 0x0044, 0x0044, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x2126, 0x2105, 0x2106, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2106, 0x2106, 0x2105, 0x2106, 0x2126, 0x2126, 0x2126, 0x2126, 
	0x2126, 0x2126, 0x2106, 0x2105, 0x2106, 0x2106, 0x2106, 0x1905, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18c5, 0x18c5, 0x18c5, 0x10c4, 
	0x10c4, 0x10c4, 0x10c5, 0x08a4, 0x0084, 0x0043, 0x0043, 0x0043, 0x0063, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 
	0x0064, 0x0064, 0x0864, 0x0864, 0x0884, 0x0884, 0x0884, 0x2881, 0x50e0, 0x5900, 0x61e3, 0x1883, 0x0064, 0x0884, 0x0884, 0x0884, 
	0x0084, 0x0084, 0x0884, 0x0884, 0x0084, 0x0064, 0x0064, 0x0063, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0043, 0x0043, 
	0x0063, 0x0063, 0x0063, 0x0044, 0x0044, 0x0064, 0x0042, 0x30e1, 0x6204, 0x30c1, 0x5160, 0x61a1, 0x61c1, 0x69e1, 0x69e2, 0x69e3, 
	0x59c5, 0x20c3, 0x18c4, 0x0063, 0x0044, 0x0064, 0x0044, 0x0043, 0x1041, 0x51a2, 0x6a43, 0x59e4, 0x2861, 0x1000, 0x0800, 0x0000, 
	0x0000, 0x18c2, 0x28a1, 0x4942, 0x7243, 0x59c3, 0x3081, 0x3881, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x4941, 0x6202, 0x6a04, 
	0x40c2, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x3061, 0x2000, 0x2860, 0x5981, 0x59a1, 0x6182, 0x3061, 0x2000, 0x3061, 0x2800, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x3080, 0x61c2, 0x6a03, 0x61c4, 0x3040, 0x2000, 0x1000, 0x0000, 0x0000, 0x2081, 0x30c1, 0x6a04, 
	0x7244, 0x4963, 0x3081, 0x3061, 0x1001, 0x0843, 0x0043, 0x0022, 0x18a2, 0x6204, 0x6a02, 0x6225, 0x3166, 0x0023, 0x0043, 0x0862, 
	0x0841, 0x1881, 0x4122, 0x69c2, 0x69c1, 0x71e1, 0x7201, 0x69c1, 0x69e2, 0x4942, 0x28e3, 0x18c5, 0x0023, 0x0044, 0x0043, 0x0043, 
	0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x2946, 0x2126, 0x2126, 0x2926, 0x2946, 0x2946, 0x2947, 0x2946, 0x2946, 0x2146, 0x2126, 0x2126, 0x2126, 0x2126, 0x2946, 0x2946, 
	0x2946, 0x2946, 0x2146, 0x2126, 0x2126, 0x2126, 0x2105, 0x2105, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10c5, 0x10c4, 
	0x10c4, 0x10c4, 0x10c4, 0x10c5, 0x08a4, 0x0064, 0x0043, 0x0043, 0x0063, 0x0064, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x0044, 0x0043, 0x0063, 0x0064, 0x0884, 0x0884, 0x0883, 0x3902, 0x6162, 0x5901, 0x61a3, 0x3124, 0x0064, 0x0064, 0x0064, 0x0064, 
	0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0063, 0x0043, 0x0063, 0x0063, 0x0064, 0x0064, 0x0063, 0x0064, 0x0043, 0x0064, 
	0x0043, 0x0043, 0x0064, 0x0044, 0x0044, 0x0044, 0x0842, 0x28c1, 0x5181, 0x5161, 0x5181, 0x59a0, 0x61c1, 0x61c1, 0x61c1, 0x61e2, 
	0x59e4, 0x3903, 0x2925, 0x0044, 0x0044, 0x0064, 0x0044, 0x0043, 0x28e1, 0x59e3, 0x51a2, 0x59c3, 0x4123, 0x1000, 0x0000, 0x0000, 
	0x0000, 0x3164, 0x4142, 0x5182, 0x7263, 0x61e3, 0x40e2, 0x5123, 0x2800, 0x2000, 0x2000, 0x2000, 0x2860, 0x51c2, 0x5181, 0x59a2, 
	0x4902, 0x2800, 0x2000, 0x2000, 0x2000, 0x2800, 0x4903, 0x3061, 0x4921, 0x61c2, 0x59a1, 0x61a2, 0x4101, 0x2840, 0x5144, 0x2820, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x4122, 0x5982, 0x5961, 0x61c4, 0x38a1, 0x2000, 0x1000, 0x0000, 0x0000, 0x3922, 0x5162, 0x6a03, 
	0x7223, 0x59c4, 0x4922, 0x4103, 0x1000, 0x0022, 0x0043, 0x0022, 0x20c2, 0x5183, 0x5141, 0x4962, 0x2904, 0x0044, 0x0043, 0x0862, 
	0x0821, 0x20a1, 0x5162, 0x61a1, 0x69a1, 0x71e1, 0x7202, 0x69c1, 0x61a1, 0x5162, 0x4164, 0x20e5, 0x0023, 0x0024, 0x0024, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x2967, 0x2946, 0x2946, 0x2947, 0x2967, 0x2967, 0x2967, 0x2967, 0x2987, 0x2967, 0x2947, 0x2946, 0x2946, 0x2946, 0x2946, 0x2946, 
	0x2966, 0x2966, 0x2946, 0x2946, 0x2126, 0x2126, 0x2106, 0x2106, 0x2105, 0x2105, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x18c5, 0x10c4, 
	0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10a5, 0x0884, 0x0064, 0x0043, 0x0043, 0x0043, 0x0044, 0x0044, 0x0044, 0x0044, 0x0043, 0x0044, 
	0x0044, 0x0044, 0x0043, 0x0064, 0x0884, 0x0884, 0x1083, 0x28c2, 0x40e2, 0x2860, 0x30c2, 0x3924, 0x0064, 0x0044, 0x0064, 0x0063, 
	0x0064, 0x0064, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0044, 0x0044, 0x0024, 0x1062, 0x3901, 0x4140, 0x59a2, 0x5181, 0x59a1, 0x61c1, 0x61c1, 0x61c1, 0x61a1, 
	0x59a2, 0x4963, 0x3103, 0x0043, 0x0044, 0x0064, 0x0064, 0x0043, 0x1881, 0x38e0, 0x40e0, 0x38c0, 0x2861, 0x1000, 0x0000, 0x0000, 
	0x0020, 0x28e1, 0x4101, 0x61c2, 0x7263, 0x6a23, 0x4922, 0x5143, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x30a0, 0x4100, 0x4100, 
	0x3880, 0x2000, 0x2000, 0x2000, 0x2000, 0x2820, 0x4102, 0x38a1, 0x59a2, 0x61a1, 0x5981, 0x59a1, 0x5182, 0x3881, 0x4903, 0x3041, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2860, 0x40e0, 0x4900, 0x40c0, 0x2820, 0x2000, 0x1000, 0x0000, 0x0800, 0x4101, 0x4921, 0x69e2, 
	0x6a02, 0x6204, 0x4902, 0x4903, 0x1000, 0x0001, 0x0043, 0x0043, 0x0800, 0x3080, 0x4900, 0x4121, 0x1062, 0x0043, 0x0063, 0x0062, 
	0x0020, 0x2060, 0x5162, 0x6181, 0x6180, 0x69e1, 0x7202, 0x69c1, 0x5980, 0x5981, 0x4983, 0x20e4, 0x0003, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x2967, 0x2947, 0x2946, 0x2966, 0x2967, 0x2967, 0x2967, 0x3167, 0x2967, 0x2967, 0x2967, 0x2966, 0x2946, 0x2946, 0x2946, 0x2146, 
	0x2946, 0x2946, 0x2946, 0x2946, 0x2946, 0x2126, 0x2126, 0x2106, 0x2105, 0x2105, 0x2105, 0x1905, 0x1905, 0x1905, 0x18e5, 0x18e5, 
	0x18c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08a5, 0x0084, 0x0064, 0x0043, 0x0043, 0x0044, 0x0044, 0x0044, 0x0044, 0x0043, 0x0043, 
	0x0043, 0x0044, 0x0043, 0x0064, 0x0084, 0x0884, 0x10a4, 0x28a3, 0x2881, 0x1000, 0x1020, 0x2082, 0x0864, 0x0044, 0x0044, 0x0064, 
	0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0044, 0x0044, 0x0023, 0x1082, 0x28c0, 0x4120, 0x59e2, 0x5181, 0x5180, 0x61c1, 0x61c1, 0x61c1, 0x5981, 
	0x5161, 0x5182, 0x49c5, 0x0884, 0x0044, 0x0044, 0x0044, 0x0063, 0x1021, 0x38e0, 0x59a2, 0x4942, 0x2020, 0x0800, 0x0000, 0x0000, 
	0x0840, 0x3942, 0x4101, 0x61a2, 0x6a02, 0x6a03, 0x40e1, 0x4942, 0x38a2, 0x1800, 0x1800, 0x1800, 0x1800, 0x30c0, 0x61e2, 0x61e2, 
	0x38a1, 0x2000, 0x2000, 0x2000, 0x2000, 0x2840, 0x4943, 0x40e1, 0x61a2, 0x61c1, 0x61a1, 0x59a1, 0x5982, 0x40c1, 0x5984, 0x4903, 
	0x2000, 0x2000, 0x2000, 0x1800, 0x1820, 0x5181, 0x61c2, 0x5983, 0x2020, 0x1800, 0x1000, 0x0000, 0x1040, 0x5182, 0x5121, 0x69e2, 
	0x69e2, 0x61e3, 0x4902, 0x5964, 0x1820, 0x0000, 0x0043, 0x0843, 0x0800, 0x38e1, 0x61c2, 0x59e4, 0x20c3, 0x0043, 0x0043, 0x0042, 
	0x0000, 0x30c1, 0x59a2, 0x6181, 0x6181, 0x69c1, 0x7201, 0x69e1, 0x6180, 0x5981, 0x5182, 0x49c6, 0x0864, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0044, 0x0043, 0x0043, 0x0043, 
	0x2946, 0x2946, 0x2946, 0x2946, 0x2946, 0x2946, 0x2946, 0x2946, 0x2966, 0x2967, 0x2946, 0x2146, 0x2146, 0x2126, 0x2126, 0x2126, 
	0x2126, 0x2126, 0x2126, 0x2146, 0x2146, 0x2126, 0x1906, 0x1906, 0x1905, 0x18e5, 0x1905, 0x1905, 0x1906, 0x1906, 0x18e5, 0x18e5, 
	0x10c5, 0x10c5, 0x10a5, 0x10c5, 0x10c5, 0x08a5, 0x0084, 0x0064, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0044, 0x0044, 0x0064, 0x0884, 0x08a4, 0x10a3, 0x1861, 0x28a1, 0x0820, 0x0820, 0x28c3, 0x1084, 0x0064, 0x0064, 0x0044, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0841, 0x1860, 0x4121, 0x51a2, 0x5141, 0x5140, 0x59a1, 0x59a1, 0x59a1, 0x5160, 
	0x5161, 0x5182, 0x5a05, 0x18c4, 0x0044, 0x0044, 0x0044, 0x0043, 0x1840, 0x5181, 0x61a2, 0x59a4, 0x30a1, 0x0800, 0x0800, 0x0000, 
	0x1040, 0x4184, 0x40e2, 0x5982, 0x5181, 0x61e3, 0x4101, 0x5184, 0x4124, 0x1800, 0x1800, 0x1800, 0x1800, 0x4941, 0x6a03, 0x6a23, 
	0x4943, 0x1800, 0x1800, 0x2000, 0x2000, 0x3061, 0x5163, 0x5121, 0x61a2, 0x5981, 0x61a1, 0x59a1, 0x5161, 0x40e1, 0x5163, 0x4103, 
	0x2000, 0x2000, 0x2000, 0x1800, 0x2040, 0x61e3, 0x61a2, 0x6a04, 0x38a2, 0x1800, 0x1000, 0x0800, 0x1040, 0x4982, 0x4901, 0x61c3, 
	0x5181, 0x6203, 0x4101, 0x5963, 0x2861, 0x0800, 0x0822, 0x0842, 0x1000, 0x5162, 0x6182, 0x59a3, 0x3944, 0x0042, 0x0043, 0x0042, 
	0x0000, 0x30e1, 0x59a2, 0x5121, 0x5941, 0x69c1, 0x69e1, 0x69e1, 0x6181, 0x5141, 0x4921, 0x41a5, 0x1084, 0x0003, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0044, 0x0043, 0x0043, 0x0043, 
	0x2946, 0x2926, 0x2926, 0x2926, 0x2926, 0x2946, 0x2946, 0x2926, 0x2946, 0x2946, 0x2126, 0x2125, 0x2125, 0x2125, 0x2105, 0x1905, 
	0x2105, 0x2105, 0x2105, 0x2126, 0x2126, 0x1905, 0x18e5, 0x10c5, 0x10c5, 0x10e5, 0x18e5, 0x18e5, 0x1906, 0x1905, 0x18e5, 0x10e5, 
	0x10c5, 0x08a4, 0x0884, 0x0884, 0x0884, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0044, 0x0064, 0x0064, 0x0064, 0x0884, 0x10a4, 0x18c4, 0x1041, 0x1840, 0x1020, 0x0800, 0x1841, 0x1063, 0x0864, 0x0064, 0x0064, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0884, 0x0883, 0x0882, 0x0020, 0x1040, 0x3900, 0x3901, 0x38c0, 0x4941, 0x59a1, 0x5181, 0x5181, 0x4940, 
	0x4900, 0x4121, 0x4163, 0x10a4, 0x0044, 0x0044, 0x0043, 0x0821, 0x30a0, 0x61e3, 0x40c1, 0x4922, 0x4943, 0x1000, 0x0000, 0x0000, 
	0x0800, 0x30e1, 0x3081, 0x4922, 0x4921, 0x5182, 0x38c0, 0x4922, 0x2841, 0x1800, 0x1800, 0x1800, 0x2840, 0x61e3, 0x5102, 0x4921, 
	0x6a05, 0x3081, 0x1800, 0x2000, 0x2000, 0x2820, 0x40e1, 0x4901, 0x5141, 0x4920, 0x5161, 0x5140, 0x4921, 0x40c0, 0x4102, 0x2861, 
	0x1800, 0x1800, 0x1000, 0x1000, 0x4101, 0x69e4, 0x4080, 0x61a3, 0x59a4, 0x2020, 0x1000, 0x0800, 0x0800, 0x30c0, 0x38a0, 0x5183, 
	0x38c0, 0x59c3, 0x4901, 0x48e1, 0x1820, 0x0800, 0x0000, 0x0820, 0x38c1, 0x69e4, 0x48c1, 0x48e1, 0x59c4, 0x20c3, 0x0022, 0x0041, 
	0x0820, 0x2080, 0x5162, 0x48e1, 0x48e0, 0x61a1, 0x61c1, 0x69c2, 0x5161, 0x4900, 0x4941, 0x4164, 0x0823, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x2926, 0x2125, 0x2125, 0x2125, 0x2125, 0x2125, 0x2125, 0x2105, 0x2125, 0x2125, 0x2125, 0x2105, 0x2105, 0x1905, 0x18e5, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x1905, 0x1905, 0x18e5, 0x10c5, 0x08a5, 0x08a5, 0x10c5, 0x10e5, 0x10e5, 0x10e5, 0x10c5, 0x10c5, 0x10a5, 
	0x08a5, 0x0884, 0x0064, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0044, 0x0064, 0x0064, 0x0884, 0x08a4, 0x10a4, 0x2904, 0x1841, 0x28c3, 0x1061, 0x0000, 0x20a2, 0x1883, 0x0864, 0x0064, 0x0064, 
	0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0044, 0x0883, 0x10c2, 0x10c1, 0x0820, 0x1000, 0x3921, 0x4982, 0x38c0, 0x4121, 0x5161, 0x5161, 0x5161, 0x4920, 
	0x38a0, 0x38e1, 0x49a3, 0x10a4, 0x0024, 0x0043, 0x0822, 0x2060, 0x5982, 0x5942, 0x2800, 0x3881, 0x59a4, 0x38e2, 0x0800, 0x0000, 
	0x1020, 0x4983, 0x4122, 0x4122, 0x4121, 0x4942, 0x38e0, 0x5183, 0x2861, 0x1000, 0x1000, 0x2020, 0x5162, 0x61c4, 0x3020, 0x3020, 
	0x61c3, 0x59c4, 0x2840, 0x1800, 0x1800, 0x2840, 0x5163, 0x4101, 0x4901, 0x4941, 0x5161, 0x5161, 0x5162, 0x40e1, 0x5163, 0x38c2, 
	0x1000, 0x1000, 0x1000, 0x30a1, 0x61c4, 0x5102, 0x3000, 0x40a0, 0x61e4, 0x4963, 0x1840, 0x0800, 0x1020, 0x4982, 0x5182, 0x5982, 
	0x38c0, 0x4941, 0x6182, 0x69e4, 0x1841, 0x0000, 0x0800, 0x2880, 0x61c3, 0x6163, 0x3020, 0x3020, 0x5962, 0x5183, 0x2081, 0x0020, 
	0x0800, 0x2080, 0x5162, 0x4901, 0x38a0, 0x5141, 0x5981, 0x5981, 0x4900, 0x38a0, 0x5142, 0x4984, 0x1022, 0x0003, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0044, 
	0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x18e5, 0x18e5, 0x18e4, 0x18e4, 
	0x18c4, 0x18c5, 0x18e5, 0x18e5, 0x18e5, 0x10c5, 0x08a4, 0x0884, 0x0884, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x0885, 0x0084, 0x0064, 
	0x0064, 0x0044, 0x0044, 0x0024, 0x0023, 0x0043, 0x0043, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0044, 0x0044, 0x0064, 0x0884, 0x08a4, 0x1083, 0x1882, 0x1020, 0x1820, 0x0800, 0x0000, 0x1861, 0x1062, 0x0864, 0x0064, 0x0044, 
	0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0044, 0x0882, 0x10c0, 0x18e1, 0x0840, 0x1000, 0x30a0, 0x4101, 0x3080, 0x3080, 0x40c0, 0x40e0, 0x40e0, 0x38a0, 
	0x3080, 0x30a0, 0x3901, 0x1882, 0x0823, 0x0822, 0x2881, 0x5162, 0x5942, 0x3040, 0x2000, 0x2820, 0x40e2, 0x5184, 0x3902, 0x1040, 
	0x1840, 0x4162, 0x4921, 0x4101, 0x40e1, 0x38c0, 0x4101, 0x5183, 0x30c2, 0x1800, 0x2020, 0x4922, 0x61a3, 0x4081, 0x3000, 0x3000, 
	0x3880, 0x59a3, 0x5183, 0x3081, 0x1800, 0x2840, 0x40e1, 0x40e0, 0x48e1, 0x4901, 0x4901, 0x4921, 0x4941, 0x5121, 0x4901, 0x38c2, 
	0x1800, 0x1800, 0x38c2, 0x61a4, 0x5122, 0x3020, 0x3000, 0x3000, 0x48e1, 0x61c4, 0x5184, 0x2081, 0x1820, 0x4101, 0x4901, 0x4900, 
	0x4100, 0x40e0, 0x4921, 0x5162, 0x2881, 0x1000, 0x38a1, 0x6183, 0x5922, 0x3820, 0x2800, 0x3000, 0x3860, 0x5142, 0x5163, 0x28a1, 
	0x0800, 0x1820, 0x40c0, 0x40c0, 0x40a0, 0x48c0, 0x4900, 0x4900, 0x48e0, 0x40a0, 0x48c0, 0x4901, 0x28a2, 0x0843, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0044, 0x0064, 0x0064, 
	0x2105, 0x2105, 0x20e5, 0x20e5, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e4, 0x18c4, 
	0x18c4, 0x18c4, 0x18c5, 0x18e5, 0x18e5, 0x10c5, 0x10a5, 0x0884, 0x0064, 0x0064, 0x0084, 0x0084, 0x0064, 0x0064, 0x0044, 0x0044, 
	0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0044, 0x0043, 0x0043, 0x0043, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0044, 0x0044, 0x0044, 0x0064, 0x0884, 0x20c4, 0x1061, 0x0800, 0x28a3, 0x0820, 0x0000, 0x1020, 0x1862, 0x1084, 0x0084, 0x0064, 
	0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x1082, 0x0860, 0x20e1, 0x1060, 0x1000, 0x30a0, 0x40e0, 0x40c0, 0x40c0, 0x40c0, 0x40e0, 0x40e0, 0x40e0, 
	0x40e0, 0x40e0, 0x4101, 0x28e2, 0x1021, 0x30a1, 0x5163, 0x5122, 0x3040, 0x2800, 0x2820, 0x2800, 0x2820, 0x40c1, 0x5163, 0x4963, 
	0x2081, 0x2040, 0x38c0, 0x40e0, 0x40e0, 0x38c0, 0x40e0, 0x38c0, 0x2860, 0x3060, 0x5143, 0x5143, 0x3860, 0x3000, 0x3020, 0x3000, 
	0x2800, 0x3040, 0x4922, 0x59a3, 0x38e2, 0x2820, 0x40e0, 0x4900, 0x4900, 0x4900, 0x4900, 0x5100, 0x5120, 0x5120, 0x4921, 0x40e2, 
	0x2840, 0x4902, 0x6183, 0x48c1, 0x3000, 0x3000, 0x3820, 0x3000, 0x3000, 0x4081, 0x5163, 0x59c4, 0x30a1, 0x2840, 0x4900, 0x5160, 
	0x5160, 0x5160, 0x5141, 0x40e1, 0x2860, 0x4922, 0x6983, 0x50c1, 0x3000, 0x2800, 0x2820, 0x3020, 0x2800, 0x3040, 0x4901, 0x5983, 
	0x38e2, 0x2860, 0x5961, 0x5960, 0x5960, 0x6160, 0x6180, 0x6181, 0x6181, 0x6160, 0x6180, 0x61a1, 0x4163, 0x1063, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0044, 0x0044, 0x0064, 0x0064, 
	0x2105, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18c4, 0x18c4, 
	0x18c4, 0x18c4, 0x18c4, 0x18e5, 0x18e5, 0x18e5, 0x10e5, 0x08a5, 0x0084, 0x0064, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 
	0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0044, 
	0x0044, 0x0044, 0x0064, 0x0064, 0x0863, 0x20e4, 0x1882, 0x0800, 0x1861, 0x0800, 0x0000, 0x1020, 0x30c3, 0x1062, 0x0063, 0x0064, 
	0x0064, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x1082, 0x0000, 0x20a1, 0x2081, 0x1820, 0x4921, 0x59a1, 0x61a2, 0x5960, 0x5980, 0x5980, 0x5981, 0x5981, 
	0x5960, 0x5980, 0x61a1, 0x38e1, 0x30a1, 0x5163, 0x40c1, 0x2820, 0x2000, 0x2020, 0x2020, 0x2820, 0x2000, 0x2000, 0x3060, 0x4942, 
	0x4983, 0x30a0, 0x5181, 0x61e1, 0x61c1, 0x61c1, 0x61e2, 0x5982, 0x3060, 0x5163, 0x4922, 0x3020, 0x2800, 0x2820, 0x2820, 0x2800, 
	0x2820, 0x2800, 0x2000, 0x40e1, 0x59a3, 0x40e1, 0x5181, 0x6a02, 0x61c1, 0x61c1, 0x69c1, 0x69c1, 0x69a1, 0x69c1, 0x69e2, 0x5162, 
	0x4902, 0x5963, 0x3860, 0x2800, 0x2820, 0x2820, 0x2000, 0x2800, 0x2800, 0x2800, 0x3020, 0x4922, 0x59a4, 0x40c0, 0x61c2, 0x6a01, 
	0x69e1, 0x69e1, 0x7222, 0x5162, 0x48e1, 0x6183, 0x4060, 0x2800, 0x2821, 0x2042, 0x1821, 0x2020, 0x2800, 0x2800, 0x2800, 0x40c1, 
	0x5983, 0x5121, 0x5980, 0x69e1, 0x6160, 0x61a0, 0x69c1, 0x69c0, 0x69e1, 0x69a0, 0x69a0, 0x6a22, 0x4164, 0x0823, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x1905, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x18e4, 0x18e4, 0x18e4, 0x18c5, 0x18c5, 0x18c5, 0x18c5, 0x18c4, 
	0x18c4, 0x18c4, 0x18c5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10e5, 0x08c5, 0x0084, 0x0063, 0x0043, 0x0064, 0x0064, 0x0064, 0x0064, 
	0x0064, 0x0044, 0x0044, 0x0044, 0x0043, 0x0044, 0x0043, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0044, 
	0x0044, 0x0044, 0x0064, 0x0064, 0x1063, 0x1041, 0x0000, 0x0820, 0x1882, 0x0000, 0x0000, 0x0800, 0x1861, 0x0841, 0x0884, 0x0064, 
	0x0044, 0x0043, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0043, 0x0043, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0842, 0x0000, 0x1860, 0x2060, 0x2020, 0x4920, 0x59a1, 0x5980, 0x5140, 0x5980, 0x5980, 0x5980, 0x5980, 
	0x5140, 0x5980, 0x6181, 0x5121, 0x5943, 0x4081, 0x2800, 0x2020, 0x2020, 0x1000, 0x1000, 0x1000, 0x2020, 0x2020, 0x2000, 0x2820, 
	0x4942, 0x5981, 0x5980, 0x69e1, 0x69e1, 0x7201, 0x7201, 0x6181, 0x5142, 0x4902, 0x2820, 0x2840, 0x1820, 0x1000, 0x1000, 0x1000, 
	0x1800, 0x2820, 0x2820, 0x2000, 0x40e1, 0x5982, 0x59a0, 0x69e1, 0x61c0, 0x69e0, 0x6a01, 0x6a01, 0x69a1, 0x6180, 0x69e1, 0x5981, 
	0x5963, 0x3061, 0x2000, 0x2041, 0x1820, 0x0800, 0x1000, 0x1800, 0x2000, 0x2820, 0x2820, 0x2800, 0x5122, 0x5982, 0x69c1, 0x7201, 
	0x69e1, 0x6a01, 0x7202, 0x6182, 0x5963, 0x3881, 0x2000, 0x2020, 0x1001, 0x1042, 0x0842, 0x1001, 0x1800, 0x2840, 0x2820, 0x2000, 
	0x40c1, 0x59a2, 0x61a1, 0x69e1, 0x6180, 0x61a0, 0x69c0, 0x69c0, 0x69c0, 0x6180, 0x6180, 0x61e2, 0x3104, 0x0023, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0044, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x1905, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e4, 0x18c4, 0x18c5, 0x18e5, 0x18e5, 0x18e5, 0x18c5, 
	0x18c5, 0x18c5, 0x18e5, 0x18e5, 0x1905, 0x1905, 0x1905, 0x1905, 0x10e5, 0x08a5, 0x0064, 0x0064, 0x0884, 0x08a4, 0x08a5, 0x10c5, 
	0x10c5, 0x08a5, 0x08a5, 0x08a5, 0x0884, 0x0884, 0x0884, 0x08a4, 0x08a4, 0x10a4, 0x10a5, 0x10a4, 0x08a4, 0x0884, 0x0064, 0x0064, 
	0x0064, 0x0064, 0x0084, 0x0063, 0x20e4, 0x3104, 0x0000, 0x0820, 0x1882, 0x0000, 0x0000, 0x0000, 0x1861, 0x1882, 0x10a4, 0x0084, 
	0x0043, 0x0043, 0x0044, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0862, 0x0820, 0x1040, 0x2881, 0x30a0, 0x5161, 0x59a1, 0x5160, 0x5140, 0x5980, 0x5981, 0x59a1, 0x5980, 
	0x5120, 0x5960, 0x5960, 0x61a2, 0x4902, 0x2800, 0x2820, 0x1820, 0x0800, 0x0800, 0x0000, 0x0000, 0x0800, 0x1800, 0x2041, 0x2020, 
	0x2840, 0x5981, 0x61c1, 0x6a01, 0x69e1, 0x69e1, 0x69e0, 0x69c2, 0x5983, 0x2820, 0x2040, 0x1821, 0x0000, 0x0000, 0x0800, 0x0800, 
	0x1000, 0x1800, 0x2020, 0x2820, 0x2820, 0x5141, 0x61c1, 0x61a1, 0x61a0, 0x69c1, 0x69e1, 0x69e1, 0x69c1, 0x61a0, 0x61a0, 0x6182, 
	0x40c1, 0x2020, 0x1841, 0x0800, 0x0000, 0x0000, 0x0800, 0x1000, 0x1000, 0x1800, 0x2861, 0x2820, 0x3040, 0x61a2, 0x6a01, 0x6a01, 
	0x7201, 0x6a01, 0x6a01, 0x69e3, 0x4902, 0x2000, 0x1820, 0x0800, 0x0800, 0x0821, 0x1063, 0x1042, 0x0820, 0x1020, 0x2861, 0x2841, 
	0x2000, 0x5142, 0x61e2, 0x61c1, 0x61a0, 0x69e1, 0x69c1, 0x69c0, 0x61a0, 0x69c1, 0x61a0, 0x59e2, 0x2904, 0x0023, 0x0044, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0044, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x1905, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x1905, 0x18e5, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x2106, 0x2126, 0x2106, 0x1906, 0x10e5, 0x08a4, 0x0884, 0x10c5, 0x10e5, 0x18e5, 0x1906, 
	0x1906, 0x1906, 0x2106, 0x1906, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x1906, 0x2106, 0x1906, 0x1906, 0x18e5, 0x10c5, 0x10a5, 
	0x08a5, 0x0884, 0x0084, 0x0863, 0x1882, 0x1862, 0x0000, 0x1020, 0x20a2, 0x0000, 0x0000, 0x0000, 0x1881, 0x20a2, 0x0022, 0x0044, 
	0x0044, 0x0043, 0x0044, 0x0043, 0x0044, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x1082, 0x0820, 0x1040, 0x28a1, 0x3901, 0x5182, 0x59c2, 0x5180, 0x5981, 0x61a1, 0x61a1, 0x59a1, 0x5981, 
	0x5981, 0x5980, 0x5980, 0x5982, 0x3081, 0x2820, 0x1820, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x2861, 
	0x2800, 0x40e0, 0x6201, 0x6a01, 0x6a01, 0x69e2, 0x61e1, 0x6a03, 0x4902, 0x2020, 0x1820, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 
	0x0800, 0x0800, 0x1000, 0x2840, 0x2800, 0x38a0, 0x61c2, 0x61e2, 0x69c1, 0x69e1, 0x69e1, 0x61c1, 0x69e2, 0x69e1, 0x61c1, 0x5982, 
	0x3061, 0x1841, 0x0800, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x1000, 0x1000, 0x1800, 0x2881, 0x2000, 0x4920, 0x7222, 0x7223, 
	0x6a22, 0x6a22, 0x6a22, 0x6a03, 0x38a1, 0x1800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1021, 0x1062, 0x0841, 0x0000, 0x1000, 0x2881, 
	0x2020, 0x3880, 0x59a2, 0x61c2, 0x59a1, 0x61c1, 0x61c2, 0x69e2, 0x69c1, 0x69c1, 0x69e1, 0x59e3, 0x2904, 0x0023, 0x0044, 0x0043, 
	0x0043, 0x0044, 0x0043, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0044, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0024, 0x0024, 0x0024, 0x0024, 
	0x1905, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x1905, 0x1905, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x2105, 0x2126, 0x2126, 0x1926, 0x1906, 0x08c5, 0x0884, 0x08a5, 0x10c5, 0x18c5, 0x1906, 
	0x2106, 0x2126, 0x2126, 0x2126, 0x2126, 0x2106, 0x1905, 0x1905, 0x2106, 0x2106, 0x2106, 0x2106, 0x2106, 0x1906, 0x1906, 0x18e5, 
	0x10c5, 0x08a5, 0x0084, 0x10a4, 0x1882, 0x0000, 0x0000, 0x1020, 0x1882, 0x0000, 0x0000, 0x0000, 0x0800, 0x1020, 0x0822, 0x0044, 
	0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0043, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x10a2, 0x1060, 0x1020, 0x2060, 0x4121, 0x5182, 0x59a2, 0x5161, 0x5161, 0x5981, 0x59a1, 0x5181, 0x5161, 
	0x5161, 0x5981, 0x5981, 0x5142, 0x2840, 0x1820, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2040, 
	0x2841, 0x2860, 0x59c2, 0x61e2, 0x61e2, 0x61e2, 0x61e2, 0x61e3, 0x38a1, 0x1820, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 
	0x1000, 0x0800, 0x0800, 0x1800, 0x2841, 0x2840, 0x5161, 0x59a1, 0x61a2, 0x61c2, 0x61a1, 0x5981, 0x61a2, 0x59a1, 0x61c2, 0x5142, 
	0x2040, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x1000, 0x0800, 0x0800, 0x2061, 0x2841, 0x3080, 0x61c2, 0x61e3, 
	0x61e2, 0x61e2, 0x61e2, 0x59a3, 0x2861, 0x1862, 0x0821, 0x0800, 0x0800, 0x0800, 0x0800, 0x1061, 0x0841, 0x0000, 0x0000, 0x1840, 
	0x2861, 0x2020, 0x4921, 0x5162, 0x5141, 0x5141, 0x5141, 0x5961, 0x5941, 0x5941, 0x5981, 0x5182, 0x28e3, 0x0022, 0x0044, 0x0044, 
	0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0044, 0x0044, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x2105, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x1905, 0x2105, 0x2105, 0x2125, 0x2125, 0x2105, 0x1905, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x2105, 0x2106, 0x1905, 0x18e5, 0x10c5, 0x0884, 0x0064, 0x0884, 0x10c5, 0x18e6, 
	0x2106, 0x2106, 0x2126, 0x2126, 0x2106, 0x2105, 0x1905, 0x1905, 0x1906, 0x1906, 0x1906, 0x2106, 0x1905, 0x18e5, 0x18e5, 0x10e5, 
	0x10a5, 0x08a4, 0x0084, 0x20e4, 0x3104, 0x0000, 0x0000, 0x1040, 0x1861, 0x0000, 0x0000, 0x0000, 0x0800, 0x28a2, 0x1062, 0x0884, 
	0x0044, 0x0044, 0x0043, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x10a2, 0x28c1, 0x1840, 0x1020, 0x3901, 0x4921, 0x4901, 0x40e0, 0x38c0, 0x40e0, 0x4100, 0x40e0, 0x40c0, 
	0x40c0, 0x40e0, 0x40e0, 0x38c0, 0x2020, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 
	0x2881, 0x2860, 0x38e0, 0x4900, 0x4920, 0x5141, 0x4920, 0x4901, 0x2860, 0x1820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 
	0x1000, 0x0800, 0x0800, 0x1000, 0x2041, 0x2020, 0x3080, 0x40c0, 0x40e0, 0x4920, 0x4900, 0x4900, 0x4900, 0x40e0, 0x4900, 0x40c0, 
	0x2040, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x0800, 0x0800, 0x0800, 0x1841, 0x2061, 0x2840, 0x40e0, 0x4900, 
	0x4900, 0x4900, 0x48e0, 0x40c0, 0x2060, 0x10a4, 0x0863, 0x0001, 0x0800, 0x0800, 0x0800, 0x0800, 0x0840, 0x0000, 0x0000, 0x0800, 
	0x2061, 0x2020, 0x3880, 0x40a0, 0x40c0, 0x40c0, 0x40c0, 0x48c0, 0x48c0, 0x48c0, 0x40c0, 0x40c0, 0x30c1, 0x1862, 0x0843, 0x0044, 
	0x0064, 0x0064, 0x0044, 0x0043, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0044, 0x0044, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x2105, 0x2105, 0x2105, 0x2105, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x1905, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x1905, 0x1905, 0x18e5, 0x10c5, 0x08a4, 0x0064, 0x0884, 0x10c5, 0x18e6, 
	0x2106, 0x2126, 0x2126, 0x2126, 0x2106, 0x2105, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10c5, 0x10c5, 
	0x08a5, 0x0884, 0x0883, 0x1061, 0x0820, 0x0000, 0x0000, 0x1861, 0x28c3, 0x0000, 0x0000, 0x0000, 0x0800, 0x2061, 0x0821, 0x0022, 
	0x0043, 0x0044, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x10a2, 0x3102, 0x28c1, 0x1820, 0x2860, 0x3880, 0x38a0, 0x38a0, 0x40e0, 0x48e0, 0x4900, 0x4900, 0x4900, 
	0x48e0, 0x40e0, 0x4900, 0x4921, 0x2881, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 
	0x1840, 0x2880, 0x40e0, 0x40e0, 0x48e0, 0x48e0, 0x40c0, 0x40c0, 0x38c1, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 
	0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 0x2860, 0x40e0, 0x48e0, 0x4900, 0x4900, 0x4920, 0x5120, 0x4900, 0x4900, 0x4900, 0x5121, 
	0x38e2, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1800, 0x40c0, 0x5121, 0x5940, 
	0x5940, 0x5140, 0x5941, 0x5161, 0x3943, 0x0883, 0x0064, 0x0843, 0x0821, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x1000, 0x3880, 0x5961, 0x5961, 0x5941, 0x5961, 0x6181, 0x6181, 0x6161, 0x6161, 0x5961, 0x5981, 0x5181, 0x3943, 0x1084, 0x0884, 
	0x0084, 0x0064, 0x0044, 0x0044, 0x0044, 0x0043, 0x0043, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0044, 0x0044, 0x0044, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x2105, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x2105, 0x2105, 0x2105, 0x2105, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10e5, 0x10e5, 0x10c5, 0x10a4, 0x10c5, 0x18e5, 
	0x2106, 0x2126, 0x2126, 0x2126, 0x2106, 0x2106, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10c5, 0x10c5, 0x08a5, 
	0x08a5, 0x0084, 0x18a3, 0x28c3, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x1020, 0x1861, 0x0021, 
	0x0884, 0x0064, 0x0044, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x1082, 0x28c1, 0x3122, 0x30a1, 0x2020, 0x4901, 0x5141, 0x5121, 0x5141, 0x5142, 0x5141, 0x5141, 0x5961, 
	0x5941, 0x5141, 0x5981, 0x5182, 0x2061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0800, 0x30a1, 0x5162, 0x5141, 0x5141, 0x5162, 0x5142, 0x5142, 0x4103, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 
	0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x3080, 0x5961, 0x5961, 0x5962, 0x5962, 0x5962, 0x5962, 0x5962, 0x5961, 0x61a1, 0x59a2, 
	0x30a1, 0x0800, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x1000, 0x40e1, 0x5942, 0x5941, 
	0x5941, 0x5121, 0x5121, 0x5142, 0x30e3, 0x0843, 0x0064, 0x0064, 0x1082, 0x0820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0800, 0x3080, 0x5941, 0x6182, 0x5101, 0x50e1, 0x50e1, 0x50e1, 0x50e1, 0x50e1, 0x50e1, 0x5961, 0x59c2, 0x3123, 0x10a4, 0x10a5, 
	0x08a5, 0x0885, 0x0044, 0x0044, 0x0044, 0x0043, 0x0043, 0x0044, 0x0044, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0044, 
	0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0044, 0x0023, 0x0023, 0x0023, 
	0x2105, 0x18e5, 0x1905, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e4, 0x18e4, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10e5, 0x10e5, 0x10c5, 0x10c4, 0x18e5, 
	0x18e5, 0x1906, 0x2106, 0x2106, 0x1906, 0x2106, 0x1905, 0x18e5, 0x18e5, 0x18c5, 0x18e5, 0x18e5, 0x10c5, 0x10c5, 0x10c5, 0x08a5, 
	0x08a5, 0x0064, 0x1883, 0x28e3, 0x0000, 0x0000, 0x0000, 0x20a2, 0x20c3, 0x0000, 0x0000, 0x0000, 0x0000, 0x1020, 0x1861, 0x0821, 
	0x0883, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x0044, 0x0044, 0x0044, 0x10a2, 0x2080, 0x28e2, 0x30e2, 0x2040, 0x40e0, 0x5141, 0x38a1, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3860, 0x5141, 0x38e1, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x1820, 0x3060, 0x3040, 0x2840, 0x2840, 0x3040, 0x3040, 0x1820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 
	0x0800, 0x0800, 0x0800, 0x0000, 0x0800, 0x2020, 0x4920, 0x5142, 0x3860, 0x3020, 0x3020, 0x3020, 0x3020, 0x3860, 0x5941, 0x4942, 
	0x1820, 0x0800, 0x0800, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0800, 0x2000, 0x3020, 0x3020, 
	0x2020, 0x2000, 0x2820, 0x2820, 0x1000, 0x0863, 0x0084, 0x0084, 0x1083, 0x1881, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0800, 0x1800, 0x40c1, 0x5922, 0x3820, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x40a0, 0x51a3, 0x20e4, 0x10a5, 0x10c5, 
	0x08a5, 0x08a5, 0x0064, 0x0044, 0x0044, 0x0043, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0044, 
	0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0023, 0x0023, 0x0043, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x18e5, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 
	0x18e5, 0x18e5, 0x18e5, 0x18c5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18c5, 0x18c5, 0x18c4, 0x18c5, 
	0x18e5, 0x18e5, 0x1906, 0x1906, 0x1905, 0x18e5, 0x18e5, 0x18c5, 0x10c5, 0x10c5, 0x10c5, 0x10e5, 0x10c5, 0x10c5, 0x08a5, 0x08a5, 
	0x0085, 0x0883, 0x1042, 0x0000, 0x0000, 0x0000, 0x0000, 0x1040, 0x1061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x28a2, 0x0820, 
	0x0022, 0x0084, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0043, 0x0044, 0x0044, 
	0x0064, 0x0064, 0x0063, 0x18c2, 0x18c1, 0x1060, 0x2080, 0x30a1, 0x3060, 0x4901, 0x3061, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2820, 0x5141, 0x28c1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x1000, 0x2000, 0x2000, 0x1800, 0x1000, 0x2000, 0x2000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x40c0, 0x4902, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x5142, 0x4122, 
	0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2800, 0x2000, 
	0x1000, 0x0800, 0x2000, 0x2800, 0x1000, 0x0042, 0x0884, 0x0884, 0x1882, 0x28a1, 0x1861, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0820, 0x1000, 0x3880, 0x5122, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x4081, 0x5183, 0x20e5, 0x10c5, 0x10c5, 
	0x10c5, 0x08c5, 0x08a5, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0044, 0x0044, 
	0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 
	0x0023, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 
	0x18e5, 0x18e5, 0x18e5, 0x18c5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18c5, 0x18c5, 0x18c5, 0x18c5, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10c5, 0x18c5, 0x10c5, 0x10c5, 0x10c4, 0x10c5, 0x10c5, 0x10a5, 0x08a5, 0x08a5, 0x0085, 
	0x0064, 0x1083, 0x3124, 0x0841, 0x0000, 0x0000, 0x0000, 0x1061, 0x1041, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1840, 0x0800, 
	0x0862, 0x0884, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 0x0064, 0x0064, 0x0043, 0x0044, 0x0044, 
	0x0063, 0x0064, 0x0083, 0x18e2, 0x18c1, 0x0840, 0x1860, 0x30c2, 0x2860, 0x5142, 0x2841, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x4942, 0x28e2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x1000, 0x2000, 0x2000, 0x1800, 0x1000, 0x1800, 0x2000, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x38a0, 0x4922, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2000, 0x5142, 0x4122, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2800, 0x2000, 
	0x1000, 0x1000, 0x1800, 0x2800, 0x1000, 0x0001, 0x0884, 0x0884, 0x1882, 0x2081, 0x28c2, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0840, 0x1000, 0x3080, 0x5963, 0x3021, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x40a1, 0x51a4, 0x20e5, 0x10c5, 0x10c5, 
	0x10c5, 0x10c5, 0x08a5, 0x0884, 0x0064, 0x0064, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0044, 0x0044, 
	0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 
	0x0023, 0x0023, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 
	0x18e5, 0x18e5, 0x18e5, 0x18c5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18c5, 0x18c5, 0x18c5, 0x18c5, 
	0x18e5, 0x18e5, 0x10e5, 0x10e5, 0x10c5, 0x10c5, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x08a5, 0x0885, 0x0084, 
	0x0084, 0x1062, 0x1881, 0x0000, 0x0000, 0x0000, 0x0000, 0x28c3, 0x20c3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1881, 0x1882, 
	0x0821, 0x0884, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0084, 0x0884, 0x0864, 0x0864, 0x0864, 
	0x0884, 0x0884, 0x0883, 0x18e2, 0x18a0, 0x0020, 0x0800, 0x1000, 0x2860, 0x5983, 0x3061, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2820, 0x5162, 0x28e2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x1000, 0x2000, 0x2000, 0x1800, 0x1000, 0x1800, 0x2000, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x38c0, 0x5163, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x5163, 0x4163, 
	0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2800, 0x2000, 
	0x1800, 0x1000, 0x1800, 0x2800, 0x1000, 0x0000, 0x0022, 0x10a4, 0x1882, 0x2040, 0x28a1, 0x1040, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0800, 0x30a0, 0x5984, 0x3021, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x40a1, 0x59c4, 0x20e5, 0x10c5, 0x10c5, 
	0x10c5, 0x10c5, 0x08c5, 0x08a5, 0x0884, 0x0064, 0x0064, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0044, 0x0044, 
	0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 0x18e4, 0x18e5, 0x18e5, 0x18e5, 
	0x18c5, 0x18c5, 0x18c5, 0x18c5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18c4, 0x18c5, 0x18e5, 0x18e5, 0x18c5, 
	0x18e5, 0x10e5, 0x10c5, 0x10c5, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10c5, 0x10c5, 0x10a5, 0x10a5, 0x08a5, 0x08a4, 
	0x08a4, 0x20c4, 0x1020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1861, 0x1881, 
	0x0000, 0x0863, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0884, 0x08a5, 0x08a5, 0x08a4, 0x08a4, 
	0x08a4, 0x0885, 0x1083, 0x20c2, 0x1880, 0x0820, 0x0820, 0x1820, 0x2860, 0x59a3, 0x3081, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2820, 0x5162, 0x28e2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0800, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x2020, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x40c0, 0x5983, 0x2820, 0x2800, 0x2800, 0x3000, 0x3000, 0x2800, 0x5142, 0x4963, 
	0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2800, 0x2800, 
	0x1800, 0x1800, 0x2000, 0x2800, 0x1000, 0x0000, 0x0000, 0x0862, 0x1882, 0x1840, 0x2081, 0x1040, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x1000, 0x3080, 0x5984, 0x3041, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x40a1, 0x59e4, 0x20e5, 0x10c5, 0x10e5, 
	0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x08a5, 0x0885, 0x0064, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0064, 0x0044, 0x0044, 
	0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x1905, 0x1905, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e4, 0x18e4, 0x18c4, 0x18c5, 0x18c5, 0x18e5, 
	0x18c5, 0x18c5, 0x18c5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10e5, 0x18e5, 0x18e5, 0x18e5, 0x10e5, 
	0x10e5, 0x10e5, 0x10c5, 0x10c4, 0x10a4, 0x10a4, 0x10a4, 0x10a4, 0x10c4, 0x10c5, 0x18e5, 0x18e5, 0x18c5, 0x18e5, 0x18e5, 0x10c5, 
	0x10c4, 0x3125, 0x1861, 0x0000, 0x0000, 0x0000, 0x0000, 0x28e3, 0x1882, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1040, 
	0x0000, 0x0842, 0x0884, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0884, 0x08a5, 0x10c5, 0x10c5, 0x10c5, 
	0x10c5, 0x10a5, 0x10a4, 0x20e2, 0x1880, 0x1061, 0x0820, 0x2061, 0x38a1, 0x59a3, 0x3081, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2820, 0x5162, 0x28e2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0041, 0x0862, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0800, 0x2000, 0x2000, 0x1800, 0x1800, 0x2000, 0x2000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x40c1, 0x5983, 0x3020, 0x2800, 0x3000, 0x3000, 0x3000, 0x2800, 0x4942, 0x4963, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2000, 0x2000, 
	0x2000, 0x1800, 0x2000, 0x2800, 0x1000, 0x0000, 0x0000, 0x0000, 0x1061, 0x1040, 0x1040, 0x0820, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x1000, 0x3080, 0x61a4, 0x3841, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x40a1, 0x59e4, 0x2905, 0x10e5, 0x10e5, 
	0x10e5, 0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x08a5, 0x08a4, 0x0084, 0x0084, 0x0064, 0x0064, 0x0043, 0x0063, 0x0064, 0x0064, 0x0044, 
	0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0043, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x1905, 0x1905, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e4, 0x18e4, 0x18e4, 0x18e5, 0x18e5, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e4, 0x18e4, 0x18e4, 0x18e5, 0x18e5, 
	0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x10c4, 0x10c4, 0x10c4, 0x10c5, 0x10c5, 0x10c5, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x2105, 0x2105, 
	0x20e4, 0x1041, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1861, 0x1061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x3923, 
	0x1061, 0x0001, 0x0043, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0084, 0x08a5, 0x08a5, 0x10a5, 0x10c5, 
	0x10a5, 0x10c5, 0x10c4, 0x2903, 0x1880, 0x0860, 0x0820, 0x1861, 0x38c1, 0x5983, 0x30a1, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2820, 0x5162, 0x28e2, 0x0000, 0x0000, 0x0000, 0x0041, 0x18e5, 0x10c4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x38a0, 0x5983, 0x3020, 0x2800, 0x3000, 0x3000, 0x3000, 0x2800, 0x4942, 0x4983, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x2000, 0x2800, 
	0x2000, 0x1800, 0x2000, 0x2800, 0x1000, 0x0000, 0x0000, 0x0000, 0x0820, 0x1040, 0x1040, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0800, 0x3080, 0x61c3, 0x3861, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x3881, 0x59e4, 0x2905, 0x10c5, 0x18e5, 
	0x18e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10a5, 0x08a5, 0x08a4, 0x08a4, 0x0084, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 
	0x0064, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x18e5, 0x18e5, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e4, 0x10e4, 0x10c4, 0x18e5, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x10c5, 0x10c5, 0x10c4, 0x10e5, 0x10c5, 0x10c5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x1905, 0x20e5, 
	0x3965, 0x20a2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1020, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x1820, 0x4902, 0x1840, 
	0x0000, 0x0001, 0x0864, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0084, 0x0885, 0x08a5, 0x08a5, 0x08a4, 
	0x08a4, 0x08a5, 0x10a4, 0x2903, 0x1880, 0x1080, 0x1080, 0x20a1, 0x38a1, 0x5163, 0x30a1, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2020, 0x5162, 0x30e2, 0x0000, 0x0000, 0x0000, 0x08a3, 0x2126, 0x10a4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x38a0, 0x5983, 0x3020, 0x2800, 0x2800, 0x2800, 0x3000, 0x2000, 0x4922, 0x4963, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x2000, 0x2800, 
	0x2800, 0x2000, 0x2800, 0x2800, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0820, 0x1041, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0800, 0x3060, 0x61a3, 0x3861, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x3880, 0x59e4, 0x2925, 0x10c5, 0x18e5, 
	0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08a4, 0x08a4, 0x08a4, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 
	0x0064, 0x0064, 0x0044, 0x0064, 0x0044, 0x0064, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x18e5, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10e4, 0x10c4, 0x18e5, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x10e5, 0x10c5, 0x10c5, 0x18e5, 0x18e4, 0x2925, 0x20e5, 0x18e5, 0x18e5, 0x1905, 0x18e5, 0x18e5, 0x18e4, 
	0x28e3, 0x1041, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2903, 0x18a2, 0x0000, 0x0000, 0x0000, 0x0000, 0x2860, 0x8224, 0x3902, 
	0x1061, 0x0000, 0x0843, 0x0884, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0084, 0x0085, 0x0885, 0x0885, 0x0884, 
	0x08a4, 0x08a5, 0x1084, 0x2903, 0x18a0, 0x0880, 0x0860, 0x2081, 0x30a1, 0x5163, 0x38a1, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2020, 0x5162, 0x3103, 0x0000, 0x0000, 0x0000, 0x0862, 0x2126, 0x10a4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x1020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x38a0, 0x5963, 0x3040, 0x2800, 0x2800, 0x2800, 0x2800, 0x2000, 0x4922, 0x4963, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x2000, 0x3000, 
	0x3000, 0x2800, 0x2800, 0x2800, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0800, 0x2860, 0x59a3, 0x3881, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x3880, 0x59e4, 0x2925, 0x18c5, 0x18e5, 
	0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10a5, 0x10c5, 0x08c5, 0x08a4, 0x08a4, 0x08a4, 0x08a5, 0x08a5, 0x08c5, 0x08c5, 0x10c5, 
	0x08a5, 0x0085, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0044, 0x0044, 0x0044, 0x0043, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x1905, 0x2105, 0x2105, 0x2106, 0x2106, 0x1905, 0x18e5, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10e5, 0x18e5, 0x18e5, 0x18e5, 
	0x18e5, 0x1905, 0x1905, 0x18e5, 0x18c5, 0x18e5, 0x18e5, 0x28e4, 0x5208, 0x2105, 0x1906, 0x1906, 0x18e5, 0x18e5, 0x1905, 0x20e4, 
	0x0841, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0820, 0x0000, 0x0000, 0x0000, 0x0000, 0x2040, 0x6162, 0x4964, 
	0x28e2, 0x0000, 0x0841, 0x18c5, 0x0884, 0x0085, 0x0084, 0x0084, 0x0084, 0x0064, 0x0084, 0x0085, 0x08a5, 0x08a4, 0x0884, 0x08a4, 
	0x08a4, 0x0884, 0x0884, 0x2103, 0x18a0, 0x0860, 0x0840, 0x2061, 0x30a1, 0x4942, 0x3881, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x4962, 0x3103, 0x0000, 0x0000, 0x0000, 0x0000, 0x18e4, 0x18c4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0800, 0x2000, 0x2800, 0x2800, 0x2800, 0x3000, 0x2820, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x38a0, 0x5963, 0x3040, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x4101, 0x4962, 
	0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x2000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x2820, 0x1000, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0800, 0x2860, 0x59a3, 0x3881, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x3860, 0x59c3, 0x2905, 0x18c5, 0x10e5, 
	0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c6, 
	0x10c6, 0x08a5, 0x0085, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x1905, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x1905, 0x18e5, 0x1905, 0x1906, 0x1906, 0x1905, 0x18e5, 0x18c5, 0x18c5, 
	0x10c4, 0x18c5, 0x10e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x1906, 
	0x1906, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x1906, 0x20e5, 0x3924, 0x59e7, 0x2105, 0x1906, 0x1906, 0x18e6, 0x18e6, 0x18e5, 0x3946, 
	0x20c3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3103, 0x1861, 0x0000, 0x0000, 0x0000, 0x0000, 0x2060, 0x40e1, 0x1820, 
	0x1040, 0x0000, 0x0000, 0x1083, 0x0884, 0x0085, 0x0085, 0x00a4, 0x0084, 0x0085, 0x00a5, 0x00a5, 0x08a5, 0x08a5, 0x0084, 0x0084, 
	0x00a4, 0x0084, 0x0863, 0x2103, 0x18a0, 0x0840, 0x1040, 0x28c1, 0x38a1, 0x5142, 0x38a1, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2820, 0x5142, 0x4122, 0x1840, 0x1840, 0x1840, 0x1020, 0x1861, 0x2081, 0x1040, 0x1840, 0x1820, 0x1820, 0x1020, 0x1820, 
	0x1020, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x3000, 0x2800, 0x1800, 0x1020, 0x1020, 0x1840, 0x1840, 0x1840, 0x1840, 0x1840, 
	0x1840, 0x1840, 0x1840, 0x1840, 0x1840, 0x2020, 0x38a0, 0x5162, 0x3060, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x4100, 0x5161, 
	0x30a0, 0x30a0, 0x30c1, 0x30c1, 0x30c1, 0x38c1, 0x38c1, 0x38c1, 0x38e1, 0x38e1, 0x38e1, 0x38e1, 0x38e1, 0x30a1, 0x2820, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x2800, 0x2880, 0x3901, 0x3901, 0x3901, 0x3901, 0x3901, 0x3901, 0x4122, 0x3922, 0x4102, 0x4122, 0x4122, 
	0x4122, 0x38e1, 0x38e0, 0x5162, 0x40c2, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x3880, 0x59c3, 0x3945, 0x18c5, 0x18e5, 
	0x18e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10c5, 0x10c5, 
	0x10c5, 0x08a5, 0x0885, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1906, 0x1905, 0x18e5, 0x18e5, 0x18c5, 0x18c5, 0x10c4, 0x10c5, 
	0x10c4, 0x10c4, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x1906, 0x2106, 0x2106, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1906, 0x1906, 
	0x1906, 0x1905, 0x2105, 0x1905, 0x2106, 0x2126, 0x2105, 0x4164, 0x6247, 0x2105, 0x1906, 0x1906, 0x18e6, 0x18e6, 0x18e5, 0x28e3, 
	0x1861, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2903, 0x18a2, 0x0000, 0x0000, 0x0000, 0x0000, 0x30c2, 0x51c4, 0x1881, 
	0x2082, 0x1041, 0x0000, 0x0842, 0x10a5, 0x0885, 0x0084, 0x00a4, 0x00a5, 0x0884, 0x0084, 0x08a5, 0x00a5, 0x0084, 0x0084, 0x00a4, 
	0x0084, 0x0084, 0x0063, 0x20e3, 0x20a0, 0x28a0, 0x3901, 0x4983, 0x4121, 0x5182, 0x4102, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x3060, 0x5161, 0x5181, 0x5181, 0x5982, 0x59a2, 0x5982, 0x5162, 0x5182, 0x5182, 0x59a2, 0x5182, 0x5182, 0x5182, 0x5182, 
	0x5163, 0x4922, 0x2820, 0x2800, 0x2800, 0x3000, 0x3000, 0x2800, 0x38a0, 0x5182, 0x51a2, 0x59a2, 0x59c2, 0x59c2, 0x59c2, 0x59c2, 
	0x59c2, 0x59c2, 0x59c2, 0x59c3, 0x59c3, 0x4962, 0x4940, 0x59c2, 0x40e2, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x5161, 0x61c1, 
	0x61c1, 0x61c1, 0x6a02, 0x6a02, 0x6a03, 0x6a03, 0x6a03, 0x6a03, 0x6a03, 0x6a03, 0x6a23, 0x6a03, 0x61e2, 0x5142, 0x3020, 0x2800, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x5141, 0x6a03, 0x6a02, 0x6a02, 0x6a02, 0x6a02, 0x6a02, 0x6a02, 0x6a02, 0x6a02, 0x6a02, 0x6a02, 
	0x6a02, 0x59a2, 0x5141, 0x61c3, 0x5142, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x40c0, 0x61e3, 0x4185, 0x18c5, 0x18e5, 
	0x10e5, 0x18c5, 0x18e5, 0x18e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x18e5, 0x18e5, 0x1906, 0x18e6, 0x18e5, 0x18e5, 0x18e5, 
	0x10c6, 0x08a5, 0x0085, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0065, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x2105, 0x1905, 0x1905, 0x1905, 0x2105, 0x1905, 0x1905, 0x2105, 0x2106, 0x2105, 0x18e5, 0x18c5, 0x18c5, 0x18a4, 0x10a4, 0x10a4, 
	0x10c4, 0x10c4, 0x10e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x2106, 0x2106, 0x2106, 0x2105, 0x2105, 0x2106, 0x2106, 0x1926, 0x2126, 
	0x1926, 0x2126, 0x2126, 0x2126, 0x2126, 0x2147, 0x2926, 0x4144, 0x4163, 0x2105, 0x2106, 0x2106, 0x1906, 0x2106, 0x2905, 0x1061, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x28a1, 0x4983, 0x1881, 
	0x1861, 0x1041, 0x0000, 0x1042, 0x18c5, 0x0885, 0x0085, 0x00a5, 0x0884, 0x20c4, 0x1906, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 
	0x0084, 0x0085, 0x0063, 0x20e3, 0x2880, 0x38c0, 0x4921, 0x5182, 0x4941, 0x59a2, 0x4942, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2000, 0x3060, 0x59a1, 0x59c1, 0x59a1, 0x61c1, 0x61c2, 0x61c2, 0x61c1, 0x61c1, 0x61a1, 0x61c2, 0x61c2, 0x61a2, 0x59a1, 0x59a2, 
	0x59c2, 0x5163, 0x3040, 0x2800, 0x2800, 0x3000, 0x3000, 0x2800, 0x40c0, 0x61c2, 0x61e1, 0x69e2, 0x69e2, 0x69e2, 0x69e2, 0x69e2, 
	0x69e2, 0x69e2, 0x69e2, 0x69e2, 0x61e2, 0x5161, 0x5160, 0x61c2, 0x48e2, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x5981, 0x69e1, 
	0x61c0, 0x61c0, 0x61c1, 0x69e1, 0x6a02, 0x6a02, 0x6a02, 0x6a02, 0x6a02, 0x6a02, 0x6a02, 0x6a02, 0x69e2, 0x5942, 0x3020, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x4900, 0x61e1, 0x61c1, 0x61e1, 0x69e2, 0x69e2, 0x69e2, 0x69e2, 0x6a02, 0x69e2, 0x69e2, 0x61e1, 
	0x61c1, 0x5981, 0x5141, 0x61c2, 0x5162, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x40e0, 0x59e3, 0x3964, 0x18c5, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10c5, 0x10c5, 0x10c5, 0x18e5, 0x18e5, 0x18e6, 0x18e6, 0x1906, 0x1906, 0x18e5, 0x18e5, 
	0x10c5, 0x08a5, 0x0085, 0x0064, 0x0064, 0x0064, 0x0084, 0x0085, 0x0085, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0064, 0x0064, 
	0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x18e5, 0x18e5, 0x18e5, 0x2105, 0x2105, 0x18e5, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x20e5, 0x18e5, 0x18e5, 
	0x18c5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x1906, 0x1906, 0x2106, 0x2105, 0x2106, 0x2126, 0x2126, 0x2126, 
	0x2126, 0x2126, 0x2146, 0x2946, 0x2146, 0x2947, 0x2926, 0x3924, 0x3923, 0x2905, 0x2126, 0x2106, 0x2106, 0x2105, 0x3166, 0x2924, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0820, 0x3944, 0x1061, 0x0000, 0x0000, 0x0000, 0x0000, 0x28c1, 0x51c4, 0x20a1, 
	0x0800, 0x1020, 0x0800, 0x0000, 0x0843, 0x0885, 0x0885, 0x0085, 0x0864, 0x4103, 0x41a7, 0x0064, 0x0084, 0x0084, 0x0084, 0x0084, 
	0x0084, 0x0084, 0x0063, 0x20e3, 0x2880, 0x38c0, 0x4100, 0x5182, 0x4941, 0x51a2, 0x5162, 0x2840, 0x2800, 0x2820, 0x2820, 0x2820, 
	0x2800, 0x3080, 0x51a2, 0x5181, 0x5161, 0x5981, 0x59a2, 0x59a1, 0x59a1, 0x59a1, 0x59a2, 0x59a2, 0x59a2, 0x59a2, 0x59a2, 0x59a1, 
	0x59a2, 0x5162, 0x2840, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x38a0, 0x5981, 0x59a2, 0x61a2, 0x61c2, 0x61c3, 0x61c3, 0x61c2, 
	0x61c2, 0x61c2, 0x61c2, 0x61c2, 0x61c2, 0x5161, 0x4940, 0x59a2, 0x4902, 0x2820, 0x2820, 0x2820, 0x2820, 0x3040, 0x5161, 0x59a1, 
	0x5181, 0x5981, 0x59a1, 0x61c2, 0x61e2, 0x61e2, 0x61e2, 0x61e2, 0x61e2, 0x6202, 0x6202, 0x6202, 0x61e2, 0x5142, 0x3060, 0x3860, 
	0x3860, 0x3860, 0x3860, 0x3060, 0x4900, 0x59a1, 0x59a2, 0x61c2, 0x61c2, 0x61c2, 0x61c2, 0x61e2, 0x61e2, 0x61c2, 0x61c2, 0x61c2, 
	0x59a2, 0x5161, 0x4940, 0x59c2, 0x59a3, 0x40e2, 0x40c1, 0x40c1, 0x40c1, 0x40c1, 0x40c1, 0x4921, 0x51c2, 0x4184, 0x18e5, 0x18e6, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10c5, 0x10c5, 0x18e5, 0x18e5, 0x18e5, 0x18e6, 0x18e6, 0x18e6, 0x18e6, 0x10c5, 
	0x10c5, 0x08a5, 0x0084, 0x0064, 0x0064, 0x0084, 0x0085, 0x0085, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 0x0064, 0x0064, 
	0x0085, 0x0084, 0x0084, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x18e5, 0x18e5, 0x18e5, 0x2105, 0x18e5, 0x18e5, 0x18e5, 0x2105, 0x20e5, 0x1905, 0x2105, 0x2126, 0x2946, 0x2946, 0x2926, 0x2126, 
	0x2106, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x2106, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 
	0x2146, 0x2146, 0x2946, 0x2946, 0x2946, 0x2947, 0x2946, 0x3104, 0x30c2, 0x2905, 0x2106, 0x2105, 0x2106, 0x2105, 0x18a2, 0x0840, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1882, 0x0841, 0x0000, 0x0000, 0x0000, 0x0800, 0x3922, 0x59e3, 0x30e2, 
	0x1000, 0x30e3, 0x0820, 0x0000, 0x0862, 0x10a5, 0x0885, 0x0085, 0x0863, 0x5164, 0x5a28, 0x0064, 0x0084, 0x0084, 0x0084, 0x0084, 
	0x0084, 0x0084, 0x0063, 0x20e3, 0x2880, 0x30a0, 0x4101, 0x4982, 0x4962, 0x5182, 0x4942, 0x38e1, 0x4102, 0x4102, 0x40e2, 0x4102, 
	0x38e1, 0x4122, 0x4962, 0x4961, 0x4120, 0x4941, 0x4941, 0x5162, 0x51a2, 0x59a3, 0x59a3, 0x59a3, 0x59a2, 0x59c3, 0x5182, 0x51a2, 
	0x51a2, 0x4941, 0x40e1, 0x4943, 0x4942, 0x4922, 0x4922, 0x4922, 0x4101, 0x5161, 0x5182, 0x5983, 0x59a3, 0x59a3, 0x59a3, 0x59a3, 
	0x59a3, 0x59a3, 0x59a3, 0x59c3, 0x5182, 0x4921, 0x4921, 0x5182, 0x5162, 0x4942, 0x4122, 0x4102, 0x4102, 0x4121, 0x4961, 0x4941, 
	0x4121, 0x4941, 0x4961, 0x5182, 0x51a2, 0x59a2, 0x59a2, 0x59c2, 0x59c2, 0x59c2, 0x59c2, 0x59a2, 0x5161, 0x4100, 0x4921, 0x59a3, 
	0x59a3, 0x59a3, 0x5183, 0x5183, 0x4941, 0x4921, 0x5162, 0x5182, 0x59a2, 0x59a2, 0x5982, 0x5982, 0x5982, 0x5982, 0x5982, 0x5182, 
	0x4942, 0x38c0, 0x38c0, 0x4941, 0x4941, 0x4922, 0x4922, 0x4922, 0x4921, 0x4921, 0x4901, 0x4901, 0x4921, 0x3922, 0x20a3, 0x18a4, 
	0x18c5, 0x18e5, 0x18e5, 0x18e5, 0x10c5, 0x18e5, 0x18e5, 0x10c5, 0x10c5, 0x10c5, 0x18e5, 0x18e5, 0x18e5, 0x10c5, 0x10c5, 0x10c5, 
	0x08c5, 0x0885, 0x0064, 0x0064, 0x0064, 0x0085, 0x0085, 0x0084, 0x0064, 0x0064, 0x0064, 0x0064, 0x0044, 0x0064, 0x0064, 0x0064, 
	0x0084, 0x0064, 0x0064, 0x0064, 0x0064, 0x0044, 0x0064, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x2105, 0x18e5, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2126, 0x2106, 0x2126, 0x2126, 0x2926, 0x2946, 0x2946, 0x2126, 
	0x2126, 0x2106, 0x18e5, 0x18e5, 0x18c5, 0x18c5, 0x18c5, 0x18c5, 0x18e5, 0x1905, 0x2106, 0x2126, 0x2126, 0x2126, 0x2926, 0x2946, 
	0x2946, 0x2946, 0x2946, 0x2946, 0x2946, 0x2947, 0x3146, 0x3924, 0x28c1, 0x2925, 0x2126, 0x2126, 0x2126, 0x2925, 0x20c3, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0820, 0x4122, 0x51a2, 0x3902, 
	0x0800, 0x1020, 0x0800, 0x0000, 0x1062, 0x10c5, 0x0884, 0x0084, 0x0884, 0x30a1, 0x3904, 0x0884, 0x0084, 0x0084, 0x0085, 0x0084, 
	0x0084, 0x0085, 0x0063, 0x20e3, 0x30a0, 0x30c1, 0x28a0, 0x30a1, 0x30c1, 0x38c1, 0x38a0, 0x30a0, 0x30a0, 0x30a0, 0x30a0, 0x30a0, 
	0x30a0, 0x38a0, 0x38a0, 0x38c0, 0x38c0, 0x30a0, 0x3080, 0x38a0, 0x38c1, 0x40e1, 0x40e1, 0x40e1, 0x40e1, 0x40e1, 0x40e1, 0x40e1, 
	0x40e1, 0x38a0, 0x38c1, 0x4922, 0x4922, 0x4901, 0x4901, 0x4901, 0x38c0, 0x38c0, 0x38c0, 0x40e1, 0x40e1, 0x40e1, 0x40e1, 0x40e1, 
	0x40e1, 0x40c1, 0x40e1, 0x40e1, 0x38c0, 0x38a0, 0x38a0, 0x38c0, 0x40c1, 0x38a0, 0x38a0, 0x38a0, 0x38a0, 0x38a0, 0x38a0, 0x3880, 
	0x3080, 0x3880, 0x38a0, 0x38c0, 0x40c0, 0x40a0, 0x40c0, 0x40a0, 0x40a0, 0x40c0, 0x40c0, 0x40a0, 0x38a0, 0x38a0, 0x40c0, 0x40e1, 
	0x40e1, 0x40e1, 0x40c0, 0x40e0, 0x38a0, 0x38a0, 0x40c0, 0x40c0, 0x40e0, 0x40e0, 0x40c0, 0x40c0, 0x40c0, 0x40c0, 0x40e0, 0x40e0, 
	0x40a0, 0x3860, 0x40c0, 0x4901, 0x40e0, 0x40e0, 0x48e0, 0x48e0, 0x48e0, 0x48e0, 0x48e0, 0x48e0, 0x4900, 0x4901, 0x38e2, 0x2082, 
	0x18a4, 0x18e5, 0x18e5, 0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10c5, 0x10c5, 0x10c5, 0x10a5, 
	0x08a5, 0x00a4, 0x0084, 0x0084, 0x0084, 0x0084, 0x0085, 0x0085, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 
	0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2105, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2106, 
	0x2106, 0x2106, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18c5, 0x18c5, 0x18e5, 0x2106, 0x2126, 0x2126, 0x2946, 0x2946, 0x2946, 0x2946, 
	0x2946, 0x2946, 0x2946, 0x2946, 0x2946, 0x2946, 0x3146, 0x3943, 0x3902, 0x2925, 0x2967, 0x2946, 0x2926, 0x3145, 0x2903, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1040, 0x3944, 0x1041, 0x0000, 0x0000, 0x0000, 0x1040, 0x4142, 0x5182, 0x4122, 
	0x0800, 0x0800, 0x0820, 0x0000, 0x0000, 0x0863, 0x08a5, 0x0084, 0x0884, 0x28a2, 0x3925, 0x10a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 
	0x00a5, 0x0085, 0x0884, 0x20e3, 0x30c0, 0x30e1, 0x1820, 0x2040, 0x38c0, 0x40e0, 0x40e0, 0x40e0, 0x48e0, 0x48e0, 0x4900, 0x4900, 
	0x4900, 0x4900, 0x4900, 0x4900, 0x4920, 0x38c0, 0x38a0, 0x38a0, 0x3880, 0x40c0, 0x40c0, 0x40c0, 0x40c0, 0x40c0, 0x40c0, 0x40e0, 
	0x40e0, 0x40e0, 0x48e0, 0x48e0, 0x48e0, 0x48e0, 0x48e0, 0x48e0, 0x48e0, 0x48e0, 0x48e0, 0x4900, 0x4900, 0x4900, 0x4900, 0x4900, 
	0x4900, 0x4900, 0x48e0, 0x4900, 0x4900, 0x4900, 0x4900, 0x4900, 0x4900, 0x48e0, 0x4900, 0x5100, 0x5120, 0x5120, 0x5120, 0x5121, 
	0x5120, 0x5120, 0x5140, 0x5940, 0x5941, 0x5941, 0x5941, 0x5921, 0x5921, 0x5921, 0x5941, 0x5941, 0x5941, 0x5941, 0x5941, 0x5940, 
	0x5940, 0x5941, 0x5941, 0x5961, 0x5961, 0x5961, 0x5941, 0x5941, 0x5941, 0x5941, 0x5940, 0x5941, 0x5961, 0x5961, 0x5961, 0x6181, 
	0x6161, 0x5940, 0x5940, 0x69a1, 0x69a1, 0x69a1, 0x69a1, 0x69c1, 0x69c0, 0x69a0, 0x69a1, 0x69a1, 0x69c1, 0x61c2, 0x5163, 0x20a2, 
	0x10a4, 0x10c5, 0x18c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10a5, 0x08a5, 0x08a5, 
	0x08a5, 0x0084, 0x0084, 0x0064, 0x0084, 0x0084, 0x0084, 0x0084, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 
	0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x2126, 0x2126, 0x2946, 0x2126, 0x2126, 0x2126, 0x2126, 0x2106, 0x2106, 0x2126, 0x2126, 0x2106, 0x2106, 0x2106, 0x2106, 0x2106, 
	0x2106, 0x1905, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x1905, 0x2106, 0x2126, 0x2146, 0x2946, 0x2946, 0x2946, 0x2946, 0x2946, 
	0x2946, 0x2946, 0x2946, 0x2946, 0x2947, 0x2946, 0x3146, 0x3922, 0x38e1, 0x2904, 0x2967, 0x2946, 0x2946, 0x20c3, 0x0800, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1040, 0x0820, 0x0000, 0x0000, 0x0000, 0x1861, 0x4122, 0x4121, 0x4122, 
	0x0820, 0x1061, 0x28e3, 0x0000, 0x0000, 0x1063, 0x10c5, 0x08a5, 0x0884, 0x2082, 0x3124, 0x18c5, 0x08a5, 0x08c5, 0x10c5, 0x08c5, 
	0x08a5, 0x08a5, 0x08a5, 0x2103, 0x28c0, 0x30c1, 0x1840, 0x3080, 0x5141, 0x5160, 0x5160, 0x5960, 0x5960, 0x5960, 0x5960, 0x5960, 
	0x5960, 0x5960, 0x5961, 0x5961, 0x5120, 0x48e0, 0x4900, 0x4901, 0x4921, 0x5141, 0x5140, 0x5940, 0x5960, 0x5960, 0x5960, 0x5960, 
	0x5960, 0x6180, 0x6180, 0x6160, 0x6160, 0x6160, 0x6160, 0x6160, 0x6160, 0x6160, 0x6180, 0x6181, 0x6181, 0x6180, 0x6180, 0x6161, 
	0x6161, 0x6161, 0x6161, 0x6161, 0x6180, 0x6180, 0x6180, 0x6181, 0x6181, 0x6181, 0x6160, 0x6160, 0x5960, 0x6160, 0x6180, 0x6180, 
	0x6160, 0x6160, 0x6180, 0x6980, 0x6981, 0x6181, 0x6160, 0x6160, 0x6181, 0x6981, 0x6981, 0x6981, 0x6981, 0x6181, 0x6180, 0x61a0, 
	0x69a0, 0x6980, 0x6180, 0x69a0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x69a0, 0x69a0, 0x69a0, 0x69a0, 0x69a0, 0x69a0, 0x6161, 0x40c0, 
	0x5921, 0x6981, 0x5900, 0x6160, 0x71c1, 0x71c1, 0x71c1, 0x69c1, 0x71c1, 0x71c1, 0x71e1, 0x71c1, 0x71e2, 0x6a03, 0x30e2, 0x1083, 
	0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 
	0x08a5, 0x0084, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0064, 0x0064, 
	0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x2126, 0x2946, 0x2947, 0x2947, 0x2947, 0x2946, 0x2126, 0x2106, 0x2106, 0x2126, 0x2106, 0x2105, 0x2106, 0x2126, 0x2126, 0x2126, 
	0x2126, 0x2106, 0x2105, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x2105, 0x2126, 0x2126, 0x2946, 0x2946, 0x2946, 0x2946, 0x2126, 0x2146, 
	0x2946, 0x2946, 0x2946, 0x2946, 0x2947, 0x2946, 0x3145, 0x3102, 0x30e0, 0x28e3, 0x2947, 0x2946, 0x3166, 0x3986, 0x0820, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1041, 0x28c3, 0x0820, 0x0000, 0x0000, 0x0000, 0x2080, 0x30e0, 0x30c0, 0x38e1, 
	0x1861, 0x0800, 0x0800, 0x0000, 0x0000, 0x1062, 0x18e6, 0x08a5, 0x10a4, 0x20a1, 0x3943, 0x18e5, 0x10c5, 0x10c5, 0x10c5, 0x10c6, 
	0x08c5, 0x08a5, 0x08a5, 0x20e4, 0x28a1, 0x30c1, 0x2040, 0x3060, 0x4921, 0x5982, 0x5982, 0x5982, 0x5982, 0x61a2, 0x61a2, 0x59a2, 
	0x59a1, 0x59a1, 0x61a2, 0x61a2, 0x5121, 0x5121, 0x5962, 0x4902, 0x3060, 0x5141, 0x61a2, 0x6181, 0x61a1, 0x61a2, 0x61a2, 0x61a1, 
	0x6181, 0x61a1, 0x61a2, 0x61a2, 0x61a2, 0x69c2, 0x69c2, 0x69a2, 0x69a2, 0x69c2, 0x69c2, 0x69c2, 0x69c2, 0x69c2, 0x69c2, 0x61c2, 
	0x61a2, 0x61a2, 0x61c2, 0x61c2, 0x61a2, 0x61a2, 0x61a2, 0x61a2, 0x61c3, 0x61c3, 0x61a3, 0x61a2, 0x61a2, 0x61c2, 0x69c3, 0x69c2, 
	0x69c2, 0x69a2, 0x69a2, 0x69a2, 0x69a2, 0x69a2, 0x61a2, 0x61a2, 0x69a2, 0x69c3, 0x69c3, 0x69c3, 0x69c3, 0x69c2, 0x69c2, 0x69c2, 
	0x69c2, 0x69c2, 0x69c2, 0x69c2, 0x69c2, 0x69c2, 0x69c2, 0x69c2, 0x69c2, 0x69c2, 0x69c2, 0x69c2, 0x69c3, 0x69c2, 0x5984, 0x2841, 
	0x40e1, 0x61a3, 0x5122, 0x5101, 0x5962, 0x5942, 0x5941, 0x5941, 0x5942, 0x5942, 0x5942, 0x5942, 0x5942, 0x4963, 0x20c3, 0x08a4, 
	0x08a5, 0x08a5, 0x10c5, 0x10c5, 0x10a5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 
	0x0885, 0x0084, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0044, 0x0064, 0x0064, 
	0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0044, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x2946, 0x2946, 0x2947, 0x2947, 0x2947, 0x2947, 0x2946, 0x2146, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 
	0x2126, 0x2126, 0x2126, 0x2126, 0x2106, 0x2126, 0x2126, 0x2126, 0x2126, 0x2146, 0x2946, 0x2946, 0x2146, 0x2146, 0x2126, 0x2146, 
	0x2946, 0x2946, 0x2946, 0x2947, 0x2967, 0x2946, 0x3145, 0x30e1, 0x30e0, 0x28c2, 0x2926, 0x2966, 0x3144, 0x2903, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1020, 0x30e3, 0x0820, 0x0000, 0x0000, 0x0840, 0x28e1, 0x30c0, 0x30a0, 0x30e1, 
	0x2061, 0x0800, 0x1881, 0x0841, 0x0000, 0x0001, 0x10a4, 0x10c5, 0x18e4, 0x28e1, 0x4183, 0x2925, 0x18e6, 0x1906, 0x1906, 0x10e6, 
	0x10e5, 0x10c5, 0x10c5, 0x18c4, 0x1860, 0x30e2, 0x2061, 0x3080, 0x38c1, 0x3081, 0x3081, 0x3081, 0x3081, 0x30a1, 0x38a1, 0x38a0, 
	0x38a0, 0x38a0, 0x38a0, 0x38a1, 0x38a1, 0x38c1, 0x40e2, 0x38c2, 0x2881, 0x40e2, 0x4902, 0x40e2, 0x48e2, 0x48e2, 0x48e2, 0x48e2, 
	0x4902, 0x4902, 0x4902, 0x4922, 0x40e2, 0x4902, 0x48e2, 0x48e2, 0x48e2, 0x4902, 0x48e2, 0x40e2, 0x48e2, 0x48e2, 0x48e2, 0x40e2, 
	0x40e1, 0x40e1, 0x40e2, 0x40e1, 0x40c1, 0x40c1, 0x40a1, 0x40a1, 0x40c1, 0x40c1, 0x40c1, 0x40a1, 0x40a1, 0x38a1, 0x38a1, 0x38a1, 
	0x38a1, 0x40a1, 0x3881, 0x3880, 0x3880, 0x3880, 0x3880, 0x3880, 0x3880, 0x3880, 0x3880, 0x3880, 0x3880, 0x3880, 0x3880, 0x3860, 
	0x3860, 0x3860, 0x3860, 0x3860, 0x3860, 0x3860, 0x3860, 0x3860, 0x3840, 0x3840, 0x3060, 0x3860, 0x3860, 0x3060, 0x2861, 0x1840, 
	0x2060, 0x2861, 0x2020, 0x2000, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2000, 0x1841, 0x10a4, 0x08a5, 
	0x08a5, 0x08a5, 0x10c5, 0x10c5, 0x10a5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 
	0x0085, 0x0084, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 
	0x0044, 0x0044, 0x0044, 0x0064, 0x0064, 0x0064, 0x0044, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x2946, 0x2126, 0x2126, 0x2146, 0x2946, 0x2946, 0x2946, 0x2946, 0x2946, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2106, 0x2106, 
	0x2106, 0x2106, 0x2105, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2146, 0x2146, 0x2126, 0x2146, 
	0x2146, 0x2146, 0x2146, 0x2946, 0x2947, 0x3146, 0x3124, 0x30c0, 0x30c0, 0x2081, 0x20e5, 0x3166, 0x2903, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x0000, 0x0000, 0x0000, 0x1880, 0x28c0, 0x28a0, 0x30a0, 0x30c1, 
	0x28a1, 0x1020, 0x20a2, 0x1881, 0x0000, 0x0000, 0x1082, 0x1905, 0x20e4, 0x30c1, 0x4162, 0x3165, 0x2127, 0x2147, 0x2147, 0x2146, 
	0x18e6, 0x1906, 0x1906, 0x1905, 0x2903, 0x30c2, 0x2040, 0x3080, 0x2860, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 
	0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1840, 0x1820, 0x1800, 0x2000, 0x2000, 0x2000, 0x2800, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2000, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2000, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2000, 0x1800, 0x1000, 
	0x1000, 0x1000, 0x1000, 0x1800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2000, 0x1863, 0x10c5, 0x08c5, 
	0x08c5, 0x08a5, 0x10c5, 0x10c5, 0x08a5, 0x08c5, 0x08c5, 0x10c5, 0x08c5, 0x10c5, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x00a5, 0x0085, 
	0x0084, 0x0084, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 
	0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x2926, 0x2126, 0x2106, 0x2126, 0x2126, 0x2126, 0x2926, 0x2926, 0x2126, 0x2126, 0x2126, 0x2126, 0x2106, 0x2106, 0x2105, 0x2105, 
	0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x2105, 0x2105, 0x2105, 0x2105, 0x2106, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 
	0x2126, 0x2126, 0x2126, 0x2146, 0x2946, 0x3145, 0x30e2, 0x2880, 0x2880, 0x2060, 0x20a2, 0x3965, 0x3145, 0x0841, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1041, 0x28e3, 0x0820, 0x0000, 0x1040, 0x30e1, 0x3901, 0x30c1, 0x30a1, 0x30a1, 
	0x38e2, 0x28a1, 0x0800, 0x0800, 0x0000, 0x0000, 0x1082, 0x2125, 0x28e3, 0x28c0, 0x4162, 0x3965, 0x2967, 0x2967, 0x2947, 0x2947, 
	0x2126, 0x2947, 0x2968, 0x2946, 0x20a2, 0x2040, 0x2040, 0x2860, 0x2861, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2000, 0x1800, 0x1800, 0x1000, 0x0800, 0x0800, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3000, 
	0x3000, 0x3000, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2000, 0x1800, 0x1800, 
	0x1800, 0x2000, 0x2000, 0x2000, 0x2800, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x2800, 0x1863, 0x10c5, 0x08a5, 
	0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a4, 0x08a4, 0x08a5, 0x08a4, 0x08a5, 0x0885, 0x0084, 0x0084, 0x0084, 0x0084, 
	0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0064, 
	0x0044, 0x0044, 0x0044, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0044, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 
	0x2126, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2125, 0x2125, 0x2105, 0x2105, 0x2105, 0x2105, 0x18e5, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1906, 0x1906, 0x1905, 0x2105, 0x2105, 0x2105, 0x1905, 
	0x2105, 0x2105, 0x2125, 0x2126, 0x2946, 0x28e3, 0x2060, 0x2880, 0x2080, 0x2080, 0x1040, 0x1881, 0x1061, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1041, 0x0000, 0x1020, 0x28a1, 0x3081, 0x2860, 0x2840, 0x2820, 0x2020, 
	0x3081, 0x30c2, 0x28a2, 0x2082, 0x0800, 0x0000, 0x0000, 0x20e3, 0x3103, 0x2880, 0x4101, 0x3944, 0x3167, 0x2967, 0x2967, 0x2967, 
	0x2947, 0x2947, 0x2988, 0x3187, 0x20a2, 0x2880, 0x30a0, 0x3080, 0x3081, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2000, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 
	0x2800, 0x2800, 0x2000, 0x2800, 0x2800, 0x3000, 0x3000, 0x2800, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 
	0x3020, 0x3000, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x2000, 0x1800, 0x1000, 
	0x1800, 0x2000, 0x2800, 0x2000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3001, 0x2063, 0x10c5, 0x08a5, 
	0x08a5, 0x08a5, 0x08a5, 0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x0884, 0x0884, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 
	0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x0044, 0x0044, 0x0044, 0x0064, 0x0064, 0x0084, 0x0084, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 
	0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 
	0x1905, 0x1905, 0x2125, 0x2926, 0x3145, 0x28e2, 0x28a0, 0x28c0, 0x28a0, 0x28a1, 0x2061, 0x1840, 0x0820, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1020, 0x0000, 0x1000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2800, 0x2820, 0x2861, 0x2081, 0x0800, 0x0000, 0x0000, 0x2082, 0x3103, 0x2060, 0x38e0, 0x3923, 0x3167, 0x2967, 0x2967, 0x2967, 
	0x2967, 0x2967, 0x2967, 0x3188, 0x3144, 0x28a0, 0x38e1, 0x38c1, 0x2840, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x2800, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x2800, 0x2000, 0x2000, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x2000, 0x2800, 0x2800, 0x2800, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x2000, 0x1800, 0x1000, 
	0x1800, 0x2000, 0x2800, 0x2800, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3001, 0x2063, 0x10c5, 0x08a5, 
	0x08a5, 0x08a5, 0x08a4, 0x0884, 0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x08a5, 0x0085, 0x0084, 0x0084, 0x0084, 0x0084, 
	0x0084, 0x0064, 0x0084, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 0x0044, 
	0x0044, 0x0064, 0x0064, 0x0064, 0x0084, 0x0085, 0x0085, 0x0084, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 
	0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x20e5, 0x2105, 0x2105, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x1905, 0x18e5, 
	0x18e5, 0x1905, 0x2105, 0x2925, 0x28e3, 0x2061, 0x2060, 0x2060, 0x2040, 0x2040, 0x2061, 0x20a2, 0x1061, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1841, 0x28e3, 0x0000, 0x0800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2000, 0x1020, 0x0800, 0x0000, 0x0000, 0x1020, 0x2061, 0x2040, 0x30c0, 0x30e2, 0x3145, 0x3187, 0x2967, 0x2967, 
	0x2967, 0x2967, 0x2947, 0x2967, 0x2945, 0x2880, 0x3902, 0x38c1, 0x2840, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x2800, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x2800, 0x2800, 0x2800, 0x2000, 0x2000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 
	0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x2000, 0x1800, 0x1800, 
	0x1800, 0x2000, 0x2800, 0x2800, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3001, 0x2063, 0x10c5, 0x08a5, 
	0x08a5, 0x08a5, 0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x08a5, 0x0885, 0x08a5, 0x0085, 0x0084, 0x0084, 0x0084, 
	0x0085, 0x0084, 0x0084, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 
	0x0064, 0x0064, 0x0084, 0x0085, 0x0885, 0x08a5, 0x08a5, 0x0085, 0x0084, 0x0084, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 0x0044, 
	0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x20e5, 0x20e5, 0x20e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10e5, 0x10e5, 0x10e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10e5, 
	0x18e5, 0x18e5, 0x20e5, 0x1882, 0x1800, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1040, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1021, 0x0000, 0x0000, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 
	0x2800, 0x2800, 0x1800, 0x1041, 0x1041, 0x0000, 0x0000, 0x0000, 0x1020, 0x2040, 0x2060, 0x2080, 0x20c2, 0x3166, 0x2967, 0x2966, 
	0x2967, 0x2967, 0x2967, 0x2947, 0x2925, 0x28c2, 0x4142, 0x4122, 0x38e1, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x2800, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x2800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x3000, 0x3000, 0x2800, 
	0x2800, 0x2800, 0x3000, 0x3000, 0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2000, 0x2000, 0x2800, 0x2800, 0x3000, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3000, 0x3000, 0x2800, 0x3000, 0x2800, 0x2800, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x2800, 0x2000, 0x2000, 
	0x1800, 0x1800, 0x2000, 0x2000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x2063, 0x10c5, 0x08a5, 
	0x08a5, 0x08a5, 0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x08a4, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x00a4, 0x0084, 0x0085, 
	0x0085, 0x0085, 0x0084, 0x0084, 0x0084, 0x0064, 0x0064, 0x0084, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0084, 
	0x0885, 0x0885, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x00a5, 0x0084, 0x0084, 0x0064, 0x0064, 0x0064, 0x0044, 0x0044, 
	0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x20e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e4, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10e5, 0x10c4, 0x10c4, 0x10c4, 0x10e5, 0x10e5, 0x10c4, 0x10c4, 0x10e5, 0x10e5, 0x10e5, 
	0x18e5, 0x18e5, 0x20e5, 0x20a2, 0x1800, 0x1800, 0x2000, 0x1800, 0x1800, 0x1800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0840, 0x1041, 0x0000, 0x0000, 0x1800, 0x2000, 0x2000, 0x1800, 0x2000, 0x2800, 
	0x2800, 0x2000, 0x1000, 0x0820, 0x0861, 0x0000, 0x0000, 0x0000, 0x1020, 0x2060, 0x2881, 0x2880, 0x28e2, 0x2924, 0x3166, 0x2966, 
	0x2967, 0x2967, 0x2966, 0x2947, 0x3146, 0x3102, 0x4141, 0x4962, 0x4101, 0x2820, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3020, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x2020, 0x1000, 0x1000, 0x1800, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x3000, 0x3000, 0x3000, 
	0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2000, 0x1800, 0x1000, 0x1800, 0x2800, 0x3000, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x2800, 0x2800, 0x2800, 
	0x2000, 0x1800, 0x1800, 0x1800, 0x2800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x2063, 0x10a5, 0x08a5, 
	0x08a5, 0x08a5, 0x10a5, 0x10a5, 0x10a5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 
	0x08a5, 0x00a5, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0064, 0x0064, 0x0084, 0x0084, 0x0084, 0x0885, 0x08a5, 
	0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x0084, 0x0084, 0x0064, 0x0064, 0x0064, 0x0064, 
	0x2105, 0x2105, 0x2105, 0x2105, 0x20e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10e5, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10e5, 0x10c4, 
	0x10c4, 0x10c5, 0x18e5, 0x28e4, 0x1820, 0x1800, 0x2000, 0x2000, 0x1800, 0x1000, 0x1041, 0x0841, 0x0000, 0x0000, 0x0000, 0x0800, 
	0x0800, 0x1000, 0x1000, 0x1000, 0x0800, 0x0800, 0x1061, 0x1081, 0x0000, 0x0000, 0x1000, 0x2000, 0x2000, 0x1000, 0x1800, 0x2800, 
	0x2800, 0x2000, 0x1000, 0x0000, 0x0820, 0x0800, 0x0820, 0x0800, 0x1841, 0x2061, 0x1820, 0x2040, 0x2880, 0x30e2, 0x3946, 0x3167, 
	0x2967, 0x2967, 0x2966, 0x2966, 0x3146, 0x3923, 0x4142, 0x4962, 0x4101, 0x3020, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x2800, 0x2000, 0x1800, 0x1800, 0x2000, 0x1800, 0x1800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 
	0x1000, 0x0000, 0x0000, 0x0800, 0x1800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x3000, 0x3000, 0x3000, 
	0x2800, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2000, 0x1000, 0x0800, 0x0800, 0x0800, 0x2000, 0x3000, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3800, 0x3000, 0x2800, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x2800, 0x2800, 0x2800, 
	0x2000, 0x1800, 0x1800, 0x1800, 0x2800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x2062, 0x10a5, 0x08c5, 
	0x08c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08a5, 0x10a5, 0x10a5, 0x08a5, 
	0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x0885, 0x0885, 0x0885, 0x0885, 0x0885, 0x0885, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 
	0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x10c5, 0x10c5, 0x08a5, 0x08a5, 0x08a5, 0x0085, 0x0084, 0x0084, 0x0085, 0x0084, 
	0x2105, 0x2105, 0x2105, 0x2105, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10e4, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 
	0x10c4, 0x18c5, 0x18e5, 0x2083, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x0800, 0x0841, 0x0820, 0x0000, 0x0800, 0x1000, 0x1020, 
	0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x0800, 0x0800, 0x0800, 0x1800, 0x2000, 0x1800, 0x1000, 0x1800, 0x2000, 
	0x2000, 0x2000, 0x1000, 0x0800, 0x1020, 0x1841, 0x1820, 0x1000, 0x1820, 0x1841, 0x1000, 0x1800, 0x1800, 0x2840, 0x2882, 0x2905, 
	0x2967, 0x2947, 0x2967, 0x3167, 0x3966, 0x3923, 0x3901, 0x4121, 0x38c1, 0x3020, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2000, 0x1800, 0x1800, 0x2000, 0x2000, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2000, 
	0x0800, 0x0000, 0x0000, 0x0000, 0x0800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x3000, 0x3000, 0x3000, 
	0x2800, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x1800, 0x0800, 0x0000, 0x0000, 0x0000, 0x1000, 0x2800, 0x3000, 
	0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3000, 0x2800, 0x2800, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3000, 0x3000, 0x3000, 0x3800, 0x3000, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2000, 0x1800, 0x1800, 0x2000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x2062, 0x10c5, 0x08c5, 
	0x08c5, 0x10c5, 0x10c5, 0x10a5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 
	0x10c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x10c5, 0x10c5, 0x10c5, 
	0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x10c5, 0x10c5, 0x10c5, 0x08c5, 0x08a5, 0x08a5, 0x00a5, 0x0085, 0x0085, 0x0085, 
	0x2105, 0x2105, 0x2105, 0x2105, 0x20e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10e5, 0x10e5, 0x10e5, 0x10e5, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10e5, 0x10e5, 
	0x18e5, 0x18e5, 0x20e5, 0x1841, 0x1000, 0x1800, 0x1800, 0x1800, 0x1000, 0x0800, 0x0000, 0x0800, 0x0800, 0x1000, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 
	0x2000, 0x2000, 0x1800, 0x1820, 0x2040, 0x1800, 0x1800, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2800, 0x1800, 0x20a3, 
	0x2967, 0x2947, 0x2946, 0x2904, 0x28a2, 0x2060, 0x2880, 0x4142, 0x40e1, 0x3020, 0x3000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x1800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2020, 
	0x0800, 0x0000, 0x0000, 0x0000, 0x0800, 0x2000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x2800, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x1800, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3000, 0x2800, 0x2800, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3000, 0x3000, 0x3000, 0x3800, 0x3000, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3000, 0x3000, 0x2800, 0x2800, 
	0x2800, 0x2000, 0x1800, 0x1800, 0x2000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x2063, 0x10c5, 0x08c5, 
	0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 
	0x10c5, 0x10c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a4, 0x08a5, 0x08a5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 
	0x10c5, 0x10c5, 0x10c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x10c5, 0x10c5, 0x10c5, 0x08a5, 0x08a5, 0x08a5, 0x00a5, 0x0085, 0x0085, 
	0x2105, 0x2105, 0x2105, 0x2105, 0x20e5, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x18e5, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x10e5, 0x10c4, 0x10c4, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 
	0x18e5, 0x2105, 0x28e4, 0x1000, 0x1000, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 
	0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2800, 0x2020, 0x2905, 
	0x2147, 0x2946, 0x20e4, 0x1020, 0x1820, 0x2040, 0x3080, 0x4942, 0x4102, 0x2820, 0x2800, 0x3000, 0x3000, 0x2800, 0x2800, 0x3000, 
	0x3000, 0x2800, 0x2000, 0x1000, 0x1800, 0x2000, 0x2800, 0x2000, 0x1800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2000, 
	0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x2800, 0x2800, 0x2800, 0x3000, 0x3800, 0x3800, 0x3800, 0x3000, 0x1800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x2800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3000, 0x3000, 0x2800, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x2800, 0x2000, 0x2000, 0x1800, 0x2000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x3800, 0x2062, 0x10c5, 0x10c5, 
	0x10c5, 0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 
	0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a4, 0x08a4, 0x08a4, 0x08a5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 
	0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08a5, 0x10c5, 0x08c5, 0x08a5, 0x08a5, 0x08c5, 0x08c5, 0x08a5, 0x0085, 0x0085, 
	0x2125, 0x2105, 0x2105, 0x2105, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x18e5, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x18e5, 0x1905, 
	0x1905, 0x20e5, 0x1862, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 
	0x1800, 0x1800, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x2000, 0x2800, 0x2841, 0x2905, 
	0x2126, 0x2126, 0x2905, 0x2082, 0x2060, 0x2881, 0x2840, 0x4122, 0x4122, 0x3020, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x2800, 0x2000, 0x1800, 0x1800, 0x2000, 0x2800, 0x2000, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2000, 
	0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3800, 0x3000, 
	0x3000, 0x2800, 0x2800, 0x3000, 0x3800, 0x3000, 0x3800, 0x3000, 0x1800, 0x0800, 0x0000, 0x0000, 0x0000, 0x1000, 0x2800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3000, 0x2800, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3000, 0x3000, 0x3800, 0x3000, 0x3000, 0x2800, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x2800, 0x2000, 0x1800, 0x2800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x3800, 0x2062, 0x10c5, 0x10c5, 
	0x10c5, 0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 
	0x10c5, 0x10c5, 0x10c5, 0x08c5, 0x08c5, 0x08a5, 0x08c5, 0x08a5, 0x08a4, 0x08a4, 0x08a4, 0x08a5, 0x08c5, 0x10c5, 0x10c5, 0x10c5, 
	0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08c5, 0x08a5, 0x08a5, 0x0885, 
	0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x18e5, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x18e5, 0x1905, 0x1905, 0x1905, 0x1905, 0x18e5, 0x1905, 
	0x1905, 0x20c4, 0x1000, 0x1000, 0x1000, 0x1800, 0x1000, 0x0800, 0x1000, 0x1000, 0x1800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x3000, 0x2800, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x2000, 0x2800, 0x2000, 0x1882, 
	0x2125, 0x2126, 0x20e5, 0x2905, 0x28a2, 0x2860, 0x2840, 0x4922, 0x4122, 0x3020, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x2000, 0x1800, 0x2000, 0x2000, 0x2800, 0x2800, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2020, 
	0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 
	0x3000, 0x2800, 0x2800, 0x3000, 0x3800, 0x3000, 0x3000, 0x3000, 0x1800, 0x0800, 0x0000, 0x0000, 0x0000, 0x1000, 0x2800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x2800, 0x2000, 0x2000, 0x2800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x3800, 0x2062, 0x18c5, 0x10e5, 
	0x10e5, 0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 
	0x10c5, 0x10c5, 0x10c5, 0x08c5, 0x08c5, 0x10c5, 0x10c5, 0x08c5, 0x08a5, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x10c5, 0x10c5, 0x10c5, 
	0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10a5, 0x10a5, 0x10a5, 0x08a5, 0x10a5, 0x10a5, 0x10c5, 0x10c5, 0x08a5, 0x08a5, 
	0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x18e5, 0x18e5, 
	0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x1905, 0x1905, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 
	0x18e5, 0x2105, 0x2062, 0x1000, 0x1800, 0x1800, 0x1000, 0x0800, 0x1000, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x2800, 0x2000, 0x1800, 0x2000, 0x1800, 0x1800, 0x2000, 0x2000, 0x1820, 
	0x2104, 0x2125, 0x18e5, 0x20e4, 0x1861, 0x2880, 0x38e1, 0x4942, 0x4922, 0x3020, 0x2800, 0x3000, 0x3000, 0x2800, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x2000, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2020, 
	0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 
	0x3000, 0x2800, 0x3000, 0x3000, 0x3800, 0x3800, 0x3000, 0x3000, 0x1800, 0x0800, 0x0000, 0x0000, 0x0000, 0x1000, 0x2800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3000, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x2800, 0x2800, 0x2000, 0x2000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x3800, 0x2042, 0x18c5, 0x10c5, 
	0x10c5, 0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 
	0x10c5, 0x10c5, 0x10c5, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08c5, 0x08c5, 0x08c5, 0x10c5, 
	0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c6, 0x10c5, 0x10c5, 0x10c5, 
	0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 
	0x1905, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x1905, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 
	0x18e5, 0x2105, 0x28c4, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 
	0x1800, 0x2000, 0x2000, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x3000, 0x2800, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x2800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x1800, 
	0x18a3, 0x2126, 0x2105, 0x1882, 0x2040, 0x38e1, 0x4101, 0x4962, 0x4122, 0x2840, 0x2800, 0x3000, 0x2800, 0x2800, 0x3000, 0x3000, 
	0x3000, 0x2800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2000, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2020, 
	0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x1800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x2800, 0x2800, 0x3000, 0x3000, 0x3800, 0x3000, 0x2800, 0x1800, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2000, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x2800, 0x2800, 0x2000, 0x2000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x3800, 0x2042, 0x18c5, 0x10e5, 
	0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 
	0x10c5, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 
	0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 
	0x2125, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x1905, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x1905, 0x1905, 0x1905, 0x1905, 
	0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 
	0x18e5, 0x2105, 0x20a3, 0x1800, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 
	0x1800, 0x1800, 0x2000, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x2000, 0x3860, 0x3860, 0x3860, 0x3860, 
	0x3860, 0x3840, 0x2800, 0x1800, 0x1800, 0x2800, 0x3000, 0x3000, 0x2800, 0x2000, 0x1800, 0x2000, 0x1800, 0x1800, 0x2000, 0x2000, 
	0x1062, 0x2126, 0x18e5, 0x1041, 0x2880, 0x4101, 0x4101, 0x4962, 0x4122, 0x2840, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 
	0x3000, 0x2800, 0x2000, 0x1800, 0x1800, 0x2000, 0x2800, 0x2000, 0x1800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2000, 
	0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3800, 0x3000, 0x2800, 0x1800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 0x2000, 0x3000, 
	0x3800, 0x3800, 0x3800, 0x3000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3000, 0x2800, 0x2800, 0x2820, 0x2800, 0x2800, 0x2800, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2000, 0x2000, 0x2000, 0x2000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x3800, 0x2042, 0x18c5, 0x10e6, 
	0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08c5, 
	0x08c5, 0x08a5, 0x08a5, 0x0884, 0x0884, 0x0084, 0x0885, 0x0885, 0x0084, 0x0085, 0x00a5, 0x0085, 0x0085, 0x0085, 0x08a5, 0x08a5, 
	0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 
	0x2125, 0x2125, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x2105, 
	0x2105, 0x2105, 0x2105, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 
	0x18e5, 0x18e5, 0x20a3, 0x1800, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 
	0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x1020, 0x0800, 0x1000, 0x1800, 0x3040, 0x5961, 0x6181, 0x5961, 0x5961, 
	0x6182, 0x5101, 0x2800, 0x1800, 0x1800, 0x2000, 0x2800, 0x2800, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x2000, 0x2000, 
	0x1042, 0x1906, 0x1906, 0x18a3, 0x2060, 0x3901, 0x4121, 0x4942, 0x4102, 0x2840, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 
	0x3000, 0x2800, 0x2000, 0x1800, 0x1800, 0x2000, 0x2020, 0x2020, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2000, 
	0x1800, 0x1820, 0x1820, 0x1820, 0x1820, 0x2000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2800, 0x2800, 0x3000, 0x3000, 0x3800, 0x3000, 0x3000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x3000, 
	0x3800, 0x3800, 0x3000, 0x3000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3000, 0x2820, 0x2840, 0x2820, 0x2820, 0x2820, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3020, 0x3020, 0x3020, 
	0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x3800, 0x2842, 0x18c5, 0x10e6, 
	0x10e6, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08c5, 0x08a5, 
	0x08a5, 0x08a5, 0x08a4, 0x0884, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 
	0x0085, 0x0085, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x10c5, 0x10a5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 
	0x2126, 0x2125, 0x2125, 0x2126, 0x2125, 0x2125, 0x2125, 0x2125, 0x2105, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x2105, 
	0x2105, 0x2125, 0x2125, 0x2105, 0x2105, 0x1905, 0x1905, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x18e5, 0x18c5, 0x18c5, 0x18c5, 0x18e5, 
	0x18e5, 0x18e5, 0x28c4, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x2040, 0x1820, 0x1000, 0x1000, 
	0x1000, 0x1800, 0x1800, 0x1800, 0x2020, 0x1820, 0x1020, 0x0800, 0x1861, 0x3902, 0x4943, 0x5162, 0x61c2, 0x5982, 0x48c0, 0x5100, 
	0x69a2, 0x69a2, 0x40e1, 0x2840, 0x1800, 0x1800, 0x2800, 0x2000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x1800, 0x2800, 0x2021, 
	0x18c4, 0x1906, 0x18e6, 0x20e5, 0x20a2, 0x3901, 0x4121, 0x4942, 0x4122, 0x2840, 0x2800, 0x3000, 0x2800, 0x2800, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x2800, 0x1800, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x3000, 0x2800, 0x3000, 0x3000, 0x3800, 0x3800, 0x3000, 0x3000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 
	0x3000, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x2800, 0x2000, 0x2000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x3800, 0x2842, 0x18c5, 0x10e6, 
	0x10e6, 0x10e6, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08c5, 0x08a5, 
	0x08a5, 0x08a5, 0x08a4, 0x0884, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 
	0x0085, 0x0085, 0x0085, 0x00a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08c5, 0x10c5, 0x10c5, 
	0x2926, 0x2946, 0x2946, 0x2146, 0x2125, 0x2126, 0x2125, 0x2126, 0x2126, 0x2126, 0x2125, 0x2125, 0x2125, 0x2125, 0x2126, 0x2106, 
	0x2105, 0x2105, 0x2125, 0x2125, 0x2126, 0x2126, 0x2126, 0x1905, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x18c5, 0x18c5, 0x18e5, 0x18e5, 
	0x18e5, 0x20e5, 0x28c3, 0x2040, 0x3060, 0x3880, 0x40c1, 0x3881, 0x2000, 0x1800, 0x1800, 0x2840, 0x2860, 0x1000, 0x0800, 0x0800, 
	0x1000, 0x1000, 0x1800, 0x2000, 0x1820, 0x0800, 0x0800, 0x0000, 0x2081, 0x4102, 0x40e2, 0x48e2, 0x40a1, 0x3860, 0x3020, 0x4060, 
	0x50c1, 0x5122, 0x5984, 0x38c2, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2041, 
	0x18e5, 0x10e6, 0x18e6, 0x18e6, 0x20e4, 0x3922, 0x4121, 0x4962, 0x4122, 0x2840, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 
	0x2800, 0x3000, 0x2800, 0x2000, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3000, 0x2000, 0x2000, 0x3800, 0x4000, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x3800, 0x2842, 0x18c5, 0x10e6, 
	0x10e6, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 
	0x08a5, 0x08a5, 0x08a5, 0x0884, 0x0084, 0x0084, 0x0084, 0x00a5, 0x0085, 0x0085, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 
	0x0084, 0x0084, 0x0085, 0x0085, 0x0085, 0x0085, 0x0885, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x10c5, 0x10c5, 
	0x2966, 0x2966, 0x2946, 0x2946, 0x2946, 0x2946, 0x2146, 0x2946, 0x2946, 0x2946, 0x2946, 0x2146, 0x2126, 0x2126, 0x2126, 0x2126, 
	0x2126, 0x2125, 0x2125, 0x2125, 0x2126, 0x2126, 0x2126, 0x2126, 0x2106, 0x2105, 0x2105, 0x1905, 0x18e5, 0x18e5, 0x18e5, 0x1905, 
	0x2105, 0x2105, 0x28e4, 0x30c2, 0x38c0, 0x4921, 0x5982, 0x5142, 0x38a1, 0x40e2, 0x38c2, 0x38a1, 0x2861, 0x1000, 0x0800, 0x0800, 
	0x0800, 0x1800, 0x2820, 0x2020, 0x1000, 0x0800, 0x0000, 0x0000, 0x1000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 
	0x3000, 0x3000, 0x2820, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x2840, 0x2040, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x1841, 
	0x18e5, 0x10e6, 0x10e6, 0x10e6, 0x18e4, 0x3943, 0x4141, 0x4962, 0x4122, 0x2840, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 
	0x2800, 0x3000, 0x2800, 0x2000, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x3800, 
	0x3800, 0x3800, 0x3000, 0x2000, 0x2000, 0x3800, 0x4000, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x3800, 0x2842, 0x18c5, 0x10e6, 
	0x10e6, 0x10e6, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 
	0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a4, 0x08a5, 0x00a5, 0x00a5, 0x00a5, 0x0085, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 
	0x0084, 0x0085, 0x0085, 0x0084, 0x0085, 0x0085, 0x0885, 0x08a5, 0x0885, 0x0885, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x10c5, 
	0x2967, 0x2966, 0x2966, 0x2966, 0x2966, 0x2966, 0x2967, 0x2967, 0x3167, 0x2967, 0x2967, 0x2966, 0x2946, 0x2946, 0x2946, 0x2946, 
	0x2146, 0x2126, 0x2126, 0x2126, 0x2126, 0x2146, 0x2146, 0x2146, 0x2126, 0x2126, 0x2126, 0x2106, 0x2105, 0x2105, 0x2105, 0x2105, 
	0x2106, 0x2106, 0x2925, 0x3903, 0x38e2, 0x3880, 0x40e1, 0x5142, 0x4902, 0x4902, 0x38a1, 0x3081, 0x2881, 0x2061, 0x0820, 0x0000, 
	0x0800, 0x2020, 0x40c1, 0x38c1, 0x1820, 0x0800, 0x0800, 0x0800, 0x0800, 0x1800, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x3000, 
	0x3000, 0x2800, 0x1820, 0x1000, 0x2020, 0x2020, 0x1800, 0x1000, 0x2020, 0x3060, 0x2000, 0x2000, 0x2000, 0x2800, 0x3020, 0x1841, 
	0x10c5, 0x10c6, 0x10e6, 0x10e6, 0x18c4, 0x3943, 0x4141, 0x4962, 0x4101, 0x2020, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 
	0x2800, 0x3000, 0x2800, 0x2000, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3000, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x3800, 
	0x3800, 0x3800, 0x3000, 0x2000, 0x2000, 0x3800, 0x4000, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x3800, 0x2822, 0x18c5, 0x10e6, 
	0x10e6, 0x10e6, 0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 
	0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x00a5, 0x00a4, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x0085, 
	0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x0885, 0x08a5, 0x0085, 0x0885, 0x0884, 0x08a5, 0x08a5, 0x10c5, 0x10c5, 0x10c5, 
	0x2946, 0x2946, 0x2946, 0x2966, 0x2966, 0x3167, 0x3187, 0x3187, 0x3187, 0x3187, 0x2967, 0x2967, 0x2967, 0x2967, 0x2967, 0x2947, 
	0x2946, 0x2946, 0x2946, 0x2946, 0x2946, 0x2967, 0x2967, 0x2947, 0x2946, 0x2946, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 
	0x2106, 0x2126, 0x2126, 0x3125, 0x2882, 0x2000, 0x2800, 0x2820, 0x2800, 0x2000, 0x2000, 0x1800, 0x1800, 0x1020, 0x0800, 0x0800, 
	0x0000, 0x2020, 0x5163, 0x5184, 0x2061, 0x0800, 0x0800, 0x0800, 0x0800, 0x1800, 0x3060, 0x40c1, 0x4902, 0x4922, 0x4922, 0x5122, 
	0x48e1, 0x3081, 0x28c3, 0x20a3, 0x30a1, 0x38e1, 0x2881, 0x1820, 0x3080, 0x40c1, 0x38a1, 0x3881, 0x38a1, 0x3860, 0x40a1, 0x28a2, 
	0x10e5, 0x10e6, 0x10e6, 0x10e6, 0x18c5, 0x3123, 0x4142, 0x4942, 0x4101, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x3000, 0x2800, 0x1800, 0x1800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3800, 0x3800, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x2800, 0x2000, 0x2000, 0x3000, 0x4000, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x3800, 0x2822, 0x18c5, 0x10e6, 
	0x10e6, 0x10c6, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 
	0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x10c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 
	0x08a5, 0x0885, 0x0885, 0x0885, 0x0885, 0x0885, 0x0885, 0x08a5, 0x08a5, 0x0085, 0x0884, 0x08a5, 0x08a5, 0x10c5, 0x10c5, 0x08c5, 
	0x2126, 0x2126, 0x2926, 0x2946, 0x3167, 0x3167, 0x3167, 0x2967, 0x2966, 0x2966, 0x2966, 0x2966, 0x2966, 0x2966, 0x2946, 0x2946, 
	0x2946, 0x2946, 0x2946, 0x2946, 0x2946, 0x2967, 0x2966, 0x2966, 0x2946, 0x2946, 0x2946, 0x2146, 0x2126, 0x2126, 0x2126, 0x2126, 
	0x2126, 0x2126, 0x2126, 0x2926, 0x20a3, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x1000, 0x0800, 0x0800, 0x0000, 
	0x0000, 0x1800, 0x4902, 0x4102, 0x1840, 0x0800, 0x0000, 0x0800, 0x0800, 0x2040, 0x4902, 0x4942, 0x4922, 0x4902, 0x4922, 0x5942, 
	0x5963, 0x4943, 0x2925, 0x2904, 0x2840, 0x4102, 0x3103, 0x1820, 0x30c1, 0x4922, 0x48e1, 0x5122, 0x69e3, 0x61a3, 0x5122, 0x28e3, 
	0x10e5, 0x1106, 0x18e6, 0x18e6, 0x18e5, 0x3144, 0x4142, 0x4142, 0x4102, 0x2840, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1800, 0x2000, 0x2800, 0x3000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x2800, 0x2000, 0x2000, 0x3000, 0x3800, 0x4000, 0x3800, 0x3800, 0x3800, 0x4000, 0x3800, 0x2822, 0x18c5, 0x08e6, 
	0x08c6, 0x08c6, 0x08c5, 0x08c5, 0x08c5, 0x10c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x00a5, 0x00a5, 0x0085, 0x0085, 0x0085, 
	0x08a5, 0x08a5, 0x08a5, 0x08c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 
	0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08c5, 0x08a5, 0x08a5, 0x0885, 0x0885, 0x08a5, 0x10c5, 0x08c5, 0x08a5, 0x08a5, 
	0x2926, 0x2926, 0x2946, 0x2946, 0x3167, 0x3187, 0x3187, 0x2987, 0x2966, 0x2966, 0x2966, 0x2946, 0x2946, 0x2946, 0x2946, 0x2946, 
	0x2946, 0x2946, 0x2946, 0x2946, 0x2946, 0x2946, 0x2966, 0x2966, 0x2946, 0x2946, 0x2946, 0x2946, 0x2146, 0x2126, 0x2126, 0x2126, 
	0x2126, 0x2126, 0x2126, 0x2106, 0x2904, 0x1820, 0x2040, 0x2840, 0x2860, 0x2860, 0x2840, 0x1820, 0x1000, 0x1040, 0x0800, 0x0861, 
	0x18a3, 0x1820, 0x2820, 0x2860, 0x1000, 0x0800, 0x0800, 0x0800, 0x0800, 0x1820, 0x2820, 0x2000, 0x2800, 0x2800, 0x2800, 0x3000, 
	0x3020, 0x2861, 0x1061, 0x1041, 0x2861, 0x38e2, 0x1841, 0x0800, 0x1820, 0x3040, 0x3000, 0x3820, 0x4881, 0x50e2, 0x4923, 0x2925, 
	0x10e5, 0x1906, 0x1906, 0x1906, 0x18e5, 0x3144, 0x4142, 0x4122, 0x38e1, 0x2840, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1800, 0x2000, 0x2800, 0x3000, 0x2800, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3000, 0x2000, 0x2000, 0x3000, 0x3800, 0x4000, 0x3800, 0x3800, 0x3800, 0x4000, 0x3800, 0x2822, 0x18c5, 0x08e6, 
	0x08c6, 0x08c6, 0x08c5, 0x08c5, 0x08c5, 0x10c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 
	0x08a5, 0x08a5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 
	0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10e6, 0x10c6, 0x08c5, 0x08c5, 0x08a5, 0x08c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 
	0x2126, 0x2126, 0x2946, 0x2946, 0x2966, 0x2967, 0x3187, 0x2987, 0x2966, 0x2966, 0x2966, 0x2946, 0x2946, 0x2946, 0x2946, 0x2946, 
	0x2946, 0x2946, 0x2126, 0x2126, 0x2946, 0x2146, 0x2146, 0x2146, 0x2946, 0x2146, 0x2146, 0x2126, 0x2146, 0x2126, 0x2126, 0x2126, 
	0x2126, 0x2126, 0x2126, 0x2105, 0x2904, 0x3903, 0x4943, 0x4943, 0x4143, 0x4122, 0x4122, 0x38e2, 0x28a2, 0x30e3, 0x1041, 0x20e4, 
	0x2925, 0x28a3, 0x30a2, 0x2861, 0x1000, 0x1020, 0x1000, 0x0800, 0x0800, 0x1000, 0x2000, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 
	0x3000, 0x2020, 0x1062, 0x1062, 0x1861, 0x1820, 0x0000, 0x0800, 0x1000, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x28a3, 0x1905, 
	0x1906, 0x1906, 0x1906, 0x1906, 0x2105, 0x3144, 0x3942, 0x30c1, 0x30a1, 0x2840, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1800, 0x2000, 0x2800, 0x3000, 0x2800, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3000, 0x2000, 0x2000, 0x3000, 0x4000, 0x4000, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x2822, 0x10a5, 0x08c6, 
	0x08c5, 0x08c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 
	0x08c5, 0x08c5, 0x08c5, 0x10c5, 0x10c5, 0x10c5, 0x10e5, 0x10e5, 0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10e5, 
	0x10e5, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10c6, 0x08c6, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 
	0x2125, 0x2126, 0x2126, 0x2126, 0x2146, 0x2946, 0x2967, 0x2967, 0x2967, 0x2966, 0x2966, 0x2966, 0x2946, 0x2946, 0x2946, 0x2946, 
	0x2946, 0x2146, 0x2126, 0x2126, 0x2126, 0x2146, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2106, 
	0x2106, 0x2126, 0x2126, 0x2105, 0x28e4, 0x30a2, 0x3061, 0x2840, 0x2840, 0x2840, 0x2840, 0x2041, 0x2881, 0x30e3, 0x1041, 0x18c4, 
	0x20e4, 0x1841, 0x2041, 0x1020, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 0x2000, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 
	0x3000, 0x2862, 0x2125, 0x2126, 0x2105, 0x1062, 0x0000, 0x0800, 0x1000, 0x2000, 0x2800, 0x3020, 0x2800, 0x2821, 0x20e5, 0x1906, 
	0x1906, 0x1906, 0x2106, 0x2106, 0x2126, 0x2924, 0x2081, 0x2040, 0x2020, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1800, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3000, 0x2000, 0x2000, 0x3000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x2842, 0x10a5, 0x08c5, 
	0x08c5, 0x08c5, 0x10c6, 0x10e6, 0x10e6, 0x10e6, 0x10c5, 0x10c5, 0x08c5, 0x08c5, 0x10c5, 0x10e5, 0x10e6, 0x10e5, 0x10e5, 0x10c5, 
	0x08c5, 0x10c5, 0x08c5, 0x10c5, 0x10c5, 0x10c5, 0x10e5, 0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 
	0x10e5, 0x10e5, 0x18e6, 0x1906, 0x18e6, 0x18e6, 0x10e6, 0x10e6, 0x10c6, 0x10c6, 0x08c5, 0x08a5, 0x08a5, 0x00a5, 0x0085, 0x08a5, 
	0x2125, 0x2125, 0x2125, 0x2126, 0x2126, 0x2146, 0x2946, 0x2966, 0x2966, 0x2966, 0x2966, 0x2966, 0x2946, 0x2946, 0x2946, 0x2946, 
	0x2946, 0x2146, 0x2146, 0x2146, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2106, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 
	0x2105, 0x2126, 0x2105, 0x2106, 0x28e4, 0x2020, 0x1800, 0x1800, 0x2000, 0x2000, 0x1800, 0x1000, 0x1020, 0x28e4, 0x1883, 0x2105, 
	0x20e4, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2000, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 
	0x3000, 0x2862, 0x2126, 0x1926, 0x2946, 0x2905, 0x0820, 0x1820, 0x2881, 0x40e2, 0x5122, 0x5143, 0x5123, 0x30e3, 0x2105, 0x1906, 
	0x1926, 0x2126, 0x2126, 0x2106, 0x2126, 0x20c3, 0x1820, 0x2020, 0x2020, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1800, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 
	0x3800, 0x3800, 0x3000, 0x2800, 0x2000, 0x3000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x3042, 0x18a5, 0x08c6, 
	0x08c6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x18e6, 0x18e6, 0x10e6, 0x10e5, 0x10c5, 0x10e5, 0x10e5, 0x10e6, 0x10e6, 0x10e6, 0x10e5, 
	0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10e5, 0x10e5, 0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10e5, 0x10e5, 
	0x10e5, 0x10e5, 0x10e5, 0x1906, 0x1906, 0x18e6, 0x10e6, 0x10c5, 0x10c5, 0x08a5, 0x08a5, 0x08a5, 0x0085, 0x0085, 0x0084, 0x08a5, 
	0x2926, 0x2125, 0x2125, 0x2125, 0x2126, 0x2146, 0x2146, 0x2146, 0x2946, 0x2946, 0x2946, 0x2946, 0x2946, 0x2946, 0x2946, 0x2946, 
	0x2946, 0x2146, 0x2146, 0x2146, 0x2126, 0x2126, 0x2106, 0x2106, 0x2106, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 0x1905, 
	0x1905, 0x1905, 0x2105, 0x2106, 0x2905, 0x2041, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x1841, 0x2925, 0x2126, 0x2947, 
	0x2946, 0x1021, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0800, 0x1800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x2862, 0x2926, 0x2126, 0x2146, 0x2105, 0x1020, 0x1020, 0x2040, 0x3061, 0x3881, 0x48c2, 0x5123, 0x3925, 0x2125, 0x1926, 
	0x2126, 0x2126, 0x2126, 0x2106, 0x2126, 0x2925, 0x30e2, 0x30c1, 0x30a1, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1800, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 
	0x3800, 0x3800, 0x3000, 0x2800, 0x2000, 0x3000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x3021, 0x18a5, 0x10e6, 
	0x10e6, 0x1106, 0x1106, 0x1906, 0x1906, 0x1906, 0x18e6, 0x1906, 0x1106, 0x10e6, 0x10e5, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 
	0x10e6, 0x10e5, 0x10e5, 0x10e5, 0x10e5, 0x10e5, 0x10e5, 0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10e6, 0x10e6, 
	0x10e6, 0x10e5, 0x10e6, 0x1906, 0x1906, 0x1906, 0x10e6, 0x10e6, 0x10c5, 0x08a5, 0x08a5, 0x0085, 0x00a5, 0x0085, 0x0084, 0x0085, 
	0x1883, 0x28e5, 0x2946, 0x2926, 0x2925, 0x2126, 0x2126, 0x2946, 0x2946, 0x2146, 0x2146, 0x2146, 0x2146, 0x2146, 0x2146, 0x2126, 
	0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2106, 0x2105, 0x2105, 0x2105, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 0x18e5, 
	0x18e5, 0x1905, 0x1905, 0x2105, 0x20e4, 0x2021, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x1821, 0x2906, 0x2126, 0x2127, 
	0x2947, 0x20c3, 0x1861, 0x1861, 0x1861, 0x1041, 0x1020, 0x1020, 0x1820, 0x2020, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 
	0x3000, 0x2821, 0x28e5, 0x2967, 0x2947, 0x18a3, 0x0800, 0x0800, 0x1000, 0x1800, 0x2800, 0x2800, 0x2800, 0x2082, 0x2126, 0x2126, 
	0x2126, 0x2126, 0x2126, 0x2126, 0x2106, 0x2925, 0x3923, 0x38e1, 0x4102, 0x3061, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1800, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3000, 0x2800, 0x2000, 0x3000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x3021, 0x18c5, 0x10e6, 
	0x10e6, 0x1106, 0x1106, 0x1106, 0x18e6, 0x18e6, 0x18e6, 0x1906, 0x1906, 0x1106, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 
	0x10e6, 0x10e5, 0x10e5, 0x10e5, 0x10e5, 0x10e6, 0x10e6, 0x10e6, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10e6, 0x10e6, 
	0x10e6, 0x10e5, 0x10e5, 0x10e6, 0x1906, 0x1906, 0x1906, 0x10e6, 0x08c5, 0x08a5, 0x08a5, 0x00a5, 0x0085, 0x0085, 0x0085, 0x08a5, 
	0x1000, 0x1841, 0x1862, 0x1862, 0x20e4, 0x3146, 0x3146, 0x2946, 0x2946, 0x2946, 0x2146, 0x2146, 0x2946, 0x2146, 0x2126, 0x2126, 
	0x2126, 0x2126, 0x2126, 0x2125, 0x2126, 0x2106, 0x2105, 0x2105, 0x2105, 0x1905, 0x1905, 0x18e5, 0x18e5, 0x1905, 0x1905, 0x18e5, 
	0x18e5, 0x1905, 0x1905, 0x2105, 0x20c4, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x28e5, 0x2947, 0x2126, 
	0x2946, 0x20a3, 0x1841, 0x1020, 0x0820, 0x0800, 0x0800, 0x0800, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 
	0x3800, 0x3000, 0x28a3, 0x3167, 0x3188, 0x20e4, 0x0000, 0x0800, 0x1000, 0x2000, 0x2800, 0x3000, 0x2800, 0x28c4, 0x2126, 0x1926, 
	0x2126, 0x2126, 0x2126, 0x1926, 0x1906, 0x2905, 0x3923, 0x3901, 0x4102, 0x3061, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1800, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3000, 0x2800, 0x2000, 0x3000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x3021, 0x18c5, 0x10e6, 
	0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e5, 0x10e5, 0x10e5, 0x10e5, 0x10e5, 0x10c5, 0x10e5, 0x10e5, 0x10e5, 0x10e5, 
	0x10e5, 0x10e5, 0x10e5, 0x10e5, 0x10e5, 0x10e5, 0x1106, 0x10e6, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 
	0x10c5, 0x10c5, 0x10c5, 0x10e5, 0x10e6, 0x18e6, 0x1906, 0x10e6, 0x10c5, 0x08c5, 0x08a5, 0x08a5, 0x0085, 0x0085, 0x0085, 0x08a5, 
	0x1000, 0x1000, 0x0800, 0x0800, 0x0800, 0x2904, 0x3125, 0x20c4, 0x2925, 0x3167, 0x2966, 0x2946, 0x2946, 0x2146, 0x2146, 0x2146, 
	0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2106, 0x2106, 0x2106, 0x2106, 0x2106, 0x2105, 0x1905, 0x1905, 0x1905, 
	0x1905, 0x1906, 0x2106, 0x2905, 0x20a3, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x20a3, 0x2947, 0x2147, 
	0x2946, 0x1862, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 
	0x3800, 0x3000, 0x2842, 0x2926, 0x3187, 0x2905, 0x0800, 0x0800, 0x1800, 0x2000, 0x2800, 0x3000, 0x2800, 0x28a4, 0x2126, 0x1906, 
	0x1906, 0x1906, 0x1926, 0x1906, 0x1906, 0x2104, 0x3902, 0x38e1, 0x38e1, 0x2820, 0x4902, 0x40c2, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x2800, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3000, 0x2800, 0x2000, 0x3000, 0x3800, 0x4000, 0x4000, 0x4000, 0x3800, 0x4000, 0x4000, 0x3021, 0x18a5, 0x10e6, 
	0x10e6, 0x10e6, 0x10e6, 0x10e5, 0x10e5, 0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10e5, 
	0x10c5, 0x10e5, 0x10e5, 0x10e5, 0x10e5, 0x10e5, 0x10e6, 0x10e6, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 
	0x08c5, 0x08c5, 0x08c5, 0x10c5, 0x10e6, 0x10e6, 0x10e6, 0x10c6, 0x10c5, 0x08c5, 0x08a5, 0x08a5, 0x0085, 0x0085, 0x0085, 0x00a5, 
	0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x1020, 0x1861, 0x1021, 0x1882, 0x20c4, 0x20e4, 0x2946, 0x2946, 0x2946, 0x2946, 0x2946, 
	0x2946, 0x2146, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 0x2106, 0x2105, 0x2106, 0x2126, 
	0x2126, 0x1926, 0x2126, 0x2905, 0x2041, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1862, 0x2946, 0x2147, 
	0x2966, 0x20c4, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x2841, 0x2905, 0x3167, 0x20c3, 0x0800, 0x1000, 0x1800, 0x2000, 0x2800, 0x3000, 0x3000, 0x2883, 0x2106, 0x1906, 
	0x1906, 0x1906, 0x1906, 0x1906, 0x18e6, 0x2904, 0x30e1, 0x30c0, 0x30c1, 0x2840, 0x61a4, 0x5964, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3000, 0x2000, 0x2000, 0x3000, 0x3800, 0x4000, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x3021, 0x18a4, 0x10e5, 
	0x10e6, 0x10e6, 0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10e5, 
	0x10c5, 0x10e5, 0x10e5, 0x10e5, 0x10e5, 0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 
	0x08a5, 0x08a5, 0x08a5, 0x08c5, 0x10c6, 0x10e6, 0x10c6, 0x10c5, 0x08c5, 0x08a5, 0x08a5, 0x0885, 0x0085, 0x0085, 0x0084, 0x0085, 
	0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0800, 0x1000, 0x1000, 0x0800, 0x0800, 0x1041, 0x3145, 0x3187, 0x2946, 0x2946, 
	0x2967, 0x2947, 0x2947, 0x2147, 0x2146, 0x2946, 0x2146, 0x2146, 0x2146, 0x2146, 0x2146, 0x2126, 0x2126, 0x2126, 0x2126, 0x2126, 
	0x2126, 0x2126, 0x2926, 0x28e4, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1821, 0x2105, 0x2126, 
	0x2946, 0x20c3, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x3000, 
	0x3000, 0x3000, 0x2062, 0x2946, 0x2946, 0x1041, 0x0800, 0x1000, 0x1800, 0x2000, 0x2800, 0x3000, 0x3000, 0x2841, 0x2105, 0x1906, 
	0x1906, 0x1906, 0x1906, 0x18e6, 0x20e5, 0x28e3, 0x28c1, 0x30c0, 0x30e1, 0x2840, 0x3881, 0x3881, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3000, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3000, 0x2000, 0x2000, 0x3000, 0x4000, 0x4000, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x3021, 0x18a4, 0x10e5, 
	0x10e6, 0x10e6, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10e5, 
	0x10e5, 0x10e5, 0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10e6, 0x10c5, 0x10c5, 0x10c5, 0x08c5, 0x08c5, 0x08c5, 0x08a5, 
	0x08a5, 0x08a5, 0x08a5, 0x08c5, 0x10c6, 0x10c5, 0x10c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x0085, 0x0085, 0x0085, 
	0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x0000, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x2082, 0x28e4, 0x1862, 0x2904, 
	0x3166, 0x2946, 0x2967, 0x2967, 0x2967, 0x2967, 0x2967, 0x2967, 0x2967, 0x2967, 0x2967, 0x2946, 0x2146, 0x2146, 0x2146, 0x2126, 
	0x2126, 0x2126, 0x2926, 0x28a4, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1000, 0x18c4, 0x2946, 
	0x2946, 0x1862, 0x0800, 0x0800, 0x0800, 0x0000, 0x0800, 0x0800, 0x1000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2800, 0x2800, 0x3000, 
	0x3000, 0x2800, 0x20a3, 0x2967, 0x2105, 0x0800, 0x0800, 0x1000, 0x1800, 0x2000, 0x2800, 0x3000, 0x3000, 0x2820, 0x20c4, 0x1906, 
	0x1906, 0x1906, 0x1906, 0x1906, 0x1083, 0x1040, 0x2060, 0x2060, 0x2860, 0x2840, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 0x3800, 0x3800, 
	0x3800, 0x3000, 0x2800, 0x2000, 0x2000, 0x3000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x3021, 0x18a4, 0x10c5, 
	0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10e5, 
	0x10e5, 0x10e5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c6, 0x10c6, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08a5, 
	0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08c5, 0x08a5, 0x08a5, 0x00a5, 0x00a5, 0x00a5, 
	0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1020, 0x0800, 0x0800, 0x1820, 0x1820, 0x1020, 
	0x1021, 0x1041, 0x20c4, 0x3187, 0x3987, 0x3187, 0x3187, 0x2987, 0x2967, 0x2967, 0x2967, 0x2967, 0x2146, 0x2147, 0x2147, 0x2146, 
	0x2146, 0x2127, 0x2926, 0x28c4, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x1800, 0x1000, 0x18c4, 0x2946, 
	0x2904, 0x1020, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 
	0x3000, 0x2820, 0x2905, 0x2967, 0x1083, 0x0800, 0x1000, 0x1000, 0x1800, 0x2000, 0x2800, 0x3000, 0x3800, 0x3000, 0x2083, 0x1906, 
	0x1106, 0x1906, 0x1906, 0x1926, 0x18a3, 0x1000, 0x1800, 0x1000, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1800, 0x1000, 0x0800, 0x1000, 0x2000, 0x2800, 0x3000, 0x3000, 0x2800, 0x3000, 0x3000, 0x2800, 
	0x2000, 0x1000, 0x1000, 0x1000, 0x1000, 0x2000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2000, 0x1800, 0x1800, 0x1800, 0x2800, 0x3000, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x2800, 0x1800, 0x1000, 0x1000, 0x2000, 0x3000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x3800, 
	0x3800, 0x3000, 0x2800, 0x2000, 0x2000, 0x3000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x3021, 0x18a4, 0x10e6, 
	0x10e6, 0x10e5, 0x10e5, 0x10e5, 0x10e5, 0x10e5, 0x10e5, 0x10e5, 0x10e5, 0x10e5, 0x10e5, 0x10e6, 0x10e6, 0x10e5, 0x10e5, 0x10e6, 
	0x10e6, 0x10c6, 0x10c6, 0x10c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08a5, 0x08c5, 0x08c5, 0x08c5, 
	0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x0885, 0x0885, 0x00a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x00a5, 0x08a5, 
	0x0000, 0x0000, 0x0000, 0x1000, 0x1800, 0x1800, 0x1800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 
	0x1800, 0x1000, 0x0800, 0x28c3, 0x3125, 0x20a3, 0x2925, 0x3187, 0x3187, 0x3187, 0x2987, 0x2967, 0x2966, 0x2947, 0x2147, 0x2147, 
	0x2147, 0x2126, 0x2126, 0x2905, 0x1821, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1001, 0x20e5, 0x2946, 
	0x1882, 0x1000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 0x1800, 0x2000, 0x2820, 0x3040, 0x3861, 0x3861, 0x3840, 
	0x3020, 0x2882, 0x3167, 0x2967, 0x1061, 0x0800, 0x1000, 0x1000, 0x1800, 0x2000, 0x2800, 0x3000, 0x3800, 0x3000, 0x2062, 0x1906, 
	0x1106, 0x1106, 0x1906, 0x1906, 0x18c4, 0x1000, 0x1800, 0x1800, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1000, 0x0800, 0x0000, 0x0000, 0x1000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 
	0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3800, 0x3000, 0x3800, 0x2020, 0x0800, 0x0000, 0x0000, 0x0000, 0x1000, 0x2800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x3000, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3801, 0x1800, 0x0800, 0x0000, 0x0000, 0x0800, 0x3000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x3800, 
	0x3000, 0x3000, 0x2800, 0x2000, 0x2000, 0x3000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x3021, 0x2084, 0x10e6, 
	0x10e6, 0x10e6, 0x10e6, 0x10e5, 0x10e6, 0x10e6, 0x10e6, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08c6, 0x08c5, 0x08c6, 0x08c6, 
	0x08c6, 0x08c5, 0x08e6, 0x08c6, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08a5, 0x08c5, 0x08c6, 0x08c6, 
	0x08c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 0x0885, 0x0884, 0x0084, 0x0084, 0x0085, 0x08a5, 0x08a5, 0x08a5, 0x00a5, 0x00a5, 0x08a5, 
	0x0800, 0x0000, 0x0000, 0x1000, 0x1800, 0x1800, 0x1800, 0x0800, 0x0000, 0x0000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 
	0x1000, 0x1000, 0x0800, 0x1000, 0x2041, 0x1821, 0x2041, 0x2082, 0x1882, 0x2905, 0x3187, 0x3187, 0x3187, 0x2967, 0x2967, 0x2147, 
	0x2147, 0x2147, 0x2126, 0x2926, 0x2083, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1883, 0x2126, 0x2925, 
	0x1841, 0x1000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 0x1800, 0x4103, 0x5164, 0x5163, 0x5984, 0x61a4, 0x69a4, 
	0x5984, 0x4145, 0x2946, 0x2946, 0x1062, 0x0800, 0x1000, 0x1000, 0x1800, 0x2000, 0x2800, 0x3000, 0x3800, 0x3000, 0x2062, 0x1906, 
	0x1106, 0x1906, 0x1927, 0x1927, 0x18e5, 0x20c4, 0x1841, 0x1000, 0x1000, 0x1800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1000, 0x0800, 0x0000, 0x0000, 0x0800, 0x2000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2820, 
	0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x1800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x2020, 0x0800, 0x0000, 0x0000, 0x0000, 0x0800, 0x2000, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x3000, 0x3800, 0x3800, 0x3800, 
	0x4000, 0x3800, 0x3800, 0x1800, 0x0800, 0x0000, 0x0000, 0x1000, 0x2800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x3800, 
	0x3800, 0x3000, 0x2800, 0x2000, 0x2000, 0x3000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x3000, 0x2083, 0x10c5, 
	0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 
	0x08c5, 0x08c5, 0x08c5, 0x08c6, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08c5, 0x08c5, 0x08c5, 0x08c6, 
	0x08c6, 0x10c5, 0x10c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x00a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x0085, 0x0085, 
	0x0800, 0x0000, 0x0000, 0x1000, 0x1800, 0x1800, 0x1800, 0x0800, 0x0000, 0x0000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1000, 0x0800, 
	0x0800, 0x1000, 0x1000, 0x0800, 0x1000, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x2904, 0x3145, 0x28e4, 0x3146, 0x3187, 0x2967, 
	0x2946, 0x2126, 0x2126, 0x2126, 0x28e4, 0x1820, 0x1800, 0x2020, 0x2020, 0x2020, 0x2020, 0x1800, 0x1000, 0x2105, 0x2126, 0x2105, 
	0x1021, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 0x1800, 0x3061, 0x3040, 0x2840, 0x3040, 0x3840, 0x4081, 
	0x40c2, 0x3104, 0x2946, 0x2947, 0x1083, 0x0800, 0x1000, 0x1000, 0x1800, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x2083, 0x1927, 
	0x1106, 0x1926, 0x1927, 0x1927, 0x1926, 0x20e4, 0x1020, 0x1000, 0x1000, 0x1800, 0x2000, 0x2000, 0x2800, 0x2800, 0x2000, 0x2800, 
	0x2800, 0x2800, 0x2000, 0x1800, 0x1000, 0x0800, 0x0000, 0x0000, 0x0800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x2000, 
	0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x1800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x2000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3800, 
	0x3800, 0x3800, 0x3000, 0x1800, 0x0800, 0x0000, 0x0000, 0x0800, 0x2000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3000, 0x3000, 0x2800, 0x2000, 0x2000, 0x3000, 0x3800, 0x4000, 0x4000, 0x4000, 0x4020, 0x4020, 0x4020, 0x3820, 0x28a3, 0x10c5, 
	0x10e6, 0x10e6, 0x10e6, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 
	0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 
	0x08c5, 0x10c5, 0x10c5, 0x10c5, 0x10c6, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 0x0085, 0x00a5, 
	0x0800, 0x0000, 0x0000, 0x1000, 0x1800, 0x1800, 0x1800, 0x0800, 0x0000, 0x0000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1000, 0x0000, 
	0x0000, 0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1000, 0x1041, 0x2062, 0x1821, 0x2082, 0x20a3, 0x20a3, 
	0x2925, 0x2946, 0x2146, 0x2126, 0x2105, 0x30e3, 0x38e2, 0x4102, 0x4102, 0x4102, 0x4102, 0x30c2, 0x28c3, 0x2125, 0x2106, 0x2105, 
	0x1041, 0x0800, 0x0800, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2800, 0x3000, 0x3000, 
	0x2000, 0x2082, 0x2946, 0x2947, 0x20e5, 0x0800, 0x0800, 0x1000, 0x1800, 0x2000, 0x2800, 0x2800, 0x3000, 0x2800, 0x20c5, 0x1927, 
	0x1126, 0x1926, 0x1927, 0x1927, 0x2147, 0x1082, 0x1000, 0x1820, 0x1000, 0x1800, 0x3881, 0x38a1, 0x38a1, 0x38a1, 0x38a1, 0x38a1, 
	0x38a1, 0x38a1, 0x38a1, 0x30a2, 0x2020, 0x2861, 0x30e2, 0x30c2, 0x30a1, 0x3861, 0x3861, 0x3861, 0x3881, 0x3881, 0x3861, 0x3061, 
	0x2061, 0x1861, 0x1841, 0x1861, 0x2061, 0x2861, 0x3861, 0x3881, 0x3861, 0x3861, 0x3861, 0x3861, 0x3861, 0x3881, 0x3881, 0x40a1, 
	0x40a1, 0x40a1, 0x3881, 0x3881, 0x3881, 0x4081, 0x40a1, 0x40a1, 0x4081, 0x3881, 0x2881, 0x2081, 0x2081, 0x2081, 0x2881, 0x3881, 
	0x40a1, 0x48a1, 0x48a1, 0x48a1, 0x48a1, 0x48a1, 0x48c1, 0x48c1, 0x50e2, 0x5102, 0x5102, 0x48e2, 0x48e2, 0x48c1, 0x50e2, 0x50c2, 
	0x50e2, 0x50e2, 0x5102, 0x4102, 0x38e2, 0x38e2, 0x38e2, 0x40e2, 0x48e2, 0x5102, 0x5902, 0x5922, 0x5902, 0x5902, 0x5902, 0x5902, 
	0x5902, 0x5102, 0x5143, 0x38a2, 0x2820, 0x5122, 0x6163, 0x6143, 0x6143, 0x6143, 0x6142, 0x6142, 0x6142, 0x6143, 0x4165, 0x18e6, 
	0x10c6, 0x10e6, 0x10c6, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 
	0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x00a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08c5, 0x08c5, 0x08c5, 
	0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x10c6, 0x10c6, 0x08c6, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x00a5, 
	0x0800, 0x0000, 0x0800, 0x0800, 0x1000, 0x1800, 0x1000, 0x0800, 0x0000, 0x0000, 0x1000, 0x1800, 0x1000, 0x1000, 0x0800, 0x0000, 
	0x0000, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x0800, 0x1000, 0x1800, 0x1800, 0x1000, 0x0800, 
	0x1861, 0x3965, 0x28e4, 0x2104, 0x2925, 0x30c3, 0x2840, 0x2020, 0x2820, 0x2820, 0x2840, 0x2840, 0x2062, 0x2105, 0x1906, 0x2125, 
	0x1882, 0x0800, 0x0800, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x1820, 0x2020, 0x3060, 0x3881, 0x38a1, 0x40c2, 0x40a1, 0x48e2, 
	0x4902, 0x3903, 0x2946, 0x2147, 0x2126, 0x1062, 0x0800, 0x1000, 0x1800, 0x2820, 0x2820, 0x3000, 0x2800, 0x2863, 0x2127, 0x1927, 
	0x1126, 0x1926, 0x1927, 0x1927, 0x2146, 0x1041, 0x1000, 0x1820, 0x1000, 0x2020, 0x40c2, 0x40c2, 0x40c2, 0x40c2, 0x40c2, 0x40c2, 
	0x40c2, 0x40c2, 0x40c2, 0x40c3, 0x2841, 0x38a1, 0x4923, 0x4923, 0x5103, 0x4902, 0x4902, 0x4902, 0x4902, 0x5103, 0x5103, 0x4903, 
	0x4923, 0x4923, 0x4923, 0x4923, 0x4923, 0x4923, 0x5123, 0x5123, 0x5103, 0x5103, 0x5103, 0x5103, 0x5103, 0x5103, 0x5123, 0x5123, 
	0x5123, 0x5123, 0x5122, 0x5122, 0x5122, 0x5123, 0x5123, 0x5122, 0x5123, 0x5123, 0x5123, 0x4923, 0x4923, 0x5123, 0x5123, 0x5123, 
	0x5123, 0x5123, 0x5102, 0x5102, 0x5102, 0x5922, 0x5902, 0x5922, 0x5922, 0x5922, 0x5102, 0x5122, 0x5902, 0x5902, 0x5902, 0x5902, 
	0x5902, 0x5903, 0x5102, 0x5103, 0x5102, 0x5102, 0x50e2, 0x50e2, 0x50e2, 0x50e2, 0x50e2, 0x50c2, 0x50c1, 0x50c1, 0x50c1, 0x50a1, 
	0x50a1, 0x48a1, 0x48c1, 0x3061, 0x2800, 0x3860, 0x4861, 0x4860, 0x4860, 0x4860, 0x4060, 0x4840, 0x4840, 0x4060, 0x28a3, 0x18e5, 
	0x10e6, 0x10c6, 0x10c6, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 
	0x08a5, 0x08a5, 0x08a5, 0x0085, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x08a5, 0x08a5, 0x08a5, 0x08c5, 0x08a5, 0x08a5, 
	0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08c6, 0x08c6, 0x08a5, 0x08a5, 0x08a5, 0x00a5, 0x08a5, 0x08a5, 0x08a5, 0x0885, 0x0885, 0x08a5, 
	0x0800, 0x1020, 0x1841, 0x2061, 0x1820, 0x1800, 0x1000, 0x0800, 0x0000, 0x0000, 0x0800, 0x1000, 0x1000, 0x1000, 0x0800, 0x0000, 
	0x0000, 0x1000, 0x1800, 0x1800, 0x1000, 0x1000, 0x0000, 0x0800, 0x1000, 0x1000, 0x0800, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1000, 0x2061, 0x2861, 0x2061, 0x20a2, 0x2040, 0x1800, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x1821, 0x2105, 0x2126, 0x2125, 
	0x20e4, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1020, 0x30c2, 0x30a1, 0x30a1, 0x30a1, 0x3081, 0x3081, 0x2840, 0x3061, 
	0x48c2, 0x4923, 0x3124, 0x2925, 0x2946, 0x28e4, 0x1840, 0x2040, 0x3081, 0x40c1, 0x5922, 0x6163, 0x5143, 0x3126, 0x1927, 0x1927, 
	0x1926, 0x1926, 0x1927, 0x1927, 0x2125, 0x1020, 0x1820, 0x1820, 0x1000, 0x1800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2000, 0x1800, 0x2000, 0x2800, 0x3000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3000, 0x3000, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3000, 0x2800, 0x2000, 0x3000, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x3800, 0x2883, 0x18e6, 
	0x10e6, 0x10c6, 0x10c6, 0x10c6, 0x10c6, 0x10c6, 0x10c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 
	0x08a5, 0x08a5, 0x00a5, 0x0085, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08c5, 0x08c5, 
	0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x00a5, 0x00a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 
	0x1041, 0x1041, 0x1841, 0x2061, 0x1820, 0x1800, 0x1000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x0800, 0x0800, 0x0800, 0x0000, 
	0x0000, 0x0800, 0x1000, 0x1800, 0x1800, 0x0800, 0x0000, 0x0000, 0x1000, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 
	0x1000, 0x1000, 0x2020, 0x1800, 0x1800, 0x1000, 0x1800, 0x30a2, 0x3903, 0x2881, 0x3060, 0x2860, 0x2041, 0x20a3, 0x20e5, 0x2905, 
	0x3125, 0x2082, 0x1861, 0x2061, 0x2061, 0x2061, 0x2041, 0x1840, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 
	0x2800, 0x2800, 0x2861, 0x3104, 0x3965, 0x28e3, 0x1020, 0x1820, 0x2020, 0x2820, 0x3860, 0x48a1, 0x5103, 0x3146, 0x1927, 0x1927, 
	0x1927, 0x1927, 0x2147, 0x2126, 0x1882, 0x1000, 0x1820, 0x1000, 0x1000, 0x1800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2000, 0x1800, 0x2000, 0x2800, 0x3000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 
	0x4000, 0x3800, 0x3800, 0x2800, 0x2000, 0x3000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x2083, 0x10e6, 
	0x10e6, 0x10c6, 0x10c6, 0x10c6, 0x10c6, 0x10c6, 0x10c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 
	0x08a5, 0x08a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x08a5, 0x08c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 
	0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 
	0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 0x1800, 0x1000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x0800, 0x0800, 0x0800, 0x0000, 
	0x0000, 0x0800, 0x1000, 0x1000, 0x1000, 0x0800, 0x0000, 0x0800, 0x1800, 0x2000, 0x2000, 0x1800, 0x0800, 0x0000, 0x0800, 0x1000, 
	0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1020, 0x28a1, 0x2861, 0x2840, 0x2020, 0x2040, 0x2061, 0x2082, 0x2082, 
	0x2062, 0x1841, 0x1820, 0x1820, 0x1820, 0x1820, 0x1800, 0x1800, 0x1800, 0x2020, 0x3080, 0x38a1, 0x38c1, 0x40c1, 0x4901, 0x5122, 
	0x48c1, 0x3840, 0x2800, 0x30a2, 0x4944, 0x4103, 0x2061, 0x1820, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2083, 0x1947, 0x1927, 
	0x1906, 0x1927, 0x2967, 0x1083, 0x0800, 0x1820, 0x1000, 0x0800, 0x1000, 0x1800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1800, 0x2000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 
	0x4000, 0x3800, 0x3800, 0x2800, 0x2000, 0x3000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x2063, 0x10c6, 
	0x10c6, 0x10c6, 0x10c6, 0x10e6, 0x10e6, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x00a5, 
	0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 
	0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 
	0x0800, 0x0000, 0x0000, 0x0800, 0x1000, 0x1800, 0x1000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x0800, 0x0800, 0x0000, 0x0000, 
	0x0000, 0x0800, 0x1000, 0x1000, 0x1000, 0x0800, 0x0000, 0x0800, 0x1000, 0x2000, 0x2000, 0x1800, 0x0800, 0x0000, 0x0800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1800, 0x1000, 0x0800, 0x1820, 0x2020, 0x1800, 0x1800, 0x1800, 0x2041, 0x38e3, 0x2040, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x1800, 0x2020, 0x4923, 0x5163, 0x5123, 0x4902, 0x48e2, 0x50e1, 0x6162, 
	0x69a3, 0x69a3, 0x40a2, 0x2800, 0x2800, 0x3861, 0x40c2, 0x40e3, 0x40e2, 0x38a1, 0x3840, 0x3860, 0x40a1, 0x30e3, 0x2946, 0x1927, 
	0x1926, 0x2127, 0x2146, 0x2105, 0x1862, 0x1000, 0x1000, 0x1000, 0x1000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x2800, 0x2000, 0x2800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x2063, 0x10c6, 
	0x08c6, 0x10c6, 0x10c6, 0x10e6, 0x10e6, 0x10c6, 0x10e6, 0x10c5, 0x10c5, 0x10c5, 0x08c5, 0x08c5, 0x08c5, 0x08c6, 0x08a5, 0x00a5, 
	0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 
	0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08a5, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x00a5, 
	0x0800, 0x0000, 0x0000, 0x0800, 0x1000, 0x1000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x0800, 0x0800, 0x0800, 0x0000, 
	0x0000, 0x0800, 0x1000, 0x1000, 0x1000, 0x0800, 0x0000, 0x0800, 0x1000, 0x1800, 0x1800, 0x1800, 0x0800, 0x0000, 0x0800, 0x1800, 
	0x2000, 0x2000, 0x1000, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2041, 0x3061, 
	0x2861, 0x2861, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x1800, 0x2000, 0x3060, 0x3060, 0x3060, 0x3860, 0x3860, 0x40a0, 0x48a0, 
	0x50a0, 0x58e1, 0x4881, 0x3000, 0x3000, 0x3000, 0x3000, 0x3020, 0x3861, 0x40c2, 0x48c2, 0x3881, 0x3881, 0x38c2, 0x3145, 0x2147, 
	0x2147, 0x2127, 0x2147, 0x2967, 0x2946, 0x20c3, 0x1021, 0x1000, 0x1800, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 
	0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x2800, 0x2000, 0x3000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x2063, 0x10c5, 
	0x08c6, 0x10e6, 0x10c6, 0x10e6, 0x10c6, 0x10e6, 0x10e6, 0x10c5, 0x10c5, 0x10c6, 0x08c6, 0x08c5, 0x08c5, 0x08c6, 0x08a5, 0x08a5, 
	0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x0085, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x08a5, 0x08a5, 0x08a5, 0x08c5, 0x08c5, 
	0x08c5, 0x08c5, 0x10c6, 0x10c5, 0x10c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x00a5, 0x00a5, 
	0x0800, 0x0000, 0x0000, 0x0800, 0x1000, 0x1000, 0x0800, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x0800, 0x0800, 0x0800, 0x0000, 
	0x0000, 0x0800, 0x1000, 0x1000, 0x1000, 0x0800, 0x0000, 0x0000, 0x1000, 0x1800, 0x1800, 0x1800, 0x0800, 0x0000, 0x0800, 0x1800, 
	0x2000, 0x2000, 0x1000, 0x0800, 0x0000, 0x1000, 0x1800, 0x2000, 0x1800, 0x1800, 0x1000, 0x1800, 0x2000, 0x1800, 0x1800, 0x2020, 
	0x2000, 0x2000, 0x1800, 0x1800, 0x30c2, 0x30a2, 0x2840, 0x2020, 0x1820, 0x40e2, 0x4943, 0x5142, 0x5143, 0x5163, 0x5982, 0x61a3, 
	0x6982, 0x6162, 0x4060, 0x3000, 0x3000, 0x3800, 0x3800, 0x3000, 0x3000, 0x2800, 0x3000, 0x2800, 0x2000, 0x2000, 0x2882, 0x2946, 
	0x2147, 0x2147, 0x2147, 0x2147, 0x2947, 0x3988, 0x20c3, 0x0800, 0x1800, 0x2020, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 
	0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x2800, 0x2000, 0x3000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4800, 0x4000, 0x2063, 0x10c6, 
	0x08e6, 0x10c6, 0x10c6, 0x10e5, 0x10c5, 0x10e6, 0x10e6, 0x10c5, 0x10c5, 0x10c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 
	0x00a5, 0x00a5, 0x0085, 0x00a5, 0x0085, 0x0085, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x08a5, 0x08a5, 0x08a5, 0x08c5, 0x08c5, 
	0x08c5, 0x08c5, 0x10c5, 0x10c6, 0x08c6, 0x08c6, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x0085, 0x0085, 0x00a5, 
	0x0800, 0x0000, 0x0000, 0x0800, 0x1000, 0x1000, 0x0800, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x1000, 0x0800, 0x0800, 0x0000, 
	0x0000, 0x0800, 0x1000, 0x1000, 0x1000, 0x0800, 0x0000, 0x0000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x0000, 0x0800, 0x1800, 
	0x2000, 0x2000, 0x1000, 0x0000, 0x0000, 0x1000, 0x2000, 0x2000, 0x2000, 0x1000, 0x0800, 0x1000, 0x2000, 0x1800, 0x1800, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x1000, 0x2040, 0x30a1, 0x3081, 0x2841, 0x2040, 0x30c1, 0x38e2, 0x3881, 0x3060, 0x3060, 0x3060, 0x4080, 
	0x5101, 0x69a3, 0x50c2, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x48c1, 0x48c1, 0x3040, 0x2082, 0x2947, 
	0x2147, 0x2147, 0x2147, 0x2147, 0x2147, 0x3167, 0x20c4, 0x0800, 0x1800, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1800, 0x1800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x2800, 0x2000, 0x2800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4800, 0x4800, 0x4000, 0x2863, 0x10c6, 
	0x10e6, 0x10c6, 0x10c6, 0x10e5, 0x10e6, 0x10e6, 0x10e5, 0x10e5, 0x10e6, 0x10c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 
	0x08a5, 0x00a5, 0x00a5, 0x00a5, 0x0085, 0x0085, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x08a5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 
	0x10c6, 0x10c5, 0x10c5, 0x10c5, 0x08c6, 0x08c6, 0x08c6, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x00a5, 0x0085, 0x0085, 0x0085, 0x0085, 
	0x0800, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x1000, 0x1000, 0x0800, 0x0000, 
	0x0000, 0x0800, 0x1000, 0x1000, 0x1000, 0x0800, 0x0000, 0x0000, 0x0800, 0x1000, 0x1000, 0x1000, 0x0800, 0x0000, 0x0800, 0x1800, 
	0x2000, 0x2000, 0x1000, 0x0000, 0x0000, 0x1000, 0x2000, 0x2800, 0x2000, 0x1000, 0x0000, 0x1000, 0x2000, 0x2000, 0x2000, 0x1800, 
	0x1800, 0x1000, 0x1800, 0x1800, 0x1000, 0x2020, 0x2800, 0x2000, 0x2000, 0x1800, 0x2020, 0x2840, 0x2000, 0x2000, 0x2800, 0x3000, 
	0x3800, 0x3820, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x2800, 0x48e1, 0x6183, 0x6184, 0x3945, 0x2147, 
	0x2147, 0x2147, 0x2147, 0x2147, 0x2147, 0x2967, 0x20c4, 0x1000, 0x1800, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1000, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x3800, 0x4000, 
	0x4000, 0x4000, 0x3800, 0x2800, 0x2000, 0x2800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4800, 0x4800, 0x4800, 0x4000, 0x2883, 0x18e6, 
	0x10e6, 0x10e6, 0x10e6, 0x10c5, 0x10e6, 0x10e6, 0x10c5, 0x10e6, 0x10e6, 0x10c5, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 
	0x08c5, 0x08c5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 
	0x08c6, 0x08c5, 0x08c5, 0x08c5, 0x08c6, 0x08c6, 0x08c6, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x00a5, 0x0085, 0x0085, 0x0085, 0x00a5, 
	0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0800, 0x1000, 0x1000, 0x1800, 0x1000, 0x0800, 0x0000, 
	0x0000, 0x0800, 0x1000, 0x1800, 0x1000, 0x0800, 0x0000, 0x0000, 0x0800, 0x1000, 0x1000, 0x1000, 0x0800, 0x0000, 0x0800, 0x1800, 
	0x1800, 0x1800, 0x1000, 0x0000, 0x0000, 0x1000, 0x2000, 0x2800, 0x2020, 0x1000, 0x0000, 0x1000, 0x2000, 0x2800, 0x2800, 0x1800, 
	0x0800, 0x0800, 0x1800, 0x2000, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1820, 0x38c2, 0x38a2, 0x2841, 0x2800, 0x3000, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x2820, 0x40a0, 0x48a0, 0x48c1, 0x3945, 0x2167, 
	0x2167, 0x2167, 0x2167, 0x2167, 0x2167, 0x2967, 0x20c4, 0x1000, 0x2000, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1000, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 
	0x4000, 0x4000, 0x3800, 0x3000, 0x2000, 0x2800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4800, 0x4800, 0x4800, 0x4000, 0x2863, 0x18e6, 
	0x10e6, 0x10e6, 0x10e6, 0x10c5, 0x10e6, 0x10e6, 0x10c5, 0x10e5, 0x10c5, 0x10e5, 0x10e6, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 
	0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x00a5, 0x00a5, 0x00c5, 0x00c5, 0x00c5, 0x00a5, 0x00a5, 0x00a5, 0x00c5, 0x08c5, 0x08c5, 0x08c5, 
	0x08c6, 0x08c5, 0x08c5, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a6, 
	0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0800, 0x1000, 0x1800, 0x1800, 0x1000, 0x0800, 0x0000, 
	0x0000, 0x0800, 0x1000, 0x1800, 0x1800, 0x0800, 0x0000, 0x0000, 0x0800, 0x1000, 0x0800, 0x1000, 0x0800, 0x0000, 0x0800, 0x1000, 
	0x1800, 0x1800, 0x1000, 0x0000, 0x0000, 0x1000, 0x2000, 0x2000, 0x2020, 0x1000, 0x0000, 0x0800, 0x2000, 0x3000, 0x2800, 0x1820, 
	0x0800, 0x0000, 0x1800, 0x2800, 0x2800, 0x2000, 0x1000, 0x1000, 0x2000, 0x2000, 0x1800, 0x2020, 0x3081, 0x2041, 0x2000, 0x3000, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3820, 0x3020, 0x5942, 0x6982, 0x5962, 0x3945, 0x2167, 
	0x2167, 0x2967, 0x2967, 0x2967, 0x2167, 0x2987, 0x20e4, 0x1000, 0x2020, 0x2820, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1000, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 
	0x4000, 0x4000, 0x3800, 0x3000, 0x2000, 0x2800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4800, 0x4800, 0x4800, 0x4000, 0x2863, 0x10e6, 
	0x10e6, 0x10e6, 0x10e6, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10e6, 0x10e6, 0x10e6, 0x10c6, 0x08c5, 0x10c6, 
	0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08c5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00c5, 0x08c5, 0x08c5, 
	0x08c6, 0x08c5, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 
	0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 0x1800, 0x1800, 0x1000, 0x0800, 0x0000, 
	0x0000, 0x0800, 0x1000, 0x1800, 0x1800, 0x0800, 0x0000, 0x0000, 0x0800, 0x1000, 0x0800, 0x1000, 0x0800, 0x0000, 0x0000, 0x1000, 
	0x1000, 0x1000, 0x1000, 0x0000, 0x0000, 0x1000, 0x2000, 0x1800, 0x1800, 0x1000, 0x0000, 0x0800, 0x2000, 0x2800, 0x2800, 0x1800, 
	0x0800, 0x0800, 0x2000, 0x2800, 0x3000, 0x2000, 0x1000, 0x0800, 0x1000, 0x2000, 0x2000, 0x1800, 0x1800, 0x1000, 0x1800, 0x2800, 
	0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3820, 0x48a0, 0x5122, 0x3965, 0x2167, 
	0x2967, 0x2967, 0x2967, 0x2167, 0x2167, 0x2988, 0x20e4, 0x1000, 0x2020, 0x2020, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1000, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 
	0x4000, 0x4000, 0x3800, 0x3000, 0x2000, 0x2800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4800, 0x4000, 0x2863, 0x18c5, 
	0x10e6, 0x10e6, 0x10e6, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c6, 
	0x08c5, 0x08c6, 0x08c6, 0x08c6, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x08a5, 0x08c5, 0x08c5, 
	0x08c5, 0x08c5, 0x08c6, 0x08c6, 0x08c6, 0x08c5, 0x08c6, 0x10c5, 0x08c5, 0x08c5, 0x10c6, 0x10c6, 0x10e6, 0x10e6, 0x08e6, 0x08c6, 
	0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x0800, 0x0800, 0x1000, 0x1000, 0x1800, 0x1800, 0x1000, 0x0800, 0x0800, 0x0000, 
	0x0000, 0x0800, 0x1800, 0x1800, 0x1000, 0x0800, 0x0000, 0x0000, 0x0800, 0x1000, 0x1000, 0x1000, 0x0800, 0x0000, 0x0000, 0x1000, 
	0x1000, 0x1800, 0x1000, 0x0000, 0x0000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1000, 0x0000, 0x0800, 0x2000, 0x2800, 0x2800, 0x1800, 
	0x0800, 0x0800, 0x2000, 0x2800, 0x3000, 0x2800, 0x1000, 0x0000, 0x1000, 0x2800, 0x2800, 0x2000, 0x1800, 0x1000, 0x1800, 0x2000, 
	0x2800, 0x2800, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3800, 0x3020, 0x2904, 0x2187, 
	0x2947, 0x2967, 0x2167, 0x2167, 0x2167, 0x2968, 0x2905, 0x1820, 0x2020, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1000, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 
	0x4000, 0x4000, 0x3800, 0x3000, 0x2000, 0x2800, 0x4000, 0x4000, 0x4000, 0x4800, 0x4000, 0x4000, 0x4000, 0x4000, 0x2862, 0x18c5, 
	0x10e6, 0x10e6, 0x10e6, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x10c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c6, 
	0x08c5, 0x08c5, 0x08a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x08a5, 0x08a5, 0x08c5, 0x08c5, 
	0x08c5, 0x08c5, 0x08a5, 0x08a5, 0x08c5, 0x08c5, 0x08c6, 0x10c6, 0x10c6, 0x10c6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x08c6, 0x10e6, 
	0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x0800, 0x1000, 0x1020, 
	0x0800, 0x1000, 0x1800, 0x1800, 0x1000, 0x0800, 0x0000, 0x0000, 0x0800, 0x1000, 0x1000, 0x1000, 0x0800, 0x0000, 0x0000, 0x1000, 
	0x1800, 0x1800, 0x1000, 0x0000, 0x0000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1000, 0x0000, 0x0800, 0x2000, 0x2800, 0x2800, 0x1800, 
	0x0800, 0x0000, 0x1800, 0x2800, 0x2800, 0x2800, 0x1000, 0x0000, 0x1800, 0x2800, 0x3000, 0x2800, 0x2000, 0x2000, 0x2820, 0x40c0, 
	0x48c0, 0x3860, 0x3020, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3800, 0x3020, 0x3105, 0x3188, 
	0x2967, 0x2967, 0x2167, 0x2167, 0x2167, 0x2967, 0x2925, 0x1840, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1000, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 
	0x4000, 0x4000, 0x3800, 0x3000, 0x2000, 0x2800, 0x4000, 0x4000, 0x4000, 0x4800, 0x4000, 0x4000, 0x4000, 0x4000, 0x2862, 0x10c5, 
	0x10e6, 0x10c6, 0x10c6, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c6, 0x08c5, 0x08c5, 0x08c5, 0x08a5, 0x08c5, 0x08c5, 
	0x08a5, 0x08a5, 0x08a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00c5, 0x00c5, 0x08c5, 0x08a5, 0x08c5, 0x08c5, 0x08a5, 0x08c5, 0x08c5, 
	0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08c5, 0x10c5, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x08c6, 0x08c6, 0x10c6, 
	0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 
	0x1000, 0x1820, 0x1800, 0x1800, 0x1800, 0x0800, 0x0000, 0x0000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x0000, 0x0800, 0x1800, 
	0x2000, 0x1800, 0x1000, 0x0000, 0x0000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1000, 0x0000, 0x0800, 0x2000, 0x2800, 0x2800, 0x1800, 
	0x0000, 0x0000, 0x1800, 0x2800, 0x2800, 0x2800, 0x1000, 0x0000, 0x1800, 0x2800, 0x3000, 0x2800, 0x2000, 0x2820, 0x3040, 0x5921, 
	0x6181, 0x6162, 0x5922, 0x3840, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x3000, 0x3800, 0x3000, 0x30c3, 0x2905, 
	0x2926, 0x3167, 0x2967, 0x2967, 0x2967, 0x2987, 0x3145, 0x1840, 0x1800, 0x2020, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1000, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 
	0x4000, 0x4000, 0x3800, 0x3000, 0x2000, 0x2800, 0x4000, 0x4000, 0x4000, 0x4800, 0x4000, 0x4000, 0x4000, 0x4000, 0x2862, 0x10a5, 
	0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08a6, 0x08a5, 0x08a5, 0x08a6, 0x08a5, 0x00a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 
	0x08a5, 0x08a5, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08c5, 0x08c5, 0x08c5, 0x08c6, 0x08c6, 0x10c6, 0x10c6, 0x08c5, 0x08c5, 
	0x08c5, 0x08c5, 0x08c5, 0x08c6, 0x10c6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x08c5, 0x08c6, 0x08a5, 0x08a5, 0x08c6, 
	0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 
	0x1000, 0x1800, 0x2000, 0x2000, 0x1800, 0x1000, 0x1000, 0x1020, 0x1800, 0x1800, 0x1000, 0x1000, 0x0800, 0x0000, 0x0800, 0x1800, 
	0x2000, 0x1800, 0x1000, 0x0000, 0x0000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1000, 0x0000, 0x0800, 0x2000, 0x2800, 0x2800, 0x1800, 
	0x0800, 0x0800, 0x1800, 0x2000, 0x2000, 0x2000, 0x1000, 0x0000, 0x1800, 0x2800, 0x3000, 0x2800, 0x2020, 0x2040, 0x2840, 0x48c0, 
	0x58e0, 0x5900, 0x6142, 0x4060, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2000, 0x2800, 0x3000, 0x3000, 0x2020, 0x1000, 
	0x1021, 0x3145, 0x3966, 0x2925, 0x3166, 0x3187, 0x28e4, 0x0800, 0x1800, 0x2820, 0x2800, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1000, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 
	0x4000, 0x4000, 0x3800, 0x3000, 0x2000, 0x2800, 0x4000, 0x4000, 0x4000, 0x4800, 0x4000, 0x4000, 0x4000, 0x4000, 0x2842, 0x10a5, 
	0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08a6, 0x08a6, 0x08a6, 0x08a6, 0x08a5, 0x08a5, 0x00a5, 0x00a5, 0x00a5, 0x08a5, 0x08a5, 0x08c5, 
	0x08c5, 0x08c6, 0x08c6, 0x10c6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 
	0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10c6, 0x10c6, 0x10c6, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 
	0x1000, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x0800, 0x0000, 0x0800, 0x0800, 0x1000, 0x1000, 0x0800, 0x0800, 
	0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x1800, 0x2000, 0x2020, 0x2000, 0x1800, 0x1000, 0x0800, 0x0800, 0x0000, 0x0800, 0x1800, 
	0x2000, 0x1800, 0x1000, 0x0000, 0x0000, 0x1000, 0x1800, 0x1800, 0x1800, 0x0800, 0x0000, 0x0800, 0x2000, 0x2800, 0x2000, 0x1820, 
	0x1841, 0x2061, 0x2881, 0x3081, 0x2020, 0x2000, 0x1000, 0x0000, 0x1800, 0x2800, 0x3000, 0x2800, 0x2000, 0x1820, 0x2020, 0x48a0, 
	0x58e1, 0x6122, 0x58e1, 0x4020, 0x3800, 0x3800, 0x3800, 0x4020, 0x3800, 0x3000, 0x3020, 0x3020, 0x3000, 0x2800, 0x2000, 0x1800, 
	0x1800, 0x2861, 0x30a3, 0x2082, 0x2082, 0x20a2, 0x2082, 0x1020, 0x1800, 0x2800, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1000, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 
	0x4000, 0x4000, 0x3800, 0x3000, 0x2000, 0x2800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x2842, 0x08a5, 
	0x00c6, 0x00c6, 0x00a6, 0x00a6, 0x00a6, 0x00a6, 0x00a6, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x08c5, 0x08c6, 
	0x08c6, 0x08c6, 0x08c6, 0x10c6, 0x10c6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 
	0x08e6, 0x08e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10c6, 0x10c6, 0x08c6, 0x08c5, 0x08a5, 0x08a5, 0x08c5, 0x08c6, 
	0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x0800, 0x0000, 0x0000, 0x0800, 0x1000, 0x1000, 0x0800, 0x0800, 0x1000, 
	0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1000, 0x0800, 0x0800, 0x1020, 0x1800, 0x1800, 
	0x2000, 0x1800, 0x1000, 0x0000, 0x0000, 0x1000, 0x1800, 0x1800, 0x1800, 0x0800, 0x0000, 0x0800, 0x2000, 0x2800, 0x2800, 0x2020, 
	0x1841, 0x2041, 0x2840, 0x2841, 0x2000, 0x2000, 0x1000, 0x0000, 0x1000, 0x2800, 0x3000, 0x2800, 0x1800, 0x0800, 0x1000, 0x3000, 
	0x4020, 0x4860, 0x4860, 0x3800, 0x3800, 0x3800, 0x4020, 0x58c1, 0x3840, 0x3000, 0x4880, 0x6162, 0x5901, 0x48a1, 0x2840, 0x1000, 
	0x2000, 0x2000, 0x2000, 0x2020, 0x1000, 0x1000, 0x2861, 0x3082, 0x2841, 0x3041, 0x2820, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x1800, 0x1000, 0x1800, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 
	0x4000, 0x4000, 0x3800, 0x3000, 0x2000, 0x2800, 0x4000, 0x4800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x2842, 0x08a5, 
	0x00a6, 0x00a6, 0x00a6, 0x00a6, 0x00a6, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00c5, 0x00c5, 0x00a5, 0x00a5, 0x00a5, 0x00c5, 0x00c6, 
	0x08c6, 0x08e6, 0x08c6, 0x08c5, 0x10c5, 0x10c6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x08e6, 0x08c6, 0x08c6, 
	0x08c5, 0x08c5, 0x08c6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10c6, 0x10c6, 0x10e6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 
	0x0800, 0x1000, 0x1800, 0x1800, 0x1000, 0x1000, 0x0800, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1000, 0x0800, 0x1000, 0x1820, 0x1800, 0x1800, 
	0x2000, 0x1800, 0x1000, 0x0000, 0x0000, 0x1000, 0x1800, 0x1800, 0x1800, 0x0800, 0x0000, 0x0800, 0x2000, 0x2800, 0x2800, 0x1800, 
	0x0800, 0x0800, 0x1800, 0x2000, 0x2000, 0x2000, 0x1000, 0x0000, 0x1000, 0x2800, 0x3000, 0x2800, 0x1800, 0x0800, 0x1000, 0x3000, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4860, 0x6943, 0x4081, 0x3000, 0x4860, 0x6961, 0x6981, 0x71a2, 0x4102, 0x0800, 
	0x2000, 0x2800, 0x2000, 0x2000, 0x1000, 0x1800, 0x2000, 0x3061, 0x3061, 0x2820, 0x2820, 0x30a2, 0x3061, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2000, 0x2800, 0x1800, 0x1000, 0x1000, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x4000, 0x4000, 0x3800, 0x3000, 0x2000, 0x2800, 0x4000, 0x4800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x2842, 0x08a5, 
	0x00a6, 0x00a6, 0x00a6, 0x00a6, 0x00a5, 0x00a5, 0x00a6, 0x00c5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 
	0x08a5, 0x08c6, 0x08c5, 0x08c5, 0x10e5, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10c6, 0x10c6, 0x10c6, 0x08c6, 0x08c6, 0x08c5, 0x08c6, 
	0x08c5, 0x08c5, 0x08c6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10c6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x08e6, 0x08c6, 0x08c6, 
	0x1000, 0x1000, 0x1000, 0x1800, 0x1000, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x1000, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x1000, 0x0800, 0x1000, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1000, 0x0800, 0x0800, 0x1000, 0x1800, 0x1800, 0x1800, 0x0800, 0x0000, 0x0800, 0x1800, 0x2800, 0x2800, 0x1800, 
	0x0000, 0x0000, 0x1800, 0x2800, 0x2000, 0x2000, 0x1000, 0x0000, 0x1000, 0x2800, 0x3000, 0x2800, 0x1800, 0x0800, 0x1800, 0x3000, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4040, 0x6143, 0x4881, 0x3000, 0x4840, 0x6961, 0x6981, 0x6981, 0x38e1, 0x0800, 
	0x2000, 0x3000, 0x2800, 0x1800, 0x0800, 0x1800, 0x2000, 0x2000, 0x2800, 0x2000, 0x1800, 0x2840, 0x38c2, 0x3061, 0x3061, 0x3041, 
	0x2840, 0x2820, 0x2000, 0x1800, 0x1000, 0x1000, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x4000, 0x4000, 0x3000, 0x2000, 0x2000, 0x4000, 0x4800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x2842, 0x08a5, 
	0x00c6, 0x00a6, 0x00a6, 0x00a6, 0x00a5, 0x00a5, 0x00a5, 0x00c5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 
	0x08c5, 0x08c6, 0x08c6, 0x08e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 
	0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10c6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x08e6, 0x08c6, 0x08c6, 
	0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x1000, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x0800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 
	0x1800, 0x1000, 0x0800, 0x0800, 0x1000, 0x1820, 0x1800, 0x1800, 0x1800, 0x1000, 0x0000, 0x0800, 0x1800, 0x2800, 0x2800, 0x1800, 
	0x0000, 0x0000, 0x1000, 0x2000, 0x2800, 0x2000, 0x1000, 0x0000, 0x1000, 0x2800, 0x3000, 0x3000, 0x2000, 0x1800, 0x2020, 0x48a1, 
	0x4880, 0x3820, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3800, 0x5080, 0x5901, 0x6983, 0x30e2, 0x0000, 
	0x2800, 0x3000, 0x2800, 0x1000, 0x0000, 0x1800, 0x2800, 0x2000, 0x1800, 0x1800, 0x2000, 0x2000, 0x3041, 0x3861, 0x2800, 0x2000, 
	0x3082, 0x40c2, 0x2820, 0x2841, 0x1820, 0x1800, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x3800, 0x3800, 
	0x3800, 0x4000, 0x3800, 0x3000, 0x2000, 0x2800, 0x3800, 0x4800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x2842, 0x08a5, 
	0x00a6, 0x00a6, 0x00c6, 0x00c5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00c5, 0x08c6, 
	0x08c6, 0x08c6, 0x08e6, 0x08e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x08e6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x10e6, 
	0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10c6, 0x10c6, 0x10c6, 0x10c5, 0x08c5, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 
	0x1000, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1000, 0x0800, 0x0000, 0x0000, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 
	0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 
	0x1000, 0x1000, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1820, 0x1821, 0x1841, 0x2021, 0x2800, 0x2800, 0x1800, 
	0x0800, 0x0000, 0x1000, 0x2800, 0x2800, 0x2800, 0x1000, 0x0000, 0x1000, 0x2800, 0x3000, 0x3000, 0x2800, 0x2020, 0x3040, 0x6141, 
	0x6961, 0x5901, 0x48a1, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x4040, 0x2040, 0x0800, 
	0x2800, 0x3800, 0x3000, 0x1000, 0x0000, 0x1800, 0x2821, 0x2821, 0x1000, 0x0800, 0x2000, 0x2800, 0x2800, 0x2800, 0x2000, 0x2000, 
	0x2000, 0x38a2, 0x3861, 0x2840, 0x2020, 0x2861, 0x2841, 0x2000, 0x2800, 0x2800, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x3800, 
	0x3800, 0x4000, 0x3800, 0x3000, 0x2000, 0x2800, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x2842, 0x08a5, 
	0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00a5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00a5, 0x08c5, 0x08c6, 
	0x08c6, 0x08e6, 0x08e6, 0x08c6, 0x08c6, 0x08e6, 0x10e6, 0x10e6, 0x08e6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08e6, 0x10e6, 
	0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08a5, 0x08c6, 0x08c6, 0x08a5, 0x08a5, 0x08a5, 
	0x1800, 0x1800, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1000, 0x0800, 0x0000, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 
	0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x0800, 0x0800, 0x0800, 0x1000, 0x0800, 0x1000, 0x1000, 0x1000, 
	0x1000, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2020, 0x2821, 0x2800, 0x2800, 0x2000, 
	0x1000, 0x1000, 0x1800, 0x2800, 0x3000, 0x2800, 0x1000, 0x0000, 0x1800, 0x2800, 0x3000, 0x3000, 0x2800, 0x2000, 0x2820, 0x5121, 
	0x6982, 0x6982, 0x5102, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3800, 0x1820, 0x0800, 
	0x2800, 0x3800, 0x3000, 0x1000, 0x0000, 0x0800, 0x1800, 0x2820, 0x1000, 0x0800, 0x2000, 0x3000, 0x2800, 0x2000, 0x1800, 0x2000, 
	0x2000, 0x2820, 0x2820, 0x2000, 0x2000, 0x2861, 0x38c2, 0x3041, 0x3061, 0x2821, 0x2820, 0x2800, 0x2000, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x3000, 0x2800, 0x2800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 
	0x4000, 0x4000, 0x4000, 0x3000, 0x2000, 0x2000, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x3042, 0x10c5, 
	0x00c6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08e6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 
	0x08e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x08e6, 0x08e6, 0x08c6, 0x08c6, 0x08e6, 0x08e6, 0x10e6, 0x10e6, 
	0x10e6, 0x1106, 0x1106, 0x10e6, 0x10e6, 0x10e6, 0x10c6, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08a5, 0x08a5, 0x08a5, 
	0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x0000, 0x0000, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 
	0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x0800, 0x0800, 0x1000, 0x1000, 0x0800, 0x0800, 0x1000, 0x1000, 
	0x0800, 0x0000, 0x0800, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2000, 
	0x2020, 0x3061, 0x3041, 0x3000, 0x3000, 0x2800, 0x1000, 0x0800, 0x1800, 0x2800, 0x3000, 0x2800, 0x2000, 0x1800, 0x2000, 0x3880, 
	0x48a0, 0x50e1, 0x48a1, 0x2800, 0x2800, 0x3000, 0x3800, 0x3800, 0x3000, 0x3000, 0x3820, 0x4880, 0x4040, 0x4020, 0x1820, 0x0800, 
	0x2800, 0x3800, 0x3000, 0x1000, 0x0000, 0x0800, 0x1000, 0x2000, 0x1800, 0x0800, 0x2000, 0x3800, 0x3000, 0x1800, 0x1000, 0x2000, 
	0x2800, 0x2800, 0x2000, 0x2000, 0x2000, 0x2000, 0x3041, 0x3041, 0x2800, 0x2000, 0x3061, 0x38a2, 0x2800, 0x2841, 0x2820, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x2820, 0x1000, 0x1000, 
	0x2800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 
	0x4000, 0x4000, 0x4000, 0x3000, 0x2000, 0x2000, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x3042, 0x10c5, 
	0x08e6, 0x08e6, 0x08e7, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x1106, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x08c5, 
	0x10e6, 0x10e6, 0x1907, 0x1106, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x08c6, 0x08c6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 
	0x10e6, 0x10e6, 0x1106, 0x1926, 0x1927, 0x1906, 0x10e6, 0x10e6, 0x08c6, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x08c5, 0x10c6, 0x10e6, 
	0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 
	0x1000, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 0x0800, 0x0000, 0x0800, 0x0800, 
	0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 
	0x2800, 0x3020, 0x3020, 0x3000, 0x3000, 0x2800, 0x2020, 0x1820, 0x2000, 0x2800, 0x3000, 0x2800, 0x2000, 0x1800, 0x2840, 0x5101, 
	0x50e0, 0x50c0, 0x48a0, 0x2020, 0x1000, 0x2800, 0x3800, 0x3800, 0x3000, 0x2800, 0x4060, 0x6961, 0x6941, 0x6121, 0x28a1, 0x0000, 
	0x2800, 0x3800, 0x2800, 0x1000, 0x0000, 0x0800, 0x2000, 0x2800, 0x1800, 0x0800, 0x2000, 0x3800, 0x3800, 0x1800, 0x0800, 0x2000, 
	0x3000, 0x3000, 0x2000, 0x1000, 0x2000, 0x2800, 0x2800, 0x2820, 0x2000, 0x2000, 0x2820, 0x38a2, 0x3041, 0x3041, 0x3040, 0x3882, 
	0x2820, 0x2800, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x3800, 0x2020, 0x0000, 0x0000, 
	0x2000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 
	0x4000, 0x4000, 0x4000, 0x3000, 0x2800, 0x2000, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4800, 0x4000, 0x3042, 0x18c5, 
	0x10e6, 0x10e6, 0x10e7, 0x10e6, 0x18e7, 0x1106, 0x1106, 0x1106, 0x1106, 0x1907, 0x1106, 0x1107, 0x1106, 0x1106, 0x10e6, 0x10e6, 
	0x10e6, 0x1907, 0x1907, 0x1907, 0x1907, 0x1906, 0x1906, 0x1106, 0x10e6, 0x10c6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 
	0x10e6, 0x1906, 0x1927, 0x1927, 0x1927, 0x1927, 0x1907, 0x1106, 0x10e6, 0x10e6, 0x08e6, 0x08c6, 0x10e6, 0x10e6, 0x1106, 0x1926, 
	0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x0800, 0x0800, 0x1000, 
	0x1000, 0x1800, 0x1800, 0x1800, 0x1000, 0x0800, 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1820, 0x1820, 0x1820, 0x1820, 0x1800, 0x2000, 0x2000, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x2820, 0x3061, 0x3861, 0x3000, 0x3000, 0x2800, 0x2000, 0x2000, 0x3040, 0x5961, 
	0x6981, 0x6961, 0x6162, 0x2881, 0x0800, 0x2000, 0x3800, 0x3800, 0x3000, 0x2000, 0x3020, 0x58e0, 0x6960, 0x79e2, 0x4123, 0x0000, 
	0x2000, 0x3800, 0x2800, 0x1000, 0x0000, 0x1000, 0x2800, 0x2820, 0x1800, 0x0800, 0x2000, 0x3800, 0x3800, 0x2020, 0x0800, 0x2000, 
	0x3000, 0x3000, 0x1800, 0x1000, 0x2000, 0x3000, 0x3000, 0x2000, 0x1800, 0x2000, 0x2000, 0x2800, 0x3020, 0x2000, 0x2800, 0x3081, 
	0x40c2, 0x3041, 0x3061, 0x3040, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x2020, 0x0000, 0x0000, 
	0x2000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 
	0x4000, 0x4000, 0x4000, 0x3000, 0x2800, 0x2000, 0x3800, 0x4800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4800, 0x4000, 0x3042, 0x18e5, 
	0x1106, 0x18e6, 0x1906, 0x18e6, 0x10e6, 0x1106, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x1106, 0x10e6, 0x10e6, 0x10e6, 
	0x1106, 0x1106, 0x1906, 0x1906, 0x1906, 0x1906, 0x1927, 0x1927, 0x1106, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x1107, 0x1907, 0x1906, 
	0x1927, 0x1947, 0x2147, 0x2147, 0x2147, 0x2147, 0x1927, 0x1907, 0x1906, 0x1906, 0x1106, 0x10e6, 0x10e6, 0x1106, 0x1906, 0x1947, 
	0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x0000, 0x0000, 0x0800, 0x0800, 0x1000, 0x0800, 0x0800, 0x0800, 
	0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x0000, 0x0000, 0x0800, 0x0800, 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 
	0x0800, 0x1000, 0x1000, 0x1000, 0x0800, 0x1000, 0x1841, 0x20a2, 0x28c2, 0x20a2, 0x28a2, 0x1820, 0x1800, 0x2000, 0x2800, 0x2800, 
	0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3820, 0x3000, 0x3000, 0x3000, 0x2800, 0x2820, 0x3020, 0x5101, 
	0x6981, 0x6981, 0x61a2, 0x28c2, 0x0000, 0x2000, 0x3800, 0x3800, 0x3000, 0x2000, 0x2820, 0x4880, 0x58c0, 0x6941, 0x3902, 0x0000, 
	0x2000, 0x3800, 0x3000, 0x1000, 0x0000, 0x1800, 0x2800, 0x2800, 0x1800, 0x0800, 0x2000, 0x3800, 0x3800, 0x1820, 0x0800, 0x1800, 
	0x3000, 0x3000, 0x1800, 0x1000, 0x2800, 0x3800, 0x3000, 0x1800, 0x1000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2000, 0x2800, 0x2800, 
	0x3061, 0x3020, 0x2000, 0x2840, 0x40e3, 0x3041, 0x3041, 0x3021, 0x2820, 0x2800, 0x2800, 0x2800, 0x3000, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x2020, 0x0000, 0x0000, 
	0x2000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 
	0x4000, 0x4000, 0x4000, 0x3800, 0x2800, 0x2800, 0x3800, 0x4800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4800, 0x4000, 0x3042, 0x20e5, 
	0x1106, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x08e6, 0x08c6, 0x08c6, 0x08e6, 0x08e6, 0x08e6, 0x08e6, 
	0x08e6, 0x08e6, 0x10e6, 0x1106, 0x1106, 0x1906, 0x1927, 0x1927, 0x1907, 0x1106, 0x1106, 0x1107, 0x1107, 0x1907, 0x1927, 0x1927, 
	0x2147, 0x2147, 0x2167, 0x2167, 0x2167, 0x2147, 0x2147, 0x2127, 0x1927, 0x1927, 0x1927, 0x1906, 0x1906, 0x1927, 0x1927, 0x2147, 
	0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0000, 0x0000, 0x0800, 0x0800, 0x1000, 0x1000, 0x0800, 0x0800, 
	0x1000, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x0800, 0x0800, 0x0000, 
	0x0800, 0x1000, 0x1000, 0x0800, 0x1041, 0x20a2, 0x2082, 0x1881, 0x1841, 0x1000, 0x2061, 0x2041, 0x1800, 0x2000, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3020, 0x3020, 0x3820, 
	0x4060, 0x50c0, 0x5942, 0x28a2, 0x0000, 0x2000, 0x3800, 0x3800, 0x3000, 0x2000, 0x3880, 0x6161, 0x6120, 0x5901, 0x28a1, 0x0000, 
	0x2000, 0x3800, 0x3000, 0x1000, 0x0000, 0x1800, 0x2800, 0x2800, 0x1800, 0x0000, 0x2000, 0x3800, 0x3020, 0x1820, 0x0000, 0x1800, 
	0x3000, 0x3000, 0x2000, 0x1000, 0x2800, 0x3800, 0x3800, 0x1820, 0x1000, 0x2800, 0x3800, 0x3000, 0x2000, 0x1800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2000, 0x2800, 0x3861, 0x3862, 0x3041, 0x3041, 0x3882, 0x3081, 0x2820, 0x3020, 0x2800, 0x2800, 0x2800, 0x3000, 
	0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x2020, 0x0000, 0x0000, 
	0x2000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 
	0x4000, 0x4000, 0x4000, 0x3800, 0x2800, 0x2800, 0x3800, 0x4800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4800, 0x4000, 0x3021, 0x18c5, 
	0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x10e6, 0x08e6, 0x08e6, 0x08e6, 0x08e6, 0x08e6, 0x08c6, 0x08c6, 0x08c6, 0x08c6, 0x08e6, 0x08c6, 
	0x08c6, 0x08e6, 0x08e6, 0x08e6, 0x08e6, 0x10e6, 0x1106, 0x1106, 0x1106, 0x1106, 0x1106, 0x1107, 0x1907, 0x1927, 0x1927, 0x2147, 
	0x2147, 0x2967, 0x2967, 0x2967, 0x2967, 0x2167, 0x2147, 0x2147, 0x2147, 0x2147, 0x2127, 0x2127, 0x2127, 0x2127, 0x2147, 0x2147, 
	0x0800, 0x0800, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1000, 0x0000, 0x0800, 0x0000, 0x0800, 0x1000, 0x1000, 0x0800, 0x0800, 
	0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1000, 0x0800, 0x0000, 0x0000, 
	0x0800, 0x0800, 0x0800, 0x1861, 0x20c3, 0x1061, 0x0800, 0x0800, 0x1000, 0x1000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2800, 
	0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x3000, 
	0x3800, 0x3000, 0x3020, 0x1820, 0x0000, 0x2000, 0x3000, 0x3800, 0x3000, 0x2000, 0x4080, 0x69a1, 0x71c1, 0x71c2, 0x3903, 0x0000, 
	0x2000, 0x3800, 0x3020, 0x1000, 0x0000, 0x1800, 0x2800, 0x3000, 0x1800, 0x0000, 0x2000, 0x3800, 0x3820, 0x1820, 0x0000, 0x1000, 
	0x3000, 0x3000, 0x2000, 0x1000, 0x2800, 0x3800, 0x3800, 0x1800, 0x1000, 0x2800, 0x3800, 0x3020, 0x1800, 0x1800, 0x3000, 0x3800, 
	0x3000, 0x2000, 0x2000, 0x2800, 0x2800, 0x3020, 0x2800, 0x2000, 0x3040, 0x40e3, 0x3861, 0x3041, 0x3041, 0x3061, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3800, 0x2820, 0x1000, 0x1000, 
	0x2000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 
	0x4000, 0x4000, 0x4000, 0x3800, 0x2800, 0x2000, 0x3800, 0x4800, 0x4000, 0x4000, 0x4000, 0x4800, 0x4800, 0x4000, 0x3021, 0x10c5, 
	0x08e6, 0x08e6, 0x08c6, 0x08c6, 0x08c6, 0x08e6, 0x08e6, 0x08e6, 0x08e6, 0x08e6, 0x08c6, 0x00e6, 0x00e6, 0x00e6, 0x00e6, 0x00c6, 
	0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x08c6, 0x08c6, 0x08e6, 0x08e6, 0x08e6, 0x10e6, 0x10e6, 0x1106, 0x1106, 0x1927, 0x1947, 0x2147, 
	0x2167, 0x2967, 0x2967, 0x2967, 0x2968, 0x2968, 0x2967, 0x2167, 0x2147, 0x2147, 0x2147, 0x2147, 0x2147, 0x2147, 0x2167, 0x2967, 
	0x0000, 0x0800, 0x1000, 0x1000, 0x1800, 0x1800, 0x1000, 0x0800, 0x0000, 0x0800, 0x0000, 0x0800, 0x1000, 0x0800, 0x0800, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1000, 0x0800, 0x0000, 0x0000, 
	0x0800, 0x0800, 0x1020, 0x1861, 0x0820, 0x0000, 0x0800, 0x1000, 0x1800, 0x1800, 0x1000, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2800, 0x3000, 0x3000, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x3000, 
	0x3800, 0x3800, 0x3000, 0x1000, 0x0000, 0x2000, 0x3000, 0x3800, 0x2820, 0x1800, 0x2820, 0x5101, 0x6161, 0x6982, 0x4123, 0x0000, 
	0x2000, 0x3800, 0x3020, 0x1000, 0x0000, 0x1800, 0x3000, 0x3000, 0x1820, 0x0800, 0x2000, 0x3800, 0x3820, 0x1820, 0x0800, 0x1800, 
	0x3020, 0x3000, 0x1800, 0x1000, 0x2800, 0x3800, 0x3800, 0x1800, 0x0800, 0x2800, 0x3000, 0x3000, 0x1800, 0x1800, 0x3000, 0x3800, 
	0x3000, 0x1800, 0x2000, 0x3000, 0x3000, 0x3000, 0x2000, 0x2800, 0x2800, 0x3020, 0x3021, 0x2800, 0x2000, 0x38a2, 0x3061, 0x3041, 
	0x3041, 0x3020, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 
	0x3000, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 
	0x4000, 0x4000, 0x4000, 0x3800, 0x2800, 0x2000, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x3021, 0x10a5, 
	0x00e6, 0x00e6, 0x00e6, 0x00c6, 0x00c6, 0x00e6, 0x00e6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00e6, 0x00e6, 0x00c6, 0x00c6, 0x00c6, 
	0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00e6, 0x00e6, 0x08c6, 0x08c6, 0x08c6, 0x08e6, 0x10e6, 0x1106, 0x1927, 0x1947, 0x2147, 
	0x2967, 0x2967, 0x2987, 0x2988, 0x2988, 0x2988, 0x2988, 0x2968, 0x2967, 0x2968, 0x2968, 0x2968, 0x2968, 0x2968, 0x2968, 0x2988, 
	0x0000, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x0000, 0x0800, 0x0000, 0x0000, 0x0800, 0x0800, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1000, 0x1000, 0x0800, 0x0800, 
	0x0820, 0x1020, 0x0820, 0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 0x1800, 0x1800, 0x1000, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x2800, 0x3000, 0x48c1, 
	0x5902, 0x50a1, 0x4081, 0x1020, 0x0000, 0x2000, 0x3000, 0x3800, 0x2820, 0x0800, 0x1800, 0x3000, 0x3820, 0x4060, 0x3081, 0x0800, 
	0x2000, 0x3800, 0x3020, 0x1000, 0x0000, 0x1800, 0x3000, 0x3000, 0x1820, 0x0800, 0x2000, 0x3800, 0x3820, 0x2841, 0x2082, 0x3082, 
	0x40c2, 0x4082, 0x2020, 0x0800, 0x2000, 0x3800, 0x3800, 0x1820, 0x0800, 0x2000, 0x3000, 0x3000, 0x1800, 0x1000, 0x3000, 0x3800, 
	0x3000, 0x1800, 0x2000, 0x3800, 0x3800, 0x2800, 0x1800, 0x2800, 0x3000, 0x3000, 0x3000, 0x2800, 0x2000, 0x2820, 0x3861, 0x3020, 
	0x2800, 0x3040, 0x38a2, 0x3040, 0x3020, 0x3020, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 
	0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 0x3800, 0x3800, 0x4000, 0x4000, 0x4000, 0x4000, 
	0x4000, 0x4000, 0x4000, 0x3800, 0x2800, 0x2000, 0x3000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x3021, 0x10a4, 
	0x00e6, 0x00e7, 0x00e6, 0x00e6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 
	0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00e6, 0x00e6, 0x08e6, 0x08e6, 0x08e6, 0x10e6, 0x1907, 0x1927, 0x2147, 0x2967, 
	0x2967, 0x2987, 0x2988, 0x2988, 0x3188, 0x2988, 0x2988, 0x2988, 0x2988, 0x2988, 0x2988, 0x2988, 0x2988, 0x2988, 0x2988, 0x2988
};

const uint16_t spasskaya_clock[IMG_PIXELS] PROGMEM = {
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0821, 0x1021, 0x1820, 0x1800, 0x1800, 0x1800, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x1820, 0x1800, 0x1800, 0x1820, 0x2060, 0x30a0, 0x38e0, 
	0x3920, 0x4120, 0x4140, 0x4980, 0x4981, 0x4981, 0x4961, 0x4981, 0x51a2, 0x51a2, 0x51a2, 0x51c2, 0x51c2, 0x51a2, 0x51c3, 0x4982, 
	0x4962, 0x4122, 0x4101, 0x3902, 0x38c1, 0x2840, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 0x2000, 0x2000, 0x2020, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2020, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 
	0x2820, 0x2840, 0x2020, 0x1800, 0x1800, 0x2881, 0x3944, 0x28a2, 0x1820, 0x30e3, 0x3103, 0x2081, 0x1840, 0x1841, 0x3924, 0x3103, 
	0x1840, 0x1000, 0x1020, 0x3103, 0x28e3, 0x1840, 0x1861, 0x20c2, 0x3144, 0x20e2, 0x1020, 0x2904, 0x3945, 0x1040, 0x1040, 0x28e2, 
	0x1861, 0x1861, 0x3965, 0x28e3, 0x1000, 0x1840, 0x28a1, 0x3903, 0x28a2, 0x1800, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 
	0x3000, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x3060, 0x40c0, 0x4900, 0x5140, 0x5140, 0x5981, 0x61a1, 0x61c1, 0x61c2, 0x61c2, 
	0x59c2, 0x59c2, 0x59a2, 0x59a1, 0x59a1, 0x59a2, 0x5181, 0x4961, 0x4121, 0x38e1, 0x3080, 0x2840, 0x2000, 0x2800, 0x2800, 0x2820, 
	0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x1820, 0x1000, 0x0801, 0x1042, 0x1062, 0x0863, 0x0843, 0x0043, 0x0043, 0x0043, 
	0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0883, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 0x0821, 0x1020, 0x1820, 0x1800, 0x1800, 0x2000, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x1820, 0x1800, 0x1800, 0x2060, 0x30c1, 0x4141, 0x4981, 
	0x51a1, 0x51c1, 0x51c2, 0x59e2, 0x59e2, 0x59c2, 0x51a2, 0x51a2, 0x51a2, 0x51a2, 0x51a2, 0x51a2, 0x49a2, 0x4982, 0x4141, 0x3901, 
	0x38e0, 0x30c0, 0x30c0, 0x38c1, 0x30a0, 0x2840, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2800, 0x2000, 0x2000, 0x2020, 0x2020, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2020, 0x2000, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2840, 0x2040, 0x2020, 0x1800, 0x1800, 0x2881, 0x3944, 0x28a2, 0x1000, 0x28c2, 0x30e3, 0x2081, 0x1820, 0x1840, 0x3944, 0x3123, 
	0x1840, 0x1000, 0x1020, 0x30e3, 0x28e3, 0x1840, 0x1861, 0x20a2, 0x3124, 0x20c2, 0x1000, 0x28e3, 0x3945, 0x1040, 0x1040, 0x20c2, 
	0x1861, 0x1861, 0x3124, 0x28c3, 0x1000, 0x1820, 0x2081, 0x3103, 0x30a2, 0x2020, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 
	0x3000, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x3060, 0x40c0, 0x4900, 0x4920, 0x4900, 0x4920, 0x5140, 0x5960, 0x5981, 0x61c1, 
	0x61e2, 0x61e2, 0x61e2, 0x59c2, 0x59c1, 0x59c2, 0x59c2, 0x59c2, 0x59c3, 0x5183, 0x4122, 0x3081, 0x2820, 0x2800, 0x2800, 0x2800, 
	0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2041, 0x1821, 0x1021, 0x1042, 0x0842, 0x0863, 0x0863, 0x0863, 0x0063, 0x0043, 
	0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0800, 0x1020, 0x1820, 0x1820, 0x2020, 0x2020, 
	0x2020, 0x2020, 0x2020, 0x2820, 0x2820, 0x2820, 0x2800, 0x2000, 0x2020, 0x2020, 0x1800, 0x2020, 0x2880, 0x4142, 0x51c3, 0x59e2, 
	0x5a02, 0x6223, 0x6203, 0x5a02, 0x59e3, 0x51c2, 0x5182, 0x4982, 0x4982, 0x4982, 0x4962, 0x4141, 0x4161, 0x4161, 0x3900, 0x30a0, 
	0x2880, 0x2880, 0x30a0, 0x30a1, 0x3080, 0x2840, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2800, 0x2000, 0x2000, 0x2020, 0x2020, 
	0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2040, 0x2020, 0x1800, 0x1800, 0x2881, 0x4144, 0x28a2, 0x1000, 0x28c2, 0x30e3, 0x2082, 0x1840, 0x1840, 0x3944, 0x3123, 
	0x1840, 0x1000, 0x1020, 0x3103, 0x28e3, 0x1840, 0x1840, 0x2081, 0x3124, 0x28c2, 0x0800, 0x28e3, 0x3124, 0x1840, 0x1040, 0x20a2, 
	0x1861, 0x1861, 0x2903, 0x20a2, 0x1000, 0x1020, 0x2081, 0x3103, 0x30a2, 0x2020, 0x2020, 0x2820, 0x2800, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 
	0x3000, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3060, 0x40c0, 0x4900, 0x4900, 0x4900, 0x4900, 0x4900, 0x4920, 0x5140, 0x5960, 
	0x59a1, 0x61c2, 0x61c2, 0x61c2, 0x59c1, 0x59c2, 0x59c2, 0x61e2, 0x6204, 0x6205, 0x5184, 0x40e2, 0x2840, 0x2800, 0x2800, 0x2800, 
	0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2041, 0x1841, 0x1041, 0x1042, 0x0842, 0x0863, 0x0863, 0x0863, 0x0063, 0x0063, 
	0x0063, 0x0063, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0800, 0x1820, 0x2040, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2000, 0x2020, 0x2020, 0x1800, 0x2020, 0x30a0, 0x4962, 0x5a04, 0x5a02, 
	0x5a02, 0x6223, 0x6203, 0x59e2, 0x51a1, 0x4961, 0x4120, 0x4120, 0x4121, 0x4121, 0x3900, 0x30c0, 0x3900, 0x3920, 0x30c0, 0x28a0, 
	0x2880, 0x2880, 0x30a0, 0x30a1, 0x3081, 0x2840, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2800, 0x2000, 0x2000, 0x2020, 0x2020, 
	0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2020, 0x2020, 0x1820, 0x1800, 0x1800, 0x2881, 0x4144, 0x28a1, 0x1000, 0x28a2, 0x30e3, 0x28a2, 0x1840, 0x1840, 0x3923, 0x3103, 
	0x1840, 0x1000, 0x1820, 0x3124, 0x3103, 0x1841, 0x1840, 0x20a2, 0x3944, 0x28e3, 0x1000, 0x28c2, 0x3124, 0x1841, 0x1040, 0x2082, 
	0x1841, 0x1861, 0x28e3, 0x2082, 0x0800, 0x1020, 0x2081, 0x30e3, 0x30a2, 0x2020, 0x2020, 0x2000, 0x2800, 0x2800, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 
	0x3000, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3040, 0x38a0, 0x4900, 0x5121, 0x5120, 0x5120, 0x4900, 0x48e0, 0x48e0, 0x4900, 
	0x5140, 0x5980, 0x5981, 0x61a1, 0x61c1, 0x59c1, 0x59a1, 0x59a1, 0x59c2, 0x59c4, 0x51a4, 0x4123, 0x3060, 0x2820, 0x2800, 0x3000, 
	0x3020, 0x3020, 0x3020, 0x3020, 0x2800, 0x2820, 0x2020, 0x1841, 0x1841, 0x1042, 0x1042, 0x0862, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0063, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 
	0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0801, 0x0800, 0x1840, 0x2040, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x2020, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2000, 0x2020, 0x2020, 0x2000, 0x2040, 0x30c0, 0x4962, 0x59e3, 0x59c2, 
	0x51a1, 0x51c2, 0x51a1, 0x4961, 0x4120, 0x38e0, 0x38c0, 0x38e0, 0x3900, 0x3900, 0x30e0, 0x28a0, 0x30c0, 0x38e0, 0x30c0, 0x28a0, 
	0x28a0, 0x2880, 0x30a0, 0x30a1, 0x3081, 0x2840, 0x2820, 0x2820, 0x2820, 0x2820, 0x2800, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 
	0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2020, 0x2020, 0x1800, 0x1800, 0x1820, 0x28a1, 0x3944, 0x28a1, 0x1000, 0x28a2, 0x30e3, 0x28a2, 0x1840, 0x1840, 0x3123, 0x3103, 
	0x1840, 0x1000, 0x1820, 0x3124, 0x3124, 0x1861, 0x1840, 0x20a2, 0x3944, 0x28e3, 0x1020, 0x28c2, 0x3103, 0x1861, 0x1841, 0x20a2, 
	0x1841, 0x1841, 0x28e3, 0x20a2, 0x1000, 0x1020, 0x2081, 0x30e3, 0x30a2, 0x2020, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 
	0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x3040, 0x38a0, 0x40e0, 0x4920, 0x4920, 0x5120, 0x4920, 0x4900, 0x48e0, 0x40e0, 
	0x4900, 0x4900, 0x4920, 0x5140, 0x5980, 0x5981, 0x59a1, 0x59a1, 0x59a2, 0x59a3, 0x5184, 0x4123, 0x3081, 0x2820, 0x2800, 0x3000, 
	0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 0x1841, 0x1841, 0x1042, 0x1062, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 
	0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0821, 0x0800, 0x1820, 0x2040, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 0x2800, 0x2800, 0x2000, 0x2020, 0x2000, 0x2840, 0x38c0, 0x4942, 0x51a3, 0x4962, 
	0x4940, 0x4120, 0x4100, 0x38e0, 0x38c0, 0x30a0, 0x30a0, 0x30c0, 0x38e0, 0x3901, 0x38e0, 0x2880, 0x30c0, 0x38e0, 0x30e0, 0x30c0, 
	0x28a0, 0x30a0, 0x30a1, 0x30c1, 0x3081, 0x2840, 0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 
	0x2020, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2020, 0x2020, 0x1800, 0x1800, 0x1820, 0x28a1, 0x3944, 0x28a1, 0x1820, 0x28a1, 0x30e2, 0x28c2, 0x2040, 0x1840, 0x3103, 0x3103, 
	0x1840, 0x1000, 0x1820, 0x3103, 0x3123, 0x2081, 0x1840, 0x2081, 0x3944, 0x30e3, 0x1020, 0x28c2, 0x3103, 0x1840, 0x1861, 0x28c2, 
	0x1841, 0x1840, 0x30e3, 0x28a2, 0x1000, 0x1820, 0x2881, 0x3903, 0x30a2, 0x2020, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 
	0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x3040, 0x38a0, 0x40e0, 0x4900, 0x4900, 0x4920, 0x5140, 0x5140, 0x4920, 0x48e0, 
	0x40c0, 0x40c0, 0x40c0, 0x48e0, 0x4920, 0x5160, 0x5981, 0x5981, 0x59a2, 0x5183, 0x4963, 0x4102, 0x3060, 0x2820, 0x2800, 0x2800, 
	0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2021, 0x1841, 0x1041, 0x1042, 0x1062, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 
	0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0801, 0x0800, 0x1820, 0x1820, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 0x2820, 0x2800, 0x2000, 0x2000, 0x2000, 0x2820, 0x3080, 0x4101, 0x4921, 0x4121, 
	0x4100, 0x38c0, 0x38a0, 0x38c0, 0x38c0, 0x38c0, 0x30a0, 0x30a0, 0x38e0, 0x3901, 0x30e0, 0x2860, 0x30a0, 0x3901, 0x38e1, 0x30c0, 
	0x2880, 0x30a0, 0x30c1, 0x30c1, 0x3081, 0x2020, 0x2020, 0x2020, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x1820, 0x1820, 0x1820, 0x1820, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x2000, 0x2020, 
	0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x2881, 0x3923, 0x28a1, 0x1820, 0x28a1, 0x30c2, 0x28a1, 0x2060, 0x1840, 0x30e2, 0x30e2, 
	0x1840, 0x1000, 0x1000, 0x28c2, 0x28c2, 0x2061, 0x1840, 0x1860, 0x3103, 0x28c2, 0x1820, 0x2081, 0x28c2, 0x2061, 0x2081, 0x28c2, 
	0x1840, 0x1840, 0x28c2, 0x2081, 0x1800, 0x1820, 0x2060, 0x30e2, 0x30a1, 0x2020, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 
	0x2800, 0x2820, 0x3020, 0x3020, 0x2820, 0x2800, 0x3040, 0x38a0, 0x40e0, 0x4100, 0x40e0, 0x4100, 0x4900, 0x4920, 0x4920, 0x4900, 
	0x40e0, 0x40e0, 0x40e0, 0x40e0, 0x4900, 0x4900, 0x5140, 0x5161, 0x5182, 0x5183, 0x4963, 0x40e2, 0x3060, 0x2800, 0x2800, 0x3000, 
	0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2021, 0x1841, 0x1842, 0x1042, 0x1062, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0801, 0x0800, 0x1000, 0x1820, 0x1820, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 0x2800, 0x2000, 0x2000, 0x2000, 0x2000, 0x3060, 0x38a0, 0x40e1, 0x38e1, 
	0x38c0, 0x3080, 0x3080, 0x38a0, 0x38e0, 0x38c0, 0x30a0, 0x30a0, 0x30c0, 0x3901, 0x30c0, 0x2880, 0x30a0, 0x38e1, 0x3901, 0x30c0, 
	0x2880, 0x30a0, 0x30c1, 0x38c1, 0x3081, 0x2020, 0x2000, 0x2020, 0x2020, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x1820, 
	0x1820, 0x1820, 0x1820, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x2060, 0x38e2, 0x2880, 0x1820, 0x2060, 0x28a1, 0x28a1, 0x2060, 0x2040, 0x30c1, 0x28c1, 
	0x1840, 0x1000, 0x1000, 0x2060, 0x2081, 0x1860, 0x1820, 0x1840, 0x28a1, 0x2081, 0x1820, 0x2060, 0x28a1, 0x2060, 0x2081, 0x28a1, 
	0x1840, 0x1820, 0x2881, 0x2060, 0x1820, 0x1800, 0x2040, 0x30a1, 0x2860, 0x2020, 0x2000, 0x2000, 0x2800, 0x2800, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2820, 0x2820, 
	0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2800, 0x2840, 0x38a0, 0x40e0, 0x4100, 0x40e0, 0x40e0, 0x40e0, 0x4900, 0x4900, 0x4900, 
	0x4900, 0x4900, 0x4900, 0x40e0, 0x40e0, 0x40e0, 0x4900, 0x4920, 0x5161, 0x5162, 0x4943, 0x38e2, 0x3060, 0x2800, 0x2800, 0x3000, 
	0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2021, 0x1841, 0x1842, 0x1042, 0x1062, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0800, 0x1000, 0x1820, 0x1800, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2840, 0x38a0, 0x4101, 0x38e1, 
	0x30a0, 0x3080, 0x30a0, 0x38c0, 0x38e0, 0x38c0, 0x30a0, 0x30a0, 0x30c0, 0x30e1, 0x30c0, 0x28a0, 0x30a0, 0x30e1, 0x3901, 0x30c1, 
	0x2880, 0x30a0, 0x38e1, 0x38c1, 0x3081, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x2020, 0x28a0, 0x2060, 0x1800, 0x1820, 0x2060, 0x2880, 0x2040, 0x2040, 0x2880, 0x2880, 
	0x1820, 0x1800, 0x1800, 0x2040, 0x2060, 0x1820, 0x1000, 0x1800, 0x2080, 0x2060, 0x1820, 0x2060, 0x2060, 0x2060, 0x2060, 0x2060, 
	0x2040, 0x1820, 0x2060, 0x2040, 0x2020, 0x1800, 0x1800, 0x2840, 0x2020, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2000, 0x2840, 0x38a0, 0x4100, 0x4921, 0x4100, 0x4100, 0x4100, 0x4100, 0x4100, 0x4100, 
	0x4100, 0x4100, 0x4900, 0x4900, 0x4900, 0x40e0, 0x40e0, 0x4100, 0x4920, 0x4922, 0x4122, 0x38c1, 0x3040, 0x2800, 0x2800, 0x2800, 
	0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 0x1821, 0x1042, 0x1042, 0x1062, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0884, 
	0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0800, 0x1000, 0x1800, 0x1800, 0x1800, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 0x2820, 0x2020, 0x1800, 0x1800, 0x2000, 0x2820, 0x38a0, 0x4101, 0x38e1, 
	0x30a0, 0x3080, 0x3080, 0x30a0, 0x38c0, 0x38c0, 0x30c0, 0x30a0, 0x30a0, 0x30c0, 0x30c0, 0x28a0, 0x28a0, 0x30c1, 0x3901, 0x30c1, 
	0x2880, 0x30a1, 0x38e1, 0x38c1, 0x3080, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2820, 0x2820, 0x2800, 0x2800, 
	0x2820, 0x2020, 0x2000, 0x2000, 0x2000, 0x2020, 0x2860, 0x2040, 0x2020, 0x1800, 0x2020, 0x2860, 0x2860, 0x2040, 0x2880, 0x2860, 
	0x2020, 0x2020, 0x2040, 0x2040, 0x2040, 0x2040, 0x1820, 0x1820, 0x2060, 0x2860, 0x2060, 0x2860, 0x2860, 0x2860, 0x2860, 0x2860, 
	0x2060, 0x2040, 0x2860, 0x2860, 0x2860, 0x2040, 0x2020, 0x2840, 0x2820, 0x2000, 0x2820, 0x2840, 0x3040, 0x3040, 0x3040, 0x3040, 
	0x3040, 0x3040, 0x3040, 0x3040, 0x3040, 0x3040, 0x2840, 0x2840, 0x2840, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 0x2800, 0x2840, 0x3880, 0x40e0, 0x4921, 0x4921, 0x4100, 0x4100, 0x4120, 0x4100, 0x4100, 
	0x4100, 0x4100, 0x4100, 0x4100, 0x4100, 0x40e0, 0x40e0, 0x40e0, 0x4100, 0x4121, 0x4102, 0x38c1, 0x2840, 0x2800, 0x2800, 0x2800, 
	0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2000, 0x2020, 0x1821, 0x1041, 0x1042, 0x0862, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0884, 0x0884, 
	0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0800, 0x1000, 0x1800, 0x1800, 0x1800, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2820, 0x2020, 0x2020, 0x1800, 0x1800, 0x2000, 0x2820, 0x30a0, 0x4102, 0x38e1, 
	0x30a0, 0x3080, 0x3080, 0x30a0, 0x30c0, 0x30c0, 0x30c0, 0x30c0, 0x30a0, 0x30c0, 0x28a0, 0x2880, 0x28a0, 0x30c1, 0x30e1, 0x30c1, 
	0x2880, 0x30c1, 0x38e1, 0x38c1, 0x2880, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1820, 0x2020, 0x2040, 0x2040, 0x2840, 0x2840, 0x2840, 0x2840, 0x2840, 0x3060, 0x3060, 0x3060, 0x3060, 0x3060, 0x3060, 0x3060, 
	0x3060, 0x3060, 0x2860, 0x2840, 0x2840, 0x2860, 0x2860, 0x2860, 0x2860, 0x2040, 0x2860, 0x30a0, 0x30a0, 0x3080, 0x30a0, 0x3080, 
	0x2860, 0x3080, 0x30a0, 0x2880, 0x2880, 0x2880, 0x2860, 0x2860, 0x2880, 0x30a0, 0x30a0, 0x30a0, 0x30a0, 0x30a0, 0x30a0, 0x30a0, 
	0x30a0, 0x30a0, 0x2880, 0x30a0, 0x38c0, 0x30a0, 0x3080, 0x3080, 0x3060, 0x3060, 0x3880, 0x38a0, 0x38a0, 0x38a0, 0x38a0, 0x38a0, 
	0x40a0, 0x40c0, 0x40a0, 0x40a0, 0x40c0, 0x40c0, 0x40c0, 0x38c0, 0x38a0, 0x38a0, 0x38a0, 0x3080, 0x3060, 0x2840, 0x2820, 0x2820, 
	0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2840, 0x3080, 0x38e0, 0x4100, 0x4121, 0x4120, 0x4120, 0x4921, 0x4121, 0x4100, 
	0x4100, 0x40e0, 0x4100, 0x4100, 0x40e0, 0x40e0, 0x40e0, 0x40e0, 0x4100, 0x4121, 0x4102, 0x38c1, 0x2840, 0x2800, 0x2000, 0x2800, 
	0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2020, 0x2020, 0x1821, 0x1041, 0x1042, 0x0862, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0800, 0x1000, 0x1000, 0x1800, 0x1800, 0x2000, 
	0x2000, 0x2020, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2020, 0x2000, 0x1800, 0x1800, 0x2000, 0x2020, 0x30a0, 0x4101, 0x38c1, 
	0x30a0, 0x2880, 0x30a0, 0x30a0, 0x30a0, 0x30a0, 0x30c0, 0x30a0, 0x30a0, 0x30c0, 0x30a0, 0x2880, 0x28a0, 0x30c0, 0x30c1, 0x30a0, 
	0x2880, 0x30c1, 0x38e1, 0x30c0, 0x2860, 0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2020, 0x2840, 0x2860, 0x2860, 
	0x3080, 0x30a0, 0x38c0, 0x38c0, 0x40e0, 0x40e0, 0x40e0, 0x40e0, 0x40e0, 0x4900, 0x4900, 0x4900, 0x4900, 0x4900, 0x4900, 0x4900, 
	0x4900, 0x4900, 0x4100, 0x4100, 0x4100, 0x4100, 0x40e0, 0x4100, 0x4100, 0x40e0, 0x4100, 0x4940, 0x4940, 0x4920, 0x4940, 0x4920, 
	0x4920, 0x4920, 0x4920, 0x4120, 0x4120, 0x4100, 0x4100, 0x4100, 0x4100, 0x4120, 0x4920, 0x4920, 0x4920, 0x4920, 0x4920, 0x4940, 
	0x4920, 0x4100, 0x4100, 0x4920, 0x4941, 0x4940, 0x4940, 0x4940, 0x4920, 0x4900, 0x5120, 0x5140, 0x5140, 0x5140, 0x5141, 0x5141, 
	0x5161, 0x5961, 0x5961, 0x5161, 0x5961, 0x5961, 0x5981, 0x5981, 0x5161, 0x5141, 0x4921, 0x4920, 0x4100, 0x40c0, 0x40c0, 0x3880, 
	0x3860, 0x3060, 0x3040, 0x2820, 0x2820, 0x2820, 0x2820, 0x3040, 0x3080, 0x38c0, 0x38e0, 0x40e0, 0x4100, 0x4121, 0x4121, 0x4101, 
	0x4100, 0x4100, 0x4100, 0x4100, 0x4100, 0x38e0, 0x38c0, 0x38e0, 0x4100, 0x4121, 0x4102, 0x38a1, 0x2840, 0x2000, 0x2000, 0x2800, 
	0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2020, 0x1820, 0x1821, 0x1041, 0x1042, 0x0862, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0883, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0884, 0x0884, 0x0884, 
	0x0884, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0800, 0x0800, 0x1000, 0x1800, 0x1800, 0x2000, 
	0x2000, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2000, 0x1800, 0x1800, 0x2000, 0x2020, 0x30a0, 0x4101, 0x38c0, 
	0x30a0, 0x2880, 0x30a0, 0x30c0, 0x30a0, 0x28a0, 0x30a0, 0x28a0, 0x28a0, 0x30c0, 0x30c0, 0x2880, 0x28a0, 0x30a0, 0x28a0, 0x28a0, 
	0x2880, 0x30a0, 0x30c0, 0x3080, 0x2840, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2840, 0x2860, 0x3080, 0x38c0, 0x40e0, 0x4100, 
	0x4120, 0x4940, 0x5161, 0x5161, 0x5161, 0x5161, 0x5161, 0x5981, 0x5981, 0x5981, 0x5981, 0x5981, 0x59a1, 0x5981, 0x5981, 0x59a1, 
	0x59a1, 0x59a1, 0x5981, 0x5981, 0x5981, 0x5181, 0x5181, 0x5981, 0x59a1, 0x5181, 0x5981, 0x59a2, 0x59a1, 0x59a1, 0x59a1, 0x59a1, 
	0x59a1, 0x59a1, 0x59a1, 0x59a1, 0x59a1, 0x5181, 0x5181, 0x5981, 0x59a1, 0x59a1, 0x59a1, 0x59a1, 0x59a1, 0x59a1, 0x59a1, 0x61a1, 
	0x5981, 0x5980, 0x5981, 0x5981, 0x59a1, 0x59a1, 0x59a1, 0x61c1, 0x61a1, 0x5981, 0x61a1, 0x61a1, 0x59a1, 0x59a1, 0x61a1, 0x61c1, 
	0x61c2, 0x61e2, 0x61e2, 0x61c1, 0x61c1, 0x61c2, 0x61c2, 0x69e2, 0x61c2, 0x61a1, 0x59a1, 0x5981, 0x5961, 0x5140, 0x5120, 0x4900, 
	0x40e0, 0x40c0, 0x38a0, 0x3880, 0x3060, 0x3040, 0x2820, 0x2840, 0x3040, 0x3060, 0x3080, 0x38a0, 0x38c0, 0x40e1, 0x4101, 0x4101, 
	0x4101, 0x4101, 0x4101, 0x4101, 0x4100, 0x38e0, 0x38c0, 0x38c0, 0x4100, 0x4122, 0x4102, 0x38a1, 0x2840, 0x2000, 0x2000, 0x2800, 
	0x3020, 0x3040, 0x3040, 0x3020, 0x2820, 0x2020, 0x1820, 0x1821, 0x1041, 0x1042, 0x0862, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0883, 0x0883, 0x0863, 0x0863, 0x0883, 0x0883, 0x0884, 0x0884, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0884, 0x0884, 0x0884, 
	0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0800, 0x0800, 0x1000, 0x1800, 0x1800, 0x2000, 
	0x2000, 0x2000, 0x2020, 0x2000, 0x2000, 0x2000, 0x2820, 0x2020, 0x2020, 0x1800, 0x1800, 0x2000, 0x2020, 0x3080, 0x3901, 0x38c0, 
	0x30a0, 0x2880, 0x30a0, 0x30c0, 0x30a0, 0x2880, 0x28a0, 0x28a0, 0x28a0, 0x30c0, 0x30c0, 0x2880, 0x2880, 0x28a0, 0x2880, 0x2880, 
	0x2860, 0x2860, 0x2860, 0x2840, 0x2020, 0x2020, 0x2020, 0x2840, 0x30a0, 0x38a0, 0x38c0, 0x40e0, 0x4940, 0x5161, 0x59a1, 0x61c2, 
	0x59c1, 0x59a1, 0x61c1, 0x61c1, 0x61c1, 0x61c1, 0x61c1, 0x61c1, 0x61c1, 0x61c1, 0x61c0, 0x61c0, 0x61c0, 0x59c1, 0x59c1, 0x61c1, 
	0x61c1, 0x61c1, 0x61c1, 0x61c1, 0x61a1, 0x61a1, 0x61c1, 0x61c1, 0x61c1, 0x61c1, 0x61c1, 0x61c1, 0x61c1, 0x61c1, 0x61c1, 0x61c0, 
	0x61c0, 0x69c1, 0x69e1, 0x61c1, 0x61c0, 0x61c0, 0x61c0, 0x61c0, 0x61c1, 0x61c1, 0x61c0, 0x61c1, 0x61c1, 0x61c1, 0x69c1, 0x69c0, 
	0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61c0, 0x61c0, 0x61c1, 0x61c1, 0x61a1, 0x61a1, 0x61a0, 0x59a0, 0x59a0, 0x59a0, 0x59a0, 
	0x61a0, 0x61c1, 0x61c1, 0x61c0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x6180, 0x6180, 0x5980, 0x5980, 0x5960, 0x5140, 
	0x4920, 0x4900, 0x4900, 0x4920, 0x40e0, 0x38a0, 0x3860, 0x3040, 0x3040, 0x2840, 0x2840, 0x3060, 0x3080, 0x38a0, 0x38e0, 0x40e1, 
	0x40e1, 0x4101, 0x4101, 0x4101, 0x38e0, 0x38e0, 0x38e0, 0x38e0, 0x4101, 0x4122, 0x4102, 0x38a1, 0x2840, 0x2000, 0x2000, 0x2800, 
	0x3020, 0x3040, 0x3040, 0x3020, 0x2820, 0x2020, 0x1820, 0x1821, 0x1041, 0x1042, 0x0842, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0884, 0x0884, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0000, 0x0800, 0x1000, 0x1000, 0x1800, 0x2020, 
	0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x1820, 0x1800, 0x2000, 0x2020, 0x3080, 0x38e1, 0x38c0, 
	0x30a0, 0x2880, 0x30a0, 0x38e0, 0x30a0, 0x28a0, 0x30a0, 0x2880, 0x2880, 0x30a0, 0x28a0, 0x2860, 0x2060, 0x2860, 0x2860, 0x2860, 
	0x2840, 0x2860, 0x2880, 0x3060, 0x3060, 0x3080, 0x38a0, 0x38e0, 0x4100, 0x4920, 0x4940, 0x5161, 0x5181, 0x5981, 0x59a1, 0x61c2, 
	0x61c1, 0x61c1, 0x61e1, 0x61e1, 0x61c1, 0x61c1, 0x61c1, 0x61c1, 0x61c1, 0x61c1, 0x61c0, 0x61c0, 0x61c0, 0x61c1, 0x61c1, 0x61c1, 
	0x61c1, 0x61c1, 0x61c1, 0x61a0, 0x61a0, 0x61c0, 0x61c1, 0x61c1, 0x61c1, 0x61c1, 0x61c1, 0x61c2, 0x61c1, 0x69c1, 0x69c1, 0x69c0, 
	0x69c0, 0x69c0, 0x69c0, 0x69c1, 0x69c1, 0x69c1, 0x61c1, 0x61c1, 0x61c1, 0x61c1, 0x61c0, 0x69c0, 0x69c0, 0x69c0, 0x69c0, 0x69c0, 
	0x69c0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 
	0x61c0, 0x61c0, 0x61c0, 0x61c0, 0x61c0, 0x69c0, 0x69c0, 0x69c0, 0x69c0, 0x69c0, 0x69c0, 0x69c0, 0x61c1, 0x61c1, 0x61a1, 0x5980, 
	0x5960, 0x5160, 0x5160, 0x5161, 0x5141, 0x5140, 0x4900, 0x40e0, 0x38a0, 0x3880, 0x3060, 0x3060, 0x3060, 0x3080, 0x3880, 0x38a0, 
	0x38c0, 0x38c0, 0x40e0, 0x40e0, 0x40e0, 0x4101, 0x4101, 0x4101, 0x4121, 0x4122, 0x4102, 0x38a1, 0x2840, 0x2000, 0x2000, 0x2800, 
	0x3020, 0x3020, 0x3040, 0x3020, 0x2820, 0x2020, 0x1820, 0x1821, 0x1021, 0x1042, 0x0842, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0884, 0x0884, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0000, 0x0800, 0x1000, 0x1000, 0x1800, 0x2020, 
	0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x1820, 0x1800, 0x1800, 0x2020, 0x2880, 0x38e1, 0x30c0, 
	0x30a0, 0x30a0, 0x30a0, 0x30c0, 0x30a0, 0x3080, 0x30a0, 0x2880, 0x2860, 0x2880, 0x2880, 0x2860, 0x2040, 0x2040, 0x2840, 0x2860, 
	0x2860, 0x3080, 0x38a0, 0x38c0, 0x40e0, 0x4100, 0x4940, 0x5161, 0x5161, 0x5181, 0x59a1, 0x59a1, 0x59a1, 0x5961, 0x5980, 0x5980, 
	0x59a0, 0x61a0, 0x61c0, 0x61c0, 0x61c0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61c0, 0x61c0, 0x61c0, 0x61a0, 0x61a1, 0x61a1, 0x61a1, 
	0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61a1, 0x61a1, 0x61c1, 0x61c2, 0x61c2, 0x61c2, 0x69c1, 0x69c1, 0x69c0, 
	0x69c0, 0x61c0, 0x61c0, 0x69c0, 0x69c1, 0x69e1, 0x69c1, 0x61a1, 0x61a1, 0x61a1, 0x61a0, 0x61a0, 0x61a0, 0x69a0, 0x69c0, 0x69c0, 
	0x69a0, 0x61a0, 0x61a1, 0x61c1, 0x61c1, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61a1, 0x61c1, 0x61c1, 0x61c1, 0x61c1, 
	0x61c1, 0x61c0, 0x61c0, 0x69c0, 0x69c1, 0x69e1, 0x69e1, 0x71e1, 0x71e1, 0x69e1, 0x69e1, 0x69e1, 0x69e1, 0x69e1, 0x69c1, 0x61c1, 
	0x61c1, 0x61a1, 0x6181, 0x5981, 0x61a1, 0x61c2, 0x61a2, 0x5961, 0x5120, 0x48e0, 0x40c0, 0x38a0, 0x3880, 0x3060, 0x3060, 0x3060, 
	0x3880, 0x3880, 0x38a0, 0x38c0, 0x38e0, 0x4101, 0x4101, 0x4101, 0x4122, 0x4122, 0x38e2, 0x30a1, 0x2840, 0x2800, 0x2800, 0x2820, 
	0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 0x1820, 0x1021, 0x1021, 0x1042, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0800, 0x0800, 0x1000, 0x1800, 0x1820, 
	0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x1820, 0x1820, 0x1800, 0x1820, 0x2880, 0x38e1, 0x30c1, 
	0x30a0, 0x2880, 0x3080, 0x3080, 0x2860, 0x2860, 0x2860, 0x2840, 0x2020, 0x2860, 0x2860, 0x2860, 0x2860, 0x2860, 0x3080, 0x38c0, 
	0x38c0, 0x4100, 0x4920, 0x4940, 0x5161, 0x5181, 0x5981, 0x59a1, 0x5981, 0x5981, 0x59a1, 0x59a1, 0x59a1, 0x59a1, 0x61a1, 0x61c1, 
	0x61a0, 0x61a0, 0x61a0, 0x61c0, 0x61c0, 0x61a0, 0x6180, 0x61a0, 0x61a0, 0x69c0, 0x61c0, 0x61a0, 0x61a0, 0x61a1, 0x61c2, 0x69e2, 
	0x69e2, 0x69e2, 0x69e1, 0x61c1, 0x61a0, 0x61a0, 0x61a1, 0x61a1, 0x61c2, 0x61c2, 0x61c2, 0x69e3, 0x69e3, 0x69e2, 0x69e1, 0x69c1, 
	0x61a0, 0x61a0, 0x69c0, 0x69c1, 0x69c1, 0x69c2, 0x69c2, 0x69c2, 0x69c2, 0x69c2, 0x69c1, 0x69a0, 0x69a0, 0x69a0, 0x69a0, 0x69a0, 
	0x69a1, 0x69c1, 0x69c2, 0x69e2, 0x69e2, 0x69c1, 0x61c1, 0x61a0, 0x61a0, 0x61a0, 0x61a0, 0x61c1, 0x61c1, 0x69c1, 0x69e2, 0x69e2, 
	0x69e2, 0x69e1, 0x69e1, 0x69c0, 0x69c0, 0x69a0, 0x69a0, 0x69c0, 0x69c0, 0x69c0, 0x69c0, 0x69e1, 0x71e1, 0x7201, 0x7202, 0x7202, 
	0x7202, 0x7202, 0x7202, 0x69e1, 0x69e1, 0x69e2, 0x69e2, 0x69e2, 0x61c1, 0x6181, 0x5960, 0x5140, 0x4900, 0x40e0, 0x40a0, 0x3880, 
	0x3880, 0x3860, 0x3060, 0x3060, 0x3080, 0x30a0, 0x38c0, 0x38e1, 0x38e1, 0x38e1, 0x38c1, 0x3081, 0x2840, 0x2820, 0x2820, 0x2820, 
	0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 0x1820, 0x1821, 0x1021, 0x1042, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0800, 0x0800, 0x1000, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x1820, 0x1800, 0x1800, 0x1800, 0x2860, 0x30a0, 0x30a0, 
	0x3080, 0x2860, 0x2860, 0x2860, 0x2840, 0x2840, 0x2840, 0x2840, 0x2840, 0x3060, 0x30a0, 0x38a0, 0x38c0, 0x40e0, 0x4100, 0x4920, 
	0x5160, 0x5161, 0x5181, 0x5981, 0x59a1, 0x59c1, 0x61c1, 0x59a1, 0x59a0, 0x5980, 0x5980, 0x5981, 0x59a1, 0x61a1, 0x61a1, 0x61a1, 
	0x61a0, 0x6180, 0x6180, 0x61a0, 0x61a0, 0x6180, 0x6180, 0x6180, 0x61a0, 0x69a0, 0x61a0, 0x61a0, 0x6180, 0x61a1, 0x61a2, 0x61c2, 
	0x61c2, 0x61c2, 0x61c1, 0x61c1, 0x61c1, 0x61c1, 0x61c1, 0x61c2, 0x61c2, 0x61a2, 0x5982, 0x5982, 0x5982, 0x6181, 0x61a1, 0x61a1, 
	0x69c1, 0x69c0, 0x69c0, 0x69c1, 0x69c2, 0x69a2, 0x6182, 0x6181, 0x6182, 0x6181, 0x69a1, 0x69a0, 0x69a0, 0x69a0, 0x69a0, 0x69a0, 
	0x69a1, 0x69a2, 0x69a2, 0x69a2, 0x61c2, 0x61c2, 0x69c1, 0x69c1, 0x69e1, 0x69e1, 0x69e1, 0x69c2, 0x69c2, 0x61a1, 0x61a1, 0x61a1, 
	0x61c1, 0x69c1, 0x69c1, 0x69c0, 0x69a0, 0x6180, 0x6180, 0x6180, 0x6180, 0x6180, 0x6180, 0x69a0, 0x69c0, 0x69c1, 0x69e1, 0x71e1, 
	0x7202, 0x7222, 0x7222, 0x7201, 0x71e1, 0x69e1, 0x7201, 0x7202, 0x7202, 0x69e2, 0x69c2, 0x61c1, 0x6181, 0x5960, 0x5120, 0x48e0, 
	0x40c0, 0x40a0, 0x3860, 0x3060, 0x3060, 0x3060, 0x3080, 0x30a0, 0x30a0, 0x30a0, 0x3080, 0x2860, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x3020, 0x2820, 0x2820, 0x2820, 0x2020, 0x1820, 0x1821, 0x1021, 0x1042, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0800, 0x1000, 0x1000, 0x1000, 0x1800, 
	0x1800, 0x1800, 0x2000, 0x2020, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x1820, 0x1800, 0x1800, 0x1800, 0x2020, 0x2860, 0x2860, 
	0x2860, 0x2840, 0x2840, 0x2840, 0x2840, 0x2840, 0x3060, 0x3080, 0x38a0, 0x38e0, 0x4100, 0x4920, 0x4940, 0x5161, 0x5181, 0x59a1, 
	0x59a1, 0x59a1, 0x59a1, 0x59a1, 0x59a1, 0x59a1, 0x59a1, 0x61a1, 0x61a1, 0x5980, 0x5160, 0x5960, 0x5981, 0x5981, 0x5961, 0x5960, 
	0x5960, 0x6180, 0x6180, 0x6180, 0x6180, 0x6180, 0x6160, 0x6160, 0x6180, 0x6180, 0x6180, 0x6180, 0x6181, 0x5961, 0x5141, 0x5120, 
	0x5100, 0x5100, 0x5140, 0x6181, 0x61c1, 0x69e2, 0x69e2, 0x69e2, 0x61a2, 0x5161, 0x4901, 0x48e0, 0x40c0, 0x48c0, 0x5100, 0x6180, 
	0x69e1, 0x69e1, 0x69c1, 0x69c1, 0x61a2, 0x6162, 0x5941, 0x5100, 0x5100, 0x5920, 0x5940, 0x69a0, 0x69c1, 0x69c1, 0x69c1, 0x69a1, 
	0x69a1, 0x6181, 0x5962, 0x5941, 0x5941, 0x5961, 0x61a1, 0x69e2, 0x7222, 0x7a22, 0x7223, 0x7203, 0x61c2, 0x5961, 0x5120, 0x4900, 
	0x5120, 0x5960, 0x6180, 0x69a0, 0x69a0, 0x6180, 0x6160, 0x6160, 0x6160, 0x5940, 0x6160, 0x6180, 0x6160, 0x5940, 0x5940, 0x6160, 
	0x61a0, 0x69c1, 0x69e1, 0x69c1, 0x69c1, 0x69c1, 0x69c1, 0x69e1, 0x69e1, 0x69c1, 0x69c1, 0x69e1, 0x69c1, 0x69c1, 0x61a1, 0x5960, 
	0x5940, 0x5100, 0x48e0, 0x40c0, 0x3880, 0x3080, 0x3060, 0x3060, 0x2860, 0x2840, 0x2840, 0x2820, 0x2000, 0x2000, 0x2000, 0x2800, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x1821, 0x1021, 0x1042, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0801, 0x1000, 0x1000, 0x1800, 0x1800, 
	0x1800, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2840, 0x2840, 
	0x2860, 0x3060, 0x3080, 0x3080, 0x38a0, 0x38a0, 0x40e0, 0x4900, 0x4940, 0x5160, 0x5161, 0x5981, 0x5981, 0x59a1, 0x59a1, 0x59c1, 
	0x59c1, 0x59a1, 0x59a1, 0x61a1, 0x61a1, 0x61c1, 0x61c1, 0x61a1, 0x61a1, 0x61a1, 0x61c1, 0x61a2, 0x61a2, 0x5982, 0x5962, 0x5961, 
	0x6181, 0x69c1, 0x69c0, 0x69c0, 0x69c0, 0x69a0, 0x69a0, 0x69a0, 0x69a0, 0x69a1, 0x69a1, 0x69c1, 0x69c3, 0x5982, 0x4901, 0x40a0, 
	0x3860, 0x3860, 0x40c0, 0x5961, 0x61c2, 0x6a02, 0x6a03, 0x69e3, 0x5982, 0x4900, 0x38a0, 0x3860, 0x3040, 0x3840, 0x40a0, 0x5940, 
	0x69e2, 0x7202, 0x69e2, 0x69c2, 0x5961, 0x50e1, 0x48a0, 0x4080, 0x4060, 0x4080, 0x50e0, 0x6160, 0x69e1, 0x71e2, 0x69c2, 0x69a1, 
	0x5941, 0x50e0, 0x40a0, 0x4080, 0x4080, 0x48c0, 0x5120, 0x69c2, 0x7223, 0x7a43, 0x7a44, 0x71e3, 0x6182, 0x48e0, 0x3880, 0x3860, 
	0x3880, 0x48e0, 0x5960, 0x69c1, 0x69e1, 0x69c1, 0x69c0, 0x69a0, 0x69a0, 0x6980, 0x69a0, 0x69a0, 0x6980, 0x6180, 0x6180, 0x6180, 
	0x6180, 0x6180, 0x6180, 0x69a0, 0x71c1, 0x71e1, 0x71e1, 0x71e1, 0x71e1, 0x69e1, 0x69c1, 0x69c1, 0x69c1, 0x69e1, 0x69c1, 0x61a1, 
	0x61a0, 0x6180, 0x5960, 0x5140, 0x4900, 0x48e0, 0x40c0, 0x38a0, 0x3880, 0x3060, 0x2840, 0x2820, 0x2000, 0x2000, 0x2000, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2020, 0x2020, 0x1821, 0x1041, 0x1042, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0863, 
	0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0001, 0x0801, 0x1000, 0x1000, 0x1800, 0x1800, 
	0x1820, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x2000, 0x2000, 0x2000, 0x2820, 0x2840, 0x3060, 
	0x30a0, 0x38c0, 0x40e0, 0x4100, 0x4920, 0x5140, 0x5161, 0x5981, 0x59a1, 0x59a1, 0x59a1, 0x61a1, 0x61a1, 0x61a1, 0x61a1, 0x59a1, 
	0x5980, 0x5981, 0x61a1, 0x61a1, 0x61a2, 0x61c2, 0x61c1, 0x61a1, 0x6180, 0x61c1, 0x6a03, 0x69e3, 0x5982, 0x5942, 0x5142, 0x5941, 
	0x69a2, 0x71e2, 0x7202, 0x7201, 0x71e1, 0x71e1, 0x71e1, 0x71e1, 0x71e1, 0x71e1, 0x71e2, 0x7203, 0x7204, 0x5983, 0x40c1, 0x3040, 
	0x2800, 0x2800, 0x3860, 0x5140, 0x61a1, 0x6a03, 0x6a03, 0x69e3, 0x5982, 0x40c0, 0x3040, 0x2800, 0x2800, 0x3000, 0x3860, 0x5120, 
	0x69e2, 0x7223, 0x6a02, 0x61a2, 0x5121, 0x4080, 0x3820, 0x3000, 0x3000, 0x3820, 0x4080, 0x5940, 0x69c1, 0x69e2, 0x69c2, 0x6181, 
	0x5100, 0x3860, 0x3000, 0x2800, 0x2800, 0x3020, 0x40a0, 0x6161, 0x7203, 0x7a43, 0x7a44, 0x69e3, 0x5962, 0x40a0, 0x3020, 0x2800, 
	0x2820, 0x4080, 0x5140, 0x69e1, 0x7202, 0x7a22, 0x7201, 0x7201, 0x71e0, 0x71e0, 0x71e0, 0x71e1, 0x71e1, 0x71e2, 0x71e2, 0x71c1, 
	0x6180, 0x5940, 0x5920, 0x69a0, 0x71e1, 0x7a02, 0x7201, 0x7201, 0x7201, 0x71e1, 0x69e1, 0x69c0, 0x69a0, 0x69c0, 0x69c0, 0x69c0, 
	0x69c0, 0x69c1, 0x69c1, 0x61a1, 0x6181, 0x5960, 0x5140, 0x5120, 0x4900, 0x40c0, 0x38a0, 0x3060, 0x3040, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2020, 0x2020, 0x1841, 0x1841, 0x1042, 0x0843, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0002, 0x0001, 0x0001, 0x0801, 0x1000, 0x1000, 0x1820, 0x2020, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2840, 0x2860, 0x3060, 0x3880, 0x38c0, 0x40e0, 
	0x4920, 0x5141, 0x5161, 0x5161, 0x5981, 0x5981, 0x59a1, 0x59a1, 0x59a1, 0x59a1, 0x59a1, 0x61a1, 0x61c1, 0x61c1, 0x59a1, 0x5980, 
	0x5980, 0x61a1, 0x61a2, 0x61a2, 0x5982, 0x5981, 0x61a1, 0x61a1, 0x6181, 0x61a1, 0x61c2, 0x5961, 0x48e0, 0x40a0, 0x3880, 0x40a0, 
	0x5940, 0x69c2, 0x71e2, 0x7201, 0x69e1, 0x69c1, 0x69c0, 0x69c1, 0x69c1, 0x69c1, 0x69e2, 0x6a03, 0x61c3, 0x4901, 0x3060, 0x2800, 
	0x2800, 0x2800, 0x3040, 0x48e0, 0x5961, 0x61c2, 0x69e3, 0x61c3, 0x5162, 0x38a0, 0x2800, 0x2000, 0x2000, 0x2800, 0x3020, 0x48c0, 
	0x5981, 0x69c2, 0x69c2, 0x6182, 0x4900, 0x3840, 0x3000, 0x2800, 0x3000, 0x3000, 0x3860, 0x5100, 0x6181, 0x69a1, 0x69a2, 0x6161, 
	0x48e0, 0x3860, 0x2800, 0x2800, 0x2800, 0x3000, 0x4080, 0x5920, 0x69c2, 0x7223, 0x7223, 0x69c3, 0x5942, 0x40a0, 0x3020, 0x2800, 
	0x2800, 0x3860, 0x5100, 0x69c1, 0x7202, 0x7222, 0x7201, 0x7201, 0x7201, 0x71e0, 0x71e1, 0x71e1, 0x71e2, 0x71e2, 0x71e2, 0x69a1, 
	0x5940, 0x5100, 0x5100, 0x6980, 0x7202, 0x7a43, 0x7a23, 0x7202, 0x7202, 0x7202, 0x7202, 0x71e1, 0x69c1, 0x69c0, 0x69c0, 0x69c1, 
	0x69c0, 0x69c0, 0x69c0, 0x69c1, 0x69a1, 0x61a1, 0x61a1, 0x61c1, 0x61a1, 0x5981, 0x5140, 0x4900, 0x40e0, 0x40a0, 0x3880, 0x3040, 
	0x3020, 0x2800, 0x2800, 0x2800, 0x2800, 0x2000, 0x2020, 0x1820, 0x1021, 0x1041, 0x1042, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0001, 0x0001, 0x0801, 0x1020, 0x1000, 0x1800, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2020, 0x2820, 0x2820, 0x2840, 0x3060, 0x3080, 0x30a0, 0x38c0, 0x40e0, 0x40e0, 0x4920, 0x5141, 0x5161, 
	0x5981, 0x59a1, 0x59a1, 0x5981, 0x61a1, 0x61a1, 0x61a1, 0x61a1, 0x5981, 0x5980, 0x5981, 0x61a1, 0x61c1, 0x61c1, 0x5981, 0x5980, 
	0x5981, 0x59a1, 0x5982, 0x5141, 0x5121, 0x5120, 0x5960, 0x61a1, 0x61a2, 0x61a2, 0x5981, 0x4900, 0x3880, 0x2820, 0x2800, 0x3020, 
	0x48e0, 0x6181, 0x69e2, 0x7202, 0x69c1, 0x69c1, 0x61a0, 0x61a0, 0x61a0, 0x61a1, 0x6a02, 0x69e3, 0x5982, 0x40c0, 0x2820, 0x2800, 
	0x2800, 0x2800, 0x3860, 0x48e0, 0x5961, 0x61a2, 0x61c3, 0x61c3, 0x5962, 0x40c0, 0x3040, 0x2800, 0x2800, 0x3020, 0x3860, 0x40c0, 
	0x5140, 0x61a1, 0x61a2, 0x5982, 0x5101, 0x4080, 0x3020, 0x3000, 0x3000, 0x3020, 0x3860, 0x48e0, 0x5960, 0x61a1, 0x61a2, 0x5961, 
	0x5100, 0x3880, 0x3020, 0x2800, 0x3020, 0x3020, 0x4080, 0x5100, 0x6181, 0x69e2, 0x69e3, 0x61a2, 0x5942, 0x48c0, 0x3860, 0x2820, 
	0x2820, 0x3040, 0x48e0, 0x6181, 0x69e2, 0x7202, 0x7201, 0x7201, 0x7201, 0x71e1, 0x71e1, 0x71e1, 0x69c2, 0x69c2, 0x6181, 0x5920, 
	0x50e0, 0x48a0, 0x48c0, 0x6160, 0x71e2, 0x7a23, 0x7203, 0x71e2, 0x69c2, 0x69c2, 0x71e2, 0x71e2, 0x71c1, 0x69c1, 0x71c1, 0x71e1, 
	0x71e1, 0x71e0, 0x69c0, 0x69c0, 0x69c0, 0x69c0, 0x69e1, 0x7201, 0x7202, 0x69e1, 0x61c1, 0x61a1, 0x5981, 0x5140, 0x5120, 0x48e0, 
	0x40a0, 0x3880, 0x3060, 0x3060, 0x3040, 0x2840, 0x2040, 0x1840, 0x1840, 0x1041, 0x1042, 0x0843, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0843, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0001, 0x0001, 0x0821, 0x1020, 0x1000, 0x1800, 0x1800, 
	0x2000, 0x2020, 0x2820, 0x3060, 0x3080, 0x3880, 0x38a0, 0x40e0, 0x4100, 0x4921, 0x4941, 0x5161, 0x5181, 0x5981, 0x59a1, 0x59a1, 
	0x59a1, 0x5981, 0x5980, 0x5960, 0x5980, 0x5980, 0x5980, 0x5980, 0x5980, 0x5980, 0x5981, 0x61a1, 0x61c1, 0x61a1, 0x5981, 0x5981, 
	0x5981, 0x5961, 0x5141, 0x40e0, 0x40a0, 0x40a0, 0x5120, 0x61a2, 0x69e3, 0x69e3, 0x5982, 0x4901, 0x3880, 0x2800, 0x2000, 0x2800, 
	0x40a0, 0x5960, 0x69e2, 0x7202, 0x69e1, 0x69c1, 0x61a1, 0x61a1, 0x61a1, 0x61c1, 0x6a03, 0x6a03, 0x5982, 0x40c0, 0x3040, 0x3020, 
	0x3040, 0x3860, 0x40a0, 0x4900, 0x5961, 0x61a2, 0x61c3, 0x61a3, 0x5982, 0x4921, 0x40c0, 0x3880, 0x3880, 0x40a0, 0x40e0, 0x5120, 
	0x5961, 0x5981, 0x61a2, 0x61a2, 0x5962, 0x4901, 0x40a0, 0x3860, 0x3840, 0x3860, 0x40a0, 0x4900, 0x5960, 0x61a1, 0x61a2, 0x5981, 
	0x5121, 0x48c0, 0x3880, 0x3860, 0x3860, 0x3860, 0x40a0, 0x4900, 0x5940, 0x61a1, 0x61a2, 0x61a2, 0x5962, 0x4901, 0x40a0, 0x3880, 
	0x3060, 0x3880, 0x48e0, 0x5960, 0x69c1, 0x7202, 0x7202, 0x7201, 0x7201, 0x69e1, 0x69e1, 0x69e2, 0x69a2, 0x6161, 0x5100, 0x4080, 
	0x3840, 0x3840, 0x48a0, 0x5920, 0x61a1, 0x71e3, 0x69c2, 0x6161, 0x5920, 0x5940, 0x6181, 0x69a2, 0x71c2, 0x71c1, 0x71c1, 0x71e1, 
	0x7201, 0x7201, 0x71e0, 0x69c0, 0x69a0, 0x69c0, 0x69c0, 0x71e0, 0x69e0, 0x69e0, 0x69e1, 0x69e1, 0x69e1, 0x61c1, 0x61a1, 0x6181, 
	0x5961, 0x5120, 0x4900, 0x40c0, 0x40c0, 0x38a0, 0x3080, 0x2880, 0x2081, 0x1861, 0x1042, 0x0843, 0x0843, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0843, 0x0063, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0883, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0801, 0x0821, 0x1020, 0x1820, 0x2020, 0x2020, 
	0x2860, 0x3080, 0x38a0, 0x40e0, 0x4901, 0x4901, 0x4921, 0x5141, 0x5141, 0x5141, 0x5161, 0x5161, 0x5981, 0x5981, 0x5981, 0x5980, 
	0x5980, 0x5981, 0x5981, 0x5960, 0x5980, 0x5980, 0x5960, 0x5960, 0x5980, 0x5981, 0x5981, 0x5981, 0x5961, 0x5961, 0x5981, 0x61a1, 
	0x61a2, 0x5961, 0x4900, 0x3880, 0x3040, 0x3040, 0x48c0, 0x5961, 0x61a2, 0x61c3, 0x61a3, 0x5121, 0x38a0, 0x2820, 0x2000, 0x2800, 
	0x40a0, 0x5961, 0x69c2, 0x69e2, 0x69e2, 0x69e2, 0x69e2, 0x69e2, 0x69e3, 0x6a03, 0x7224, 0x7224, 0x69e4, 0x5983, 0x5122, 0x4922, 
	0x5142, 0x5962, 0x61a3, 0x61c3, 0x61e3, 0x69e3, 0x69e4, 0x6a04, 0x69e4, 0x61c4, 0x59a4, 0x5963, 0x5963, 0x5983, 0x61a3, 0x61c3, 
	0x69e4, 0x69e4, 0x6a04, 0x7225, 0x7225, 0x69e5, 0x61a4, 0x5963, 0x5142, 0x5942, 0x5982, 0x61c2, 0x69e3, 0x7204, 0x7204, 0x6a04, 
	0x69e4, 0x61c4, 0x5984, 0x5983, 0x5963, 0x5982, 0x5982, 0x61a3, 0x69c3, 0x69e3, 0x6a04, 0x6a04, 0x69e4, 0x61c4, 0x61a3, 0x5983, 
	0x5983, 0x5962, 0x59a2, 0x61e3, 0x6a03, 0x7224, 0x7223, 0x7223, 0x7223, 0x7223, 0x7223, 0x7203, 0x71e3, 0x61a2, 0x5920, 0x40a0, 
	0x3840, 0x4060, 0x48e0, 0x6160, 0x69c2, 0x69c3, 0x6161, 0x50e0, 0x48a0, 0x48a0, 0x5100, 0x6181, 0x69a2, 0x6981, 0x6981, 0x69a0, 
	0x69c0, 0x71e1, 0x71e1, 0x71e0, 0x69c0, 0x69c0, 0x71c0, 0x71e0, 0x69c0, 0x69c0, 0x69c0, 0x69c0, 0x69c1, 0x69c1, 0x61a1, 0x61a1, 
	0x61a1, 0x5981, 0x5961, 0x5141, 0x5141, 0x4921, 0x4122, 0x3922, 0x3103, 0x20c3, 0x1883, 0x0843, 0x0843, 0x0843, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0063, 0x0063, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0801, 0x0820, 0x1020, 0x2040, 0x2860, 0x3080, 
	0x38c0, 0x4100, 0x4921, 0x5161, 0x5161, 0x5961, 0x5982, 0x5982, 0x5161, 0x5141, 0x5140, 0x5160, 0x5960, 0x5960, 0x5960, 0x5960, 
	0x5960, 0x5960, 0x5961, 0x5981, 0x5981, 0x5980, 0x5960, 0x5980, 0x5981, 0x5961, 0x5141, 0x4900, 0x48e0, 0x4900, 0x5141, 0x61a2, 
	0x69c3, 0x5962, 0x40e0, 0x3060, 0x2820, 0x2820, 0x3880, 0x4900, 0x5941, 0x6182, 0x61a3, 0x5962, 0x48e1, 0x3880, 0x3020, 0x3040, 
	0x48e0, 0x5982, 0x61c2, 0x69c3, 0x69c3, 0x69e3, 0x69e3, 0x69e3, 0x6a04, 0x6a04, 0x6a04, 0x6a25, 0x6a25, 0x6a25, 0x6a05, 0x6a05, 
	0x6a05, 0x7225, 0x7246, 0x7266, 0x6a25, 0x6a04, 0x6a05, 0x6a25, 0x7226, 0x7226, 0x7226, 0x6a06, 0x6a05, 0x6a05, 0x6a25, 0x7225, 
	0x7225, 0x7225, 0x7246, 0x7a66, 0x7a67, 0x7a87, 0x7a67, 0x7226, 0x6a05, 0x6a05, 0x7225, 0x7245, 0x7245, 0x7225, 0x7225, 0x7246, 
	0x7246, 0x7246, 0x7246, 0x7246, 0x7226, 0x7226, 0x7225, 0x7225, 0x7225, 0x7225, 0x7225, 0x7246, 0x7246, 0x7246, 0x7246, 0x7246, 
	0x6a26, 0x6a25, 0x6a05, 0x6a05, 0x6a04, 0x7224, 0x7224, 0x7224, 0x7224, 0x7224, 0x7224, 0x7204, 0x7204, 0x69e4, 0x6182, 0x5120, 
	0x48c0, 0x48e0, 0x5920, 0x69a2, 0x71e3, 0x69c3, 0x5921, 0x4060, 0x3820, 0x3840, 0x48c0, 0x6141, 0x69a2, 0x6161, 0x5920, 0x5920, 
	0x6160, 0x69a0, 0x71e1, 0x71e1, 0x71c1, 0x71c1, 0x71e1, 0x71e1, 0x69c0, 0x69a0, 0x69a0, 0x69a0, 0x69c0, 0x61a0, 0x61a0, 0x61a0, 
	0x61a1, 0x61a1, 0x61a1, 0x59a1, 0x59a2, 0x59a2, 0x5183, 0x4984, 0x4164, 0x3124, 0x20c3, 0x0863, 0x0842, 0x0042, 0x0843, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0063, 0x0063, 0x0063, 0x0063, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0000, 0x0800, 0x1820, 0x2880, 0x30c0, 0x40e0, 
	0x4941, 0x5161, 0x4961, 0x5140, 0x5140, 0x5140, 0x5940, 0x5140, 0x5140, 0x5140, 0x5960, 0x5980, 0x5980, 0x5980, 0x5980, 0x5980, 
	0x5980, 0x6181, 0x6182, 0x61a2, 0x61a2, 0x61a1, 0x61c1, 0x61c2, 0x61a2, 0x5142, 0x40e0, 0x3880, 0x3860, 0x38a0, 0x4921, 0x61a2, 
	0x69e3, 0x59a3, 0x4101, 0x3060, 0x2000, 0x2800, 0x3040, 0x40c0, 0x5121, 0x5962, 0x5962, 0x5983, 0x5963, 0x5122, 0x4901, 0x4921, 
	0x5982, 0x61c3, 0x61c3, 0x61c3, 0x61c3, 0x69c3, 0x61c3, 0x5983, 0x5962, 0x5162, 0x5142, 0x5142, 0x5162, 0x5963, 0x5983, 0x5983, 
	0x5983, 0x59a3, 0x59a3, 0x59a3, 0x5983, 0x5983, 0x5983, 0x5983, 0x59a4, 0x59a4, 0x59a4, 0x59a4, 0x5984, 0x5983, 0x5963, 0x5963, 
	0x5963, 0x59a4, 0x61a4, 0x61a4, 0x61a4, 0x61a4, 0x5983, 0x5983, 0x5963, 0x5963, 0x5983, 0x5983, 0x5983, 0x5983, 0x5983, 0x5983, 
	0x5963, 0x5963, 0x5963, 0x5163, 0x5163, 0x5162, 0x5162, 0x5963, 0x5962, 0x5942, 0x5963, 0x5963, 0x5963, 0x5143, 0x5143, 0x5143, 
	0x5143, 0x5142, 0x5122, 0x4922, 0x4921, 0x5121, 0x5121, 0x5121, 0x5121, 0x5942, 0x5962, 0x5962, 0x61a3, 0x69c4, 0x69e4, 0x69e4, 
	0x69c3, 0x69a2, 0x69a2, 0x69a3, 0x69a3, 0x6162, 0x50e0, 0x4040, 0x3000, 0x3840, 0x48c0, 0x6162, 0x69a3, 0x5942, 0x50e0, 0x4080, 
	0x48c0, 0x5920, 0x69a1, 0x71e2, 0x71e2, 0x71e1, 0x71e1, 0x7a01, 0x71e1, 0x71c1, 0x69c0, 0x69c0, 0x71e1, 0x69e1, 0x69c1, 0x61a1, 
	0x61a0, 0x5980, 0x5980, 0x5980, 0x5981, 0x5981, 0x5182, 0x4983, 0x4184, 0x3124, 0x18a3, 0x0862, 0x0842, 0x0842, 0x0843, 0x0863, 
	0x0843, 0x0843, 0x0843, 0x0843, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0864, 0x0863, 0x0863, 0x0863, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0000, 0x0800, 0x1820, 0x28a0, 0x3901, 0x4920, 
	0x5161, 0x5181, 0x5160, 0x5140, 0x5140, 0x5140, 0x5140, 0x5120, 0x5120, 0x5140, 0x5981, 0x61a1, 0x61c1, 0x61c1, 0x61a1, 0x61a1, 
	0x6181, 0x5981, 0x5961, 0x5962, 0x5961, 0x5981, 0x69e2, 0x6a03, 0x61c3, 0x4922, 0x38a0, 0x3040, 0x2820, 0x3060, 0x48e0, 0x5962, 
	0x61c3, 0x5983, 0x4901, 0x3080, 0x2840, 0x3060, 0x3880, 0x4900, 0x5962, 0x5983, 0x5982, 0x61a3, 0x61c4, 0x61c4, 0x59a4, 0x59a3, 
	0x61a3, 0x61a3, 0x5962, 0x5142, 0x5142, 0x5142, 0x5122, 0x48e1, 0x40c0, 0x38a0, 0x3880, 0x3880, 0x38a0, 0x38a0, 0x40c0, 0x40c0, 
	0x40c0, 0x40c0, 0x40c0, 0x40c0, 0x40c0, 0x40c1, 0x40e1, 0x40e1, 0x40e1, 0x40e1, 0x40e1, 0x40c1, 0x40c1, 0x40c1, 0x38a0, 0x38a0, 
	0x40a0, 0x40c1, 0x40e1, 0x40c1, 0x40c0, 0x40c0, 0x40a0, 0x40a0, 0x40a0, 0x40c0, 0x40c1, 0x40c0, 0x40a0, 0x40c0, 0x40a0, 0x40a0, 
	0x38a0, 0x3880, 0x38a0, 0x3880, 0x3880, 0x3880, 0x3880, 0x3880, 0x3880, 0x3880, 0x3880, 0x3880, 0x3880, 0x3880, 0x3860, 0x3060, 
	0x3060, 0x3060, 0x3060, 0x3040, 0x3040, 0x3040, 0x3040, 0x3860, 0x3860, 0x4080, 0x40a0, 0x48c0, 0x5101, 0x5942, 0x61a3, 0x69e4, 
	0x7204, 0x7204, 0x71e4, 0x69c3, 0x69a3, 0x6183, 0x5921, 0x48a0, 0x4060, 0x4080, 0x5100, 0x6182, 0x69a3, 0x5942, 0x48c0, 0x4060, 
	0x4080, 0x50e0, 0x6181, 0x71e2, 0x71e2, 0x69a1, 0x6980, 0x71a1, 0x71c1, 0x71e1, 0x71e1, 0x7201, 0x7202, 0x7202, 0x71e2, 0x69e1, 
	0x61a0, 0x61a0, 0x6180, 0x5980, 0x59a1, 0x5981, 0x5182, 0x4983, 0x3964, 0x2903, 0x1882, 0x0842, 0x0842, 0x0843, 0x0843, 0x0843, 
	0x0843, 0x0843, 0x0843, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0864, 0x0863, 0x0863, 0x0863, 
	0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0800, 0x0800, 0x1820, 0x28a0, 0x38e0, 0x4920, 
	0x4940, 0x5140, 0x5140, 0x5160, 0x5160, 0x5960, 0x5940, 0x5140, 0x5941, 0x5981, 0x61a2, 0x69e2, 0x6a02, 0x69e2, 0x61a1, 0x61a1, 
	0x5981, 0x5941, 0x4900, 0x40c0, 0x48e0, 0x5141, 0x61e2, 0x6a04, 0x61c4, 0x4921, 0x3080, 0x2820, 0x2800, 0x3040, 0x40c0, 0x5142, 
	0x5982, 0x5962, 0x4922, 0x40e1, 0x40e1, 0x40e1, 0x5142, 0x6183, 0x69e4, 0x69e4, 0x61c4, 0x61c4, 0x61e5, 0x61c5, 0x61a4, 0x5983, 
	0x5142, 0x4901, 0x40c0, 0x40a0, 0x3880, 0x3860, 0x3040, 0x3040, 0x3020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x3040, 0x3040, 0x2820, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3020, 0x3040, 0x3840, 0x3840, 0x3840, 0x4080, 0x48c0, 0x5121, 
	0x6162, 0x69c4, 0x71e4, 0x71e4, 0x71e4, 0x71e4, 0x69a3, 0x6162, 0x5920, 0x5100, 0x5920, 0x6182, 0x6982, 0x5942, 0x50e0, 0x4080, 
	0x40a0, 0x5100, 0x6181, 0x71c2, 0x71c2, 0x6140, 0x5900, 0x5900, 0x6160, 0x71c1, 0x7a02, 0x7a22, 0x7202, 0x7202, 0x7202, 0x71e2, 
	0x69e1, 0x69c1, 0x61c1, 0x61c1, 0x61a2, 0x59a2, 0x51a3, 0x4184, 0x3124, 0x20c3, 0x1062, 0x0842, 0x0042, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0820, 0x0800, 0x1820, 0x2880, 0x38c0, 0x4900, 
	0x4920, 0x4920, 0x5160, 0x5960, 0x5980, 0x5960, 0x5940, 0x5940, 0x5941, 0x5961, 0x5961, 0x6181, 0x61a1, 0x61c1, 0x61c2, 0x61a2, 
	0x5981, 0x5121, 0x40a0, 0x3040, 0x3860, 0x40e0, 0x5981, 0x61c3, 0x59a3, 0x4922, 0x38a0, 0x3040, 0x2820, 0x3060, 0x40e1, 0x5142, 
	0x5983, 0x5983, 0x5984, 0x59a4, 0x59a4, 0x59a4, 0x59a3, 0x61a3, 0x61c4, 0x61a4, 0x5983, 0x5963, 0x5143, 0x4923, 0x4902, 0x40c1, 
	0x3880, 0x3060, 0x3040, 0x3040, 0x3020, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3840, 0x3860, 
	0x48a0, 0x5101, 0x5942, 0x6162, 0x61a3, 0x69c4, 0x71e4, 0x71e4, 0x71c3, 0x69c2, 0x69c2, 0x69c3, 0x69a2, 0x5941, 0x50e0, 0x48a0, 
	0x48a0, 0x5100, 0x6181, 0x71c2, 0x69a2, 0x5920, 0x50c0, 0x50a0, 0x5900, 0x6961, 0x69a1, 0x71c2, 0x69a1, 0x6981, 0x6981, 0x69a1, 
	0x69c1, 0x69e2, 0x69e2, 0x61e2, 0x61c3, 0x59c3, 0x51c4, 0x4164, 0x28e3, 0x1882, 0x0842, 0x0042, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0042, 0x0022, 0x0022, 0x0021, 0x0820, 0x1020, 0x1820, 0x2060, 0x38a0, 0x48e0, 
	0x4900, 0x5140, 0x5160, 0x5980, 0x5980, 0x5960, 0x5960, 0x5960, 0x5941, 0x5121, 0x48e0, 0x48e0, 0x5120, 0x6181, 0x69c2, 0x69c2, 
	0x5982, 0x4901, 0x3060, 0x2800, 0x2820, 0x3880, 0x5120, 0x5982, 0x59a3, 0x5163, 0x4102, 0x38a0, 0x3880, 0x40a0, 0x4922, 0x5963, 
	0x5983, 0x61a4, 0x61c5, 0x61e5, 0x61e5, 0x61c4, 0x5983, 0x5162, 0x5122, 0x4922, 0x4902, 0x40c1, 0x3880, 0x3060, 0x3040, 0x2820, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 
	0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2820, 0x2820, 0x2820, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3840, 0x3840, 0x3020, 0x3000, 0x3000, 
	0x3020, 0x3840, 0x4080, 0x48c0, 0x5101, 0x6162, 0x69a3, 0x71e3, 0x7204, 0x7a24, 0x7a24, 0x7a03, 0x69c3, 0x6162, 0x5100, 0x50e0, 
	0x50e0, 0x5920, 0x69a1, 0x69a2, 0x6982, 0x5900, 0x4880, 0x4860, 0x50c0, 0x5920, 0x6161, 0x6161, 0x5920, 0x5900, 0x5900, 0x5940, 
	0x61a1, 0x69e2, 0x69e2, 0x61e3, 0x59c3, 0x51a3, 0x49a4, 0x3123, 0x1882, 0x0821, 0x0021, 0x0042, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 
	0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0863, 0x0863, 0x0863, 0x0863, 0x0863, 0x0864, 0x0864, 0x0863, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0042, 0x0022, 0x0021, 0x0821, 0x0800, 0x1000, 0x2040, 0x30a0, 0x4900, 
	0x5120, 0x5140, 0x5160, 0x5960, 0x5960, 0x5960, 0x5960, 0x5961, 0x5921, 0x48e0, 0x4080, 0x4060, 0x40a0, 0x5940, 0x69e3, 0x69e3, 
	0x6182, 0x48e0, 0x3060, 0x2820, 0x2820, 0x3880, 0x4900, 0x5982, 0x61c4, 0x59a4, 0x5184, 0x5143, 0x5143, 0x5143, 0x5984, 0x5984, 
	0x5963, 0x5983, 0x5984, 0x5163, 0x4923, 0x40e2, 0x38a0, 0x3060, 0x3040, 0x3040, 0x3040, 0x2840, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2820, 0x2840, 0x2820, 0x2800, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2000, 
	0x2800, 0x2820, 0x2820, 0x2820, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3040, 0x3840, 0x3840, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x3820, 0x3820, 0x3860, 0x4080, 0x48c0, 0x5101, 0x5941, 0x6982, 0x71c3, 0x7a04, 0x7a04, 0x71e4, 0x69a2, 0x6161, 
	0x5940, 0x6161, 0x69a2, 0x69a2, 0x6162, 0x50c0, 0x4860, 0x4860, 0x50c0, 0x6140, 0x6961, 0x6141, 0x5900, 0x50c0, 0x48a0, 0x50e0, 
	0x5940, 0x61a1, 0x61c2, 0x59a2, 0x5182, 0x4963, 0x3943, 0x28c2, 0x1062, 0x0821, 0x0001, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 
	0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0863, 0x0863, 0x0863, 0x0864, 0x0864, 0x0864, 0x0863, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0042, 0x0022, 0x0022, 0x0042, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0022, 0x0841, 0x0800, 0x1000, 0x2040, 0x38a0, 0x4900, 
	0x5140, 0x5960, 0x5960, 0x5960, 0x5960, 0x6180, 0x61a1, 0x61a2, 0x5941, 0x48a0, 0x3840, 0x3020, 0x3860, 0x5100, 0x69c3, 0x69e3, 
	0x5983, 0x48e1, 0x38a0, 0x3880, 0x3880, 0x40c0, 0x5121, 0x5983, 0x61c4, 0x61c4, 0x59c5, 0x59a4, 0x5984, 0x5164, 0x5163, 0x4923, 
	0x4902, 0x40e2, 0x40c1, 0x38a1, 0x3080, 0x3040, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2800, 0x2820, 0x3020, 0x3020, 0x2840, 0x2840, 0x2820, 0x2820, 0x2820, 0x2020, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x2000, 0x2020, 0x2820, 0x2840, 0x3040, 0x3880, 0x38a0, 0x3880, 0x3040, 0x2820, 0x2000, 0x2000, 0x2800, 0x2820, 0x2800, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2820, 
	0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3040, 0x3840, 0x3040, 0x3020, 
	0x3020, 0x3020, 0x3000, 0x3000, 0x3000, 0x3000, 0x3820, 0x3860, 0x4080, 0x50e0, 0x5921, 0x6183, 0x69c4, 0x69c4, 0x69c3, 0x69a3, 
	0x69a2, 0x69c2, 0x71e3, 0x71c3, 0x6982, 0x5900, 0x48a0, 0x4880, 0x50e0, 0x6161, 0x6982, 0x6161, 0x50e0, 0x48a0, 0x4880, 0x50c0, 
	0x5920, 0x6180, 0x61a1, 0x59a2, 0x4982, 0x3922, 0x28c2, 0x1861, 0x0821, 0x0021, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0043, 0x0063, 0x0063, 0x0063, 0x0043, 0x0063, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0863, 0x0863, 0x0864, 0x0864, 0x0863, 0x0063, 
	0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 
	0x0042, 0x0022, 0x0022, 0x0042, 0x0042, 0x0042, 0x0043, 0x0043, 0x0022, 0x0042, 0x0841, 0x1020, 0x1020, 0x2040, 0x38a0, 0x5120, 
	0x5141, 0x5940, 0x5960, 0x5981, 0x61a1, 0x69c2, 0x69e2, 0x71e3, 0x5942, 0x4880, 0x3840, 0x3820, 0x3840, 0x50e0, 0x6182, 0x61a3, 
	0x5962, 0x4921, 0x4901, 0x4902, 0x4901, 0x5142, 0x5962, 0x59a3, 0x59a4, 0x59a4, 0x5984, 0x5164, 0x4923, 0x40e2, 0x40c1, 0x3881, 
	0x3060, 0x3040, 0x2820, 0x2800, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x2800, 0x2000, 0x2000, 0x2020, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2020, 0x2000, 0x2820, 0x3040, 0x38a0, 0x40e0, 0x4901, 0x4922, 0x4902, 0x40c1, 0x3060, 0x2820, 0x2000, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2800, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2000, 0x2020, 
	0x2020, 0x2820, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3000, 0x3000, 0x3020, 0x3840, 0x4060, 0x4060, 0x48a0, 0x5101, 0x5922, 0x6162, 0x69a3, 
	0x71c3, 0x7204, 0x7a24, 0x7a04, 0x71e4, 0x6161, 0x5100, 0x50c0, 0x5900, 0x6161, 0x69a2, 0x6162, 0x50e0, 0x48a0, 0x48a0, 0x5900, 
	0x6161, 0x61a1, 0x61c2, 0x59a3, 0x4983, 0x3102, 0x1860, 0x0800, 0x0001, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0863, 0x0863, 0x0863, 0x0063, 0x0063, 
	0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0042, 0x0841, 0x1020, 0x1020, 0x2040, 0x38a0, 0x5121, 
	0x5120, 0x5120, 0x5940, 0x5981, 0x61a1, 0x69c2, 0x69e2, 0x69c3, 0x5942, 0x48a0, 0x3860, 0x3860, 0x40a0, 0x5121, 0x5983, 0x5983, 
	0x5983, 0x5983, 0x5963, 0x5164, 0x5983, 0x5163, 0x5163, 0x5142, 0x4922, 0x4922, 0x4102, 0x40c1, 0x38a1, 0x3060, 0x2840, 0x2820, 
	0x2820, 0x2800, 0x2800, 0x2000, 0x2000, 0x2000, 0x2020, 0x2820, 0x2020, 0x2020, 0x2820, 0x2020, 0x2020, 0x2820, 0x2820, 0x2020, 
	0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2820, 0x2840, 0x3880, 0x40e0, 0x4921, 0x5962, 0x5982, 0x5983, 0x5983, 0x5142, 0x4901, 0x38a0, 0x3060, 0x2820, 0x2800, 0x2000, 
	0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2800, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 
	0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3000, 0x3000, 0x3020, 0x3020, 0x3820, 0x3820, 0x3840, 0x4060, 0x4080, 0x48c0, 0x5101, 
	0x5921, 0x6162, 0x6182, 0x69a3, 0x69c4, 0x69a3, 0x6982, 0x6181, 0x69a2, 0x71e3, 0x7204, 0x71c3, 0x6141, 0x50e0, 0x50c0, 0x5940, 
	0x69a1, 0x69e2, 0x6a03, 0x59e4, 0x51c4, 0x3923, 0x1861, 0x0000, 0x0001, 0x0022, 0x0042, 0x0043, 0x0043, 0x0022, 0x0022, 0x0023, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 
	0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 
	0x0042, 0x0022, 0x0042, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0842, 0x0841, 0x1020, 0x1000, 0x2020, 0x38a0, 0x5101, 
	0x4900, 0x4900, 0x5140, 0x5961, 0x5981, 0x61a2, 0x61a2, 0x61a3, 0x5942, 0x48e1, 0x40c0, 0x48c0, 0x5120, 0x5962, 0x59a3, 0x5983, 
	0x59a3, 0x61a4, 0x59a4, 0x5984, 0x5984, 0x5143, 0x4902, 0x40c1, 0x38a1, 0x3080, 0x3060, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2000, 
	0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2020, 
	0x3060, 0x38c0, 0x4921, 0x5161, 0x5982, 0x61a2, 0x61c3, 0x61c3, 0x61c3, 0x59a3, 0x5983, 0x5142, 0x40e1, 0x3880, 0x3040, 0x2820, 
	0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2800, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 0x3020, 0x3020, 0x3820, 0x3840, 
	0x4080, 0x40a0, 0x48c0, 0x5101, 0x5942, 0x6183, 0x69c3, 0x71e4, 0x7204, 0x7a24, 0x7a25, 0x7204, 0x69a3, 0x5941, 0x5100, 0x6161, 
	0x69c2, 0x7202, 0x6a23, 0x6204, 0x51e5, 0x3943, 0x1881, 0x0021, 0x0001, 0x0001, 0x0022, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 
	0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0842, 0x0841, 0x0800, 0x1000, 0x2020, 0x38a0, 0x4901, 
	0x48e0, 0x48e0, 0x4920, 0x5141, 0x5981, 0x5981, 0x5982, 0x5982, 0x5963, 0x5963, 0x5962, 0x5962, 0x61a3, 0x61c4, 0x61e4, 0x59a4, 
	0x5983, 0x5163, 0x4943, 0x4902, 0x40e2, 0x38c1, 0x3080, 0x3060, 0x2840, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2820, 0x2820, 0x2800, 0x2800, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2020, 0x2000, 0x2000, 0x2820, 0x2820, 0x2800, 
	0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2000, 0x2020, 
	0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x2020, 0x2840, 0x30a0, 
	0x40e0, 0x5141, 0x5982, 0x61a2, 0x61a2, 0x6181, 0x6181, 0x5981, 0x5981, 0x61a2, 0x61c3, 0x61c3, 0x5983, 0x5142, 0x40e1, 0x38a1, 
	0x2840, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3040, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3840, 
	0x3840, 0x3840, 0x3840, 0x3860, 0x4080, 0x48c0, 0x5101, 0x5962, 0x61a3, 0x69c3, 0x71e4, 0x7204, 0x69e4, 0x61a2, 0x6162, 0x6182, 
	0x69a1, 0x69c1, 0x61e3, 0x6204, 0x51e5, 0x3944, 0x1061, 0x0021, 0x0001, 0x0021, 0x0022, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 
	0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0022, 0x0022, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0822, 0x0821, 0x0800, 0x1000, 0x2020, 0x38a0, 0x4901, 
	0x48e0, 0x40e0, 0x4900, 0x5141, 0x59a3, 0x5982, 0x5982, 0x5962, 0x5983, 0x59a4, 0x59a4, 0x5983, 0x5983, 0x5983, 0x5163, 0x4922, 
	0x4102, 0x40e1, 0x38a1, 0x3080, 0x3060, 0x2840, 0x2820, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 0x2820, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2820, 0x2820, 0x2800, 
	0x2800, 0x2800, 0x2000, 0x2000, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x2040, 0x38e1, 0x4962, 
	0x5182, 0x5982, 0x59a2, 0x61a2, 0x61a1, 0x6181, 0x5981, 0x5961, 0x5961, 0x59a2, 0x61c3, 0x61e3, 0x61e3, 0x61c4, 0x5984, 0x4923, 
	0x3881, 0x2820, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 0x2800, 0x2800, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 
	0x3840, 0x3840, 0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x3020, 0x3000, 0x3020, 0x3840, 0x3860, 0x40a0, 0x48e0, 0x5101, 0x5921, 0x5962, 0x5962, 0x5962, 0x5962, 0x61a2, 
	0x69c2, 0x69c2, 0x61e3, 0x59e4, 0x49c5, 0x3123, 0x1041, 0x0000, 0x0001, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0841, 0x1000, 0x1820, 0x2040, 0x38c0, 0x4901, 
	0x40e0, 0x40c0, 0x48e0, 0x5162, 0x61e4, 0x61c4, 0x59a3, 0x5983, 0x5984, 0x5184, 0x5163, 0x4922, 0x40e1, 0x38a0, 0x3080, 0x3060, 
	0x2860, 0x2840, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2820, 0x2020, 0x2020, 0x2820, 0x2020, 0x2000, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 
	0x2800, 0x2800, 0x2000, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1000, 0x1800, 0x2860, 0x4983, 0x6205, 
	0x59e3, 0x59a2, 0x5981, 0x5981, 0x5981, 0x61a1, 0x61a1, 0x6181, 0x5981, 0x5981, 0x61a2, 0x61a2, 0x61c3, 0x6a04, 0x6205, 0x59a5, 
	0x40e2, 0x2820, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3840, 0x3040, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3840, 0x3880, 0x40a0, 0x48e1, 0x5121, 0x5983, 
	0x69e3, 0x6a03, 0x6204, 0x59c4, 0x4184, 0x28e3, 0x0820, 0x0000, 0x0001, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 
	0x0043, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0821, 0x1000, 0x1820, 0x2040, 0x38c0, 0x4901, 
	0x40e0, 0x40c0, 0x4901, 0x5163, 0x59c4, 0x51a4, 0x4963, 0x4922, 0x4102, 0x38c1, 0x38a1, 0x3080, 0x2860, 0x2840, 0x2840, 0x2820, 
	0x2020, 0x2020, 0x2800, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2820, 
	0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 0x2020, 0x2820, 0x2020, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2800, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1000, 0x1800, 0x2880, 0x51c4, 0x6225, 
	0x59a2, 0x5981, 0x5981, 0x5981, 0x5981, 0x61a1, 0x61a1, 0x61a1, 0x61a1, 0x5981, 0x59a1, 0x59a2, 0x61c2, 0x61c3, 0x61e4, 0x59c5, 
	0x4102, 0x2860, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 0x2800, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3000, 0x2800, 0x2800, 0x3020, 0x3040, 0x3060, 0x3880, 0x40c0, 
	0x4921, 0x5982, 0x59c4, 0x59e5, 0x4164, 0x20c2, 0x0821, 0x0000, 0x0001, 0x0022, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 
	0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0043, 0x0042, 0x0821, 0x1000, 0x1820, 0x2860, 0x38c0, 0x4101, 
	0x40e0, 0x40c0, 0x4922, 0x5143, 0x4943, 0x4122, 0x38e1, 0x30a1, 0x2860, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 
	0x2020, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2020, 
	0x2820, 0x2820, 0x2800, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2020, 0x2020, 0x2000, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1000, 0x1820, 0x28a0, 0x51c4, 0x59e4, 
	0x5161, 0x5161, 0x5981, 0x5980, 0x5980, 0x5980, 0x5980, 0x5980, 0x5980, 0x5980, 0x5981, 0x59a1, 0x59a2, 0x5982, 0x5983, 0x59a4, 
	0x4922, 0x3080, 0x2020, 0x2000, 0x2020, 0x2000, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x3040, 0x40c0, 0x5163, 0x51c5, 0x3944, 0x20a2, 0x1041, 0x0021, 0x0021, 0x0022, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 
	0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0043, 0x0842, 0x0821, 0x0800, 0x1820, 0x2880, 0x38e1, 0x4901, 
	0x40e1, 0x40e1, 0x4102, 0x40e1, 0x38a1, 0x3060, 0x2840, 0x2840, 0x2020, 0x2000, 0x2020, 0x2020, 0x2020, 0x2820, 0x2840, 0x2820, 
	0x2820, 0x2840, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x1800, 0x1820, 0x1820, 0x1800, 0x2000, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2020, 0x2820, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x1800, 0x1820, 0x1800, 0x1000, 0x1820, 0x30a0, 0x4963, 0x5182, 
	0x4120, 0x4940, 0x5140, 0x5140, 0x5140, 0x5140, 0x5140, 0x5140, 0x5140, 0x5140, 0x5160, 0x5981, 0x5161, 0x4921, 0x5142, 0x5984, 
	0x4943, 0x38c1, 0x2020, 0x2000, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3040, 0x3040, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 
	0x2820, 0x3080, 0x3902, 0x4144, 0x3103, 0x1882, 0x0821, 0x0001, 0x0001, 0x0022, 0x0022, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 
	0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0842, 0x0821, 0x0800, 0x1820, 0x30c1, 0x4101, 0x40e0, 
	0x4901, 0x4902, 0x40e1, 0x38a0, 0x2840, 0x2820, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2820, 0x2840, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x1820, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 
	0x2020, 0x2020, 0x2820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2020, 0x2020, 0x2020, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x1820, 0x1820, 0x1800, 0x1800, 0x2040, 0x30c1, 0x4142, 0x4962, 
	0x4941, 0x5161, 0x5181, 0x5181, 0x5181, 0x5980, 0x5981, 0x59a1, 0x61a1, 0x61c2, 0x61c2, 0x61c3, 0x59a2, 0x5162, 0x5183, 0x59c4, 
	0x5184, 0x40e2, 0x2840, 0x2000, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x3040, 0x2840, 0x2820, 0x2020, 0x2020, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3040, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2800, 0x2820, 0x2800, 
	0x2820, 0x2820, 0x2880, 0x28c2, 0x20a2, 0x1062, 0x0821, 0x0001, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 
	0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0822, 0x0821, 0x1000, 0x1820, 0x38e1, 0x4101, 0x40c0, 
	0x4901, 0x4922, 0x40e2, 0x3080, 0x2840, 0x2820, 0x2820, 0x2820, 0x2020, 0x2820, 0x2020, 0x2020, 0x2020, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x1820, 0x1820, 0x1000, 0x0800, 0x0800, 0x0800, 0x1000, 
	0x1800, 0x2020, 0x2840, 0x2020, 0x2020, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2020, 0x2000, 
	0x2020, 0x2020, 0x2020, 0x2820, 0x2820, 0x2020, 0x2000, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x2860, 0x38e1, 0x4122, 0x4983, 
	0x51a3, 0x59c3, 0x61e3, 0x6203, 0x6203, 0x61e3, 0x6a03, 0x7224, 0x7a64, 0x7a65, 0x7245, 0x6a25, 0x6204, 0x59c4, 0x61e5, 0x6206, 
	0x5184, 0x38e2, 0x2840, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2840, 0x2840, 0x2040, 0x2020, 0x1800, 0x1800, 0x2020, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x3020, 0x3020, 0x3040, 0x3040, 0x3020, 0x3020, 0x3020, 0x2820, 0x2800, 0x2800, 0x2800, 0x2820, 
	0x2020, 0x2000, 0x1820, 0x1840, 0x1041, 0x0821, 0x0821, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0043, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0023, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0043, 0x0043, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0821, 0x1000, 0x1840, 0x30e2, 0x38e1, 0x38a0, 
	0x40e1, 0x4102, 0x40e2, 0x3080, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2020, 0x1820, 0x1820, 0x1000, 0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 
	0x1800, 0x2020, 0x2040, 0x2020, 0x2000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2000, 
	0x2000, 0x2020, 0x2020, 0x2000, 0x2800, 0x2000, 0x2000, 0x2020, 0x2020, 0x1800, 0x1800, 0x2020, 0x30a1, 0x3902, 0x30c1, 0x30e1, 
	0x4121, 0x4962, 0x51a3, 0x59e3, 0x61e3, 0x61c2, 0x61c2, 0x61e3, 0x6a03, 0x6a03, 0x61c3, 0x5183, 0x4962, 0x4942, 0x51a4, 0x59e5, 
	0x5164, 0x38c2, 0x2020, 0x2000, 0x2000, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2840, 0x2840, 0x2020, 0x1800, 0x1000, 0x1000, 0x1800, 
	0x2000, 0x2820, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2800, 0x2800, 0x2800, 0x2820, 
	0x2020, 0x2000, 0x1820, 0x1840, 0x1021, 0x0821, 0x0822, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0023, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0043, 0x0043, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0821, 0x1020, 0x1861, 0x30e2, 0x30e1, 0x30a0, 
	0x38a0, 0x38c1, 0x40c1, 0x3081, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2820, 0x2820, 
	0x2820, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2020, 0x1820, 0x1820, 0x1000, 0x0800, 0x0000, 0x0000, 0x0000, 0x0800, 
	0x1800, 0x1820, 0x2020, 0x2020, 0x2000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x1800, 0x1800, 0x2020, 0x30a1, 0x38e2, 0x2060, 0x2040, 
	0x2860, 0x30c0, 0x4101, 0x4941, 0x5161, 0x5140, 0x5140, 0x5141, 0x5161, 0x5141, 0x4921, 0x38c0, 0x3080, 0x30a0, 0x40e2, 0x4943, 
	0x4102, 0x3081, 0x2020, 0x2000, 0x2020, 0x2000, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2040, 0x2040, 0x1820, 0x1000, 0x0800, 0x1000, 0x1800, 
	0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3000, 0x2800, 0x2800, 0x2820, 
	0x2820, 0x2000, 0x2020, 0x1841, 0x1041, 0x0822, 0x0822, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0023, 0x0043, 0x0043, 0x0043, 0x0023, 0x0043, 0x0043, 0x0042, 0x0821, 0x1021, 0x1861, 0x28c2, 0x30c1, 0x30a0, 
	0x30a0, 0x38a1, 0x38a1, 0x3081, 0x2820, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2820, 0x2020, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2020, 0x1840, 0x1020, 0x0820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 
	0x1000, 0x1820, 0x2020, 0x2020, 0x2000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2800, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2020, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x2000, 0x2861, 0x28a1, 0x2040, 0x1800, 
	0x1000, 0x1800, 0x2020, 0x2860, 0x3080, 0x3080, 0x38a0, 0x38c0, 0x38c0, 0x38c0, 0x3080, 0x2840, 0x2000, 0x2000, 0x2040, 0x3080, 
	0x2860, 0x2840, 0x2000, 0x2000, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x3000, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 0x2040, 0x1840, 0x1020, 0x1000, 0x0800, 0x0800, 0x1000, 
	0x1800, 0x2000, 0x2820, 0x2820, 0x2820, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 
	0x2820, 0x2020, 0x1820, 0x1820, 0x1021, 0x0822, 0x0822, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0043, 0x0043, 0x0042, 0x0842, 0x0841, 0x1061, 0x2081, 0x28a1, 0x30c1, 
	0x38e1, 0x38e2, 0x38c2, 0x3081, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2020, 0x2020, 0x1840, 0x1020, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 
	0x1800, 0x1820, 0x2020, 0x2020, 0x2000, 0x1800, 0x2000, 0x2000, 0x2000, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2020, 0x2000, 
	0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x2000, 0x2040, 0x2061, 0x1840, 0x1000, 
	0x1000, 0x1000, 0x2020, 0x2860, 0x30a0, 0x38a0, 0x40e0, 0x4100, 0x4120, 0x4120, 0x4101, 0x30a0, 0x2040, 0x1800, 0x1800, 0x1800, 
	0x2000, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2800, 0x2800, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 0x2020, 0x1820, 0x1020, 0x1000, 0x0800, 0x0800, 0x1000, 
	0x1800, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2800, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 
	0x2820, 0x2020, 0x2020, 0x1821, 0x1021, 0x0822, 0x0822, 0x0022, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0043, 0x0043, 0x0043, 0x0042, 0x0842, 0x0842, 0x1041, 0x1861, 0x20a1, 0x30c1, 
	0x3923, 0x4144, 0x40e2, 0x3081, 0x2000, 0x2020, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x1820, 0x1020, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 
	0x1800, 0x1820, 0x2020, 0x2020, 0x2000, 0x1800, 0x2000, 0x2000, 0x2000, 0x2020, 0x2820, 0x2800, 0x2000, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2020, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2020, 0x2040, 0x1821, 0x1800, 
	0x1000, 0x2040, 0x30c0, 0x4121, 0x4962, 0x5182, 0x51a2, 0x59c3, 0x59e3, 0x6204, 0x5a05, 0x51a4, 0x3902, 0x2040, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x2000, 0x2000, 0x2020, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2800, 0x2800, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2020, 0x2020, 0x1820, 0x1000, 0x1000, 0x0800, 0x0800, 0x1000, 
	0x1800, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2800, 0x3000, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3040, 0x3020, 
	0x2820, 0x2020, 0x2020, 0x1821, 0x1042, 0x0822, 0x0822, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0842, 0x0842, 0x0842, 0x1061, 0x1861, 0x2081, 
	0x3923, 0x4964, 0x38e2, 0x2860, 0x2000, 0x2020, 0x2820, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2000, 0x2020, 0x1820, 0x1820, 0x1020, 0x0800, 0x0800, 0x0000, 0x0000, 0x0800, 0x1000, 
	0x1800, 0x2020, 0x2040, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2020, 0x2020, 
	0x2020, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 0x1000, 
	0x1000, 0x2060, 0x3901, 0x4983, 0x51c3, 0x51a3, 0x59c3, 0x59c3, 0x51a2, 0x59e3, 0x5a05, 0x51e5, 0x4143, 0x2880, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x2000, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2800, 0x2800, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 0x1820, 0x1800, 0x1000, 0x0800, 0x0800, 0x1000, 
	0x1800, 0x2000, 0x2020, 0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 0x3000, 0x3020, 0x3020, 0x3820, 0x3020, 0x3040, 0x3040, 0x3020, 
	0x2820, 0x2020, 0x2020, 0x1841, 0x1042, 0x0842, 0x0822, 0x0022, 0x0022, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0042, 0x0842, 0x0842, 0x1041, 0x1041, 0x1840, 
	0x3103, 0x4144, 0x30c2, 0x2840, 0x2000, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2020, 0x1820, 0x1820, 0x1000, 0x0800, 0x0800, 0x0800, 0x0000, 0x0800, 0x1000, 
	0x1800, 0x2020, 0x2040, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1020, 0x1000, 
	0x1000, 0x2080, 0x3901, 0x4983, 0x5183, 0x4962, 0x4962, 0x4941, 0x4120, 0x4141, 0x4983, 0x49a3, 0x4143, 0x2880, 0x1820, 0x1800, 
	0x1800, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2800, 0x2800, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 0x2020, 0x1820, 0x1000, 0x0800, 0x0800, 0x1000, 
	0x1800, 0x2000, 0x2020, 0x2820, 0x3020, 0x2820, 0x2800, 0x2800, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 0x3040, 0x3020, 
	0x2820, 0x2020, 0x2020, 0x1841, 0x1042, 0x1042, 0x0822, 0x0022, 0x0022, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0042, 0x0042, 0x0842, 0x0821, 0x0820, 0x1020, 
	0x20a2, 0x30e3, 0x30a1, 0x2840, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x1820, 0x1820, 0x1000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 
	0x1800, 0x2020, 0x2040, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2020, 0x2020, 0x2000, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1020, 0x1000, 
	0x1000, 0x1840, 0x2880, 0x30c0, 0x30c0, 0x30a0, 0x30a0, 0x30a0, 0x30a0, 0x30a0, 0x30c0, 0x30e1, 0x30c1, 0x2040, 0x1800, 0x1000, 
	0x1800, 0x1820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2800, 0x2800, 0x3000, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x1820, 0x1000, 0x1000, 0x1000, 
	0x1800, 0x2000, 0x2820, 0x2840, 0x3040, 0x2820, 0x2800, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 
	0x2820, 0x2020, 0x2020, 0x1841, 0x1042, 0x0842, 0x0822, 0x0022, 0x0022, 0x0042, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 
	0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0042, 0x0022, 0x0021, 0x0821, 0x0821, 
	0x1861, 0x2081, 0x2861, 0x2040, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x0800, 0x0800, 0x1000, 0x1800, 
	0x2000, 0x2020, 0x2040, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 
	0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x1820, 0x1820, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1020, 0x1000, 
	0x1000, 0x1820, 0x2040, 0x2860, 0x2860, 0x2040, 0x2020, 0x2020, 0x2040, 0x2040, 0x2860, 0x28a0, 0x28a0, 0x2040, 0x1800, 0x1000, 
	0x1800, 0x1820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2800, 0x2800, 0x3000, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x1820, 0x1800, 0x1000, 0x1000, 
	0x1800, 0x2000, 0x2820, 0x2840, 0x2840, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 
	0x2820, 0x2020, 0x1820, 0x1821, 0x1041, 0x0841, 0x0822, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0021, 0x0821, 
	0x1021, 0x1820, 0x2020, 0x2020, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2000, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x0800, 0x0800, 0x1000, 0x1800, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2800, 0x2000, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x1820, 0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1020, 0x1000, 
	0x1000, 0x1840, 0x2860, 0x2880, 0x2860, 0x2020, 0x2000, 0x2000, 0x2000, 0x2040, 0x2880, 0x30c1, 0x30e1, 0x2060, 0x1820, 0x1000, 
	0x1800, 0x1820, 0x2020, 0x2020, 0x2000, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2800, 0x2800, 0x3000, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2020, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x2000, 0x2820, 0x2840, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 
	0x2820, 0x2020, 0x1820, 0x1020, 0x1021, 0x0821, 0x0821, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0023, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0023, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0822, 0x0821, 
	0x1021, 0x1820, 0x1820, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2800, 
	0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2000, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 
	0x2000, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x1820, 0x1800, 0x1800, 0x1020, 0x1020, 0x1020, 0x1020, 0x1000, 
	0x1000, 0x2060, 0x30c0, 0x38e0, 0x38c0, 0x3080, 0x2840, 0x2820, 0x2840, 0x3080, 0x3901, 0x4963, 0x4143, 0x28a1, 0x1820, 0x1000, 
	0x1800, 0x1820, 0x1820, 0x2000, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2800, 0x2800, 0x3000, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 0x1800, 0x1800, 0x1800, 
	0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 
	0x2820, 0x2020, 0x1820, 0x1020, 0x1021, 0x0821, 0x0021, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0023, 0x0022, 0x0022, 0x0022, 0x0023, 0x0022, 0x0022, 0x0022, 0x0042, 0x0822, 0x0821, 
	0x1021, 0x1820, 0x1820, 0x2020, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x1820, 0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 
	0x2000, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x1820, 0x1820, 0x1820, 0x1020, 0x1020, 0x1020, 0x1020, 0x1000, 
	0x1000, 0x2880, 0x4101, 0x4942, 0x4942, 0x4101, 0x38a0, 0x3080, 0x3080, 0x4100, 0x5182, 0x5a05, 0x51c5, 0x30c1, 0x1820, 0x1000, 
	0x1800, 0x1820, 0x1800, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2800, 0x2800, 0x3000, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 
	0x2820, 0x2020, 0x2020, 0x1820, 0x1021, 0x0821, 0x0822, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0022, 0x0042, 0x0042, 
	0x0042, 0x0022, 0x0022, 0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0022, 0x0042, 0x0022, 0x0821, 
	0x0821, 0x1020, 0x2020, 0x2020, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2800, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x1820, 0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1820, 0x1800, 0x1820, 0x1020, 0x1020, 0x1020, 0x1020, 0x0800, 
	0x1000, 0x2880, 0x4941, 0x51a3, 0x51a3, 0x4942, 0x40e0, 0x38a0, 0x40e0, 0x4941, 0x59c3, 0x6246, 0x5a05, 0x3902, 0x2040, 0x1000, 
	0x1800, 0x1820, 0x1800, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2800, 0x2800, 0x2800, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2800, 0x2800, 0x3000, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 
	0x2820, 0x2020, 0x2020, 0x1821, 0x1021, 0x1022, 0x0822, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0042, 
	0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0042, 0x0042, 0x0842, 0x0822, 0x0821, 
	0x1021, 0x1821, 0x2040, 0x2020, 0x2000, 0x2000, 0x2000, 0x2020, 0x2000, 0x2000, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2800, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x2000, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1820, 0x1800, 0x1800, 0x1020, 0x1020, 0x1000, 0x1020, 0x0800, 
	0x1000, 0x30a0, 0x5162, 0x59c3, 0x59c4, 0x5983, 0x40e0, 0x38a0, 0x4900, 0x5181, 0x61e4, 0x6a66, 0x6225, 0x3922, 0x2060, 0x1000, 
	0x1800, 0x1820, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2800, 0x2800, 0x3000, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2000, 0x2000, 
	0x2800, 0x2800, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 
	0x2820, 0x2820, 0x2020, 0x1821, 0x1821, 0x1022, 0x0822, 0x0822, 0x0022, 0x0022, 0x0022, 0x0023, 0x0022, 0x0022, 0x0042, 0x0042, 
	0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0842, 0x0842, 0x0821, 
	0x1041, 0x1841, 0x2040, 0x2040, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2800, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 
	0x2000, 0x2020, 0x2020, 0x2020, 0x2000, 0x1800, 0x2000, 0x2000, 0x2020, 0x2020, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1820, 0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 
	0x1000, 0x30a0, 0x51a2, 0x59c3, 0x61c3, 0x59a3, 0x40e0, 0x3880, 0x4920, 0x5982, 0x61e3, 0x6a45, 0x6225, 0x4122, 0x2060, 0x1000, 
	0x1800, 0x1820, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2800, 0x2800, 0x3000, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2800, 0x2800, 
	0x2800, 0x2820, 0x2820, 0x3020, 0x3040, 0x3020, 0x3000, 0x3000, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 
	0x2840, 0x2820, 0x2020, 0x1820, 0x1821, 0x1021, 0x0821, 0x0822, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0042, 
	0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0842, 0x0842, 0x0841, 0x1041, 
	0x1841, 0x2061, 0x2040, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 
	0x2000, 0x2020, 0x2020, 0x2000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x0800, 
	0x1000, 0x38e0, 0x61c3, 0x59c3, 0x61c3, 0x59a3, 0x40e0, 0x3880, 0x5120, 0x59a2, 0x6203, 0x6a45, 0x6225, 0x4963, 0x28a1, 0x1000, 
	0x1000, 0x1820, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2020, 0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x3000, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2800, 
	0x2800, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 
	0x3040, 0x2840, 0x2020, 0x1820, 0x1821, 0x1021, 0x0821, 0x0821, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 0x0042, 0x0042, 
	0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0841, 0x0841, 0x1041, 0x1041, 
	0x1841, 0x2041, 0x2040, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2020, 0x2020, 0x2000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x2000, 0x2020, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x0800, 
	0x1800, 0x4120, 0x6a03, 0x61c3, 0x61a3, 0x5983, 0x40c0, 0x3880, 0x5120, 0x61c2, 0x6a03, 0x6a45, 0x6a25, 0x51a3, 0x30c1, 0x1000, 
	0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2020, 0x2020, 0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x3000, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 
	0x3040, 0x2840, 0x2020, 0x1820, 0x1820, 0x1021, 0x1021, 0x1041, 0x0842, 0x0821, 0x0021, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 
	0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0021, 0x0021, 0x0820, 0x1041, 0x1041, 0x1840, 
	0x1820, 0x2020, 0x2040, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2000, 0x2800, 0x2800, 0x2820, 0x2800, 0x2800, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x1800, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2020, 0x2020, 0x2020, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x1820, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x1000, 
	0x1820, 0x4941, 0x6a24, 0x6a04, 0x61c3, 0x5983, 0x40c0, 0x3860, 0x5120, 0x61c2, 0x6a04, 0x7245, 0x6a25, 0x59c4, 0x30e1, 0x1000, 
	0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2020, 0x2020, 0x2020, 0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x3000, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 
	0x3020, 0x2840, 0x2020, 0x2020, 0x1820, 0x1841, 0x1882, 0x1882, 0x1062, 0x0841, 0x0821, 0x0021, 0x0021, 0x0021, 0x0022, 0x0022, 
	0x0042, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0001, 0x0021, 0x0820, 0x1061, 0x20c2, 0x28c2, 0x2081, 
	0x2081, 0x2860, 0x2840, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x1800, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2820, 0x2020, 0x2000, 
	0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2000, 0x2020, 
	0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x1820, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1020, 0x0800, 0x1000, 
	0x2040, 0x4961, 0x6a44, 0x6a04, 0x61c4, 0x5983, 0x40a0, 0x3840, 0x5100, 0x61a2, 0x6a04, 0x7244, 0x6a25, 0x6205, 0x3902, 0x1000, 
	0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2020, 0x2020, 0x2020, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x3000, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 0x3820, 0x3040, 
	0x3040, 0x3040, 0x2820, 0x2020, 0x2040, 0x2061, 0x28a2, 0x28e3, 0x2904, 0x20c3, 0x1061, 0x0000, 0x0021, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0001, 0x0001, 0x0800, 0x1061, 0x28e2, 0x3944, 0x3944, 0x30e2, 
	0x38e2, 0x30c1, 0x2860, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2020, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x1800, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2820, 0x2820, 0x2020, 0x2000, 
	0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1020, 0x0800, 0x1000, 
	0x2060, 0x5182, 0x7244, 0x6a04, 0x61c4, 0x5983, 0x40a0, 0x3040, 0x4900, 0x61a2, 0x6a03, 0x7224, 0x6a24, 0x6a46, 0x4143, 0x1820, 
	0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2020, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x3000, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3000, 0x3020, 0x3020, 0x2820, 0x2820, 0x2800, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 
	0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 0x3840, 
	0x3040, 0x3040, 0x2820, 0x2020, 0x2040, 0x2881, 0x28c2, 0x3944, 0x41a5, 0x3124, 0x18a2, 0x0800, 0x0841, 0x1082, 0x0842, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0001, 0x0000, 0x0800, 0x20a1, 0x3923, 0x4184, 0x49a4, 0x4163, 
	0x4143, 0x40e2, 0x3060, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2800, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 
	0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x0800, 0x1000, 0x1020, 0x0800, 0x1000, 
	0x2880, 0x5182, 0x6a24, 0x6a04, 0x61c4, 0x5983, 0x40a0, 0x3040, 0x4900, 0x6182, 0x69e3, 0x6a03, 0x6a24, 0x6a66, 0x49a4, 0x2081, 
	0x1820, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2020, 0x2000, 0x2800, 0x2820, 0x2820, 0x2820, 0x2800, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 0x3020, 
	0x3040, 0x3040, 0x2820, 0x2820, 0x2040, 0x2060, 0x2881, 0x3102, 0x3964, 0x3944, 0x28e2, 0x1861, 0x28e3, 0x2924, 0x1061, 0x0000, 
	0x0021, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 0x0821, 0x0800, 0x1020, 0x28a1, 0x3942, 0x4983, 0x4984, 0x5183, 
	0x4943, 0x40e1, 0x3060, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x1820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 
	0x2020, 0x2020, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2020, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x1820, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x0800, 0x1000, 0x1000, 0x0800, 0x1840, 
	0x3900, 0x59a2, 0x6a03, 0x6a04, 0x61c4, 0x5143, 0x3880, 0x3040, 0x48e0, 0x5981, 0x69e3, 0x69e3, 0x6a04, 0x7266, 0x59e5, 0x3102, 
	0x2040, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 
	0x3820, 0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 
	0x3840, 0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 0x3020, 
	0x3020, 0x3020, 0x2820, 0x2820, 0x2040, 0x2060, 0x2880, 0x30c1, 0x3102, 0x3102, 0x3102, 0x28e2, 0x3944, 0x3985, 0x20a2, 0x0820, 
	0x0821, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0043, 0x0043, 0x0043, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0021, 0x0021, 0x0820, 0x1020, 0x1840, 0x28a0, 0x3901, 0x3901, 0x4121, 0x4942, 
	0x4101, 0x38a0, 0x3880, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 
	0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2820, 0x2820, 0x2020, 0x2000, 
	0x2020, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x1800, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x0800, 0x0800, 0x0800, 0x1000, 0x0800, 0x2880, 
	0x51a3, 0x61e3, 0x6a03, 0x6a04, 0x59a3, 0x4902, 0x3060, 0x3040, 0x48e0, 0x5981, 0x69e3, 0x69e2, 0x6a03, 0x7266, 0x6205, 0x4163, 
	0x2880, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2000, 0x2000, 0x2000, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 
	0x3840, 0x3840, 0x3020, 0x3020, 0x2820, 0x2800, 0x3000, 0x3020, 0x3020, 0x3000, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 0x3020, 
	0x3020, 0x2820, 0x2820, 0x2820, 0x2020, 0x2860, 0x30a0, 0x30c0, 0x30a0, 0x28a0, 0x30c1, 0x3902, 0x3922, 0x3923, 0x3102, 0x20a2, 
	0x1021, 0x0821, 0x0022, 0x0002, 0x0002, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0023, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0021, 0x0021, 0x0820, 0x1860, 0x28a0, 0x38e1, 0x4101, 0x38e0, 0x4101, 0x4921, 
	0x4100, 0x40e0, 0x48e0, 0x3880, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 
	0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2020, 0x2020, 0x2020, 0x2820, 0x2020, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x1800, 0x1820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x1800, 0x1800, 0x2000, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x0820, 0x1000, 0x1000, 0x1000, 0x30c0, 
	0x6204, 0x6a24, 0x69e3, 0x6a04, 0x5983, 0x40c1, 0x3040, 0x2820, 0x40c0, 0x5961, 0x69e3, 0x69e3, 0x6a03, 0x6a45, 0x6225, 0x51c4, 
	0x30c1, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2000, 0x2000, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x1800, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 
	0x3820, 0x3820, 0x3020, 0x3020, 0x2820, 0x2800, 0x2800, 0x3020, 0x3020, 0x3000, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x2820, 0x2820, 0x2820, 0x2020, 0x2860, 0x30c1, 0x38c1, 0x30c0, 0x30c0, 0x38e1, 0x4122, 0x3902, 0x3902, 0x4984, 0x3964, 
	0x20a2, 0x1042, 0x0002, 0x0002, 0x0002, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0821, 0x1020, 0x20a1, 0x3922, 0x4942, 0x4941, 0x4100, 0x4100, 0x4901, 
	0x4900, 0x5141, 0x61a2, 0x5141, 0x3080, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2820, 0x2820, 0x2800, 0x2820, 
	0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 
	0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x1800, 0x1800, 0x1820, 0x1820, 0x1820, 0x2020, 0x1820, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1020, 0x1020, 0x1000, 0x1000, 0x1820, 0x3900, 
	0x6a45, 0x6a24, 0x61c3, 0x61e4, 0x5163, 0x3080, 0x2820, 0x2820, 0x3860, 0x5121, 0x6a03, 0x6a03, 0x6a03, 0x6a24, 0x6a45, 0x5a05, 
	0x3902, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x1800, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x3000, 0x3000, 0x3020, 0x3020, 
	0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2800, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 
	0x3820, 0x3820, 0x3020, 0x3020, 0x2820, 0x2820, 0x2800, 0x2820, 0x3020, 0x3000, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2860, 0x30c1, 0x38e1, 0x38e1, 0x3901, 0x4122, 0x4942, 0x3901, 0x3901, 0x51e6, 0x51e6, 
	0x3124, 0x1062, 0x0001, 0x0002, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0002, 0x0821, 0x1040, 0x28c1, 0x4963, 0x5182, 0x4941, 0x40e0, 0x40c0, 0x40e0, 
	0x4900, 0x5982, 0x82a5, 0x7a86, 0x5983, 0x3081, 0x1800, 0x2000, 0x2000, 0x2020, 0x2000, 0x2020, 0x2820, 0x2820, 0x2000, 0x2820, 
	0x2820, 0x2020, 0x2020, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2000, 0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1020, 0x1020, 0x1020, 0x1020, 0x1020, 0x1000, 0x1000, 0x2880, 0x4961, 
	0x6a45, 0x6a24, 0x61c3, 0x61c4, 0x4922, 0x2840, 0x2800, 0x2800, 0x3040, 0x4900, 0x61e3, 0x61e3, 0x61e2, 0x6203, 0x6225, 0x6246, 
	0x4963, 0x2880, 0x1800, 0x1000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 
	0x2020, 0x2020, 0x2020, 0x1820, 0x1820, 0x1820, 0x1800, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x3000, 0x3020, 0x3020, 0x3020, 
	0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2800, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3020, 0x3020, 0x2820, 0x2800, 0x2800, 0x2820, 0x3020, 0x3000, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2840, 0x3080, 0x3080, 0x30a0, 0x38e1, 0x4942, 0x51a3, 0x4942, 0x3901, 0x4984, 0x49a5, 
	0x3965, 0x18a3, 0x0001, 0x0002, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0023, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 
	0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0002, 0x0820, 0x1860, 0x30e1, 0x4983, 0x5162, 0x4921, 0x40c0, 0x38a0, 0x40c0, 
	0x4900, 0x61e3, 0x9348, 0x9349, 0x7246, 0x38e2, 0x1800, 0x2000, 0x2000, 0x2020, 0x2000, 0x2020, 0x2820, 0x2820, 0x2000, 0x2020, 
	0x2820, 0x2020, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2000, 0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x1020, 0x1020, 0x1020, 0x1020, 0x1000, 0x1000, 0x1820, 0x38e0, 0x51a2, 
	0x6a24, 0x6a04, 0x61a3, 0x59a3, 0x4102, 0x2820, 0x2800, 0x2820, 0x2800, 0x40c0, 0x61a3, 0x61c2, 0x61c2, 0x61c3, 0x6204, 0x6246, 
	0x59e4, 0x3902, 0x2020, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2020, 0x2020, 
	0x2020, 0x2020, 0x1820, 0x1820, 0x1820, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2800, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3020, 0x2820, 0x2820, 0x2800, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2040, 0x2860, 0x2860, 0x3080, 0x38c0, 0x4122, 0x51a3, 0x4962, 0x4121, 0x4122, 0x4123, 
	0x3924, 0x1883, 0x0001, 0x0002, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0001, 0x0820, 0x1860, 0x3102, 0x4983, 0x4942, 0x40e0, 0x38a0, 0x3880, 0x40c0, 
	0x4900, 0x69e3, 0x9328, 0x9349, 0x7267, 0x40e3, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2820, 0x2820, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2020, 0x2840, 0x2820, 0x2020, 0x2820, 0x2820, 
	0x2820, 0x2840, 0x2040, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1020, 0x1020, 0x1000, 0x1000, 0x1000, 0x0800, 0x1800, 0x4941, 0x6203, 
	0x61e4, 0x61e3, 0x59a3, 0x5163, 0x40e1, 0x2840, 0x2820, 0x2820, 0x2800, 0x38a0, 0x5982, 0x61c2, 0x61c2, 0x59a2, 0x61e3, 0x6225, 
	0x6226, 0x51a4, 0x2880, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2000, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x1820, 0x1820, 0x1820, 0x1820, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3820, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2800, 0x3020, 0x3020, 0x3840, 0x3840, 0x3840, 0x3820, 0x3820, 
	0x3820, 0x3820, 0x3020, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2020, 0x2860, 0x3080, 0x30a0, 0x38c0, 0x38e0, 0x4101, 0x4121, 0x4101, 0x38e0, 0x30c0, 
	0x2081, 0x1041, 0x0821, 0x0022, 0x0022, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0001, 0x0820, 0x2080, 0x3922, 0x51a4, 0x5183, 0x4921, 0x40c0, 0x40a0, 0x40c0, 
	0x4900, 0x5982, 0x6a04, 0x6a05, 0x5184, 0x30a2, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2020, 0x2820, 0x2820, 0x2020, 0x2820, 
	0x2000, 0x2000, 0x2000, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2020, 0x2840, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2840, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 0x1020, 0x1020, 0x1000, 0x1000, 0x1000, 0x1800, 0x2880, 0x59a2, 0x6a24, 
	0x61c3, 0x61c4, 0x61a3, 0x4922, 0x38a1, 0x2820, 0x2820, 0x2800, 0x2800, 0x3860, 0x4921, 0x61a2, 0x61e3, 0x5982, 0x59a3, 0x6204, 
	0x6a46, 0x5a05, 0x3902, 0x2040, 0x1800, 0x1800, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 
	0x2020, 0x1820, 0x1820, 0x1820, 0x1820, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3820, 0x3020, 0x3000, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2820, 0x3020, 0x3020, 0x3840, 0x3840, 0x3840, 0x3840, 0x3840, 
	0x3820, 0x3020, 0x3020, 0x2820, 0x2000, 0x2000, 0x2800, 0x2800, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2020, 0x2840, 0x3060, 0x3080, 0x3080, 0x38a0, 0x38a0, 0x38c0, 0x40e0, 0x5183, 0x51a4, 
	0x3944, 0x20a3, 0x0821, 0x0002, 0x0002, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0001, 0x0820, 0x20a1, 0x3943, 0x51c5, 0x59c4, 0x5183, 0x4100, 0x40c0, 0x48c0, 
	0x5100, 0x5121, 0x48e0, 0x38a0, 0x2860, 0x2020, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x1820, 0x1800, 0x1000, 0x1000, 0x1800, 0x1800, 0x2020, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 0x1020, 0x1020, 0x1000, 0x1000, 0x1000, 0x2880, 0x4141, 0x61e3, 0x6a04, 
	0x59a2, 0x61c4, 0x61c4, 0x4102, 0x3060, 0x2820, 0x2800, 0x2800, 0x2800, 0x3040, 0x40c0, 0x5982, 0x69e3, 0x5982, 0x5982, 0x59c3, 
	0x6225, 0x6225, 0x5184, 0x30a1, 0x1800, 0x1800, 0x1820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1800, 0x1800, 0x2000, 0x2000, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3820, 0x3000, 0x3000, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x3020, 0x3020, 0x3820, 0x3840, 0x3840, 0x3840, 
	0x3820, 0x3020, 0x3020, 0x2820, 0x2000, 0x2000, 0x2800, 0x2800, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2840, 0x2860, 0x30a0, 0x38a0, 0x38a0, 0x38a0, 0x3880, 0x4100, 0x7286, 0x8309, 
	0x6268, 0x3125, 0x0821, 0x0001, 0x0002, 0x0023, 0x0023, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 
	0x0023, 0x0023, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0021, 0x0821, 0x20a1, 0x3943, 0x49c5, 0x4984, 0x4101, 0x38c0, 0x3880, 0x48a0, 
	0x5141, 0x5982, 0x4921, 0x3880, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2020, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x1800, 0x1000, 0x1000, 0x1800, 0x1800, 0x2020, 0x2020, 0x2020, 0x2020, 0x2820, 0x2820, 
	0x2000, 0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2020, 0x2020, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1020, 0x1020, 0x1020, 0x1000, 0x1000, 0x1000, 0x1800, 0x38e0, 0x59c3, 0x6203, 0x61e3, 
	0x59a3, 0x61c4, 0x5984, 0x38c1, 0x2840, 0x2820, 0x2800, 0x2800, 0x2800, 0x2820, 0x3060, 0x5142, 0x69e3, 0x5982, 0x5162, 0x5161, 
	0x59c3, 0x6205, 0x6205, 0x4142, 0x2040, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1800, 0x2000, 0x2020, 0x2000, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3820, 0x3000, 0x3000, 0x3000, 0x3020, 0x2820, 0x2820, 0x2820, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3820, 0x3820, 0x3820, 
	0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x3020, 0x3020, 0x3020, 0x3840, 0x3020, 0x3040, 0x3040, 0x3020, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x30a1, 0x4963, 0x59a4, 0x51a3, 0x4921, 0x40e0, 0x5162, 0x8b08, 0x938b, 
	0x72c9, 0x3145, 0x0001, 0x0001, 0x0002, 0x0023, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 
	0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0022, 0x0841, 0x1881, 0x28e2, 0x3943, 0x30e2, 0x2880, 0x2840, 0x3860, 0x48c0, 
	0x69e3, 0x7246, 0x59a4, 0x38c1, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2020, 0x2020, 0x2820, 0x2840, 0x2820, 
	0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x1820, 0x1000, 0x1000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2000, 
	0x2000, 0x2000, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 
	0x1820, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x1000, 0x2060, 0x4142, 0x6204, 0x61e3, 0x61c3, 
	0x59a3, 0x5983, 0x4922, 0x3880, 0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x3020, 0x48e1, 0x59a3, 0x61a3, 0x5982, 0x5141, 
	0x5182, 0x61e4, 0x6a25, 0x51a4, 0x38e1, 0x2040, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x1820, 0x1800, 0x1800, 
	0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1800, 0x2000, 0x2020, 0x2020, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3000, 0x3000, 0x3000, 0x3020, 0x2820, 0x2820, 0x2020, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3820, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2820, 0x3020, 0x3040, 0x3840, 0x3040, 0x3040, 0x3040, 0x3020, 
	0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x1800, 0x30a1, 0x4964, 0x51c4, 0x51a3, 0x4921, 0x4921, 0x59a3, 0x82c7, 0x8309, 
	0x6227, 0x28e4, 0x0001, 0x0002, 0x0002, 0x0023, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 
	0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0042, 0x0842, 0x1061, 0x1881, 0x1861, 0x1840, 0x1820, 0x2000, 0x3840, 0x5920, 
	0x8ac7, 0x934a, 0x6a47, 0x4102, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2820, 0x2020, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x1820, 0x1800, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 
	0x1020, 0x1000, 0x1020, 0x1020, 0x1020, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x1820, 0x30e0, 0x5182, 0x61e4, 0x59a2, 0x59a2, 
	0x59a3, 0x5142, 0x40c1, 0x3060, 0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x3020, 0x3880, 0x5121, 0x61c4, 0x61c3, 0x5161, 
	0x5161, 0x59a3, 0x6204, 0x61e4, 0x4963, 0x30a0, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1820, 0x1820, 0x1820, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x2820, 0x2820, 0x2820, 0x2020, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2820, 0x3020, 0x3020, 0x3040, 0x3040, 0x3040, 0x3020, 0x2820, 
	0x2820, 0x2800, 0x2000, 0x2020, 0x2040, 0x2040, 0x2020, 0x2060, 0x28a1, 0x30a0, 0x3080, 0x3080, 0x4900, 0x59a3, 0x61e4, 0x59a3, 
	0x3902, 0x1861, 0x0801, 0x0002, 0x0002, 0x0023, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0043, 0x0042, 0x0842, 0x0841, 0x1040, 0x1020, 0x1000, 0x1000, 0x1800, 0x3040, 0x5100, 
	0x7a65, 0x82c8, 0x6205, 0x38e2, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1020, 0x1020, 0x1020, 
	0x1020, 0x1000, 0x1020, 0x1020, 0x1020, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x2880, 0x4962, 0x59c3, 0x59c3, 0x59a2, 0x59a3, 
	0x59a4, 0x4902, 0x3060, 0x3040, 0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x3020, 0x3040, 0x40a0, 0x59a3, 0x61e4, 0x59a2, 
	0x5181, 0x5182, 0x59c3, 0x61e4, 0x59c4, 0x4122, 0x2860, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x2820, 0x2820, 0x2820, 0x2000, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 0x2000, 0x2800, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 
	0x2800, 0x2000, 0x2000, 0x2020, 0x2040, 0x2040, 0x2040, 0x2040, 0x1840, 0x1820, 0x2000, 0x2000, 0x38c0, 0x5982, 0x61c3, 0x5183, 
	0x30c2, 0x1841, 0x0801, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0002, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0022, 0x0021, 0x0821, 0x0820, 0x0800, 0x0800, 0x1000, 0x1800, 0x2840, 0x48e0, 
	0x5982, 0x61e4, 0x5163, 0x38c1, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2020, 0x2020, 0x1820, 0x1800, 0x1800, 0x1800, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x1820, 0x1800, 0x1800, 0x1800, 0x1000, 0x1020, 0x1020, 0x1000, 0x1020, 
	0x1020, 0x1020, 0x1020, 0x1000, 0x1020, 0x1000, 0x1000, 0x1000, 0x1000, 0x2040, 0x3900, 0x59e3, 0x59c3, 0x5182, 0x59a2, 0x59a3, 
	0x5983, 0x40e2, 0x3040, 0x2820, 0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x3020, 0x2800, 0x3040, 0x5142, 0x61c4, 0x6203, 
	0x59a2, 0x5161, 0x5182, 0x59c3, 0x6204, 0x5183, 0x38e1, 0x2020, 0x1800, 0x1800, 0x1800, 0x2020, 0x1820, 0x1820, 0x1800, 0x1800, 
	0x1800, 0x1820, 0x1800, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2820, 0x3020, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3000, 0x2820, 0x2820, 0x2000, 0x2000, 0x2800, 0x2800, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x2820, 0x2820, 0x2000, 0x2000, 0x2800, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 
	0x2800, 0x2800, 0x2000, 0x2000, 0x2040, 0x2060, 0x2060, 0x1840, 0x1820, 0x1800, 0x1800, 0x1800, 0x3880, 0x5983, 0x7a65, 0x7246, 
	0x4964, 0x20a3, 0x0802, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0042, 0x0021, 0x0820, 0x0800, 0x0800, 0x0800, 0x1000, 0x2040, 0x38c0, 
	0x5182, 0x59c4, 0x5143, 0x30a0, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2020, 0x2020, 0x1820, 0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x1820, 0x1800, 0x1800, 0x1000, 0x1020, 0x1020, 0x1020, 0x1020, 0x1020, 
	0x1020, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x2040, 0x3921, 0x51a2, 0x59a2, 0x51a2, 0x5182, 0x59c3, 0x5983, 
	0x4922, 0x38a1, 0x2820, 0x2800, 0x2800, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2820, 0x2800, 0x2820, 0x38a0, 0x5162, 0x6a04, 
	0x61c3, 0x5181, 0x5161, 0x59a2, 0x61e4, 0x59c4, 0x4142, 0x2860, 0x1800, 0x1800, 0x1800, 0x2020, 0x2020, 0x1820, 0x1820, 0x1800, 
	0x1800, 0x1820, 0x1820, 0x1020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2820, 0x2820, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3020, 0x2820, 0x2800, 0x2000, 0x2000, 0x2800, 0x2800, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x3020, 0x2820, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2020, 0x2040, 0x2040, 0x2060, 0x2061, 0x1840, 0x1820, 0x1800, 0x1800, 0x40c0, 0x7245, 0x9b8a, 0x9bab, 
	0x72a9, 0x3945, 0x1022, 0x0002, 0x0002, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0042, 0x0021, 0x0021, 0x0000, 0x0000, 0x0800, 0x1000, 0x2040, 0x38c0, 
	0x59a3, 0x6a25, 0x59a4, 0x38e1, 0x1800, 0x1800, 0x1000, 0x1800, 0x1800, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2020, 0x1800, 0x1800, 0x1000, 0x1000, 0x1800, 0x1800, 0x1820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2020, 0x2020, 0x1820, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x1820, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x1020, 0x1020, 0x1020, 0x1000, 
	0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x2040, 0x38e0, 0x51a3, 0x59e3, 0x5182, 0x5182, 0x59a3, 0x61c4, 0x5163, 
	0x38c1, 0x3040, 0x2800, 0x2000, 0x2800, 0x2820, 0x2800, 0x2800, 0x2800, 0x2820, 0x2800, 0x2800, 0x2800, 0x2820, 0x40e0, 0x59c3, 
	0x61e3, 0x61c2, 0x5161, 0x5181, 0x59c3, 0x59e4, 0x51a3, 0x38e1, 0x2860, 0x1800, 0x1800, 0x1800, 0x2020, 0x1820, 0x1820, 0x1800, 
	0x1800, 0x1820, 0x1020, 0x1020, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2800, 0x2820, 0x3020, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3020, 0x3020, 0x2820, 0x2820, 0x2000, 0x2800, 0x2800, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x3020, 0x2820, 0x2020, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2040, 0x2060, 0x1861, 0x1861, 0x1820, 0x1800, 0x1800, 0x4101, 0x7266, 0xa3cb, 0xa3ec, 
	0x72c9, 0x3945, 0x0822, 0x0002, 0x0002, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 
	0x0002, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0043, 0x0042, 0x0022, 0x0021, 0x0000, 0x0000, 0x0000, 0x0800, 0x2040, 0x4100, 
	0x6a25, 0x7ac8, 0x7267, 0x4943, 0x2020, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2000, 0x2000, 0x2020, 0x2020, 0x1800, 0x1800, 0x1000, 0x1000, 0x1800, 0x1800, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x1820, 0x1820, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x1820, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x1020, 0x1020, 0x1000, 0x0800, 
	0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x38e0, 0x59c3, 0x59c3, 0x59a2, 0x5182, 0x59a2, 0x59c3, 0x61c4, 0x4943, 
	0x3060, 0x2800, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2800, 0x2820, 0x2820, 0x2820, 0x2800, 0x2000, 0x3060, 0x4921, 
	0x61e4, 0x6a24, 0x5982, 0x5161, 0x5182, 0x59c3, 0x59c4, 0x5183, 0x38e1, 0x2840, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 0x1820, 
	0x1820, 0x1820, 0x1020, 0x1020, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2800, 0x2800, 0x3020, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3000, 0x3020, 0x3020, 0x2840, 0x2820, 0x2000, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2000, 0x2020, 0x1820, 0x1840, 0x1840, 0x1840, 0x1820, 0x1800, 0x1800, 0x40e1, 0x6a25, 0x8b08, 0x7ac8, 
	0x51c5, 0x28a3, 0x0801, 0x0001, 0x0002, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0002, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0043, 0x0043, 0x0042, 0x0021, 0x0000, 0x0000, 0x0000, 0x0800, 0x1820, 0x38c0, 
	0x59c3, 0x7287, 0x7267, 0x4964, 0x2020, 0x1000, 0x1000, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x2020, 0x2020, 
	0x1800, 0x2020, 0x2020, 0x2020, 0x1800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x1820, 0x1820, 0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x2020, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2020, 0x1820, 0x1820, 0x1820, 0x1020, 0x1000, 0x0800, 0x0800, 0x1020, 0x1000, 0x1000, 0x1000, 
	0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1820, 0x30c0, 0x5182, 0x6204, 0x59a2, 0x5182, 0x5982, 0x59c3, 0x59c4, 0x5163, 0x38c1, 
	0x2820, 0x2000, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2800, 0x3080, 
	0x5182, 0x6a24, 0x61e3, 0x59a2, 0x5161, 0x5982, 0x59c3, 0x59e4, 0x5183, 0x38e1, 0x2860, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 
	0x1820, 0x1820, 0x1020, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2800, 0x2800, 0x3020, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3020, 0x3020, 0x3020, 0x3040, 0x2820, 0x2000, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x1820, 0x1820, 0x1840, 0x1040, 0x1820, 0x1000, 0x1000, 0x3080, 0x5182, 0x6a44, 0x6204, 
	0x3923, 0x1861, 0x0801, 0x0802, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0043, 0x0043, 0x0042, 0x0021, 0x0021, 0x0000, 0x0800, 0x0800, 0x1800, 0x2880, 
	0x4962, 0x6225, 0x6a47, 0x4964, 0x2020, 0x1000, 0x1000, 0x1820, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 
	0x1820, 0x1820, 0x2020, 0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x1820, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x2020, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1820, 0x1820, 0x1020, 0x1020, 0x1000, 0x0820, 0x0800, 0x0800, 0x0800, 0x1000, 0x1020, 
	0x1020, 0x1000, 0x1000, 0x1000, 0x1000, 0x28a0, 0x5183, 0x59e3, 0x59c2, 0x5161, 0x5161, 0x59a2, 0x61c3, 0x5183, 0x38c1, 0x2840, 
	0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2840, 0x2820, 0x2800, 0x2000, 0x2000, 
	0x40c0, 0x59a3, 0x6a04, 0x61e3, 0x5161, 0x5161, 0x59a2, 0x61e4, 0x59e4, 0x5183, 0x38e1, 0x2040, 0x1800, 0x1000, 0x1800, 0x1820, 
	0x1820, 0x1820, 0x1020, 0x1020, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2820, 0x2820, 0x3020, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3020, 0x3020, 0x3020, 0x2840, 0x2820, 0x2000, 0x2800, 0x2800, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x1820, 0x1840, 0x1840, 0x1040, 0x1820, 0x1000, 0x1000, 0x2020, 0x4120, 0x6203, 0x59e4, 
	0x3923, 0x2062, 0x0801, 0x0802, 0x0022, 0x0023, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0042, 0x0042, 0x0841, 0x0820, 0x0800, 0x0800, 0x1000, 0x2860, 
	0x5183, 0x6a67, 0x7288, 0x5184, 0x2020, 0x1000, 0x1000, 0x1000, 0x1820, 0x1820, 0x1820, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 
	0x1820, 0x1820, 0x1820, 0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x1820, 0x1820, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1820, 0x1820, 0x1020, 0x1020, 0x1000, 0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 0x1020, 
	0x1000, 0x0800, 0x1000, 0x1820, 0x30c0, 0x4962, 0x59e4, 0x59c3, 0x5161, 0x5162, 0x59a2, 0x61c3, 0x5983, 0x4102, 0x3060, 0x2000, 
	0x2800, 0x2800, 0x2820, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2840, 0x2840, 0x2820, 0x2000, 0x2000, 
	0x2840, 0x40e0, 0x59a3, 0x61e4, 0x61c3, 0x5982, 0x5161, 0x59a2, 0x59c3, 0x59e4, 0x4963, 0x38e1, 0x2040, 0x1800, 0x1000, 0x1000, 
	0x1820, 0x1820, 0x1020, 0x1020, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x2000, 0x2820, 0x2820, 0x3020, 0x3000, 0x3000, 
	0x3000, 0x3000, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 0x2800, 0x2800, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x1820, 0x1840, 0x1840, 0x1840, 0x1820, 0x1000, 0x1000, 0x2840, 0x4941, 0x7ac7, 0x8308, 
	0x5a06, 0x28e3, 0x0801, 0x0001, 0x0002, 0x0022, 0x0002, 0x0002, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0042, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0042, 0x0841, 0x0820, 0x0800, 0x0800, 0x1000, 0x2880, 
	0x59e4, 0x72a8, 0x7288, 0x4964, 0x2020, 0x1000, 0x1000, 0x1000, 0x1800, 0x1820, 0x1820, 0x1820, 0x1800, 0x1800, 0x1800, 0x1820, 
	0x1820, 0x1820, 0x1820, 0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x1820, 0x1820, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x2000, 0x2000, 0x2000, 0x2000, 0x1820, 0x1820, 0x1820, 0x1820, 0x1020, 0x1000, 0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 
	0x1000, 0x1000, 0x1840, 0x30c0, 0x4962, 0x59e3, 0x59c3, 0x5182, 0x5161, 0x59a2, 0x59c3, 0x59a3, 0x4922, 0x3080, 0x2820, 0x2000, 
	0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 
	0x2000, 0x2840, 0x4101, 0x59a3, 0x61e4, 0x59c3, 0x5982, 0x5162, 0x5182, 0x59c3, 0x59c3, 0x4962, 0x38e0, 0x2060, 0x1800, 0x1800, 
	0x1800, 0x1820, 0x1820, 0x1020, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x2000, 0x2800, 0x2820, 0x3020, 0x3020, 0x3000, 
	0x3000, 0x3000, 0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 0x2020, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2800, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2000, 0x1800, 0x1820, 0x1840, 0x1841, 0x1840, 0x1820, 0x1000, 0x1000, 0x2840, 0x4961, 0x8b08, 0x938a, 
	0x6aa8, 0x3944, 0x0801, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0003, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0042, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0063, 0x0062, 0x0021, 0x0020, 0x0820, 0x0800, 0x1840, 0x38e0, 
	0x6225, 0x7ac8, 0x6a47, 0x4143, 0x2020, 0x1000, 0x1000, 0x1000, 0x1800, 0x1820, 0x1820, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1820, 0x1820, 0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x1820, 0x1820, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1020, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 
	0x1000, 0x1820, 0x30c0, 0x4983, 0x59e3, 0x59c3, 0x4961, 0x4961, 0x5182, 0x59c4, 0x59a4, 0x4942, 0x38a1, 0x2820, 0x2000, 0x2000, 
	0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 0x2820, 0x2020, 0x2000, 
	0x2000, 0x2000, 0x2840, 0x4101, 0x59c4, 0x6204, 0x61e3, 0x5182, 0x4941, 0x4961, 0x51a3, 0x59c3, 0x4983, 0x3901, 0x2860, 0x1820, 
	0x1000, 0x1800, 0x1820, 0x1020, 0x1020, 0x1020, 0x1000, 0x1000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2820, 0x3020, 0x3020, 0x3020, 
	0x3000, 0x3000, 0x3020, 0x3020, 0x3020, 0x2820, 0x2020, 0x2020, 0x2000, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2000, 0x1800, 0x1820, 0x1840, 0x1841, 0x1841, 0x1820, 0x1000, 0x1000, 0x2840, 0x4941, 0x7aa6, 0x8328, 
	0x6aa8, 0x3965, 0x1022, 0x0801, 0x0002, 0x0002, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0042, 0x0023, 0x0023, 0x0043, 0x0023, 0x0043, 0x0063, 0x0042, 0x0021, 0x0820, 0x0820, 0x0800, 0x1840, 0x38e0, 
	0x5a05, 0x6a67, 0x59e5, 0x4102, 0x2020, 0x1800, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1820, 0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x2000, 0x2020, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x1820, 0x1820, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2020, 
	0x2000, 0x2000, 0x2020, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1020, 0x1000, 0x1000, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 
	0x2060, 0x38e1, 0x4962, 0x51c3, 0x51a2, 0x4961, 0x4941, 0x5182, 0x59c3, 0x5183, 0x4922, 0x30a1, 0x2840, 0x2000, 0x2000, 0x2000, 
	0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x2000, 0x3060, 0x40e1, 0x5183, 0x61e4, 0x59c3, 0x5182, 0x4941, 0x5162, 0x51a3, 0x51c3, 0x4983, 0x3901, 0x2880, 
	0x1820, 0x1000, 0x1000, 0x1000, 0x1020, 0x1020, 0x1000, 0x1000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2820, 0x3020, 0x3020, 0x3020, 
	0x3000, 0x3000, 0x3020, 0x3020, 0x3020, 0x2820, 0x2020, 0x2000, 0x2000, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2000, 0x1800, 0x1820, 0x1840, 0x1861, 0x1841, 0x1820, 0x1000, 0x1000, 0x2860, 0x5161, 0x7aa5, 0x8308, 
	0x6aa8, 0x3965, 0x1042, 0x0801, 0x0001, 0x0002, 0x0002, 0x0002, 0x0003, 0x0003, 0x0003, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0042, 0x0042, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0042, 0x0041, 0x0020, 0x0820, 0x1020, 0x1000, 0x1840, 0x30c0, 
	0x51a3, 0x6205, 0x59a4, 0x3902, 0x2040, 0x1800, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1820, 0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x2000, 0x2020, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x2000, 0x1820, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 
	0x2020, 0x1800, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1020, 0x1020, 0x1000, 0x0800, 0x1000, 0x1000, 0x1820, 0x2060, 
	0x38e1, 0x51a3, 0x51c3, 0x5182, 0x4121, 0x4121, 0x5182, 0x59a4, 0x59a4, 0x4122, 0x3080, 0x2020, 0x2000, 0x2000, 0x2000, 0x2020, 
	0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x2020, 0x2000, 0x2000, 0x2000, 0x2820, 0x40e1, 0x5183, 0x61e4, 0x59c3, 0x5182, 0x4961, 0x4962, 0x51a3, 0x51a3, 0x4983, 0x3921, 
	0x2880, 0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2820, 0x2820, 0x3020, 0x3020, 
	0x3000, 0x3000, 0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2000, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2020, 0x1800, 0x1820, 0x1840, 0x2061, 0x1861, 0x1820, 0x1000, 0x1000, 0x2880, 0x5182, 0x7aa5, 0x8307, 
	0x6a87, 0x4164, 0x1062, 0x0801, 0x0001, 0x0002, 0x0002, 0x0002, 0x0003, 0x0003, 0x0003, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0042, 0x0042, 0x0043, 0x0023, 0x0023, 0x0023, 0x0022, 0x0042, 0x0021, 0x0000, 0x0820, 0x1020, 0x1000, 0x1820, 0x2880, 
	0x4963, 0x6205, 0x59e5, 0x4123, 0x2060, 0x1820, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1820, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x2000, 0x2020, 0x2000, 0x2000, 0x2000, 
	0x2000, 0x1820, 0x1820, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 
	0x1820, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x0800, 0x0800, 0x1000, 0x1840, 0x28a0, 0x4122, 
	0x4983, 0x51a3, 0x4962, 0x4121, 0x4121, 0x4962, 0x59c4, 0x5184, 0x4102, 0x3080, 0x2020, 0x2000, 0x1800, 0x1800, 0x2020, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2840, 0x38c0, 0x5162, 0x59c3, 0x61e3, 0x59a3, 0x5182, 0x4961, 0x4962, 0x4982, 0x4983, 
	0x4142, 0x30e1, 0x2060, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x2000, 0x2800, 0x2820, 0x2820, 0x3020, 
	0x3000, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x2820, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2000, 0x1800, 0x1820, 0x2040, 0x2061, 0x2061, 0x1840, 0x1800, 0x1000, 0x2860, 0x5161, 0x7aa5, 0x82e7, 
	0x6246, 0x3923, 0x1021, 0x0801, 0x0001, 0x0002, 0x0002, 0x0002, 0x0003, 0x0003, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0042, 
	0x0042, 0x0042, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0042, 0x0042, 0x0021, 0x0000, 0x0800, 0x1020, 0x1020, 0x1820, 0x2860, 
	0x5183, 0x6a66, 0x6a46, 0x4964, 0x2860, 0x1820, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 0x1020, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x1800, 0x1800, 
	0x2000, 0x1820, 0x1820, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1820, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x2040, 0x30c1, 0x4142, 0x5183, 
	0x51a3, 0x4962, 0x4941, 0x4941, 0x4962, 0x5183, 0x5183, 0x4102, 0x3060, 0x2020, 0x1800, 0x1800, 0x1800, 0x2000, 0x2020, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2840, 0x38c0, 0x4942, 0x59c3, 0x59c3, 0x59a3, 0x4962, 0x4962, 0x4962, 0x51a3, 
	0x51a3, 0x4983, 0x3901, 0x2880, 0x1820, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x2000, 0x2800, 0x2800, 0x2820, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3000, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2000, 0x1800, 0x1820, 0x1840, 0x2061, 0x2061, 0x2060, 0x1800, 0x1000, 0x2860, 0x5161, 0x7a84, 0x7ac6, 
	0x6245, 0x3943, 0x1861, 0x0821, 0x0001, 0x0002, 0x0002, 0x0002, 0x0003, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0022, 0x0042, 0x0020, 0x0000, 0x0000, 0x0800, 0x1820, 0x2040, 0x2860, 
	0x59c4, 0x7ac8, 0x7aa8, 0x51a4, 0x2040, 0x1800, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1820, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x2040, 0x30c1, 0x4963, 0x59a4, 0x5163, 
	0x4922, 0x4121, 0x4962, 0x51a4, 0x59c4, 0x4983, 0x38c1, 0x2840, 0x2000, 0x2000, 0x2020, 0x2000, 0x2000, 0x2020, 0x2000, 0x2820, 
	0x2820, 0x2820, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2800, 0x2000, 0x2000, 0x2820, 0x2820, 0x2020, 0x2000, 0x2820, 0x3080, 0x4921, 0x59a3, 0x61e4, 0x59c3, 0x5182, 0x4942, 0x4942, 
	0x4982, 0x51a4, 0x49a4, 0x4143, 0x28a0, 0x1820, 0x1000, 0x1000, 0x1800, 0x1800, 0x2000, 0x2000, 0x2800, 0x2820, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2800, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2000, 0x1800, 0x1800, 0x1820, 0x2041, 0x2061, 0x2040, 0x1800, 0x1000, 0x2860, 0x5161, 0x7264, 0x7aa6, 
	0x6246, 0x49a5, 0x28e3, 0x1042, 0x0801, 0x0002, 0x0002, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0024, 0x0043, 0x0042, 0x0042, 0x0021, 0x0000, 0x0000, 0x0800, 0x1840, 0x2060, 0x3080, 
	0x5183, 0x6a46, 0x7287, 0x59a4, 0x2860, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1820, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1820, 0x1820, 0x1800, 0x1800, 0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1820, 0x30a1, 0x4102, 0x4943, 0x4943, 0x4942, 0x4942, 
	0x4942, 0x4963, 0x5163, 0x4963, 0x4123, 0x38c1, 0x2860, 0x2020, 0x2000, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2000, 
	0x2000, 0x2800, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x2000, 0x2840, 0x3080, 0x40e1, 0x4962, 0x59a3, 0x59c4, 0x59c3, 0x51a3, 
	0x4982, 0x4982, 0x4963, 0x4962, 0x4142, 0x30e1, 0x28a0, 0x2040, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2000, 0x2800, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2000, 0x1800, 0x1800, 0x1820, 0x1840, 0x2061, 0x1820, 0x1800, 0x1800, 0x3080, 0x5161, 0x6a23, 0x7ac6, 
	0x7ae8, 0x6288, 0x4186, 0x1882, 0x0001, 0x0002, 0x0002, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0044, 0x0043, 0x0042, 0x0042, 0x0021, 0x0000, 0x0800, 0x1000, 0x2060, 0x2880, 0x30c0, 
	0x4942, 0x61e4, 0x7266, 0x59c4, 0x30a1, 0x1820, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1820, 0x1820, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1820, 0x2880, 0x4123, 0x5184, 0x5184, 0x4922, 0x40c0, 0x4922, 
	0x5163, 0x5184, 0x4943, 0x38c1, 0x2860, 0x2000, 0x2000, 0x2000, 0x2020, 0x2020, 0x2020, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x2800, 0x2800, 0x2800, 0x3000, 0x3020, 0x2800, 0x2000, 
	0x2800, 0x2820, 0x2820, 0x2000, 0x1800, 0x1800, 0x2000, 0x2820, 0x2820, 0x2820, 0x2840, 0x38a0, 0x4942, 0x59c4, 0x61e4, 0x59c4, 
	0x51a3, 0x4942, 0x4141, 0x4142, 0x4983, 0x4983, 0x4163, 0x38e1, 0x2860, 0x1800, 0x1800, 0x1800, 0x2000, 0x2800, 0x2800, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2800, 0x2820, 0x2820, 0x3020, 0x3020, 0x3020, 0x2820, 
	0x2800, 0x2800, 0x2820, 0x2800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2000, 0x1800, 0x1800, 0x1820, 0x2060, 0x2061, 0x1820, 0x1800, 0x1800, 0x3080, 0x4941, 0x69e3, 0x82c7, 
	0x8b6a, 0x72ea, 0x49e7, 0x20a2, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0024, 0x0023, 0x0022, 0x0021, 0x0020, 0x0000, 0x0800, 0x1020, 0x2080, 0x30c0, 0x4101, 
	0x51a3, 0x6a45, 0x82c7, 0x6a26, 0x3902, 0x2040, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1000, 0x1800, 0x1800, 0x1820, 
	0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x2880, 0x38e2, 0x4943, 0x4943, 0x4943, 0x4922, 0x4942, 0x4942, 0x4942, 
	0x4922, 0x40e1, 0x3080, 0x2820, 0x2000, 0x2000, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x2800, 0x3000, 0x3000, 0x3000, 0x3000, 
	0x3000, 0x3840, 0x4080, 0x4080, 0x4880, 0x4880, 0x4880, 0x4880, 0x4880, 0x4080, 0x4080, 0x4060, 0x4060, 0x4060, 0x3840, 0x3840, 
	0x3840, 0x3840, 0x3020, 0x2800, 0x2000, 0x2000, 0x2800, 0x3020, 0x2820, 0x2800, 0x3020, 0x3060, 0x3080, 0x40e0, 0x4942, 0x59c4, 
	0x59e4, 0x59c4, 0x4982, 0x4141, 0x4121, 0x4122, 0x4942, 0x4963, 0x4122, 0x2880, 0x2000, 0x1800, 0x2000, 0x2000, 0x2000, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x3020, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2000, 0x1800, 0x1800, 0x1820, 0x2060, 0x2081, 0x2060, 0x1820, 0x1800, 0x2840, 0x40e0, 0x61c2, 0x7285, 
	0x72c8, 0x5a27, 0x3944, 0x1862, 0x0801, 0x0002, 0x0002, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0023, 0x0023, 0x0022, 0x0021, 0x0000, 0x0000, 0x0800, 0x1020, 0x28a0, 0x3900, 0x4121, 
	0x59a3, 0x7245, 0x82e8, 0x7266, 0x4143, 0x2060, 0x0800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1820, 0x2860, 0x3902, 0x4963, 0x4963, 0x4922, 0x4102, 0x4122, 0x4142, 0x4942, 0x4122, 
	0x38c0, 0x3060, 0x2800, 0x2000, 0x2000, 0x2800, 0x3000, 0x3000, 0x3820, 0x3840, 0x4040, 0x4060, 0x4880, 0x50a0, 0x50a0, 0x58c0, 
	0x58c0, 0x6120, 0x6960, 0x6980, 0x7180, 0x7180, 0x7180, 0x7180, 0x7180, 0x7180, 0x7180, 0x6980, 0x6960, 0x6960, 0x6140, 0x6140, 
	0x6160, 0x6140, 0x5900, 0x50e0, 0x48a0, 0x4080, 0x4080, 0x4060, 0x3840, 0x3020, 0x3040, 0x3020, 0x2800, 0x3040, 0x38a0, 0x4921, 
	0x5183, 0x59c3, 0x51a3, 0x4982, 0x4142, 0x4121, 0x4942, 0x4963, 0x4963, 0x4102, 0x30a1, 0x3060, 0x2820, 0x2000, 0x2000, 0x2000, 
	0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2020, 0x2820, 0x2820, 0x2820, 0x3020, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2000, 0x1800, 0x1800, 0x1820, 0x2060, 0x2081, 0x2060, 0x2020, 0x1800, 0x2820, 0x40e0, 0x61c2, 0x7265, 
	0x7287, 0x51e5, 0x30e3, 0x1041, 0x0801, 0x0802, 0x0002, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0023, 0x0043, 0x0042, 0x0021, 0x0000, 0x0000, 0x0800, 0x1020, 0x28a0, 0x3900, 0x4101, 
	0x5182, 0x6a25, 0x82c7, 0x7266, 0x4963, 0x2081, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1000, 0x1000, 0x1820, 0x2880, 0x3901, 0x4943, 0x4942, 0x4101, 0x4101, 0x4122, 0x4122, 0x4122, 0x38e1, 0x30a0, 
	0x2840, 0x2000, 0x2000, 0x2000, 0x2800, 0x3000, 0x3820, 0x4040, 0x4880, 0x58c0, 0x6100, 0x6920, 0x7140, 0x7980, 0x81c0, 0x8a01, 
	0x8a42, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 
	0x9283, 0x9263, 0x8a43, 0x8223, 0x7a03, 0x6981, 0x6120, 0x50e0, 0x4880, 0x3840, 0x3860, 0x3840, 0x3020, 0x3020, 0x3020, 0x3060, 
	0x38c0, 0x4941, 0x51a3, 0x59c3, 0x51a3, 0x4962, 0x4921, 0x4121, 0x4122, 0x4963, 0x4963, 0x4122, 0x38a1, 0x2840, 0x2000, 0x2000, 
	0x2820, 0x2840, 0x2840, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2020, 0x2000, 0x2000, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2000, 0x1800, 0x1800, 0x1820, 0x2060, 0x2080, 0x2060, 0x2020, 0x1800, 0x2860, 0x4100, 0x61c2, 0x7265, 
	0x72a7, 0x59e5, 0x30e3, 0x1020, 0x0000, 0x0002, 0x0002, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0042, 0x0021, 0x0000, 0x0000, 0x0800, 0x1020, 0x28c0, 0x38e0, 0x40e0, 
	0x5182, 0x6a24, 0x7aa6, 0x6a46, 0x4963, 0x2081, 0x0800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1820, 0x1800, 0x1800, 0x1800, 
	0x1000, 0x1000, 0x1800, 0x2080, 0x28e1, 0x3902, 0x4122, 0x4942, 0x4922, 0x40e1, 0x4101, 0x40e0, 0x38c0, 0x38a0, 0x3060, 0x2820, 
	0x2800, 0x2800, 0x3000, 0x3800, 0x4860, 0x58e0, 0x6120, 0x7180, 0x79e1, 0x8202, 0x8a43, 0x8a43, 0x8a43, 0x9243, 0x9243, 0x9243, 
	0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 
	0x8a43, 0x8a43, 0x8a43, 0x8a43, 0x8a43, 0x8a43, 0x8223, 0x7a03, 0x71a2, 0x6961, 0x6141, 0x5100, 0x48a0, 0x3840, 0x3000, 0x3000, 
	0x3020, 0x3860, 0x40e0, 0x4941, 0x5182, 0x5983, 0x5182, 0x4942, 0x4942, 0x4963, 0x4963, 0x4943, 0x4102, 0x38c1, 0x3060, 0x2820, 
	0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2820, 0x2820, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2000, 0x1800, 0x1800, 0x1820, 0x2060, 0x2080, 0x2060, 0x2020, 0x1800, 0x3060, 0x4900, 0x61c2, 0x7265, 
	0x72a7, 0x6226, 0x3944, 0x1861, 0x0800, 0x0001, 0x0002, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0042, 0x0042, 0x0021, 0x0000, 0x0000, 0x0800, 0x1020, 0x30c0, 0x3900, 0x38e0, 
	0x5162, 0x6a04, 0x7a86, 0x6a25, 0x4963, 0x2061, 0x0800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1000, 0x1800, 0x1800, 0x1800, 0x1820, 
	0x1820, 0x1820, 0x1820, 0x1020, 0x1020, 0x1000, 0x1000, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1820, 0x1820, 0x1000, 
	0x1000, 0x1820, 0x2080, 0x3102, 0x3963, 0x4142, 0x4122, 0x4101, 0x40e0, 0x40e0, 0x40c0, 0x38a0, 0x3060, 0x3020, 0x3020, 0x3000, 
	0x3820, 0x4040, 0x4880, 0x58e0, 0x6960, 0x81e1, 0x8a42, 0x9263, 0x9283, 0x9283, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 
	0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 
	0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9284, 0x9264, 0x9264, 0x8a43, 0x8203, 0x71c2, 0x6960, 0x58e0, 0x4880, 0x4040, 
	0x3820, 0x3820, 0x3840, 0x40a0, 0x4900, 0x5162, 0x5983, 0x5162, 0x4942, 0x4962, 0x4962, 0x4942, 0x4943, 0x4942, 0x4102, 0x30a0, 
	0x2040, 0x2020, 0x1800, 0x1800, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 
	0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2000, 0x1800, 0x1800, 0x1820, 0x2060, 0x2080, 0x2040, 0x1820, 0x1800, 0x3060, 0x4920, 0x61a2, 0x7244, 
	0x72a7, 0x6267, 0x49a5, 0x20a2, 0x0800, 0x0001, 0x0002, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0042, 0x0042, 0x0020, 0x0000, 0x0800, 0x0800, 0x1840, 0x30e0, 0x4100, 0x4100, 
	0x5182, 0x6a04, 0x7265, 0x6a25, 0x4984, 0x2081, 0x0800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1820, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1020, 
	0x1820, 0x1820, 0x1020, 0x1020, 0x1000, 0x1000, 0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 
	0x1840, 0x28c1, 0x3943, 0x3943, 0x3122, 0x3921, 0x3901, 0x40e1, 0x40c0, 0x38a0, 0x3060, 0x3000, 0x2800, 0x3800, 0x4860, 0x50a0, 
	0x6120, 0x7160, 0x81c1, 0x9242, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 
	0x8ae5, 0x8347, 0x8b88, 0x9388, 0x9388, 0x93a8, 0x93c8, 0x93a8, 0x93a8, 0x93c8, 0x93c8, 0x93a8, 0x93a8, 0x93a8, 0x93a8, 0x9367, 
	0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9243, 0x9243, 0x9243, 0x8a43, 0x8203, 0x79c2, 0x7181, 
	0x6120, 0x58e0, 0x4880, 0x4040, 0x3840, 0x4080, 0x48c0, 0x4921, 0x5162, 0x5183, 0x5182, 0x4942, 0x4942, 0x4963, 0x4963, 0x4122, 
	0x30c1, 0x2060, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 0x1820, 0x1800, 0x1800, 0x1820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2000, 0x1800, 0x1800, 0x1820, 0x2060, 0x2060, 0x2040, 0x1820, 0x1800, 0x3060, 0x4920, 0x61c2, 0x7244, 
	0x7286, 0x6a67, 0x49c6, 0x28c2, 0x1021, 0x0001, 0x0001, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0042, 0x0042, 0x0020, 0x0000, 0x0800, 0x0800, 0x1860, 0x3900, 0x4121, 0x4920, 
	0x5182, 0x6a04, 0x7245, 0x6a25, 0x4984, 0x2081, 0x0800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1020, 0x1020, 0x1020, 0x1020, 
	0x1020, 0x1020, 0x1020, 0x1020, 0x1000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 0x1840, 
	0x28e1, 0x3963, 0x4183, 0x3962, 0x3101, 0x38e0, 0x38c0, 0x3880, 0x3860, 0x3840, 0x3820, 0x3840, 0x4060, 0x50c0, 0x6940, 0x79c1, 
	0x8a43, 0x9243, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9264, 0x8b68, 0x9388, 0x9388, 0x9b88, 0x9b87, 
	0x93c8, 0x9408, 0x9408, 0x9408, 0x9408, 0x9408, 0x9408, 0x9408, 0x93e8, 0x9429, 0x9c49, 0x9c49, 0x9c49, 0x9c6a, 0x9c6a, 0x9c6a, 
	0x9ba8, 0x9388, 0x93a8, 0x93a8, 0x93c8, 0x92e5, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x8a23, 0x8a43, 0x8a23, 
	0x8202, 0x71a2, 0x6140, 0x50c0, 0x4880, 0x4060, 0x40a0, 0x48e0, 0x4900, 0x4941, 0x5162, 0x4962, 0x4962, 0x5183, 0x5183, 0x4983, 
	0x4143, 0x30c1, 0x2060, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1820, 0x1820, 0x1820, 0x2020, 0x2020, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2020, 0x2000, 0x1800, 0x1800, 0x1800, 0x1820, 0x2040, 0x2060, 0x2040, 0x1820, 0x1800, 0x3060, 0x4920, 0x61c2, 0x7244, 
	0x6a45, 0x6246, 0x49c5, 0x28e3, 0x1041, 0x0001, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0022, 0x0021, 0x0020, 0x0000, 0x0800, 0x1020, 0x2080, 0x3921, 0x4141, 0x4920, 
	0x5161, 0x61e3, 0x7245, 0x6a25, 0x4984, 0x2081, 0x0800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1020, 0x1020, 0x1020, 0x1020, 0x1020, 
	0x1020, 0x1020, 0x1020, 0x1020, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1860, 0x3102, 
	0x4184, 0x49a4, 0x4162, 0x3921, 0x3900, 0x38c0, 0x3880, 0x3000, 0x3000, 0x3820, 0x4880, 0x58e0, 0x6960, 0x8202, 0x9263, 0x9263, 
	0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x8ac5, 0x8b67, 0x9388, 0x9ba7, 0x9387, 0x8c09, 0x93e8, 0x8bc7, 0x93c7, 0x93c6, 
	0x93a6, 0x9385, 0x8b65, 0x8b65, 0x9365, 0x9385, 0x9385, 0x9385, 0x9385, 0x93a6, 0x93c6, 0x9bc6, 0x9be6, 0x9c07, 0x9c27, 0x9c08, 
	0x93c8, 0x93e8, 0x9409, 0x9429, 0x946a, 0x9be9, 0x9ba8, 0x9bc8, 0x9bc8, 0x9b87, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 
	0x8a43, 0x8a43, 0x8223, 0x79c2, 0x6961, 0x6120, 0x50e0, 0x48a0, 0x40a0, 0x48e0, 0x4920, 0x5161, 0x5182, 0x5182, 0x5162, 0x5183, 
	0x4983, 0x4143, 0x30e1, 0x2040, 0x1000, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1820, 0x1820, 0x1820, 
	0x1840, 0x2040, 0x2040, 0x2040, 0x1820, 0x1820, 0x1800, 0x1800, 0x2000, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1820, 0x1840, 0x1860, 0x1840, 0x1800, 0x1800, 0x3080, 0x4940, 0x61e2, 0x6a43, 
	0x6224, 0x5a05, 0x49a5, 0x28c2, 0x1041, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0022, 0x0021, 0x0000, 0x0000, 0x0800, 0x1020, 0x2080, 0x4141, 0x4961, 0x4940, 
	0x5982, 0x6a03, 0x7265, 0x6a45, 0x51a4, 0x2081, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1820, 
	0x1820, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1020, 0x1020, 0x1020, 0x1020, 0x1020, 
	0x0820, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0800, 0x0000, 0x0000, 0x0000, 0x0800, 0x1860, 0x28e2, 0x3963, 
	0x4183, 0x4162, 0x3921, 0x30e0, 0x30a0, 0x3060, 0x3020, 0x4040, 0x50a0, 0x6100, 0x7180, 0x8a02, 0x8a43, 0x9243, 0x9263, 0x9263, 
	0x9263, 0x9263, 0x9263, 0x8b06, 0x9367, 0x9367, 0x93a8, 0x8be8, 0x8be8, 0x93e7, 0x93c6, 0x8b85, 0x8b65, 0x8b44, 0x8b65, 0x8b85, 
	0x9385, 0x8b65, 0x8b65, 0x8b65, 0x8b85, 0x8b85, 0x8b85, 0x8b85, 0x8b85, 0x93a5, 0x93a6, 0x93c6, 0x93c6, 0x9be6, 0x9be6, 0x93a6, 
	0x8345, 0x8b65, 0x8345, 0x7b45, 0x7b46, 0x7b47, 0x7b67, 0x83a9, 0x942a, 0x9c4a, 0x9b88, 0x9bc8, 0xa409, 0x9284, 0x9263, 0x9263, 
	0x9263, 0x9263, 0x8a43, 0x8a23, 0x8202, 0x79a2, 0x7181, 0x6140, 0x5920, 0x50e0, 0x48e0, 0x48e0, 0x4900, 0x5121, 0x4941, 0x5162, 
	0x51a3, 0x4984, 0x4143, 0x30c1, 0x1840, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 0x1020, 
	0x1820, 0x1820, 0x1840, 0x1840, 0x1840, 0x1820, 0x1820, 0x1800, 0x1800, 0x2020, 0x2020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 
	0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1820, 0x1840, 0x1860, 0x2040, 0x1820, 0x1800, 0x3080, 0x4940, 0x61e2, 0x7244, 
	0x6a24, 0x6226, 0x51c5, 0x30e3, 0x1041, 0x0000, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 0x0022, 0x0022, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0021, 0x0000, 0x0000, 0x0800, 0x1000, 0x2080, 0x4141, 0x5181, 0x5160, 
	0x59a2, 0x6a24, 0x7a86, 0x6a46, 0x51a4, 0x2081, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 
	0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0820, 0x0820, 0x0800, 0x0800, 
	0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1040, 0x28e2, 0x3963, 0x4183, 
	0x3942, 0x30e0, 0x30c0, 0x3080, 0x3060, 0x3040, 0x4060, 0x60e0, 0x7180, 0x8a02, 0x9243, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 
	0x9263, 0x9347, 0x9367, 0x8bc8, 0x8be8, 0x8bc7, 0x8386, 0x8365, 0x8364, 0x8b65, 0x9385, 0x8b85, 0x8b65, 0x8325, 0x8345, 0x8b86, 
	0x8b86, 0x8ba6, 0x8ba7, 0x8bc7, 0x8bc8, 0x8bc8, 0x8be8, 0x8be8, 0x8be8, 0x8be8, 0x8be7, 0x8bc7, 0x8bc7, 0x8bc7, 0x8bc7, 0x8ba6, 
	0x8365, 0x8b85, 0x8b85, 0x8345, 0x7b05, 0x6ac4, 0x6a84, 0x6aa4, 0x6ac5, 0x7327, 0x7b68, 0x83e9, 0xa4ac, 0x9ba8, 0xa3c8, 0x92c4, 
	0x9263, 0x9263, 0x9263, 0x9263, 0x9243, 0x8a23, 0x8a03, 0x79c2, 0x71a2, 0x6140, 0x50e0, 0x48a0, 0x48c0, 0x48e0, 0x4900, 0x4941, 
	0x5163, 0x51a3, 0x4984, 0x4143, 0x28c1, 0x1020, 0x0800, 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 
	0x1000, 0x1020, 0x1020, 0x1020, 0x1040, 0x1820, 0x1820, 0x1820, 0x1820, 0x2020, 0x2020, 0x2020, 0x2820, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1000, 0x1820, 0x1840, 0x2060, 0x2040, 0x2020, 0x2000, 0x3080, 0x4940, 0x6a02, 0x7264, 
	0x6a65, 0x6a66, 0x5a06, 0x3103, 0x1041, 0x0000, 0x0001, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0021, 0x0000, 0x0000, 0x0800, 0x1000, 0x2080, 0x4141, 0x5181, 0x5161, 
	0x61c2, 0x7244, 0x7aa6, 0x7266, 0x51a4, 0x2080, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 
	0x1000, 0x1000, 0x1000, 0x1020, 0x1000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x0000, 0x0000, 0x0800, 0x1860, 0x3102, 0x3963, 0x4183, 0x4142, 
	0x38e0, 0x3060, 0x2820, 0x2820, 0x3840, 0x48c0, 0x6960, 0x81e2, 0x8a23, 0x9243, 0x9263, 0x9263, 0x9263, 0x9263, 0x9284, 0x9347, 
	0x9326, 0x8bc8, 0x8bc8, 0x8386, 0x8344, 0x8324, 0x8344, 0x8364, 0x8385, 0x8b85, 0x8ba6, 0x8bc7, 0x8bc7, 0x8387, 0x8387, 0x83a7, 
	0x8ba7, 0x8bc8, 0x8bc8, 0x8be8, 0x93e8, 0x93e9, 0x93e8, 0x9408, 0x9409, 0x9409, 0x9408, 0x9408, 0x9408, 0x9408, 0x93e8, 0x8be8, 
	0x8ba7, 0x8be8, 0x8be8, 0x8bc7, 0x8ba7, 0x8386, 0x8345, 0x7b05, 0x72c4, 0x6264, 0x5a63, 0x6284, 0x6b07, 0x7b68, 0x8c2a, 0x93a8, 
	0x9b87, 0x9ae5, 0x9263, 0x9263, 0x9263, 0x9263, 0x9243, 0x81e2, 0x79c2, 0x79e2, 0x69a1, 0x5900, 0x50e0, 0x48e0, 0x48c0, 0x40e0, 
	0x4901, 0x4962, 0x51a3, 0x49a4, 0x4143, 0x28a1, 0x1820, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 
	0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 0x1020, 0x1820, 0x1820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 
	0x2020, 0x2020, 0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1840, 0x2060, 0x2040, 0x1820, 0x1800, 0x2860, 0x4920, 0x6a23, 0x7aa5, 
	0x7aa6, 0x72a7, 0x5a26, 0x3103, 0x1041, 0x0001, 0x0001, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0021, 0x0000, 0x0000, 0x0800, 0x1020, 0x2880, 0x4141, 0x5182, 0x59a1, 
	0x61e3, 0x7244, 0x7aa6, 0x6a45, 0x4984, 0x2080, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 
	0x1000, 0x1000, 0x1000, 0x1000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x1000, 0x2080, 0x3102, 0x4143, 0x4143, 0x4122, 0x38e0, 
	0x3080, 0x3040, 0x3840, 0x4880, 0x5900, 0x71a1, 0x8a43, 0x9243, 0x9243, 0x9263, 0x9263, 0x9263, 0x92a4, 0x9326, 0x9326, 0x8bc8, 
	0x8386, 0x7b25, 0x7b04, 0x8324, 0x8344, 0x8365, 0x8386, 0x8ba7, 0x8be7, 0x8bc7, 0x8bc7, 0x8bc7, 0x8bc8, 0x83a8, 0x7b67, 0x8367, 
	0x8367, 0x8367, 0x8367, 0x8367, 0x8367, 0x8367, 0x8366, 0x8b87, 0x8b87, 0x8ba7, 0x8ba7, 0x93c7, 0x93e7, 0x8bc7, 0x83a8, 0x83a8, 
	0x8388, 0x8bc8, 0x8be8, 0x8be8, 0x8be8, 0x93e8, 0x9408, 0x8be8, 0x83a7, 0x7b46, 0x7b25, 0x6ae4, 0x6284, 0x5a23, 0x62c5, 0x7b68, 
	0x8c0a, 0x93a8, 0x9346, 0x92e5, 0x9263, 0x9263, 0x9263, 0x9263, 0x81e2, 0x8202, 0x79e2, 0x6981, 0x6161, 0x5940, 0x5120, 0x48e0, 
	0x40c0, 0x4901, 0x5182, 0x51c4, 0x49a4, 0x4143, 0x28a1, 0x1820, 0x1000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 
	0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 
	0x1820, 0x1820, 0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1840, 0x1860, 0x2040, 0x1820, 0x1800, 0x2860, 0x4920, 0x61e2, 0x7264, 
	0x7265, 0x6a65, 0x51e4, 0x3102, 0x1861, 0x0801, 0x0001, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0021, 0x0000, 0x0000, 0x0800, 0x1020, 0x28a0, 0x4141, 0x51a2, 0x59e2, 
	0x6203, 0x7244, 0x7a85, 0x6a25, 0x4983, 0x2080, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 
	0x1000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x1000, 0x2081, 0x3923, 0x4164, 0x4143, 0x38e1, 0x3080, 0x3060, 
	0x3860, 0x4080, 0x50c0, 0x7180, 0x8a42, 0x9283, 0x9263, 0x9263, 0x9263, 0x9263, 0x92c5, 0x8ae5, 0x8b26, 0x8bc8, 0x8366, 0x7ae4, 
	0x7b03, 0x7b24, 0x8345, 0x8b86, 0x8ba7, 0x83a7, 0x83a7, 0x83c7, 0x8be8, 0x8be8, 0x8bc7, 0x8ba7, 0x8367, 0x7306, 0x6285, 0x5a44, 
	0x49e4, 0x1904, 0x1904, 0x18e3, 0x18e3, 0x18e3, 0x1904, 0x2124, 0x1904, 0x1904, 0x1904, 0x2104, 0x2124, 0x2124, 0x1903, 0x1904, 
	0x6286, 0x6ae6, 0x6b07, 0x7327, 0x7327, 0x7b68, 0x83a8, 0x83c8, 0x8be8, 0x8be8, 0x8be8, 0x8387, 0x7b46, 0x7b25, 0x6ac4, 0x6264, 
	0x6aa5, 0x7347, 0x83a8, 0x8b88, 0x9326, 0x9b46, 0x9263, 0x9263, 0x9263, 0x9263, 0x8a02, 0x8202, 0x7a03, 0x71e3, 0x69c2, 0x5940, 
	0x40a0, 0x40c0, 0x4921, 0x51a3, 0x51c4, 0x51c4, 0x4142, 0x28a0, 0x1820, 0x1000, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 0x1020, 0x1020, 0x1020, 0x1820, 0x1820, 0x1820, 
	0x1820, 0x1820, 0x1820, 0x1800, 0x1800, 0x1000, 0x1000, 0x1820, 0x1860, 0x1840, 0x1820, 0x2020, 0x3080, 0x4920, 0x59a1, 0x61e2, 
	0x59e3, 0x59e3, 0x49a3, 0x3102, 0x1881, 0x0821, 0x0001, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0021, 0x0000, 0x0000, 0x0800, 0x1820, 0x28a0, 0x3920, 0x4981, 0x59a1, 
	0x61e2, 0x6a03, 0x7224, 0x6204, 0x4983, 0x2881, 0x0800, 0x0800, 0x0800, 0x1000, 0x1020, 0x1020, 0x0800, 0x0800, 0x0800, 0x0800, 
	0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x1000, 0x2060, 0x38e2, 0x4143, 0x4122, 0x40e1, 0x3880, 0x3040, 0x3840, 
	0x48a0, 0x6140, 0x79e2, 0x8a43, 0x8a43, 0x9263, 0x9263, 0x9263, 0x9263, 0x92c5, 0x8b67, 0x8387, 0x7b05, 0x7ae4, 0x7b04, 0x8324, 
	0x8365, 0x8386, 0x83a7, 0x83a7, 0x83a8, 0x83c8, 0x83a8, 0x7b66, 0x7b26, 0x6ae5, 0x6aa4, 0x3184, 0x2144, 0x1904, 0x10e4, 0x10c4, 
	0x10c4, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x10e4, 0x1924, 0x1904, 0x10e3, 0x18e3, 0x3164, 0x5245, 0x5aa6, 0x6b07, 0x7368, 0x83a8, 0x83c8, 0x8be9, 0x8c08, 0x8386, 0x7b25, 
	0x6ac4, 0x6264, 0x5a64, 0x6ae6, 0x8be9, 0xa46a, 0x9b46, 0xa387, 0x9264, 0x9263, 0x9263, 0x9263, 0x8a23, 0x8223, 0x7a03, 0x71c3, 
	0x6161, 0x5120, 0x48e0, 0x4100, 0x4962, 0x59c4, 0x51a4, 0x4142, 0x28a0, 0x1820, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x1020, 
	0x1820, 0x1820, 0x1020, 0x1000, 0x1000, 0x1000, 0x1000, 0x1840, 0x1860, 0x1840, 0x1820, 0x2020, 0x30c0, 0x5161, 0x61c2, 0x61e2, 
	0x59c2, 0x59c3, 0x51c3, 0x49a4, 0x3124, 0x1882, 0x0822, 0x0001, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0021, 0x0000, 0x0000, 0x0800, 0x1020, 0x2880, 0x3900, 0x4941, 0x5181, 
	0x61c2, 0x6a03, 0x6a03, 0x6204, 0x51c4, 0x30c2, 0x1020, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 
	0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x1000, 0x2060, 0x38e2, 0x4122, 0x4122, 0x40c0, 0x3880, 0x3860, 0x4060, 0x48a0, 
	0x6940, 0x8202, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 0x92e5, 0x92e5, 0x8b66, 0x8366, 0x72c4, 0x72a4, 0x7b04, 0x8b85, 0x8ba6, 
	0x8387, 0x7b87, 0x83a7, 0x7b87, 0x7b46, 0x6ac5, 0x6284, 0x5204, 0x1903, 0x1904, 0x18e4, 0x08a3, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x08a3, 0x18e3, 0x18e3, 0x1903, 0x39a4, 0x5245, 0x6b07, 0x83c9, 0x83e9, 0x8be8, 0x8be8, 
	0x7b66, 0x6ac5, 0x6a84, 0x6284, 0x6284, 0x7b47, 0x9c6a, 0xb54d, 0x9b67, 0x9284, 0x9263, 0x9263, 0x9263, 0x8a23, 0x8223, 0x8224, 
	0x7a03, 0x6982, 0x5100, 0x40c0, 0x4900, 0x5162, 0x59a3, 0x51a4, 0x4122, 0x2880, 0x1820, 0x1000, 0x0800, 0x0800, 0x0800, 0x0800, 
	0x0800, 0x0000, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 
	0x1020, 0x1020, 0x1000, 0x1000, 0x1000, 0x1000, 0x1020, 0x1840, 0x2060, 0x1840, 0x1820, 0x2020, 0x38c0, 0x5181, 0x6a02, 0x6a23, 
	0x6202, 0x6203, 0x5a24, 0x5a46, 0x41a6, 0x20c3, 0x0842, 0x0001, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0021, 0x0000, 0x0000, 0x0800, 0x1020, 0x2080, 0x3900, 0x4941, 0x5181, 
	0x61e2, 0x7223, 0x7223, 0x7265, 0x6246, 0x3943, 0x1861, 0x1020, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x1000, 0x2060, 0x30e1, 0x4122, 0x4922, 0x40c0, 0x3860, 0x3820, 0x4020, 0x58c0, 0x7180, 
	0x8a23, 0x9243, 0x9263, 0x9263, 0x9263, 0x9263, 0x92e5, 0x93e9, 0x8ba7, 0x7b04, 0x7ae3, 0x8324, 0x7b25, 0x7b25, 0x8366, 0x8387, 
	0x83c8, 0x7b87, 0x6ae5, 0x5a44, 0x39a4, 0x2124, 0x2944, 0x1924, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x08a3, 0x18e3, 0x10e3, 0x10e3, 0x39a4, 0x5ac6, 0x7b88, 0x8be9, 
	0x83c8, 0x8387, 0x7b46, 0x7325, 0x72e4, 0x72c4, 0x72e5, 0x9408, 0xa4cb, 0x9b67, 0x9b46, 0x9aa4, 0x9263, 0x9263, 0x8a23, 0x8203, 
	0x8203, 0x7a03, 0x69a2, 0x5920, 0x48e0, 0x40c0, 0x4921, 0x5182, 0x5183, 0x4122, 0x2880, 0x1820, 0x0800, 0x0800, 0x0800, 0x0800, 
	0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 
	0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1840, 0x2060, 0x2040, 0x2040, 0x2040, 0x38c0, 0x5181, 0x6a22, 0x7264, 
	0x7284, 0x7285, 0x6a85, 0x6267, 0x41a5, 0x20c3, 0x0821, 0x0001, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0021, 0x0000, 0x0000, 0x0800, 0x1020, 0x2080, 0x3900, 0x5181, 0x59c2, 
	0x6a23, 0x7a64, 0x7a64, 0x7a85, 0x6a86, 0x4164, 0x1861, 0x1020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0800, 0x0800, 0x0800, 0x1000, 0x1840, 0x30c1, 0x4122, 0x4921, 0x40e0, 0x4080, 0x3840, 0x4860, 0x58e0, 0x79a0, 0x9263, 
	0x9243, 0x9263, 0x9263, 0x9264, 0x92e5, 0x92a4, 0x93e8, 0x8345, 0x7ae3, 0x8324, 0x8b65, 0x8366, 0x7b46, 0x7b27, 0x7b67, 0x7b67, 
	0x6aa4, 0x5a44, 0x3184, 0x2104, 0x08a4, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x1904, 0x18e3, 0x3163, 0x5a66, 
	0x7328, 0x7ba8, 0x83c8, 0x8bc8, 0x8ba7, 0x7b45, 0x7b04, 0x72c4, 0x8366, 0x9c4a, 0xb54d, 0xa3e9, 0x92a4, 0x9263, 0x9263, 0x8a23, 
	0x81e2, 0x8223, 0x7a03, 0x69c2, 0x5940, 0x40a0, 0x40c0, 0x4900, 0x5183, 0x4963, 0x3902, 0x2080, 0x1000, 0x1000, 0x0800, 0x0800, 
	0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 
	0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x1820, 0x2040, 0x2040, 0x2040, 0x2040, 0x38c0, 0x5160, 0x61e1, 0x7243, 
	0x7284, 0x72a5, 0x6a85, 0x5a46, 0x4185, 0x18a3, 0x0821, 0x0001, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0021, 0x0000, 0x0000, 0x0800, 0x1000, 0x2080, 0x4120, 0x51a2, 0x6202, 
	0x7264, 0x7a85, 0x7a64, 0x7285, 0x6a86, 0x4163, 0x1860, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0800, 0x1000, 0x1000, 0x1840, 0x30a1, 0x4101, 0x4921, 0x40e0, 0x4080, 0x4060, 0x4860, 0x58e0, 0x8202, 0x9284, 0x9263, 
	0x9263, 0x9263, 0x9284, 0x9306, 0x944a, 0x8ba7, 0x7ae4, 0x8303, 0x8b64, 0x8b86, 0x8386, 0x83c8, 0x8be9, 0x7b47, 0x6264, 0x5203, 
	0x2943, 0x2985, 0x08a3, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x10c3, 0x18e3, 
	0x2943, 0x4a25, 0x7327, 0x8bea, 0x9409, 0x8bc7, 0x8bc7, 0x8345, 0x7b04, 0x7b05, 0x93c8, 0xa4cb, 0xa3e9, 0x92a4, 0x9263, 0x9263, 
	0x9263, 0x9243, 0x8223, 0x8244, 0x69c2, 0x5100, 0x4080, 0x4080, 0x4921, 0x5183, 0x4964, 0x30e2, 0x1840, 0x1000, 0x0800, 0x1000, 
	0x1000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 
	0x0800, 0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1820, 0x1820, 0x2020, 0x2040, 0x38c0, 0x5160, 0x59a0, 0x6a02, 
	0x6a43, 0x6a64, 0x6a65, 0x5a25, 0x3964, 0x1882, 0x0821, 0x0001, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0021, 0x0000, 0x0000, 0x0800, 0x1000, 0x2080, 0x4141, 0x59c2, 0x61e2, 
	0x6a43, 0x7264, 0x7243, 0x7265, 0x6a65, 0x3943, 0x1860, 0x0800, 0x0000, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0800, 0x1000, 0x1820, 0x2880, 0x3901, 0x4101, 0x40e0, 0x4080, 0x4040, 0x4860, 0x6100, 0x81c1, 0x9263, 0x9263, 0x9263, 
	0x9263, 0x9284, 0x9326, 0x9429, 0x8345, 0x7ae3, 0x8b64, 0x8ba5, 0x8365, 0x83a7, 0x8c09, 0x83c8, 0x6ae5, 0x5a44, 0x2944, 0x18e4, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x10c4, 0x2144, 0x3164, 0x6286, 0x83c9, 0x946a, 0x9409, 0x93e7, 0x8ba6, 0x8324, 0x7ae4, 0x8b66, 0x9c4a, 0xa3e8, 0x92a4, 0x9263, 
	0x9263, 0x9263, 0x9263, 0x8223, 0x7a03, 0x69a2, 0x5100, 0x40a0, 0x40c0, 0x4942, 0x51a4, 0x3903, 0x2060, 0x1800, 0x1000, 0x1000, 
	0x1000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 
	0x0800, 0x0800, 0x0800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x2000, 0x2020, 0x38c0, 0x5140, 0x61c1, 0x6a02, 
	0x6a23, 0x6a64, 0x6a64, 0x6245, 0x4184, 0x18a2, 0x0821, 0x0001, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0021, 0x0000, 0x0000, 0x0800, 0x1000, 0x2080, 0x4141, 0x59c2, 0x61e1, 
	0x6a23, 0x7263, 0x7243, 0x6a44, 0x6224, 0x3942, 0x1860, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 
	0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 
	0x0800, 0x0800, 0x1000, 0x2040, 0x30c0, 0x4101, 0x40e0, 0x40a0, 0x4060, 0x4880, 0x60e0, 0x81e0, 0x9263, 0x9263, 0x9263, 0x9263, 
	0x9263, 0x9326, 0x9408, 0x7b04, 0x8303, 0x93a5, 0x8b85, 0x8386, 0x8c08, 0x8be8, 0x7305, 0x5a44, 0x39a5, 0x2985, 0x0083, 0x0083, 
	0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x10c4, 0x2124, 0x2944, 0x6ae6, 0x942a, 0x9c8a, 0x9408, 0x93e7, 0x8b85, 0x8324, 0x8b45, 0x9be8, 0xa3e8, 0x9284, 
	0x9263, 0x9263, 0x9263, 0x9263, 0x8223, 0x8224, 0x69c2, 0x5920, 0x40c0, 0x4901, 0x5163, 0x4123, 0x30a1, 0x2020, 0x1000, 0x1000, 
	0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 
	0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 0x38a0, 0x5140, 0x61c1, 0x6a22, 
	0x6a22, 0x6a43, 0x6a64, 0x6246, 0x49a5, 0x20a2, 0x0821, 0x0001, 0x0002, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0021, 0x0000, 0x0000, 0x0800, 0x1020, 0x2080, 0x4120, 0x51a1, 0x61e1, 
	0x7263, 0x7aa4, 0x7263, 0x6a43, 0x6204, 0x4142, 0x2880, 0x1820, 0x1000, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 
	0x1820, 0x1020, 0x1820, 0x1820, 0x1820, 0x1840, 0x1840, 0x1820, 0x1820, 0x1820, 0x1820, 0x1840, 0x1840, 0x1020, 0x1020, 0x1020, 
	0x1000, 0x1000, 0x1800, 0x2860, 0x38c0, 0x40c0, 0x4080, 0x4080, 0x50a0, 0x6920, 0x81c0, 0x9263, 0x9263, 0x9263, 0x9263, 0x9263, 
	0x9325, 0x8ba6, 0x7b03, 0x8b44, 0x93c5, 0x8365, 0x83a7, 0x9449, 0x83a7, 0x6ac4, 0x4a24, 0x2144, 0x0083, 0x0083, 0x0083, 0x0083, 
	0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0883, 0x2924, 0x6265, 0x8bc8, 0xa4ab, 0x9c49, 0x9c28, 0x93e6, 0x8b65, 0x8345, 0x93c7, 0xa3e8, 
	0x9284, 0x9263, 0x9263, 0x9263, 0x9263, 0x8223, 0x8244, 0x7203, 0x5941, 0x48e0, 0x40e1, 0x4102, 0x38e1, 0x2860, 0x1800, 0x1800, 
	0x1800, 0x2020, 0x2040, 0x2040, 0x2860, 0x2860, 0x2060, 0x2060, 0x2040, 0x2040, 0x2040, 0x2040, 0x2020, 0x2040, 0x2040, 0x2040, 
	0x2040, 0x2040, 0x2040, 0x2860, 0x2860, 0x2860, 0x2860, 0x2880, 0x2880, 0x2860, 0x2840, 0x2840, 0x38a0, 0x5120, 0x61c0, 0x6a22, 
	0x6a22, 0x7243, 0x6a64, 0x6245, 0x49a4, 0x20a2, 0x0821, 0x0000, 0x0002, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0842, 0x0821, 0x0000, 0x0000, 0x0800, 0x1020, 0x2880, 0x4140, 0x51a1, 0x61e2, 
	0x7243, 0x7a84, 0x7263, 0x6a43, 0x61e3, 0x4962, 0x38e0, 0x30a0, 0x2880, 0x30a0, 0x30a0, 0x30a0, 0x30a0, 0x30a0, 0x30a0, 0x30a0, 
	0x28a0, 0x28a0, 0x30a0, 0x30a0, 0x30c0, 0x30c0, 0x30c0, 0x30c0, 0x30a0, 0x28a0, 0x28a0, 0x28c0, 0x28c0, 0x28c0, 0x28a0, 0x20a0, 
	0x2060, 0x2040, 0x2040, 0x3080, 0x38a0, 0x4080, 0x4880, 0x50c0, 0x6940, 0x8a01, 0x9a83, 0x9263, 0x9263, 0x9263, 0x9263, 0x9346, 
	0x8b85, 0x8303, 0x8b64, 0x93a6, 0x8366, 0x8c09, 0x946a, 0x7325, 0x62a4, 0x4a05, 0x10e4, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 
	0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x2944, 0x49e3, 0x7b27, 0x9c4a, 0xa48a, 0x9c48, 0x9c07, 0x93a6, 0x8b44, 0x93a6, 
	0xa409, 0x9264, 0x9263, 0x9263, 0x9263, 0x9263, 0x8243, 0x8244, 0x69e2, 0x5941, 0x40e0, 0x40e0, 0x40e0, 0x30a0, 0x2860, 0x2840, 
	0x3080, 0x38c0, 0x38c0, 0x38e0, 0x38e0, 0x38e0, 0x38e0, 0x38e0, 0x38e0, 0x38e0, 0x38c0, 0x38c0, 0x38c0, 0x38c0, 0x38c0, 0x38c0, 
	0x38c0, 0x38c0, 0x38e0, 0x38e0, 0x38e0, 0x38e0, 0x38e0, 0x38e0, 0x40e0, 0x40e0, 0x38c0, 0x3880, 0x40c0, 0x5140, 0x61c0, 0x7222, 
	0x7243, 0x7243, 0x6a64, 0x6245, 0x49a4, 0x28c2, 0x1041, 0x0001, 0x0001, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 
	0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0003, 0x0002, 0x0002, 0x0002, 0x0002, 0x0021, 0x0841, 0x0821, 0x0000, 0x0000, 0x0800, 0x1020, 0x28a0, 0x4141, 0x59c2, 0x61e2, 
	0x6a22, 0x7243, 0x7263, 0x6a23, 0x61e2, 0x5182, 0x4941, 0x4921, 0x4921, 0x4921, 0x4921, 0x4921, 0x4921, 0x4941, 0x4941, 0x4941, 
	0x4941, 0x4941, 0x4941, 0x4941, 0x4941, 0x4941, 0x4941, 0x4941, 0x4941, 0x4141, 0x4141, 0x4141, 0x4141, 0x4141, 0x4142, 0x3921, 
	0x30e1, 0x30a0, 0x3080, 0x3080, 0x3860, 0x4060, 0x50a0, 0x6940, 0x8a01, 0x9aa3, 0x9263, 0x9263, 0x9263, 0x9263, 0x9366, 0x8365, 
	0x8324, 0x8b85, 0x8ba6, 0x83a7, 0x946a, 0x9429, 0x6284, 0x4a04, 0x3184, 0x10a3, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0xef10, 
	0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x2964, 0x2943, 0x5a45, 0x8be8, 0xa48a, 0x9c69, 0x9c07, 0x93c6, 0x8345, 
	0x8b66, 0x9c29, 0x9263, 0x9263, 0x9263, 0x9263, 0x79e1, 0x7a02, 0x8244, 0x71e3, 0x5120, 0x48e0, 0x40a0, 0x38a0, 0x38a0, 0x38c0, 
	0x4900, 0x5141, 0x5161, 0x5161, 0x5161, 0x5161, 0x5161, 0x5160, 0x5161, 0x5161, 0x5161, 0x5161, 0x5161, 0x5161, 0x4941, 0x4940, 
	0x4940, 0x5160, 0x5161, 0x5161, 0x5181, 0x5161, 0x5160, 0x5161, 0x5161, 0x5161, 0x5140, 0x4900, 0x4920, 0x5940, 0x69c0, 0x7202, 
	0x7243, 0x7263, 0x7264, 0x6a66, 0x49c5, 0x28e3, 0x1041, 0x0001, 0x0001, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0022, 0x0802, 0x0802, 0x0821, 0x0801, 0x0000, 0x0820, 0x0820, 0x0000, 0x0000, 0x0800, 0x1000, 0x2080, 0x4141, 0x59a1, 0x61c1, 
	0x6a22, 0x7263, 0x7263, 0x7243, 0x6a03, 0x59c2, 0x5181, 0x5161, 0x5161, 0x5161, 0x5161, 0x5161, 0x5161, 0x5162, 0x5162, 0x5162, 
	0x5161, 0x5161, 0x5161, 0x5161, 0x5161, 0x5161, 0x5161, 0x5162, 0x5162, 0x4962, 0x4962, 0x4962, 0x4962, 0x4962, 0x4982, 0x4962, 
	0x4142, 0x38e0, 0x38a0, 0x3880, 0x3860, 0x4860, 0x6900, 0x89e0, 0x9a83, 0x9263, 0x9263, 0x9263, 0x9263, 0x9366, 0x8344, 0x8323, 
	0x9385, 0x8ba6, 0x83c7, 0x9c6a, 0x8bc7, 0x5a63, 0x4a04, 0x10e3, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 
	0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 
	0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x2104, 0x5204, 0x8ba7, 0xa4aa, 0xa489, 0x9c08, 0x93a7, 
	0x7ae4, 0x7ae5, 0xa44a, 0x9284, 0x9263, 0x9263, 0x9263, 0x79e2, 0x8223, 0x7a23, 0x69a1, 0x5100, 0x3880, 0x3880, 0x38a0, 0x40e0, 
	0x4920, 0x5161, 0x5181, 0x5981, 0x5981, 0x5981, 0x5181, 0x5181, 0x5981, 0x5981, 0x5981, 0x5981, 0x5981, 0x5181, 0x5181, 0x5181, 
	0x5181, 0x5181, 0x59a1, 0x59a1, 0x59a1, 0x59a1, 0x59a1, 0x59a1, 0x59a1, 0x61c2, 0x61c2, 0x59a1, 0x5980, 0x5980, 0x69c0, 0x6a01, 
	0x7222, 0x7263, 0x7264, 0x6a66, 0x51c5, 0x28e3, 0x1041, 0x0800, 0x0021, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0822, 0x0801, 0x0801, 0x0801, 0x0800, 0x0800, 0x0800, 0x0820, 0x0000, 0x0000, 0x0000, 0x0800, 0x2060, 0x4120, 0x51a1, 0x61c1, 
	0x6a22, 0x7263, 0x7a63, 0x7243, 0x6a23, 0x61e2, 0x59c2, 0x59a1, 0x5981, 0x5981, 0x5981, 0x5981, 0x5982, 0x5982, 0x59a2, 0x5982, 
	0x5982, 0x5982, 0x5981, 0x5981, 0x5982, 0x5181, 0x5161, 0x5181, 0x5182, 0x5182, 0x5182, 0x5182, 0x5162, 0x5162, 0x51a3, 0x51a3, 
	0x4982, 0x4100, 0x38c0, 0x40a0, 0x4080, 0x50a0, 0x7980, 0x9a62, 0x9263, 0x9263, 0x9263, 0x9263, 0x9bc8, 0x7b04, 0x7ae3, 0x8b64, 
	0x8b86, 0x8be7, 0x9c49, 0x8386, 0x6264, 0x41c4, 0x08a3, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 
	0xef10, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x2124, 0x5204, 0x8367, 0x9c6a, 0x9c6a, 0x8ba7, 
	0x8325, 0x8324, 0x8346, 0xac8b, 0x92c5, 0x9263, 0x9263, 0x9243, 0x8222, 0x8223, 0x8223, 0x6180, 0x48c0, 0x3880, 0x38a0, 0x4900, 
	0x5161, 0x59a2, 0x59a2, 0x59a2, 0x61a2, 0x59a2, 0x59a2, 0x59a2, 0x59c2, 0x61c2, 0x61c2, 0x61c2, 0x59c2, 0x59c2, 0x59c2, 0x59c2, 
	0x59c2, 0x59c2, 0x61c2, 0x61e2, 0x61e2, 0x61e2, 0x61e2, 0x61e2, 0x61c2, 0x6a02, 0x6a03, 0x69e2, 0x61a1, 0x6180, 0x69c0, 0x6a01, 
	0x7222, 0x7243, 0x7264, 0x6a86, 0x51e5, 0x3103, 0x1861, 0x0800, 0x0821, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0003, 0x0002, 0x0002, 0x0002, 0x0022, 
	0x0822, 0x0801, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x2060, 0x3921, 0x51a2, 0x61e2, 
	0x6a22, 0x7243, 0x7263, 0x7243, 0x6a22, 0x6a02, 0x61e2, 0x61c2, 0x61c1, 0x61c1, 0x61c2, 0x61c2, 0x61a2, 0x61a2, 0x61a2, 0x61a2, 
	0x61a2, 0x61c2, 0x61c2, 0x59a1, 0x59a2, 0x5981, 0x5161, 0x5161, 0x5982, 0x5181, 0x5181, 0x5161, 0x5161, 0x5161, 0x59a2, 0x51a2, 
	0x4962, 0x4100, 0x40c0, 0x48a0, 0x50c0, 0x6900, 0x9201, 0x9263, 0x9263, 0x9263, 0x9263, 0xa409, 0x8b65, 0x8324, 0x7b04, 0x7b25, 
	0x8bc8, 0x9409, 0x8346, 0x6a84, 0x39a4, 0x0883, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 
	0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x2124, 0x49e5, 0x72e6, 0x93e9, 0x9429, 
	0x93c7, 0x93c7, 0x8344, 0x8b86, 0xa46a, 0x9b05, 0x9263, 0x9263, 0x9243, 0x8a23, 0x92a4, 0x8223, 0x6180, 0x48e0, 0x40e0, 0x5140, 
	0x59a2, 0x6a03, 0x6a03, 0x6a24, 0x6a24, 0x6a24, 0x6a04, 0x6a03, 0x6a03, 0x6a03, 0x6a03, 0x6a03, 0x6a03, 0x6203, 0x6202, 0x6a03, 
	0x6a03, 0x6a02, 0x6a02, 0x6a02, 0x6a02, 0x6a02, 0x6a23, 0x6a02, 0x61e2, 0x6a02, 0x6a02, 0x69e2, 0x61a0, 0x6180, 0x69c0, 0x6a01, 
	0x7222, 0x7243, 0x7264, 0x6a65, 0x51e5, 0x3123, 0x1881, 0x0821, 0x0842, 0x0022, 0x0022, 0x0023, 0x0043, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0002, 0x0002, 0x0003, 0x0003, 0x0003, 0x0022, 0x0022, 0x0022, 
	0x0821, 0x1000, 0x1800, 0x28a2, 0x3943, 0x41a4, 0x3123, 0x1881, 0x0800, 0x0000, 0x0800, 0x0800, 0x1860, 0x3900, 0x51a2, 0x6202, 
	0x6a23, 0x7243, 0x7263, 0x7243, 0x6a02, 0x6a02, 0x6a03, 0x6a23, 0x6a23, 0x7223, 0x7223, 0x6a23, 0x6a03, 0x6a03, 0x6a03, 0x69e3, 
	0x6a03, 0x6a03, 0x6a03, 0x61e3, 0x61e3, 0x61e3, 0x59a2, 0x59c2, 0x59c3, 0x59c3, 0x51a2, 0x5182, 0x5182, 0x59a3, 0x59c3, 0x59a3, 
	0x5161, 0x4900, 0x40a0, 0x50c0, 0x6120, 0x8201, 0x9263, 0x9263, 0x9263, 0x9284, 0xac8a, 0x9385, 0x9385, 0x93a5, 0x8345, 0x7b87, 
	0x83a8, 0x7b26, 0x5a64, 0x4a05, 0x08a4, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 
	0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x10c3, 0x41c4, 0x72c6, 0x9c2a, 
	0xa4ab, 0x9408, 0x93c7, 0x8b44, 0x93a7, 0xac8a, 0x9b46, 0x9263, 0x9263, 0x9243, 0x9243, 0x8a64, 0x7a23, 0x5940, 0x48e0, 0x4900, 
	0x5161, 0x59c2, 0x6203, 0x6a24, 0x6a44, 0x6a24, 0x6a24, 0x6a24, 0x6a24, 0x6a24, 0x6a24, 0x6a03, 0x6a03, 0x6203, 0x6a03, 0x6a03, 
	0x6a23, 0x6a24, 0x6a23, 0x6a03, 0x6a03, 0x6a23, 0x6a23, 0x6a03, 0x6a03, 0x6a23, 0x6a03, 0x61c2, 0x6180, 0x5980, 0x69c0, 0x6a01, 
	0x7222, 0x7243, 0x7264, 0x6a65, 0x5a05, 0x3964, 0x3103, 0x20c3, 0x18a3, 0x0862, 0x0022, 0x0022, 0x0043, 0x0043, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0023, 0x0002, 0x0002, 0x0003, 0x0003, 0x0003, 0x0023, 0x0022, 0x0002, 0x0001, 
	0x1020, 0x1800, 0x3081, 0x59e6, 0x7b4b, 0x940d, 0x732a, 0x41c6, 0x1040, 0x0000, 0x0800, 0x0800, 0x1860, 0x30e0, 0x5181, 0x6202, 
	0x6a43, 0x7263, 0x7243, 0x6a22, 0x61e2, 0x61e2, 0x6a03, 0x6a44, 0x7264, 0x7a85, 0x7265, 0x7265, 0x7265, 0x6a44, 0x6a24, 0x6a24, 
	0x6a44, 0x6a24, 0x6a04, 0x6204, 0x6a24, 0x6a24, 0x61e3, 0x61e4, 0x6204, 0x59e4, 0x59c3, 0x5182, 0x5183, 0x59c4, 0x59c3, 0x59a2, 
	0x5161, 0x48e0, 0x48c0, 0x58e0, 0x71a0, 0x9263, 0x9263, 0x9263, 0x92c5, 0xac8a, 0x93c6, 0x9364, 0x9bc6, 0x8b85, 0x93e8, 0x93e8, 
	0x7306, 0x5a44, 0x3184, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 
	0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x10c4, 0x5225, 0x72e6, 
	0xa46a, 0xaccb, 0x9c28, 0x93c6, 0x8b65, 0x93e7, 0xac8a, 0xa387, 0x9263, 0x9263, 0x8a02, 0x8a43, 0x8a84, 0x71c1, 0x5100, 0x40a0, 
	0x40e0, 0x4940, 0x5182, 0x61e3, 0x6204, 0x6204, 0x6204, 0x6204, 0x6204, 0x6204, 0x6204, 0x61e3, 0x59c3, 0x59c3, 0x61e3, 0x61e3, 
	0x6204, 0x6a24, 0x6204, 0x61e3, 0x6204, 0x61e4, 0x61c3, 0x61e3, 0x61e3, 0x6a04, 0x61e3, 0x5981, 0x5960, 0x5980, 0x69e1, 0x6a01, 
	0x7222, 0x7243, 0x7264, 0x6a65, 0x5a05, 0x4184, 0x3985, 0x3165, 0x2104, 0x1083, 0x0022, 0x0022, 0x0043, 0x0043, 0x0043, 0x0023, 
	0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0022, 0x0001, 0x0001, 
	0x1000, 0x2840, 0x5163, 0x8b8b, 0xcdb3, 0xeef8, 0xd636, 0x8c0e, 0x20c2, 0x0000, 0x0800, 0x0800, 0x1840, 0x30e0, 0x4981, 0x6202, 
	0x7243, 0x7263, 0x7223, 0x6a23, 0x6a03, 0x59c2, 0x59c2, 0x6203, 0x6a44, 0x7265, 0x6a24, 0x61e3, 0x6204, 0x59c3, 0x59a2, 0x61e3, 
	0x61e3, 0x51a2, 0x5182, 0x59a3, 0x59c3, 0x59a3, 0x4941, 0x5182, 0x59c4, 0x59c4, 0x4983, 0x38e1, 0x38e1, 0x4101, 0x4962, 0x5141, 
	0x48e0, 0x50e0, 0x5900, 0x7160, 0x8a22, 0x9263, 0x9263, 0x9263, 0x92a4, 0x9c07, 0x8b64, 0x9bc6, 0x8ba6, 0x9408, 0x9428, 0x8366, 
	0x5a65, 0x2944, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x10c3, 0x5225, 
	0x7306, 0xa46a, 0xaceb, 0x9c28, 0x93c6, 0x8b85, 0x9c08, 0x9b46, 0x9263, 0x9263, 0x9243, 0x8a22, 0x9264, 0x8a43, 0x71c1, 0x5100, 
	0x40c0, 0x38c0, 0x4100, 0x4921, 0x4962, 0x59e4, 0x59e4, 0x4921, 0x4921, 0x5182, 0x59e4, 0x59c3, 0x4121, 0x4921, 0x5183, 0x59a3, 
	0x59a3, 0x59c4, 0x5162, 0x4922, 0x5183, 0x5183, 0x4101, 0x4121, 0x4941, 0x5162, 0x4921, 0x40e0, 0x4900, 0x5160, 0x61c1, 0x6a22, 
	0x6a22, 0x7243, 0x7264, 0x6a65, 0x51e4, 0x3923, 0x28e3, 0x20c2, 0x18a3, 0x0862, 0x0021, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0023, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0003, 0x0003, 0x0003, 0x0023, 0x0023, 0x0022, 0x0021, 0x0800, 
	0x1000, 0x2860, 0x5984, 0x938b, 0xd5d3, 0xff59, 0xe6b7, 0x9470, 0x20e3, 0x0000, 0x0800, 0x0800, 0x1840, 0x30c0, 0x4961, 0x6202, 
	0x7243, 0x7264, 0x6a23, 0x6a23, 0x6a23, 0x59a2, 0x4941, 0x5182, 0x59c3, 0x59e3, 0x5182, 0x4941, 0x51a3, 0x4941, 0x4100, 0x5182, 
	0x5182, 0x4100, 0x4101, 0x4942, 0x5162, 0x4121, 0x30a0, 0x3901, 0x4983, 0x51a4, 0x4142, 0x2860, 0x2040, 0x2860, 0x38e0, 0x48e0, 
	0x48a0, 0x58e0, 0x6960, 0x8a01, 0x9263, 0x9263, 0x9263, 0x92c4, 0x9bc6, 0x8b64, 0x9bc6, 0x93a6, 0x9409, 0x9c49, 0x8386, 0x6ac5, 
	0x39a4, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x08a3, 
	0x5225, 0x7b26, 0xacec, 0xaceb, 0x9c48, 0x93a6, 0x9385, 0x9be7, 0x9b46, 0x9263, 0x9263, 0x9243, 0x8a43, 0x9aa4, 0x8a44, 0x6181, 
	0x48e0, 0x3080, 0x38c0, 0x38c0, 0x38c0, 0x51c4, 0x59c4, 0x30a0, 0x3080, 0x4121, 0x59e4, 0x51a3, 0x3080, 0x30a0, 0x4962, 0x5163, 
	0x5163, 0x4963, 0x38e1, 0x30a0, 0x4943, 0x4943, 0x3080, 0x3080, 0x38c0, 0x38c0, 0x38a0, 0x3880, 0x40c0, 0x5140, 0x61c1, 0x6a02, 
	0x6a02, 0x6a43, 0x6a44, 0x6a65, 0x51e4, 0x3102, 0x1860, 0x0820, 0x0841, 0x0841, 0x0021, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0022, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0023, 0x0023, 0x0022, 0x0022, 0x0001, 
	0x1000, 0x2040, 0x38c1, 0x51a4, 0x7b29, 0x9c4e, 0x83ac, 0x4a27, 0x1061, 0x0000, 0x0000, 0x0800, 0x1040, 0x28a0, 0x4961, 0x6a23, 
	0x7264, 0x7264, 0x6a23, 0x7244, 0x7264, 0x5181, 0x4100, 0x4120, 0x4121, 0x4120, 0x30a0, 0x30c0, 0x4962, 0x38e0, 0x2880, 0x4142, 
	0x4962, 0x30a0, 0x38c0, 0x4122, 0x4963, 0x3901, 0x2020, 0x30a0, 0x4963, 0x4984, 0x3902, 0x2040, 0x1800, 0x2020, 0x3080, 0x48a0, 
	0x50a0, 0x6100, 0x7180, 0x8a22, 0x9263, 0x9263, 0x9b05, 0xa408, 0x93a5, 0x9bc5, 0x93c6, 0x93e8, 0xa48a, 0x8386, 0x62a5, 0x31a5, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x4a05, 0x8388, 0xacec, 0xa4aa, 0x9c48, 0x93a5, 0x93a6, 0xa428, 0xa3a7, 0x9263, 0x9263, 0x9243, 0x9263, 0x9264, 0x79e2, 
	0x5120, 0x38a0, 0x40e0, 0x30a0, 0x30a0, 0x51c4, 0x59e5, 0x2860, 0x2860, 0x3901, 0x5a05, 0x51c4, 0x2040, 0x2880, 0x4943, 0x4963, 
	0x4963, 0x4142, 0x30a0, 0x2860, 0x4963, 0x4963, 0x2860, 0x2860, 0x30a0, 0x30a0, 0x30a0, 0x3080, 0x40e0, 0x4940, 0x59a0, 0x61e1, 
	0x61e1, 0x6a22, 0x6a64, 0x6a85, 0x51e4, 0x3102, 0x1040, 0x0000, 0x0000, 0x0021, 0x0021, 0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0021, 
	0x1020, 0x2040, 0x3080, 0x30a0, 0x3942, 0x49e5, 0x3164, 0x18a1, 0x0820, 0x0000, 0x0000, 0x0800, 0x1040, 0x28c0, 0x4961, 0x6a02, 
	0x7243, 0x7263, 0x6a23, 0x7244, 0x7264, 0x5181, 0x38e0, 0x4121, 0x38e0, 0x28a0, 0x2880, 0x30a0, 0x4142, 0x30c0, 0x2060, 0x4122, 
	0x4142, 0x28a0, 0x30a0, 0x3901, 0x4142, 0x38e1, 0x1820, 0x28a0, 0x4163, 0x4984, 0x3902, 0x1820, 0x1000, 0x1800, 0x3040, 0x48a0, 
	0x6100, 0x7180, 0x8a22, 0x9243, 0x9263, 0x9263, 0x92e4, 0x9be6, 0x93a5, 0x9c06, 0x8bc7, 0xa48b, 0x8bc7, 0x6ae5, 0x2124, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0xef10, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x49e4, 0x93e9, 0xad0b, 0xa4a9, 0x9c27, 0x9bc5, 0x9be6, 0x9ba7, 0x9263, 0x9263, 0x9243, 0x8a22, 0x9263, 0x8a64, 
	0x69a2, 0x5100, 0x40e0, 0x30a0, 0x2880, 0x4963, 0x4984, 0x2880, 0x2040, 0x30c1, 0x51c4, 0x4984, 0x2020, 0x2860, 0x4142, 0x3922, 
	0x4122, 0x4984, 0x30c1, 0x1820, 0x4143, 0x4144, 0x2040, 0x2040, 0x28a1, 0x30c1, 0x30a0, 0x3080, 0x38e0, 0x5160, 0x59a0, 0x61e1, 
	0x61e1, 0x6a22, 0x7264, 0x6a85, 0x51e4, 0x3102, 0x1040, 0x0000, 0x0000, 0x0020, 0x0041, 0x0042, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0022, 0x0022, 0x0021, 
	0x1020, 0x2060, 0x3080, 0x2040, 0x1840, 0x1040, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1040, 0x28c0, 0x4961, 0x6a02, 
	0x7243, 0x7243, 0x6a22, 0x6a43, 0x6a64, 0x5182, 0x3900, 0x4962, 0x38e0, 0x2060, 0x28a0, 0x30e1, 0x3942, 0x30c1, 0x2060, 0x3942, 
	0x4163, 0x28a0, 0x28a0, 0x30e1, 0x4142, 0x3901, 0x2040, 0x30c1, 0x4164, 0x4984, 0x3902, 0x1820, 0x1000, 0x2020, 0x3040, 0x50c0, 
	0x7960, 0x89e1, 0x9243, 0x9263, 0x9263, 0x92e4, 0x9385, 0x93a5, 0x9c06, 0x93e7, 0x9c8a, 0x9c29, 0x7b26, 0x2144, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x5225, 0xa46a, 0xaceb, 0xaca9, 0x9c07, 0x9bc5, 0x9bc6, 0xa387, 0x9263, 0x9263, 0x9263, 0x8a02, 0x92a5, 
	0x8244, 0x61a2, 0x4920, 0x30c0, 0x28a0, 0x3902, 0x3923, 0x2881, 0x2060, 0x2060, 0x4143, 0x4143, 0x1820, 0x2880, 0x3922, 0x28c1, 
	0x30e1, 0x49c5, 0x30e1, 0x1000, 0x3923, 0x3943, 0x1820, 0x1820, 0x2881, 0x38e2, 0x38e0, 0x2860, 0x38e0, 0x5180, 0x59c1, 0x6201, 
	0x6202, 0x6a22, 0x6a64, 0x6a85, 0x51e4, 0x3102, 0x1040, 0x0000, 0x0000, 0x0020, 0x0842, 0x0042, 0x0042, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0002, 0x0002, 0x0002, 0x0022, 0x0022, 0x0022, 0x0022, 0x0002, 0x0022, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0021, 
	0x1020, 0x2040, 0x2860, 0x2060, 0x1020, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1040, 0x28a0, 0x4961, 0x61e2, 
	0x7243, 0x7243, 0x6a02, 0x6a43, 0x6a64, 0x5182, 0x4100, 0x4962, 0x3901, 0x2060, 0x28a0, 0x3101, 0x3922, 0x28c0, 0x2080, 0x3943, 
	0x4163, 0x28a0, 0x28a0, 0x30e1, 0x3942, 0x30e2, 0x1840, 0x28a1, 0x4143, 0x4164, 0x38e2, 0x2020, 0x2000, 0x2840, 0x48a0, 0x6120, 
	0x81a0, 0x8a22, 0x9243, 0x9263, 0x9b46, 0x9bc7, 0x93c5, 0x9be6, 0x9c07, 0x9449, 0xa4aa, 0x8366, 0x7306, 0x2144, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x41c4, 0x7b26, 0xa4aa, 0xaceb, 0xac89, 0xa406, 0x9be6, 0xac48, 0xabe8, 0x9263, 0x9263, 0x8a02, 0x8a43, 
	0x8a84, 0x7a23, 0x5121, 0x38a0, 0x28a0, 0x3102, 0x3102, 0x2881, 0x1840, 0x2040, 0x3943, 0x4143, 0x1840, 0x2880, 0x3902, 0x28a1, 
	0x30e2, 0x49c5, 0x30e2, 0x1020, 0x3103, 0x3123, 0x1860, 0x1820, 0x2060, 0x30e1, 0x38e1, 0x3080, 0x38e0, 0x5160, 0x59c1, 0x6201, 
	0x6202, 0x6a22, 0x6a43, 0x6a65, 0x5a05, 0x3922, 0x1860, 0x0000, 0x0000, 0x0020, 0x0842, 0x0842, 0x0043, 0x0043, 0x0063, 0x0063, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0022, 0x0002, 0x0002, 0x0022, 0x0022, 0x0023, 0x0023, 0x0002, 0x0022, 0x0043, 0x0043, 0x0023, 0x0022, 0x0042, 0x0022, 0x0021, 
	0x1021, 0x1840, 0x2060, 0x1860, 0x1040, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1020, 0x28a0, 0x4941, 0x61e2, 
	0x6a43, 0x6a43, 0x6202, 0x6a23, 0x6a44, 0x4982, 0x4101, 0x4963, 0x30e1, 0x2040, 0x28a0, 0x3101, 0x3122, 0x28a0, 0x2080, 0x3943, 
	0x4163, 0x28a0, 0x28a0, 0x30e1, 0x3943, 0x30e2, 0x1820, 0x2880, 0x3923, 0x4143, 0x30c1, 0x2020, 0x2800, 0x3860, 0x5920, 0x79a0, 
	0x89e0, 0x9243, 0x9263, 0x9263, 0x9b86, 0x9c06, 0x9bc5, 0x9c27, 0x9428, 0xa4aa, 0x8ba6, 0x7306, 0x2164, 0x0083, 0xef10, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x41a4, 0x93c8, 0xaceb, 0xacca, 0xa468, 0xa406, 0xa427, 0xb48a, 0x9263, 0x9263, 0x9263, 0x8a43, 
	0x9284, 0x8a85, 0x6182, 0x38e0, 0x2880, 0x30e1, 0x3102, 0x2081, 0x1820, 0x1840, 0x3923, 0x3923, 0x1820, 0x2880, 0x3923, 0x28c1, 
	0x30e2, 0x41a4, 0x28e2, 0x1020, 0x2902, 0x3123, 0x2081, 0x1840, 0x1840, 0x30c1, 0x30e1, 0x2880, 0x38c0, 0x4940, 0x59a0, 0x61e1, 
	0x6202, 0x6a22, 0x6a43, 0x6a65, 0x5a05, 0x3923, 0x1860, 0x0800, 0x0000, 0x0000, 0x0842, 0x0842, 0x0043, 0x0063, 0x0063, 0x0063, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0042, 0x0022, 0x0042, 0x0822, 
	0x1021, 0x1841, 0x2040, 0x1841, 0x1020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1020, 0x2880, 0x4941, 0x6203, 
	0x6a43, 0x6a43, 0x6202, 0x6223, 0x6224, 0x4962, 0x3901, 0x4142, 0x30c1, 0x1820, 0x28a0, 0x3102, 0x3122, 0x28a0, 0x2060, 0x3942, 
	0x3943, 0x28a0, 0x2880, 0x30e1, 0x3943, 0x3102, 0x1000, 0x2080, 0x3923, 0x3922, 0x30a0, 0x2800, 0x3000, 0x4080, 0x6960, 0x81e1, 
	0x9222, 0x9243, 0x9263, 0x9b46, 0x9bc6, 0x9be6, 0xa427, 0x9c28, 0x9c8a, 0x9c28, 0x7305, 0x18e4, 0x0083, 0xef10, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0883, 0x41c5, 0xa449, 0xb50b, 0xacc9, 0xa427, 0xa406, 0xac48, 0xa3c7, 0x9263, 0x9263, 0x9263, 
	0x9264, 0x92a5, 0x7224, 0x4921, 0x2060, 0x30e2, 0x3102, 0x2081, 0x1840, 0x1840, 0x3102, 0x3102, 0x1800, 0x28a1, 0x4164, 0x28c1, 
	0x28c1, 0x4184, 0x28e2, 0x1040, 0x28e2, 0x3123, 0x20c1, 0x1860, 0x1840, 0x28c1, 0x30c0, 0x2040, 0x3080, 0x4120, 0x5180, 0x61c1, 
	0x61e1, 0x6a22, 0x7244, 0x7286, 0x5a05, 0x3923, 0x1860, 0x0800, 0x0800, 0x0800, 0x0842, 0x0842, 0x0863, 0x0063, 0x0063, 0x0063, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0022, 0x0022, 0x0042, 0x0042, 0x0822, 
	0x1021, 0x1840, 0x2040, 0x1841, 0x1041, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1020, 0x28a0, 0x4941, 0x6203, 
	0x6a23, 0x6a23, 0x6223, 0x6223, 0x6203, 0x4141, 0x38e0, 0x4142, 0x28c1, 0x1800, 0x2080, 0x30e2, 0x3102, 0x28a0, 0x2060, 0x3922, 
	0x3943, 0x2080, 0x2080, 0x28c1, 0x3943, 0x3102, 0x1000, 0x2060, 0x3902, 0x3922, 0x30a0, 0x2800, 0x3820, 0x50c0, 0x79c1, 0x8a42, 
	0x9243, 0x9263, 0x9263, 0x9ba6, 0x9c06, 0x9c06, 0xa448, 0x9c49, 0xa48a, 0x7b25, 0x1904, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0883, 0x4a05, 0xacca, 0xb50b, 0xac88, 0xa426, 0xa3e6, 0xac89, 0x9263, 0x9263, 0x9263, 
	0x9243, 0x9aa5, 0x8a85, 0x5982, 0x2860, 0x30e1, 0x3902, 0x2080, 0x1820, 0x1840, 0x3102, 0x3102, 0x1000, 0x2080, 0x3963, 0x28c1, 
	0x28c1, 0x4164, 0x28e2, 0x1040, 0x28c2, 0x2903, 0x28c2, 0x1860, 0x1020, 0x30e2, 0x30e1, 0x2060, 0x30a0, 0x4120, 0x5181, 0x61e2, 
	0x61e2, 0x6a23, 0x6a44, 0x7286, 0x5a25, 0x4143, 0x2081, 0x0800, 0x0800, 0x0800, 0x0821, 0x0842, 0x0863, 0x0863, 0x0063, 0x0063, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0002, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0822, 
	0x1021, 0x1840, 0x2040, 0x1860, 0x1041, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1020, 0x28a0, 0x4961, 0x6203, 
	0x6203, 0x6223, 0x6a23, 0x6223, 0x59e3, 0x4121, 0x30c0, 0x4142, 0x28a1, 0x1000, 0x2080, 0x28e1, 0x30e2, 0x20a0, 0x2060, 0x3122, 
	0x3943, 0x2080, 0x2080, 0x28c1, 0x3943, 0x30e2, 0x1000, 0x2060, 0x3902, 0x3902, 0x38a0, 0x3000, 0x4040, 0x6100, 0x8201, 0x9263, 
	0x9243, 0x9263, 0x92e5, 0x9365, 0x93c5, 0x9c06, 0x9c48, 0xa48a, 0x93e7, 0x7305, 0x10c4, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x3984, 0x9c08, 0xb4eb, 0xacc9, 0x9c06, 0x9384, 0xa3e7, 0xa3a7, 0x9284, 0x9263, 
	0x9243, 0x9a84, 0x9ac6, 0x69c3, 0x3080, 0x38e1, 0x3902, 0x2080, 0x1820, 0x1840, 0x3102, 0x3102, 0x1000, 0x2060, 0x3922, 0x28c1, 
	0x28e1, 0x4164, 0x28c1, 0x1020, 0x20a1, 0x28e2, 0x28c2, 0x1840, 0x1000, 0x28c2, 0x30e1, 0x2880, 0x30c0, 0x4121, 0x51a1, 0x59e2, 
	0x61e2, 0x6203, 0x6223, 0x6a45, 0x5a05, 0x4164, 0x28a1, 0x1020, 0x0800, 0x0000, 0x0001, 0x0842, 0x0863, 0x0863, 0x0063, 0x0063, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0023, 0x0003, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 
	0x1020, 0x1840, 0x2040, 0x1860, 0x1040, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1020, 0x28a0, 0x4161, 0x6203, 
	0x6203, 0x6203, 0x6a23, 0x6a44, 0x5a04, 0x4141, 0x30e0, 0x3922, 0x28c1, 0x1840, 0x20a1, 0x28e2, 0x28c1, 0x2080, 0x2060, 0x3122, 
	0x3122, 0x2080, 0x2080, 0x28c1, 0x3102, 0x28a1, 0x1000, 0x2060, 0x3902, 0x3902, 0x3080, 0x3000, 0x4840, 0x6900, 0x8a01, 0x9263, 
	0x9263, 0x9263, 0x9387, 0x8b65, 0x8b85, 0x93c7, 0x9c29, 0x9c49, 0x7b25, 0x1904, 0x08a3, 0x0083, 0xef10, 0x0083, 0x0083, 0xef10, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x08a3, 0x39a5, 0xa429, 0xa489, 0x9be7, 0x93a5, 0x9bc5, 0xbd0b, 0x92a4, 0x9263, 
	0x9263, 0x9243, 0x9ac6, 0x7a04, 0x5101, 0x40e1, 0x30a0, 0x2880, 0x1840, 0x1820, 0x30e2, 0x3102, 0x1820, 0x1840, 0x28a1, 0x28a0, 
	0x30e2, 0x4184, 0x28c1, 0x1000, 0x1860, 0x20a1, 0x20a1, 0x1861, 0x1840, 0x2060, 0x2060, 0x2060, 0x28a0, 0x38e0, 0x4941, 0x51a2, 
	0x51a2, 0x59c2, 0x59c2, 0x5a04, 0x51e4, 0x4184, 0x3102, 0x1860, 0x0800, 0x0000, 0x0000, 0x0842, 0x0863, 0x0863, 0x0863, 0x0063, 
	0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 
	0x1020, 0x1840, 0x2040, 0x1860, 0x1040, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1020, 0x28a0, 0x4962, 0x5a03, 
	0x59e2, 0x59c2, 0x6203, 0x6203, 0x59e3, 0x4141, 0x30e0, 0x3902, 0x28a1, 0x1840, 0x2081, 0x28c1, 0x20a0, 0x2060, 0x2060, 0x3102, 
	0x3122, 0x2080, 0x2080, 0x20a1, 0x28c1, 0x2080, 0x1000, 0x2060, 0x30e2, 0x38e1, 0x3880, 0x3000, 0x58a0, 0x8180, 0x9222, 0x9263, 
	0x9263, 0x9b46, 0x93c7, 0x8ba6, 0x8366, 0x83a7, 0x8be9, 0x8367, 0x62a5, 0x08a3, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 
	0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x2944, 0x8b87, 0xa469, 0xa489, 0xa447, 0xa406, 0xc4e9, 0xabc8, 0x92a4, 
	0x9263, 0x9243, 0x9a84, 0x8244, 0x6182, 0x48e1, 0x3080, 0x2880, 0x2040, 0x1820, 0x28c1, 0x30e1, 0x2060, 0x2040, 0x2060, 0x2080, 
	0x30e1, 0x4163, 0x28a0, 0x0800, 0x1020, 0x2080, 0x2081, 0x2061, 0x1840, 0x1820, 0x1820, 0x2040, 0x2860, 0x30a0, 0x38e0, 0x4120, 
	0x4140, 0x4940, 0x4940, 0x4962, 0x4162, 0x3942, 0x28e2, 0x1880, 0x1020, 0x0800, 0x0000, 0x0822, 0x0863, 0x0863, 0x0863, 0x0063, 
	0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0021, 
	0x1020, 0x1840, 0x2040, 0x1860, 0x1040, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1020, 0x28c0, 0x4962, 0x59e3, 
	0x59c2, 0x5182, 0x59a2, 0x51a2, 0x4982, 0x38e0, 0x28a0, 0x30e2, 0x2080, 0x1000, 0x1860, 0x2081, 0x2060, 0x1840, 0x1860, 0x30e1, 
	0x3102, 0x2080, 0x2060, 0x2080, 0x28a1, 0x2060, 0x1000, 0x2060, 0x30c1, 0x38e1, 0x40a0, 0x4040, 0x6920, 0x9221, 0x9263, 0x9263, 
	0x9263, 0xa46a, 0x9c07, 0x93e7, 0x8be8, 0x9429, 0x8be9, 0x5a85, 0x10c3, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 
	0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x08a3, 0x39c5, 0xb4aa, 0xbd2b, 0xac88, 0xac67, 0xbc86, 0xcd8c, 0x9ae5, 
	0x9263, 0x9263, 0x9263, 0x8a24, 0x71a3, 0x5101, 0x38a0, 0x30a0, 0x2860, 0x2040, 0x28a0, 0x28c1, 0x2060, 0x2060, 0x2880, 0x2060, 
	0x28a0, 0x3902, 0x2060, 0x0800, 0x1820, 0x1860, 0x1860, 0x1840, 0x1840, 0x1820, 0x1800, 0x1820, 0x2020, 0x2840, 0x3060, 0x30a0, 
	0x38a0, 0x38a0, 0x38a0, 0x30a0, 0x30a0, 0x28a0, 0x2080, 0x1840, 0x1020, 0x0800, 0x0800, 0x0822, 0x0843, 0x0863, 0x0863, 0x0063, 
	0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0821, 
	0x1020, 0x1840, 0x2040, 0x2060, 0x1040, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1020, 0x28a0, 0x3901, 0x4941, 
	0x4921, 0x4120, 0x4920, 0x4121, 0x3901, 0x30a0, 0x2880, 0x28a1, 0x2060, 0x1020, 0x1840, 0x1840, 0x1820, 0x1820, 0x1840, 0x28c0, 
	0x28c1, 0x2080, 0x2060, 0x2060, 0x2080, 0x2060, 0x1820, 0x2040, 0x30a0, 0x38a0, 0x40a0, 0x5080, 0x7980, 0x9a41, 0x9263, 0x9263, 
	0x9263, 0x9bc7, 0x9c07, 0x9407, 0x9449, 0x9c8b, 0x8c09, 0x5a66, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 
	0xef10, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x2944, 0xac48, 0xc54c, 0xb4ea, 0xb488, 0xb445, 0xcd4a, 0x9ae5, 
	0x9263, 0x9263, 0x9243, 0x8a23, 0x79e3, 0x6141, 0x48e0, 0x38e0, 0x30a0, 0x30a0, 0x30e1, 0x30e1, 0x30a0, 0x30c0, 0x38e1, 0x30a0, 
	0x30a0, 0x3901, 0x28a0, 0x1800, 0x1840, 0x2040, 0x2040, 0x1840, 0x1820, 0x1800, 0x1800, 0x1800, 0x2020, 0x2840, 0x3060, 0x38a0, 
	0x38a0, 0x38a0, 0x3080, 0x3080, 0x2880, 0x2080, 0x1860, 0x1020, 0x0800, 0x0800, 0x0000, 0x0822, 0x0863, 0x0863, 0x0863, 0x0063, 
	0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0002, 0x0002, 0x0002, 0x0023, 0x0023, 0x0022, 0x0042, 0x0842, 
	0x1021, 0x1840, 0x2060, 0x2080, 0x1840, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1020, 0x2060, 0x30a0, 0x38a0, 
	0x38a0, 0x38c0, 0x38c0, 0x38c0, 0x30a0, 0x2880, 0x2060, 0x2080, 0x1860, 0x1840, 0x1020, 0x1000, 0x1820, 0x1820, 0x2060, 0x28a0, 
	0x28c0, 0x2880, 0x2060, 0x2060, 0x2080, 0x2060, 0x2040, 0x2880, 0x30a0, 0x3080, 0x4080, 0x58e0, 0x81a0, 0x9a42, 0x9263, 0x9263, 
	0x92e5, 0x93a6, 0x9c27, 0x9428, 0x9c8a, 0x946a, 0x7307, 0x1904, 0x0083, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0x0083, 
	0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x08a3, 0x41e5, 0xcd4b, 0xc56c, 0xac88, 0xbc86, 0xcd08, 0xaba6, 
	0x9aa4, 0x9263, 0x9263, 0x8a23, 0x8224, 0x69a2, 0x5121, 0x4901, 0x4101, 0x4101, 0x3921, 0x3921, 0x3901, 0x4121, 0x4122, 0x3901, 
	0x38e1, 0x4122, 0x38e1, 0x28a0, 0x2880, 0x2880, 0x2060, 0x2040, 0x1800, 0x1800, 0x1800, 0x1800, 0x2020, 0x3060, 0x40c0, 0x4900, 
	0x4900, 0x40e0, 0x40c0, 0x38c0, 0x30a0, 0x28a0, 0x2060, 0x1020, 0x0800, 0x0000, 0x0000, 0x0822, 0x0863, 0x0863, 0x0863, 0x0063, 
	0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0002, 0x0002, 0x0002, 0x0023, 0x0023, 0x0023, 0x0022, 0x0042, 0x0842, 
	0x1041, 0x1840, 0x2060, 0x2060, 0x1840, 0x0820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x1000, 0x2040, 0x2860, 0x3060, 
	0x3080, 0x38a0, 0x40c0, 0x40e0, 0x38c0, 0x30c0, 0x28a0, 0x2080, 0x1840, 0x1820, 0x1820, 0x1820, 0x2060, 0x2880, 0x30a0, 0x30e1, 
	0x3901, 0x30e0, 0x30c0, 0x30e0, 0x3901, 0x3902, 0x3901, 0x4101, 0x40e0, 0x40a0, 0x50c0, 0x6940, 0x89e1, 0x9263, 0x9263, 0x9263, 
	0xa46a, 0x9407, 0x9c27, 0x9449, 0x9cab, 0x9429, 0x5aa6, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 
	0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x2124, 0xc4ea, 0xc58c, 0xb4e9, 0xbcc8, 0xc4c7, 0xcd8b, 
	0xa346, 0x9263, 0x9263, 0x8a23, 0x8a24, 0x71c2, 0x5941, 0x4921, 0x4901, 0x4121, 0x4142, 0x4142, 0x4121, 0x4142, 0x4942, 0x4121, 
	0x4942, 0x4942, 0x4942, 0x4122, 0x4102, 0x38e2, 0x38e2, 0x2881, 0x2020, 0x1800, 0x1800, 0x1800, 0x2840, 0x38a0, 0x4920, 0x5961, 
	0x5981, 0x5961, 0x5140, 0x4961, 0x4141, 0x3921, 0x28c1, 0x1840, 0x0800, 0x0000, 0x0000, 0x0822, 0x0863, 0x0863, 0x0883, 0x0063, 
	0x0864, 0x0864, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0023, 0x0023, 0x0023, 0x0022, 0x0042, 0x0842, 
	0x1041, 0x2060, 0x2060, 0x2060, 0x1860, 0x1020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1020, 0x2060, 0x3080, 0x38a0, 
	0x40c0, 0x40e0, 0x4900, 0x4920, 0x4121, 0x4101, 0x30e0, 0x2880, 0x1820, 0x1000, 0x1800, 0x2040, 0x28a0, 0x30c1, 0x3901, 0x4122, 
	0x4122, 0x4121, 0x4121, 0x4121, 0x4942, 0x4942, 0x4942, 0x4942, 0x5121, 0x48c0, 0x5900, 0x7980, 0x9201, 0x9263, 0x9263, 0x9263, 
	0x9be7, 0x9c27, 0x9427, 0x9caa, 0x9c6a, 0x6b07, 0x1904, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x08a3, 0x4a05, 0xcd8c, 0xbd6c, 0xb4c8, 0xbc86, 0xcd6a, 
	0xa345, 0x9263, 0x9263, 0x8a22, 0x8a23, 0x79e2, 0x6161, 0x5100, 0x40e0, 0x40e0, 0x4101, 0x4121, 0x4121, 0x4121, 0x4921, 0x4921, 
	0x4942, 0x4942, 0x4942, 0x4942, 0x4942, 0x4122, 0x4102, 0x30a1, 0x2040, 0x2000, 0x1800, 0x2000, 0x3040, 0x40c0, 0x5141, 0x61a2, 
	0x61c2, 0x61c2, 0x61c2, 0x59c3, 0x51c3, 0x4963, 0x30e1, 0x1860, 0x0800, 0x0000, 0x0000, 0x0842, 0x0863, 0x0883, 0x0883, 0x0884, 
	0x0884, 0x0864, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0042, 0x0842, 
	0x1861, 0x2060, 0x2860, 0x2060, 0x1860, 0x1020, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1840, 0x30c0, 0x4121, 0x5120, 
	0x5141, 0x5141, 0x5961, 0x5961, 0x5162, 0x4962, 0x4121, 0x2880, 0x1820, 0x1800, 0x1820, 0x2860, 0x30c1, 0x4101, 0x4121, 0x4922, 
	0x4921, 0x4921, 0x4921, 0x4921, 0x4921, 0x4101, 0x4101, 0x4901, 0x5100, 0x50e0, 0x6920, 0x81c0, 0x9221, 0x9263, 0x9263, 0x9ac5, 
	0x8ba6, 0x9c47, 0x9448, 0xa4cb, 0x8c09, 0x4a05, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x10c4, 0xd56b, 0xc5ad, 0xb4c8, 0xbca6, 0xcd28, 
	0xaba6, 0x9284, 0x9263, 0x9263, 0x9223, 0x79e2, 0x6981, 0x48e0, 0x40a0, 0x38a0, 0x38c0, 0x38c0, 0x38e0, 0x40e0, 0x40e0, 0x4100, 
	0x4100, 0x4101, 0x40e1, 0x4101, 0x4101, 0x4101, 0x38e1, 0x30a1, 0x2860, 0x2020, 0x2000, 0x2000, 0x3040, 0x40c0, 0x5120, 0x5981, 
	0x61a1, 0x61c2, 0x61e2, 0x61e3, 0x59c3, 0x4983, 0x30e1, 0x1860, 0x0800, 0x0000, 0x0800, 0x0842, 0x1083, 0x0883, 0x0884, 0x0884, 
	0x0864, 0x0884, 0x0864, 0x0884, 0x0864, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0022, 0x0042, 0x0842, 
	0x1861, 0x2060, 0x2880, 0x2881, 0x2081, 0x1040, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1860, 0x3901, 0x5162, 0x5982, 
	0x61a2, 0x61a2, 0x5981, 0x5961, 0x5161, 0x4962, 0x4101, 0x2880, 0x2020, 0x1800, 0x2020, 0x2860, 0x30a0, 0x38e0, 0x40e1, 0x40e0, 
	0x40e0, 0x40e0, 0x40e0, 0x40e0, 0x40c0, 0x40c0, 0x40c0, 0x48c0, 0x50e0, 0x58e0, 0x6940, 0x8a21, 0x9263, 0x9263, 0x92a4, 0xad0c, 
	0x93e7, 0x9c47, 0x9c89, 0x9cab, 0x83c9, 0x39c5, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x10c3, 0xbcc9, 0xc58d, 0xbd0a, 0xbcc8, 0xc4c7, 
	0xcd8b, 0xab87, 0x9263, 0x9263, 0x9223, 0x81e2, 0x71a2, 0x5100, 0x48c0, 0x40c0, 0x40c0, 0x40e0, 0x40e0, 0x40e0, 0x40e0, 0x4100, 
	0x4901, 0x4901, 0x4101, 0x40e1, 0x4101, 0x40e1, 0x38c1, 0x30a1, 0x3080, 0x2840, 0x2820, 0x2800, 0x3060, 0x40c0, 0x5120, 0x5961, 
	0x61a1, 0x61c1, 0x61c1, 0x59c2, 0x51a2, 0x4162, 0x30e1, 0x1840, 0x0800, 0x0000, 0x0801, 0x0842, 0x1083, 0x0883, 0x0884, 0x0864, 
	0x0864, 0x0884, 0x0884, 0x0884, 0x0864, 0x0064, 0x0063, 0x0884, 0x0864, 0x0864, 0x0064, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0842, 
	0x1841, 0x2060, 0x3080, 0x28a1, 0x20a1, 0x1861, 0x0820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x2060, 0x3901, 0x5182, 0x61c2, 
	0x61c2, 0x61a2, 0x5981, 0x5961, 0x5141, 0x4942, 0x40e1, 0x2860, 0x2020, 0x2020, 0x2020, 0x2840, 0x3080, 0x38a0, 0x40c0, 0x40c0, 
	0x40c0, 0x40c0, 0x40c0, 0x38c0, 0x38a0, 0x38a0, 0x38a0, 0x40a0, 0x48a0, 0x58e0, 0x7180, 0x8a22, 0x9263, 0x9263, 0x9284, 0xa48a, 
	0xa468, 0x9c47, 0xa4eb, 0x944a, 0x5a86, 0x1924, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x08a3, 0x4a25, 0xc56c, 0xc58d, 0xb4c9, 0xbc86, 
	0xcd4a, 0xab86, 0x9263, 0x9263, 0x9222, 0x8202, 0x71c2, 0x5941, 0x5100, 0x4900, 0x4901, 0x4101, 0x4101, 0x4900, 0x4900, 0x4901, 
	0x4901, 0x4921, 0x4921, 0x4901, 0x4101, 0x40e1, 0x38c1, 0x38c1, 0x30a1, 0x3080, 0x2840, 0x2820, 0x3060, 0x40c0, 0x5120, 0x5960, 
	0x61a1, 0x61a1, 0x59a1, 0x59a1, 0x4982, 0x4142, 0x28c1, 0x1840, 0x0800, 0x0000, 0x0821, 0x0862, 0x1083, 0x0883, 0x0884, 0x0864, 
	0x0864, 0x0864, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0864, 0x0063, 0x0863, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0842, 
	0x1841, 0x2060, 0x3080, 0x30a1, 0x28a1, 0x1881, 0x0820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1820, 0x30c0, 0x4941, 0x5981, 
	0x6181, 0x6181, 0x61a1, 0x6181, 0x5962, 0x5162, 0x4101, 0x2860, 0x2020, 0x2020, 0x2840, 0x3080, 0x38a0, 0x40c0, 0x48e0, 0x48e0, 
	0x48e0, 0x4900, 0x48e0, 0x40e0, 0x40e0, 0x40e0, 0x40c0, 0x40a0, 0x50c0, 0x6120, 0x79a0, 0x9241, 0x9263, 0x9263, 0x9284, 0x9408, 
	0xa4a9, 0x9c68, 0xad2c, 0x83e9, 0x39c5, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xbd0b, 0xcdee, 0xb4c8, 0xb4a7, 
	0xcd29, 0xab86, 0x9263, 0x9263, 0x9222, 0x8a02, 0x79e2, 0x6141, 0x5100, 0x4900, 0x4921, 0x4921, 0x4921, 0x4921, 0x4921, 0x4921, 
	0x4921, 0x5122, 0x4922, 0x4922, 0x4922, 0x4922, 0x4922, 0x4102, 0x38e2, 0x30a1, 0x3060, 0x2840, 0x3060, 0x40c0, 0x4920, 0x5980, 
	0x61c1, 0x61c1, 0x61c1, 0x59c2, 0x5182, 0x4142, 0x28c1, 0x1040, 0x0800, 0x0000, 0x0821, 0x0862, 0x1083, 0x1084, 0x0884, 0x0884, 
	0x0864, 0x0864, 0x0864, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0864, 0x0884, 0x0884, 0x0884, 0x0884, 0x0864, 0x0863, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0843, 0x0843, 0x1042, 
	0x1841, 0x2040, 0x3060, 0x30a1, 0x28a2, 0x1881, 0x1020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x28a0, 0x4920, 0x5960, 
	0x5980, 0x6181, 0x69c2, 0x61a2, 0x5962, 0x5142, 0x40e1, 0x2860, 0x2020, 0x2040, 0x3060, 0x38c0, 0x4901, 0x4921, 0x4921, 0x5121, 
	0x5121, 0x5121, 0x4921, 0x4921, 0x4921, 0x4901, 0x40e1, 0x40a0, 0x50c0, 0x6940, 0x81e0, 0x9241, 0x9263, 0x9263, 0x92a4, 0x9427, 
	0xa4a9, 0x9ca9, 0xad2c, 0x83e9, 0x2964, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xa448, 0xcdce, 0xbd2a, 0xbce8, 
	0xc508, 0xa365, 0x9263, 0x9263, 0x9263, 0x9243, 0x79e2, 0x6161, 0x5100, 0x48e0, 0x4901, 0x4922, 0x4922, 0x4921, 0x4901, 0x4902, 
	0x4922, 0x4922, 0x4922, 0x4922, 0x4942, 0x4943, 0x4923, 0x4102, 0x38c2, 0x30a1, 0x2860, 0x2840, 0x3060, 0x38c0, 0x4920, 0x5980, 
	0x61c1, 0x61c1, 0x61c1, 0x59e2, 0x51c3, 0x4183, 0x28e1, 0x1040, 0x0800, 0x0000, 0x0821, 0x0862, 0x1083, 0x1084, 0x0884, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0864, 0x0863, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0843, 0x0843, 0x1042, 
	0x1841, 0x2040, 0x3060, 0x30c1, 0x28c2, 0x2081, 0x1020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x30a0, 0x4920, 0x5960, 
	0x61a1, 0x69c2, 0x69e2, 0x61a2, 0x5141, 0x4901, 0x38c1, 0x3060, 0x2840, 0x2040, 0x3080, 0x40e2, 0x4943, 0x5163, 0x5142, 0x5142, 
	0x5142, 0x5143, 0x5163, 0x5163, 0x5163, 0x4942, 0x4101, 0x40a0, 0x50a0, 0x6940, 0x8a21, 0x9263, 0x9263, 0x9ae5, 0xb52c, 0xa488, 
	0xa488, 0xa4eb, 0xa50c, 0x83c9, 0x2944, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x9be7, 0xcdcd, 0xc56b, 0xbd09, 
	0xbce8, 0xcd8b, 0xabe8, 0x9263, 0x9263, 0x9243, 0x8203, 0x69a2, 0x5120, 0x48c0, 0x40e0, 0x40e1, 0x40e1, 0x48e1, 0x48e1, 0x48e1, 
	0x4902, 0x4902, 0x4902, 0x4902, 0x4922, 0x4102, 0x38e2, 0x30a1, 0x3081, 0x2860, 0x2820, 0x2000, 0x2840, 0x38a0, 0x4900, 0x5180, 
	0x59a1, 0x61c0, 0x61c1, 0x6203, 0x59e3, 0x49a3, 0x30e1, 0x1040, 0x0800, 0x0000, 0x0821, 0x0862, 0x1083, 0x1084, 0x1084, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0863, 0x0863, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0843, 0x0843, 0x1042, 
	0x1841, 0x2840, 0x3060, 0x30c1, 0x28c2, 0x2081, 0x1020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2860, 0x40e0, 0x5960, 
	0x61a1, 0x69c2, 0x69e2, 0x61c2, 0x5162, 0x4101, 0x38a0, 0x2860, 0x2040, 0x2040, 0x2880, 0x38e2, 0x4123, 0x4943, 0x4943, 0x4923, 
	0x4923, 0x4923, 0x4103, 0x4102, 0x4102, 0x40e1, 0x38a0, 0x3860, 0x48a0, 0x79a0, 0x9242, 0x9263, 0x9263, 0x9ac5, 0xad0a, 0xacc8, 
	0xa488, 0xad2c, 0xa4ec, 0x62c7, 0x10e4, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x5a45, 0xbd4c, 0xcdcd, 0xbd09, 
	0xb4a7, 0xcd6b, 0xabe8, 0x9263, 0x9263, 0x9243, 0x8a44, 0x71c3, 0x5920, 0x3880, 0x3860, 0x3880, 0x3880, 0x3880, 0x3880, 0x3880, 
	0x3880, 0x38a1, 0x38a1, 0x38a1, 0x38a1, 0x30a1, 0x3081, 0x2860, 0x2040, 0x2020, 0x2000, 0x2000, 0x2000, 0x3060, 0x40e0, 0x5160, 
	0x59a0, 0x59a0, 0x61c0, 0x6202, 0x59e3, 0x4983, 0x28c1, 0x1040, 0x0800, 0x0000, 0x0821, 0x0862, 0x1083, 0x1084, 0x1084, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0843, 0x0842, 0x1042, 
	0x2041, 0x2860, 0x3080, 0x30c1, 0x30c2, 0x2081, 0x1020, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x1000, 0x2020, 0x38c0, 0x5940, 
	0x61a1, 0x69c2, 0x61c2, 0x61c2, 0x5982, 0x4101, 0x3080, 0x2860, 0x2040, 0x1820, 0x2060, 0x3081, 0x38c2, 0x38e2, 0x38e2, 0x38e2, 
	0x38c2, 0x38c2, 0x30a1, 0x3061, 0x2860, 0x2840, 0x2840, 0x3040, 0x50a0, 0x8a00, 0x9a82, 0x9263, 0x9263, 0x9ac4, 0xb4ea, 0xb4e9, 
	0xa4a8, 0xb56d, 0xaceb, 0x4a26, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xacaa, 0xcdee, 0xb4e9, 
	0xb487, 0xc52a, 0xabc7, 0x9263, 0x9263, 0x9243, 0x9284, 0x7a04, 0x5921, 0x3840, 0x2800, 0x2800, 0x3040, 0x3040, 0x3020, 0x3020, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2840, 0x2820, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2840, 0x40e0, 0x5160, 
	0x59a1, 0x61c0, 0x61c1, 0x61e2, 0x51c3, 0x4142, 0x28c0, 0x1020, 0x0800, 0x0000, 0x0821, 0x0862, 0x1083, 0x1084, 0x1084, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0843, 0x0822, 0x1042, 
	0x2041, 0x2860, 0x3080, 0x38e1, 0x30c2, 0x2081, 0x1020, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800, 0x1820, 0x38a0, 0x5140, 
	0x5981, 0x61a2, 0x61c2, 0x61a2, 0x5162, 0x40e1, 0x3080, 0x2840, 0x2020, 0x1820, 0x2020, 0x2040, 0x2840, 0x2840, 0x2840, 0x2840, 
	0x2840, 0x2040, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x3820, 0x50c0, 0x89e0, 0x9a62, 0x9263, 0x9263, 0x9ac4, 0xb4e9, 0xb4e9, 
	0xa4a9, 0xb58d, 0xad0b, 0x4226, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x9c29, 0xc58c, 0xacc9, 
	0xac47, 0xb488, 0xa366, 0x9263, 0x9263, 0x9243, 0x9284, 0x8224, 0x6141, 0x3860, 0x2820, 0x2800, 0x2820, 0x3020, 0x3020, 0x2820, 
	0x2800, 0x2800, 0x2800, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2820, 0x40e0, 0x5981, 
	0x61e2, 0x6a02, 0x6201, 0x61e2, 0x51a2, 0x4142, 0x28a0, 0x1020, 0x0800, 0x0000, 0x0801, 0x0862, 0x1083, 0x10a4, 0x10a4, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0863, 0x0883, 0x0884, 0x0883, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0822, 0x1042, 
	0x2041, 0x2860, 0x3080, 0x38e1, 0x30e2, 0x2081, 0x0820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1800, 0x38c0, 0x5981, 
	0x61e2, 0x6a03, 0x6a03, 0x69e3, 0x61a3, 0x5143, 0x38c1, 0x2840, 0x1800, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x3840, 0x5900, 0x89e0, 0x9a62, 0x9263, 0x9263, 0x9ac4, 0xaca8, 0xaca8, 
	0xa4a9, 0xb54c, 0xacaa, 0x3185, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x8346, 0xacaa, 0xa469, 
	0xa427, 0xac67, 0xa365, 0x9263, 0x9263, 0x9243, 0x9264, 0x8a45, 0x6162, 0x3860, 0x2820, 0x2800, 0x2820, 0x2820, 0x2820, 0x2800, 
	0x2800, 0x2800, 0x2800, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x3060, 0x4920, 0x61e2, 
	0x7243, 0x7243, 0x6a22, 0x6223, 0x59e3, 0x4983, 0x30c1, 0x1840, 0x0800, 0x0000, 0x0800, 0x0862, 0x1083, 0x10a4, 0x10a4, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0822, 0x1041, 
	0x2040, 0x2840, 0x3060, 0x38e1, 0x30e2, 0x2081, 0x0820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x38e0, 0x6a03, 
	0x7244, 0x7a64, 0x7a84, 0x7a65, 0x7245, 0x61e5, 0x4923, 0x2860, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x4060, 0x6120, 0x8a00, 0x9a62, 0x9263, 0x9263, 0x92a4, 0x9c26, 0x9c27, 
	0x9c8a, 0xa4cb, 0x8be8, 0x2144, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x8346, 0xc54c, 0xc56c, 
	0xbd09, 0xc4e8, 0xc52a, 0xabe8, 0x9263, 0x9243, 0x9264, 0x8a65, 0x6962, 0x4060, 0x2820, 0x2800, 0x2820, 0x2820, 0x3020, 0x2820, 
	0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2040, 0x2040, 0x2040, 0x2020, 0x2000, 0x2000, 0x2820, 0x38a0, 0x5181, 0x6a23, 
	0x7264, 0x7263, 0x7243, 0x6a44, 0x6245, 0x51e5, 0x3922, 0x1860, 0x0800, 0x0000, 0x0800, 0x0842, 0x1083, 0x10a4, 0x10a4, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0822, 0x1041, 
	0x2040, 0x2840, 0x3060, 0x38c1, 0x30e2, 0x2081, 0x0820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1820, 0x3901, 0x6a03, 
	0x6a03, 0x6a03, 0x6a03, 0x6a04, 0x6a25, 0x61e5, 0x5164, 0x3081, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x4060, 0x6940, 0x9221, 0x9263, 0x9263, 0x9b25, 0xbd2b, 0xb4c8, 0xaca8, 
	0xb52b, 0xbd4d, 0x7348, 0x18e4, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x62a6, 0xbd4c, 0xd5ed, 
	0xc56a, 0xc528, 0xcd8b, 0xb469, 0x9263, 0x9263, 0x9263, 0x9266, 0x6983, 0x4080, 0x3020, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 0x38a0, 0x5141, 0x59c1, 
	0x59a1, 0x5980, 0x5980, 0x59c2, 0x59e4, 0x51c4, 0x3923, 0x2060, 0x0800, 0x0000, 0x0800, 0x0862, 0x1083, 0x10a3, 0x10a4, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0822, 0x1021, 
	0x1840, 0x2840, 0x3060, 0x38e1, 0x30e2, 0x20a1, 0x0820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1840, 0x3901, 0x59a2, 
	0x5981, 0x5140, 0x5160, 0x5982, 0x59a3, 0x5984, 0x4923, 0x3081, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 0x1820, 
	0x1800, 0x1820, 0x1800, 0x1000, 0x1800, 0x1800, 0x2000, 0x4060, 0x6940, 0x9222, 0x9263, 0x9263, 0xa366, 0xcded, 0xbd29, 0xb4e9, 
	0xbd8d, 0xcdce, 0x4226, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x9c6b, 0xd62e, 
	0xc56a, 0xbd08, 0xcd8b, 0xb469, 0x9263, 0x9263, 0x9263, 0x9286, 0x71a3, 0x4080, 0x3020, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 0x3080, 0x40e0, 0x4920, 
	0x4900, 0x4100, 0x4900, 0x5161, 0x5183, 0x4183, 0x3102, 0x1860, 0x0800, 0x0000, 0x0800, 0x1062, 0x10a3, 0x1083, 0x1084, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0822, 0x1021, 
	0x1840, 0x2840, 0x3060, 0x3901, 0x3902, 0x20a1, 0x1040, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0820, 0x1840, 0x30c0, 0x4920, 
	0x40e0, 0x40e0, 0x4900, 0x4900, 0x4101, 0x40c1, 0x3881, 0x2840, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x1800, 
	0x1800, 0x1800, 0x1000, 0x1000, 0x1800, 0x1800, 0x2000, 0x4060, 0x7160, 0x9242, 0x9263, 0x9263, 0xa366, 0xd62e, 0xc54a, 0xb509, 
	0xc5ce, 0xce0f, 0x4a26, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x9c6b, 0xde6f, 
	0xc56b, 0xbd08, 0xcd8b, 0xb469, 0x9263, 0x9263, 0x9263, 0x9286, 0x71a3, 0x40a0, 0x3040, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 0x38a0, 0x4100, 
	0x4920, 0x5140, 0x5160, 0x51a2, 0x4982, 0x3922, 0x2080, 0x1020, 0x0800, 0x0800, 0x0800, 0x1062, 0x10a3, 0x10a3, 0x1084, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0843, 0x0842, 0x1041, 
	0x2040, 0x2840, 0x3060, 0x4101, 0x3922, 0x28c1, 0x1040, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1020, 0x2880, 0x40e0, 
	0x40e0, 0x4900, 0x5140, 0x4920, 0x40e0, 0x3080, 0x2840, 0x2020, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1820, 0x1000, 0x1000, 0x1800, 0x1800, 0x2000, 0x4080, 0x7180, 0x9242, 0x9263, 0x9263, 0xa366, 0xd62e, 0xc54a, 0xb52a, 
	0xc5ee, 0xce0e, 0x4226, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x946b, 0xde70, 
	0xc56b, 0xb509, 0xc58b, 0xb469, 0x9263, 0x9263, 0x9263, 0x9285, 0x71a3, 0x48a0, 0x3040, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x3080, 0x4920, 
	0x5180, 0x59a1, 0x61c1, 0x6203, 0x49a3, 0x30e1, 0x1860, 0x0800, 0x0800, 0x0800, 0x0820, 0x1062, 0x18a3, 0x10a3, 0x1084, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0843, 0x0842, 0x1041, 
	0x2040, 0x2840, 0x3060, 0x4101, 0x3922, 0x28c1, 0x1040, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x2040, 0x40e0, 
	0x5161, 0x59a2, 0x61c2, 0x59a2, 0x5142, 0x38a1, 0x2820, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1820, 0x1820, 0x1820, 0x1000, 0x1800, 0x1800, 0x2000, 0x4080, 0x7180, 0x9222, 0x9263, 0x9263, 0xa366, 0xd62e, 0xc56a, 0xb529, 
	0xc5ee, 0xce0f, 0x4206, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 
	0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x946b, 0xde70, 
	0xc56b, 0xb509, 0xc58b, 0xb449, 0x9263, 0x9263, 0x9263, 0x9285, 0x71a3, 0x48a0, 0x3040, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x1820, 0x2020, 0x2000, 0x2000, 0x2000, 0x2820, 0x38a0, 0x5160, 
	0x61e2, 0x6a22, 0x6a23, 0x6a44, 0x51c3, 0x3101, 0x1860, 0x0800, 0x0800, 0x0800, 0x0821, 0x1062, 0x10a3, 0x10a3, 0x1084, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0863, 
	0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0843, 0x0842, 0x1041, 
	0x2060, 0x2840, 0x3860, 0x4101, 0x4142, 0x28e1, 0x1040, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x2040, 0x40e0, 
	0x5182, 0x61e3, 0x61e3, 0x61c3, 0x5163, 0x40c1, 0x2840, 0x2000, 0x1800, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1820, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x4080, 0x7160, 0x9222, 0x9263, 0x9263, 0xa386, 0xde4e, 0xc56a, 0xbd29, 
	0xce0e, 0xd62f, 0x4206, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0xef10, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 
	0xef10, 0xef10, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x8c4b, 0xde70, 
	0xc58b, 0xb509, 0xc58c, 0xb449, 0x9263, 0x9263, 0x9263, 0x9285, 0x71c3, 0x48c0, 0x3040, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2820, 0x38c0, 0x5160, 
	0x61e2, 0x6a22, 0x7243, 0x6a44, 0x51c4, 0x3902, 0x2060, 0x0800, 0x0800, 0x0800, 0x0801, 0x1062, 0x10a3, 0x10a3, 0x1084, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0842, 0x1041, 
	0x2040, 0x2840, 0x3860, 0x4121, 0x4142, 0x3102, 0x1040, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1000, 0x2040, 0x40e0, 
	0x5982, 0x6203, 0x61e2, 0x61c3, 0x5983, 0x40e1, 0x2840, 0x2000, 0x1800, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x4080, 0x7160, 0x9222, 0x9263, 0x9263, 0xa386, 0xde4e, 0xc56a, 0xbd4a, 
	0xce0e, 0xd64f, 0x4226, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0xef10, 0xef10, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 
	0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x8c4b, 0xd670, 
	0xc58b, 0xb509, 0xbd8c, 0xb449, 0x9263, 0x9263, 0x9263, 0x9aa6, 0x79e3, 0x48c0, 0x3040, 0x2800, 0x2820, 0x3040, 0x3040, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2040, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2800, 0x38a0, 0x5160, 
	0x61e2, 0x6a22, 0x7243, 0x6a44, 0x59e4, 0x3922, 0x2080, 0x1000, 0x0800, 0x0800, 0x0800, 0x1062, 0x18a3, 0x10a3, 0x1084, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 
	0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0842, 0x1041, 
	0x2040, 0x2840, 0x3880, 0x4922, 0x4143, 0x3122, 0x1860, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x2040, 0x38e0, 
	0x59a2, 0x6203, 0x61c2, 0x61c3, 0x59a3, 0x40e1, 0x2840, 0x2000, 0x1800, 0x1800, 0x1820, 0x1820, 0x1800, 0x1800, 0x1820, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2000, 0x4080, 0x7160, 0x9242, 0x9263, 0x9263, 0xab87, 0xde6f, 0xc58a, 0xbd6a, 
	0xce0f, 0xde4f, 0x4a46, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0xef10, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 
	0xef10, 0xef10, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x8c4b, 0xd670, 
	0xc58b, 0xb509, 0xbd8b, 0xac49, 0x9263, 0x9263, 0x9263, 0x9ac6, 0x7a04, 0x50e0, 0x3860, 0x2800, 0x3020, 0x3040, 0x3040, 0x2840, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2040, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x38a0, 0x5140, 
	0x61e2, 0x6a22, 0x7242, 0x6a64, 0x5a04, 0x3943, 0x2080, 0x0800, 0x0800, 0x0800, 0x0800, 0x1061, 0x18a2, 0x10a3, 0x1084, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 0x0883, 0x0883, 0x0883, 0x0883, 0x0884, 0x0884, 
	0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0822, 0x1021, 
	0x2020, 0x2840, 0x3880, 0x4922, 0x4963, 0x3942, 0x1880, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x2040, 0x38e0, 
	0x51a2, 0x6203, 0x61c2, 0x61c3, 0x59a3, 0x40e1, 0x2840, 0x2020, 0x1800, 0x1800, 0x2020, 0x2020, 0x1820, 0x1820, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1820, 0x1800, 0x2000, 0x2000, 0x4060, 0x6960, 0x9222, 0x9263, 0x9263, 0xab87, 0xde6f, 0xc58a, 0xc56a, 
	0xce0f, 0xde4f, 0x4206, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 
	0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x8c4b, 0xd670, 
	0xc58b, 0xb509, 0xbd6b, 0xac49, 0x9263, 0x9263, 0x9263, 0x9ae6, 0x7a24, 0x5101, 0x3860, 0x2800, 0x3040, 0x3040, 0x3040, 0x2840, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x3060, 0x4920, 
	0x61e2, 0x6a22, 0x7263, 0x7285, 0x5a24, 0x4143, 0x2080, 0x0800, 0x0800, 0x0800, 0x0800, 0x1861, 0x20a2, 0x18a3, 0x1083, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 0x0883, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x1021, 
	0x2040, 0x3040, 0x4080, 0x4921, 0x4963, 0x4163, 0x2080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0020, 0x0800, 0x2040, 0x38e0, 
	0x51a2, 0x6203, 0x61c2, 0x61c3, 0x59a3, 0x40e1, 0x2840, 0x2020, 0x1800, 0x1800, 0x2020, 0x2020, 0x1820, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1820, 0x1800, 0x1800, 0x1800, 0x3860, 0x6940, 0x9222, 0x9263, 0x9263, 0xab87, 0xde6e, 0xc58a, 0xc56a, 
	0xce0e, 0xd62f, 0x39e6, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x8c4b, 0xd650, 
	0xc58b, 0xb4e9, 0xbd4b, 0xac49, 0x9263, 0x9263, 0x9263, 0x9ae6, 0x8224, 0x5901, 0x3860, 0x2800, 0x3040, 0x3040, 0x3040, 0x2840, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x1800, 0x2000, 0x2840, 0x4900, 
	0x61e2, 0x7242, 0x7263, 0x7285, 0x6225, 0x4163, 0x2080, 0x0800, 0x0800, 0x0800, 0x0800, 0x1861, 0x20c2, 0x18a3, 0x1083, 0x0884, 
	0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0043, 0x0043, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0022, 0x0022, 0x0022, 0x0821, 
	0x2040, 0x3040, 0x4080, 0x4921, 0x5183, 0x4963, 0x2080, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1840, 0x38e0, 
	0x51a2, 0x6a03, 0x61e2, 0x61c3, 0x59a3, 0x40e1, 0x2840, 0x2020, 0x2000, 0x1800, 0x2020, 0x2020, 0x1820, 0x1820, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1820, 0x1820, 0x1800, 0x1800, 0x1800, 0x3840, 0x6120, 0x9222, 0x9263, 0x9263, 0xab87, 0xde6f, 0xc58a, 0xc569, 
	0xce0e, 0xd62e, 0x4206, 0x0083, 0x0083, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 
	0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x8c4b, 0xd62f, 
	0xc56b, 0xace9, 0xb54c, 0xac29, 0x9263, 0x9263, 0x9263, 0x9ae6, 0x8225, 0x5921, 0x3860, 0x2800, 0x3040, 0x3040, 0x3040, 0x2840, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2840, 0x4900, 
	0x61e1, 0x7242, 0x7262, 0x72a5, 0x6225, 0x4163, 0x2080, 0x0800, 0x0800, 0x0800, 0x0800, 0x20a1, 0x3103, 0x20e3, 0x10a4, 0x0884, 
	0x0864, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0042, 0x0021, 0x0821, 
	0x2040, 0x3040, 0x4080, 0x5122, 0x51a3, 0x4983, 0x20a0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1840, 0x38e0, 
	0x51a2, 0x6a23, 0x61e2, 0x61c3, 0x59a3, 0x40e1, 0x2840, 0x2020, 0x2000, 0x1800, 0x1800, 0x1820, 0x1820, 0x1820, 0x1820, 0x1800, 
	0x1800, 0x1820, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x3040, 0x58e0, 0x9222, 0x9263, 0x9263, 0xab87, 0xe68f, 0xc58a, 0xc549, 
	0xd60d, 0xd64f, 0x4226, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x8c4b, 0xce0e, 
	0xbd4a, 0xacc9, 0xb54b, 0xac29, 0x9263, 0x9263, 0x9263, 0xa2e6, 0x8245, 0x5921, 0x3860, 0x2800, 0x3040, 0x3040, 0x3040, 0x3040, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x3040, 0x4900, 
	0x61e1, 0x7242, 0x7262, 0x72a5, 0x6245, 0x4163, 0x2080, 0x0800, 0x0800, 0x0800, 0x1000, 0x30e2, 0x4184, 0x2924, 0x18c4, 0x0864, 
	0x0864, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0042, 0x0042, 0x0021, 0x0821, 
	0x2040, 0x3040, 0x40a0, 0x5142, 0x59a3, 0x51a4, 0x28a0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1840, 0x30e0, 
	0x51a2, 0x6a23, 0x61e2, 0x61c2, 0x59a3, 0x40e2, 0x2840, 0x2020, 0x2000, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 0x1820, 0x1820, 
	0x1820, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x3020, 0x58c0, 0x9222, 0x9263, 0x9263, 0xab87, 0xe68f, 0xc58a, 0xc549, 
	0xd5ec, 0xde6f, 0x4a46, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x8c4b, 0xc5cd, 
	0xbd4a, 0xacc9, 0xb52b, 0xac29, 0x9263, 0x9263, 0x9263, 0xa2e6, 0x8245, 0x5921, 0x3860, 0x2800, 0x2820, 0x3040, 0x3040, 0x3040, 
	0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x3040, 0x4900, 
	0x61e1, 0x7242, 0x7262, 0x72a5, 0x6244, 0x4183, 0x2080, 0x0800, 0x0800, 0x0800, 0x1000, 0x3923, 0x49c5, 0x3124, 0x18a4, 0x0044, 
	0x0864, 0x0864, 0x0884, 0x0884, 0x0864, 0x0884, 0x0884, 0x0884, 0x0884, 0x0883, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0864, 
	0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0042, 0x0022, 0x0021, 0x0821, 
	0x2040, 0x3040, 0x40a0, 0x5142, 0x61c4, 0x6204, 0x30c1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1840, 0x30c0, 
	0x51a2, 0x6a23, 0x61e2, 0x61c3, 0x61a3, 0x4102, 0x3040, 0x2020, 0x2000, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 0x1820, 0x1820, 
	0x1820, 0x1800, 0x1800, 0x1000, 0x1800, 0x1800, 0x1800, 0x2800, 0x50a0, 0x8a01, 0x9263, 0x9263, 0xa326, 0xcd6c, 0xc56a, 0xc528, 
	0xd5cb, 0xe66f, 0x5266, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x842b, 0xbd6c, 
	0xb50a, 0xa4a9, 0xad0b, 0xa409, 0x9263, 0x9263, 0x9263, 0xa307, 0x8245, 0x5121, 0x3040, 0x2000, 0x2820, 0x3040, 0x3040, 0x3040, 
	0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2840, 0x4100, 
	0x61e1, 0x7242, 0x7a62, 0x72a5, 0x6245, 0x4183, 0x20a1, 0x0800, 0x0800, 0x0800, 0x1000, 0x4163, 0x5a06, 0x3965, 0x18c4, 0x0044, 
	0x0864, 0x0864, 0x0864, 0x0864, 0x0864, 0x0864, 0x0884, 0x0884, 0x0884, 0x0883, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0864, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0021, 0x0821, 
	0x2040, 0x3040, 0x48a0, 0x5942, 0x6a04, 0x7266, 0x3901, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1840, 0x30c0, 
	0x51a2, 0x6a23, 0x61e2, 0x61e3, 0x61c3, 0x4902, 0x3060, 0x2020, 0x2000, 0x1800, 0x1800, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 
	0x1820, 0x1800, 0x1000, 0x1000, 0x1800, 0x1800, 0x1800, 0x2800, 0x4860, 0x81a0, 0x9a62, 0x9263, 0x9263, 0x9ae4, 0xc56a, 0xbd08, 
	0xcd6a, 0xd5ee, 0x9c6a, 0x2144, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x4a66, 0x9c8b, 0xa4a9, 
	0xa489, 0x9c48, 0xa449, 0xa387, 0x9263, 0x9263, 0x9a84, 0x9b07, 0x7a25, 0x5101, 0x3040, 0x2000, 0x2820, 0x3040, 0x3040, 0x3040, 
	0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2840, 0x4100, 
	0x61e1, 0x7242, 0x7a83, 0x72a5, 0x6245, 0x4983, 0x28a1, 0x1000, 0x0800, 0x0800, 0x1000, 0x4983, 0x6246, 0x41a5, 0x20e4, 0x0864, 
	0x0864, 0x0864, 0x0864, 0x0864, 0x0864, 0x0864, 0x0864, 0x0864, 0x0863, 0x0883, 0x0883, 0x0884, 0x0884, 0x0884, 0x0864, 0x0864, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0021, 0x0821, 
	0x2040, 0x3040, 0x48c0, 0x61a3, 0x7a86, 0x8b08, 0x4963, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x1840, 0x30c0, 
	0x51a2, 0x6a23, 0x69e2, 0x61e3, 0x61c4, 0x4902, 0x3060, 0x2020, 0x2000, 0x1800, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 
	0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x2000, 0x4040, 0x7980, 0x9a62, 0x9263, 0x9263, 0x9ae4, 0xc549, 0xb4a8, 
	0xbcc8, 0xb50b, 0xacca, 0x3185, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x5265, 0x8c09, 0x8bc7, 
	0x8bc7, 0x8ba7, 0x8ae5, 0x9263, 0x9263, 0x9263, 0xa2c5, 0x9ac7, 0x7204, 0x48e0, 0x3040, 0x2000, 0x2840, 0x3040, 0x3040, 0x3040, 
	0x3040, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2840, 0x40e0, 
	0x61c1, 0x7242, 0x7a83, 0x72a5, 0x6245, 0x4984, 0x28a1, 0x0800, 0x0800, 0x0800, 0x1000, 0x4983, 0x6266, 0x41a5, 0x20e4, 0x0843, 
	0x0864, 0x0884, 0x0884, 0x0864, 0x0864, 0x0864, 0x0884, 0x0884, 0x0884, 0x0883, 0x0884, 0x0884, 0x0884, 0x0884, 0x0864, 0x0864, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0021, 0x0821, 
	0x2040, 0x3040, 0x48c0, 0x69c3, 0x8b08, 0x9baa, 0x59c4, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0820, 0x0800, 0x1840, 0x30c0, 
	0x51a2, 0x6a03, 0x69e2, 0x69e3, 0x61c4, 0x4902, 0x3060, 0x2000, 0x1800, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1800, 0x1820, 
	0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x2000, 0x3820, 0x7160, 0x9242, 0x9263, 0x9263, 0x9ac4, 0xb4c8, 0xac47, 
	0xa406, 0xa468, 0xaca9, 0x39e5, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x5ac6, 0xa4ab, 0x9c07, 
	0x9427, 0x9408, 0x8b05, 0x9263, 0x9263, 0x9263, 0x9ac5, 0x92a6, 0x69a3, 0x40a0, 0x3040, 0x2800, 0x3040, 0x3040, 0x3040, 0x3040, 
	0x3040, 0x3040, 0x3020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2840, 0x40e0, 
	0x59c1, 0x6a42, 0x7283, 0x72a5, 0x6245, 0x49a4, 0x28a1, 0x1000, 0x0800, 0x0800, 0x1000, 0x4982, 0x6a86, 0x49a5, 0x20e3, 0x0043, 
	0x0863, 0x0884, 0x0884, 0x0884, 0x0884, 0x0864, 0x0884, 0x0884, 0x0884, 0x0883, 0x0884, 0x0884, 0x0884, 0x0884, 0x0864, 0x0864, 
	0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0022, 0x0021, 0x0841, 
	0x2060, 0x3040, 0x48a0, 0x69c3, 0x9308, 0xabeb, 0x5a04, 0x1820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0820, 0x0800, 0x1840, 0x30c0, 
	0x51a2, 0x6a23, 0x69e2, 0x69e3, 0x61c4, 0x4902, 0x3060, 0x2000, 0x2000, 0x2020, 0x1820, 0x1820, 0x1820, 0x1820, 0x1800, 0x1820, 
	0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x1800, 0x3000, 0x6120, 0x8a22, 0x9263, 0x9263, 0x9ae5, 0xc56b, 0xbce9, 
	0xb466, 0xb4c9, 0xbd2a, 0x5266, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x7388, 0xa4ca, 0xa468, 
	0x9c68, 0x9c8a, 0x9b66, 0x9263, 0x9263, 0x9263, 0x9ac5, 0x8a65, 0x6182, 0x3880, 0x3040, 0x2820, 0x2840, 0x3040, 0x3040, 0x3040, 
	0x3040, 0x3020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2820, 0x40e0, 
	0x59c1, 0x6a42, 0x7283, 0x72a5, 0x6a65, 0x49a4, 0x28c1, 0x1000, 0x0800, 0x0800, 0x1000, 0x51a2, 0x72a6, 0x49c5, 0x20e3, 0x0023, 
	0x0843, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x0864, 0x0063, 0x0063, 0x0063, 0x0063, 0x0864, 0x0884, 0x0884, 0x0884, 0x0884, 
	0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0022, 0x0021, 0x0841, 
	0x2060, 0x3040, 0x4080, 0x6182, 0x9307, 0xabeb, 0x6204, 0x1820, 0x0000, 0x0000, 0x0000, 0x0800, 0x0820, 0x0800, 0x1840, 0x30c0, 
	0x51a2, 0x6a24, 0x69e2, 0x69e3, 0x61e4, 0x4902, 0x3060, 0x2020, 0x2000, 0x2020, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 
	0x1820, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x3000, 0x58e0, 0x8a02, 0x9263, 0x9263, 0xa305, 0xde2e, 0xbce9, 
	0xb4a7, 0xbce8, 0xcdac, 0x5ac7, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x7bea, 0x9c69, 0xa488, 
	0x9c68, 0xa4cb, 0x9b87, 0x9263, 0x9263, 0x9263, 0x9aa6, 0x8245, 0x5942, 0x3860, 0x2820, 0x2820, 0x2840, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2000, 0x2820, 0x40e0, 
	0x59c1, 0x6a22, 0x7262, 0x72a5, 0x6a65, 0x49c4, 0x28c1, 0x1000, 0x1000, 0x0800, 0x1800, 0x59c3, 0x82e7, 0x5205, 0x28e3, 0x0022, 
	0x0043, 0x0864, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0064, 0x0064, 0x0064, 0x0064, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0044, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0042, 0x0022, 0x0022, 0x0841, 
	0x2060, 0x2820, 0x4060, 0x6161, 0x8ae7, 0xabea, 0x6204, 0x1820, 0x0800, 0x0000, 0x0000, 0x0800, 0x0820, 0x0800, 0x1840, 0x30c0, 
	0x59a2, 0x6a44, 0x69e2, 0x69e3, 0x61e4, 0x4922, 0x3060, 0x2020, 0x2000, 0x2020, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x2800, 0x50a0, 0x81e1, 0x9263, 0x9263, 0x9b05, 0xd5ed, 0xbd29, 
	0xbcc7, 0xcd29, 0xd5cd, 0x944a, 0x2944, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x4226, 0x9cac, 0x9427, 0xa488, 
	0x9c48, 0xa4ec, 0x9ba8, 0x9263, 0x9263, 0x9264, 0x9aa6, 0x7a04, 0x5121, 0x3040, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 0x40c0, 
	0x59a1, 0x6a22, 0x7262, 0x72a5, 0x6a65, 0x51c4, 0x30c1, 0x1000, 0x1000, 0x1000, 0x1800, 0x6a03, 0x8b48, 0x6246, 0x3124, 0x0022, 
	0x0023, 0x0864, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0064, 0x0063, 0x0063, 0x0063, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0022, 0x0042, 0x1041, 
	0x2060, 0x3020, 0x4060, 0x5941, 0x8ac6, 0xb40a, 0x6204, 0x1820, 0x0800, 0x0000, 0x0000, 0x0000, 0x0820, 0x1000, 0x2040, 0x30c0, 
	0x51a2, 0x6a24, 0x69e2, 0x69e3, 0x61e4, 0x4923, 0x3061, 0x2020, 0x1800, 0x1820, 0x2020, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x2800, 0x4060, 0x79c1, 0x9263, 0x9263, 0x9263, 0x9aa4, 0xcdab, 
	0xc508, 0xcd28, 0xcdab, 0xcdad, 0x4a46, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x6b68, 0xad0c, 0x93c6, 0xa468, 
	0x9c69, 0xad0c, 0xa3c8, 0x9263, 0x9263, 0x9a84, 0x9285, 0x71c3, 0x48e1, 0x3020, 0x2800, 0x2000, 0x2820, 0x2820, 0x2800, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 0x40c0, 
	0x59a1, 0x6a22, 0x7262, 0x72a5, 0x6a65, 0x51c4, 0x30c1, 0x1000, 0x1000, 0x1000, 0x2000, 0x7265, 0x9baa, 0x6aa8, 0x3145, 0x0022, 
	0x0023, 0x0864, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0022, 0x0042, 0x1041, 
	0x2060, 0x3020, 0x4060, 0x5941, 0x8ac6, 0xb40a, 0x6a24, 0x1840, 0x0800, 0x0000, 0x0000, 0x0000, 0x0820, 0x1000, 0x2060, 0x38c0, 
	0x51a2, 0x6a23, 0x69e2, 0x69e3, 0x61e4, 0x4923, 0x3081, 0x2020, 0x1800, 0x1820, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x2800, 0x3820, 0x5900, 0x8a22, 0x9263, 0x9263, 0x9aa4, 0xd60d, 
	0xc529, 0xc4e7, 0xcd4a, 0xcdcd, 0x62e7, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x7bc9, 0xa4ab, 0x9be6, 0x9c48, 
	0x9c89, 0x9326, 0x9263, 0x9263, 0x9a83, 0xa2c6, 0x8a65, 0x6982, 0x40a0, 0x2800, 0x2000, 0x2000, 0x2020, 0x2800, 0x2800, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 0x40c0, 
	0x59a1, 0x6a02, 0x7262, 0x7284, 0x6a65, 0x51e4, 0x30c1, 0x1000, 0x1000, 0x1000, 0x2020, 0x7aa6, 0xac2c, 0x7b09, 0x3985, 0x0022, 
	0x0022, 0x0864, 0x0064, 0x0064, 0x0063, 0x0063, 0x0064, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x1041, 
	0x2040, 0x3020, 0x4080, 0x5941, 0x8ae6, 0xb42a, 0x6a44, 0x1840, 0x0800, 0x0000, 0x0000, 0x0000, 0x0820, 0x1000, 0x2040, 0x38e0, 
	0x51a2, 0x6a23, 0x69e2, 0x61e3, 0x61e4, 0x4922, 0x2881, 0x2020, 0x1800, 0x1820, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1000, 0x1000, 0x1800, 0x2000, 0x3020, 0x50e0, 0x8202, 0x9263, 0x9263, 0x9ac4, 0xde4f, 
	0xbd09, 0xbcc7, 0xcd29, 0xd5ed, 0x7348, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 
	0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x8c4b, 0x9c48, 0x9c48, 0x9427, 
	0x9caa, 0x9346, 0x9263, 0x9263, 0x9a84, 0x9ac6, 0x8245, 0x5942, 0x3880, 0x2800, 0x2000, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 0x40c0, 
	0x59a1, 0x6a02, 0x7262, 0x7284, 0x6a65, 0x51e4, 0x30e1, 0x1800, 0x1000, 0x1000, 0x2840, 0x82e7, 0xb46d, 0x836b, 0x41a6, 0x0822, 
	0x0042, 0x0864, 0x0064, 0x0064, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 
	0x0043, 0x0043, 0x0043, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x1041, 
	0x2040, 0x3020, 0x4880, 0x6161, 0x9306, 0xbc4a, 0x6a44, 0x1840, 0x0800, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x2040, 0x38e0, 
	0x59a2, 0x6a23, 0x69e2, 0x61e3, 0x61e4, 0x4122, 0x2860, 0x2000, 0x1800, 0x1820, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1820, 0x1800, 0x1800, 0x1000, 0x1000, 0x1800, 0x1800, 0x2000, 0x2800, 0x48a0, 0x79e2, 0x9263, 0x9263, 0x9aa4, 0xd62f, 
	0xc54a, 0xbd08, 0xc508, 0xcd8b, 0x9c8a, 0x31a5, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 
	0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x08a3, 0x3a06, 0x9ccb, 0x9c07, 0xa468, 0x9407, 
	0xa4ec, 0x9b67, 0x9263, 0x9263, 0x9a84, 0x9ac6, 0x7a04, 0x5101, 0x3840, 0x2800, 0x2000, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 0x40c0, 
	0x5981, 0x6a02, 0x7242, 0x7284, 0x6a65, 0x51e4, 0x30e1, 0x1800, 0x1000, 0x1000, 0x2860, 0x8307, 0xbc8d, 0x8b8b, 0x49c6, 0x0822, 
	0x0042, 0x0884, 0x0064, 0x0064, 0x0043, 0x0043, 0x0063, 0x0063, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 
	0x0043, 0x0043, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x1041, 
	0x2040, 0x3020, 0x4880, 0x6182, 0x9307, 0xbc4a, 0x6a65, 0x2060, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x2040, 0x38e0, 
	0x59a2, 0x6a24, 0x69e2, 0x69e3, 0x61e4, 0x4122, 0x2860, 0x1800, 0x1800, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x3860, 0x71a1, 0x9263, 0x9263, 0x9263, 0x9ac4, 
	0xc54a, 0xc529, 0xbcc7, 0xc529, 0xc58c, 0x7348, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 
	0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x08c4, 0x8c4b, 0xaceb, 0x93e5, 0x9c68, 0x9429, 
	0x9305, 0x9264, 0x9263, 0x9263, 0x9aa4, 0x9285, 0x69a3, 0x48c0, 0x3040, 0x2800, 0x2800, 0x2820, 0x2820, 0x2020, 0x2000, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 0x40c0, 
	0x5981, 0x6a02, 0x7242, 0x7284, 0x6a65, 0x59e4, 0x30e1, 0x1800, 0x1000, 0x1000, 0x2860, 0x8307, 0xbc8d, 0x8bac, 0x49c6, 0x0801, 
	0x0022, 0x0864, 0x0064, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x1041, 
	0x2040, 0x3040, 0x4880, 0x6982, 0x9327, 0xbc4a, 0x6a65, 0x2060, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1840, 0x38c0, 
	0x5182, 0x6a03, 0x69e2, 0x69e3, 0x61e4, 0x4122, 0x2860, 0x2000, 0x1800, 0x2000, 0x2020, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x3840, 0x58e0, 0x81e2, 0x9263, 0x9263, 0x9263, 
	0xcdac, 0xbd29, 0xb4a7, 0xbcc8, 0xcd8c, 0x83c9, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 
	0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0xef10, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x08c4, 0x9ccc, 0xa4a9, 0x9c26, 0x9407, 0x9c6a, 
	0x92e5, 0x9263, 0x9263, 0x9a84, 0x9ae6, 0x8245, 0x6162, 0x4080, 0x3020, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 0x40c0, 
	0x5981, 0x6a01, 0x7a42, 0x7264, 0x6a65, 0x59e4, 0x38e1, 0x1800, 0x1000, 0x1000, 0x2860, 0x8b07, 0xbc8d, 0x93ab, 0x49c6, 0x0801, 
	0x0022, 0x0864, 0x0064, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0022, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x1021, 
	0x2060, 0x3040, 0x4880, 0x6182, 0x9307, 0xb44a, 0x6a45, 0x2060, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1840, 0x38c0, 
	0x5182, 0x6a03, 0x69e2, 0x69e3, 0x61e4, 0x4122, 0x2860, 0x2020, 0x1800, 0x2000, 0x2000, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x3020, 0x4880, 0x79a1, 0x9263, 0x9263, 0x9263, 
	0xcdad, 0xbd2a, 0xb4c8, 0xb467, 0xbd0a, 0x9c8b, 0x3185, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 
	0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x08a4, 0x3a06, 0xad0c, 0x9c06, 0x9c68, 0x8be7, 0xa4cb, 
	0x9b06, 0x9263, 0x9263, 0x9284, 0x9ac6, 0x7a04, 0x5101, 0x3860, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 0x40c0, 
	0x5961, 0x69e1, 0x7a42, 0x7a64, 0x6a65, 0x5a04, 0x3901, 0x1800, 0x1000, 0x1000, 0x2860, 0x82e7, 0xb48d, 0x93ab, 0x49c6, 0x0801, 
	0x0022, 0x0863, 0x0064, 0x0044, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0043, 0x0043, 0x0043, 0x0042, 0x0022, 0x1021, 
	0x2040, 0x3040, 0x4880, 0x6182, 0x9307, 0xb42b, 0x6a44, 0x1840, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1840, 0x38c0, 
	0x5182, 0x6203, 0x69e2, 0x69e3, 0x61e4, 0x4122, 0x2881, 0x2020, 0x1800, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1800, 
	0x1800, 0x1820, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 0x1800, 0x2000, 0x2000, 0x2800, 0x3820, 0x6120, 0x8a22, 0x9263, 0x9263, 
	0x9b05, 0xc52b, 0xbd09, 0xac46, 0xac88, 0xbd4b, 0x8c09, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 
	0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0xef10, 0xef10, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0xef10, 
	0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x1904, 0x946b, 0xa4a9, 0x9be5, 0x9448, 0x8c08, 0x9326, 
	0x9284, 0x9263, 0x9263, 0x9284, 0x9285, 0x69a3, 0x48c0, 0x3040, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 0x40c0, 
	0x5981, 0x69e1, 0x7a42, 0x7a64, 0x7265, 0x6205, 0x3901, 0x1820, 0x1000, 0x1000, 0x2840, 0x82e7, 0xb48d, 0x93ac, 0x49e6, 0x0001, 
	0x0022, 0x0863, 0x0064, 0x0044, 0x0043, 0x0023, 0x0043, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0043, 0x0042, 0x0022, 0x0022, 0x1021, 
	0x2061, 0x3040, 0x4080, 0x6162, 0x8ae7, 0xb40a, 0x6224, 0x1840, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1840, 0x30c0, 
	0x5182, 0x6a03, 0x69e2, 0x69e3, 0x61e4, 0x4923, 0x3081, 0x2020, 0x1800, 0x1820, 0x2000, 0x2000, 0x2000, 0x2020, 0x2000, 0x1800, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 0x1820, 0x1800, 0x1800, 0x2000, 0x2800, 0x3000, 0x50a0, 0x79a0, 0x9263, 0x9263, 
	0x9263, 0xc56c, 0xbd2a, 0xac67, 0xa426, 0xb4ca, 0xa48b, 0x2985, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0xef10, 0x0083, 
	0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0xef10, 0xef10, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x08a3, 0x3a06, 0xa4cb, 0x9c26, 0x9c47, 0x8bc7, 0x946a, 0x92c4, 
	0x9263, 0x9263, 0x9a83, 0x9a84, 0x8224, 0x6142, 0x4080, 0x2820, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 0x40c0, 
	0x5960, 0x69e1, 0x7a42, 0x7a84, 0x7265, 0x6205, 0x3901, 0x1820, 0x1000, 0x1000, 0x2840, 0x82c7, 0xb46c, 0x8b8b, 0x49c6, 0x0001, 
	0x0002, 0x0043, 0x0044, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0043, 0x0042, 0x0022, 0x0022, 0x1041, 
	0x2861, 0x3040, 0x4060, 0x5941, 0x82a6, 0xabea, 0x6204, 0x1820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1840, 0x30c0, 
	0x5182, 0x6a03, 0x69e2, 0x69e3, 0x61e4, 0x4943, 0x3081, 0x2020, 0x1800, 0x1820, 0x1820, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 0x1820, 0x1800, 0x1800, 0x2000, 0x2000, 0x2800, 0x3840, 0x6120, 0x9263, 0x9263, 
	0x9263, 0xbd0c, 0xc56b, 0xb4a8, 0x9be6, 0x9c07, 0xacca, 0x8c09, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0xef10, 
	0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x2124, 0x8c09, 0xa469, 0x93c5, 0x9428, 0x83c7, 0xacec, 0x9ae5, 
	0x9263, 0x9263, 0x9a84, 0x9265, 0x79e4, 0x5901, 0x3840, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 0x40a0, 
	0x5960, 0x69e1, 0x7a42, 0x7a64, 0x7265, 0x6205, 0x3901, 0x1820, 0x1000, 0x1000, 0x2840, 0x7ac6, 0xac2c, 0x836b, 0x41a6, 0x0001, 
	0x0002, 0x0043, 0x0043, 0x0044, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0043, 0x0042, 0x0022, 0x0022, 0x1041, 
	0x2061, 0x3040, 0x4060, 0x5121, 0x8286, 0xa3aa, 0x5a04, 0x1820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x1840, 0x30c0, 
	0x51a2, 0x6a23, 0x69e2, 0x69e3, 0x61e4, 0x4943, 0x30a1, 0x2020, 0x1800, 0x1820, 0x1820, 0x2020, 0x2000, 0x2000, 0x2000, 0x2000, 
	0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 0x1820, 0x1800, 0x1800, 0x1800, 0x2000, 0x2800, 0x3020, 0x50a0, 0x81e2, 0x9263, 
	0x9263, 0x9b26, 0xbd2b, 0xb4ea, 0x93e6, 0x8b66, 0x93e8, 0x9429, 0x2144, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0xef10, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 
	0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x08a3, 0x31a5, 0x83c8, 0x8bc7, 0x8bc7, 0x83a7, 0x942a, 0x9b67, 0x9284, 
	0x9263, 0x9a63, 0xa2c5, 0x9265, 0x71a3, 0x48c0, 0x3020, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 0x40a0, 
	0x5960, 0x69e1, 0x7a42, 0x7a64, 0x6a65, 0x5a04, 0x3901, 0x1840, 0x1000, 0x1000, 0x2040, 0x7286, 0xa3eb, 0x834a, 0x41a6, 0x0001, 
	0x0001, 0x0023, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0043, 0x0043, 0x0042, 0x0042, 0x0022, 0x1041, 
	0x2061, 0x2840, 0x3860, 0x5121, 0x7a66, 0x9b69, 0x59c4, 0x1820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x1840, 0x30c0, 
	0x59a2, 0x6a24, 0x69e2, 0x69e3, 0x61e4, 0x4943, 0x30a1, 0x2020, 0x1800, 0x1820, 0x1820, 0x1800, 0x2000, 0x2000, 0x2020, 0x2020, 
	0x2020, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1800, 0x1800, 0x2000, 0x2000, 0x2800, 0x3860, 0x6940, 0x9263, 
	0x9263, 0x9263, 0xb4aa, 0xb4ea, 0x93c7, 0x7b05, 0x8325, 0x9c49, 0x9c6a, 0x08a3, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 
	0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x2965, 0x7368, 0x8367, 0x7305, 0x7b47, 0x7b67, 0xa4cb, 0x9284, 0x9263, 
	0x9263, 0xa284, 0xa2c6, 0x8a25, 0x6142, 0x4080, 0x3000, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2820, 0x40a0, 
	0x5961, 0x69e1, 0x7242, 0x7264, 0x6a44, 0x5a04, 0x3921, 0x2040, 0x1000, 0x1000, 0x2020, 0x6a45, 0x93aa, 0x7b2a, 0x4185, 0x0001, 
	0x0001, 0x0023, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0063, 0x0063, 0x0043, 0x0043, 0x0043, 0x0022, 0x0842, 
	0x2061, 0x2840, 0x3860, 0x4901, 0x6a25, 0x8b08, 0x5184, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x1840, 0x30c0, 
	0x59a3, 0x6a24, 0x69e2, 0x69e3, 0x61e4, 0x4943, 0x30a1, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2020, 0x2020, 0x2020, 
	0x1820, 0x1820, 0x1820, 0x1820, 0x1800, 0x1800, 0x1820, 0x1820, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x3040, 0x50c0, 0x81c1, 
	0x9243, 0x9263, 0x9b46, 0xac69, 0x9c28, 0x8366, 0x8345, 0x93e7, 0xaccb, 0x2965, 0x08a3, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 
	0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 
	0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x08c3, 0x3a06, 0x83a8, 0x8366, 0x7b46, 0x7306, 0x83c8, 0x9b67, 0x9264, 0x9263, 
	0x9263, 0xa264, 0x9a85, 0x79c3, 0x50c1, 0x3840, 0x2800, 0x2800, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2800, 0x40a0, 
	0x5961, 0x69e1, 0x7222, 0x7263, 0x6a44, 0x6204, 0x3921, 0x2040, 0x1000, 0x0800, 0x1820, 0x6224, 0x8b69, 0x72e9, 0x3985, 0x0001, 
	0x0001, 0x0022, 0x0023, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0022, 0x0841, 
	0x1841, 0x2020, 0x3040, 0x40c0, 0x61c4, 0x7aa7, 0x4143, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x1840, 0x30c0, 
	0x51a2, 0x6a24, 0x69e2, 0x6a03, 0x6204, 0x4963, 0x30a1, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2020, 0x1820, 
	0x1820, 0x1820, 0x1820, 0x1820, 0x1800, 0x1800, 0x1820, 0x1820, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 0x2820, 0x3840, 0x6100, 
	0x9243, 0x9263, 0x9263, 0xac29, 0xacca, 0x9c28, 0x93a6, 0x8b85, 0xa469, 0xacab, 0x1904, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 
	0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x31c5, 0x8be9, 0x8bc7, 0x8366, 0x7b87, 0x7b68, 0x9c8b, 0x9263, 0x9263, 0x9263, 
	0x9a84, 0xa265, 0x8a04, 0x6122, 0x3840, 0x3000, 0x2800, 0x2820, 0x2820, 0x3020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2000, 0x2020, 0x2020, 0x2020, 0x2000, 0x2000, 0x2800, 0x38a0, 
	0x5961, 0x69e1, 0x7222, 0x7264, 0x7264, 0x6224, 0x4122, 0x2040, 0x1000, 0x0800, 0x1800, 0x59e4, 0x7b08, 0x6aa8, 0x3965, 0x0801, 
	0x0001, 0x0022, 0x0023, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0023, 0x0043, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0022, 0x0841, 
	0x1840, 0x2020, 0x2820, 0x3080, 0x5163, 0x6a46, 0x3922, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1840, 0x30c0, 
	0x5182, 0x6a03, 0x69e2, 0x6a03, 0x6a04, 0x4963, 0x30a1, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 
	0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1800, 0x1800, 0x1820, 0x1800, 0x1800, 0x2800, 0x48a0, 
	0x9243, 0x9263, 0x9263, 0x9b46, 0xac89, 0xacaa, 0x9be7, 0x9385, 0x93a6, 0xacab, 0x2985, 0x0883, 0x0083, 0x0083, 0x0083, 0xef10, 
	0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x08a3, 0x4a46, 0x9408, 0x8ba7, 0x8387, 0x7b87, 0x8c09, 0x9b87, 0x9263, 0x9263, 0x9263, 
	0xa2a5, 0x9265, 0x7183, 0x48a0, 0x3000, 0x2800, 0x2800, 0x2820, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x1800, 0x1800, 0x2020, 0x2020, 0x2000, 0x2000, 0x2800, 0x38a0, 
	0x5961, 0x69c2, 0x7222, 0x7264, 0x7265, 0x6224, 0x4142, 0x2060, 0x1000, 0x0800, 0x1000, 0x49a3, 0x72c8, 0x6268, 0x3145, 0x0821, 
	0x0002, 0x0022, 0x0023, 0x0023, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0022, 0x0042, 0x0042, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0821, 
	0x1840, 0x1800, 0x2820, 0x30a0, 0x4963, 0x59e5, 0x3102, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0800, 0x1840, 0x30c0, 
	0x5182, 0x61e3, 0x69e2, 0x6a03, 0x6a04, 0x5163, 0x30a1, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 
	0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1800, 0x1800, 0x1800, 0x1820, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x2000, 0x3840, 
	0x71a1, 0x9243, 0x9263, 0x9263, 0xa3e8, 0xaceb, 0xa469, 0x9be7, 0x8b85, 0x9c08, 0xa4ab, 0x2965, 0x0883, 0x0083, 0x0083, 0xef10, 
	0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0xef10, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x08a3, 0x4a67, 0x9c29, 0x93e7, 0x8ba6, 0x83a7, 0x83c9, 0xa46a, 0x9263, 0x9263, 0x9263, 0x9a84, 
	0x9aa5, 0x8204, 0x5901, 0x4060, 0x2800, 0x2800, 0x2800, 0x2820, 0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2000, 0x1800, 0x1800, 0x2020, 0x2020, 0x2000, 0x2000, 0x2800, 0x38a0, 
	0x5962, 0x69e3, 0x7223, 0x7224, 0x6a44, 0x6224, 0x4142, 0x2880, 0x1000, 0x0800, 0x1000, 0x4163, 0x6267, 0x5227, 0x3125, 0x0822, 
	0x0002, 0x0022, 0x0023, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0022, 0x0042, 0x0042, 0x0022, 0x0022, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0821, 
	0x1020, 0x1800, 0x2020, 0x30a0, 0x4143, 0x51a4, 0x30e2, 0x0820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1840, 0x30c0, 
	0x5161, 0x61e3, 0x69c2, 0x6a03, 0x6204, 0x5163, 0x38c1, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 
	0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1800, 0x1800, 0x1800, 0x1820, 0x1800, 0x1800, 0x1800, 0x1000, 0x1000, 0x1800, 0x2820, 
	0x4880, 0x79c1, 0x9243, 0x9263, 0x9b06, 0xa449, 0xacca, 0xa427, 0x93a6, 0x8b85, 0x9c69, 0x9c8a, 0x2984, 0x0883, 0x0083, 0x0083, 
	0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x08a3, 0x4a46, 0x944a, 0x9c07, 0x93c6, 0x83a7, 0x83a8, 0x942a, 0xa3a7, 0x9263, 0x9263, 0x9263, 0x9aa5, 
	0x8a45, 0x6983, 0x48a0, 0x3020, 0x2800, 0x2800, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 0x3020, 0x2820, 0x2820, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x1800, 0x1800, 0x1820, 0x2020, 0x2000, 0x2000, 0x2800, 0x38a0, 
	0x5982, 0x69e3, 0x7223, 0x6a03, 0x6a24, 0x6224, 0x4962, 0x28a0, 0x1000, 0x0800, 0x1000, 0x3902, 0x5a06, 0x49c6, 0x2904, 0x0822, 
	0x0002, 0x0022, 0x0023, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0821, 
	0x1020, 0x1820, 0x2840, 0x30a1, 0x4123, 0x4984, 0x28c2, 0x0820, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1820, 0x38c0, 
	0x5161, 0x61c2, 0x61e2, 0x69e3, 0x61e4, 0x5183, 0x38c1, 0x2020, 0x1800, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1800, 0x1820, 0x1820, 0x1820, 0x1820, 0x1820, 0x1000, 0x1000, 0x2000, 0x2800, 
	0x3820, 0x58e0, 0x8a23, 0x9263, 0x9263, 0x9b05, 0xa428, 0xaca9, 0x9c07, 0x8b65, 0x8b86, 0xa4ca, 0x8c09, 0x2964, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0xef10, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x4a46, 0x944a, 0x9c28, 0x9be6, 0x8bc6, 0x83a7, 0x8ba7, 0x9b67, 0x9263, 0x9263, 0x9263, 0x9a84, 0x9a85, 
	0x79e4, 0x5101, 0x3860, 0x3000, 0x2800, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x2820, 
	0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x1800, 0x1800, 0x1800, 0x1820, 0x2000, 0x2000, 0x2820, 0x40c0, 
	0x5962, 0x69c3, 0x7203, 0x6a03, 0x6a24, 0x6a24, 0x4982, 0x30c0, 0x1000, 0x0800, 0x0800, 0x30e2, 0x49a5, 0x4186, 0x20e4, 0x0822, 
	0x0002, 0x0022, 0x0023, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0043, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0042, 0x0042, 0x0841, 
	0x1040, 0x1820, 0x2840, 0x30c1, 0x4123, 0x4164, 0x28a1, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1840, 0x38c0, 
	0x4961, 0x59c2, 0x61c2, 0x61c3, 0x61c4, 0x59a4, 0x4102, 0x2840, 0x1820, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x1800, 0x1820, 0x1820, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 0x1800, 0x1800, 0x1800, 0x1820, 0x1800, 0x1800, 0x2000, 0x2800, 
	0x3000, 0x4060, 0x79a1, 0x9243, 0x9263, 0x9263, 0xa366, 0xb50b, 0xa468, 0x93a6, 0x8324, 0x93e8, 0xa4aa, 0x39c5, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 
	0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x62e7, 0x9c69, 0x93e6, 0x93e7, 0x8bc7, 0x8be8, 0x9bc7, 0x9263, 0x9263, 0x9263, 0x9a84, 0x9a85, 0x8204, 
	0x6142, 0x4080, 0x3020, 0x2800, 0x2820, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2000, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2020, 0x3060, 0x40e0, 
	0x5142, 0x5982, 0x61a2, 0x61a2, 0x61c3, 0x61e3, 0x5183, 0x38e1, 0x1840, 0x0800, 0x0800, 0x28c2, 0x3964, 0x3145, 0x20c3, 0x0022, 
	0x0002, 0x0022, 0x0043, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0023, 0x0022, 0x0022, 0x0023, 0x0023, 
	0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0044, 0x0043, 0x0043, 0x0842, 0x0842, 
	0x1841, 0x2040, 0x2860, 0x30c1, 0x3903, 0x4123, 0x2081, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1000, 0x2060, 0x38e0, 
	0x4941, 0x5982, 0x5981, 0x59a2, 0x59a3, 0x59a4, 0x4943, 0x30a1, 0x2040, 0x1820, 0x1800, 0x1800, 0x1800, 0x2000, 0x2020, 0x1820, 
	0x1820, 0x1820, 0x1820, 0x1820, 0x1800, 0x1800, 0x1800, 0x1820, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 
	0x2800, 0x3000, 0x4860, 0x8a02, 0x9263, 0x9263, 0x9b05, 0xac6a, 0xb50b, 0x9c27, 0x8b85, 0x8345, 0x9c49, 0x9c4a, 0x39e5, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 
	0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0xef10, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x5ae7, 0x9c6a, 0x93e6, 0x93e6, 0x8ba7, 0x83c8, 0x9408, 0x9b87, 0x9263, 0x9263, 0x9263, 0xaae6, 0x9245, 0x7182, 
	0x50c0, 0x3840, 0x3000, 0x2800, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2000, 0x1800, 0x1800, 0x1800, 0x2000, 0x2820, 0x38a0, 0x40e1, 
	0x4921, 0x5141, 0x5141, 0x5141, 0x5981, 0x59a1, 0x5182, 0x4122, 0x28a1, 0x1820, 0x1000, 0x2081, 0x3103, 0x2904, 0x18a3, 0x0022, 
	0x0002, 0x0022, 0x0043, 0x0043, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0043, 0x0043, 0x0023, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0044, 0x0043, 0x0043, 0x0842, 0x0842, 
	0x1841, 0x2060, 0x2880, 0x30c1, 0x38e2, 0x3902, 0x1860, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1840, 0x28a0, 0x3900, 
	0x4100, 0x40e0, 0x4900, 0x4920, 0x4921, 0x5163, 0x4943, 0x38e2, 0x2881, 0x1820, 0x1800, 0x1800, 0x1800, 0x2000, 0x2020, 0x2020, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1820, 0x2020, 0x2020, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 
	0x2820, 0x3000, 0x4040, 0x7181, 0x9243, 0x9263, 0x9263, 0x9ae5, 0xac8a, 0xacaa, 0x9c07, 0x8345, 0x8366, 0x9c4a, 0x944a, 0x4226, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 
	0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0xef10, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x5ae7, 0x9c6a, 0x93e6, 0x93c6, 0x8bc7, 0x83a7, 0x93c8, 0x9b46, 0x9263, 0x9263, 0x9263, 0x9a84, 0x9a85, 0x79c3, 0x5901, 
	0x4080, 0x3020, 0x3000, 0x3040, 0x3860, 0x3040, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x2840, 0x38c0, 0x4101, 
	0x4900, 0x4900, 0x48e0, 0x48e0, 0x4900, 0x4900, 0x4962, 0x4963, 0x3923, 0x2082, 0x1020, 0x1861, 0x20c2, 0x20e3, 0x1883, 0x0022, 
	0x0002, 0x0022, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 
	0x0043, 0x0023, 0x0022, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0842, 0x0842, 
	0x1841, 0x2060, 0x2880, 0x30a1, 0x30c1, 0x30e2, 0x1840, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0820, 0x1860, 0x30c0, 0x38e0, 
	0x38c0, 0x38a0, 0x40c0, 0x40c0, 0x40e0, 0x4901, 0x4122, 0x3902, 0x2881, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 0x2000, 
	0x2020, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x1800, 0x2000, 0x2020, 0x2020, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 
	0x2840, 0x3040, 0x3860, 0x4060, 0x79a1, 0x9263, 0x9263, 0x9263, 0x9ae5, 0xb54c, 0x9c48, 0x93c7, 0x8325, 0x8b87, 0x9c6a, 0x946a, 
	0x5266, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 
	0xef10, 0x0083, 0x0083, 0xef10, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x08a3, 
	0x62e7, 0x9449, 0x93e6, 0x93c5, 0x93e7, 0x83a7, 0x8c29, 0x9346, 0x9263, 0x9263, 0x9263, 0x9a84, 0x9aa6, 0x8204, 0x6142, 0x48a0, 
	0x3840, 0x3840, 0x3860, 0x40c0, 0x48e1, 0x40a1, 0x3840, 0x3020, 0x3000, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 0x3020, 
	0x3020, 0x3020, 0x2820, 0x2820, 0x2820, 0x2820, 0x2020, 0x2020, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x2840, 0x30a0, 0x40e0, 
	0x4900, 0x4900, 0x4900, 0x4900, 0x48e0, 0x40e0, 0x4941, 0x4983, 0x3924, 0x20a2, 0x1020, 0x1841, 0x1882, 0x18a3, 0x1062, 0x0022, 
	0x0002, 0x0022, 0x0043, 0x0043, 0x0023, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0023, 0x0043, 0x0043, 
	0x0043, 0x0022, 0x0022, 0x0023, 0x0023, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0842, 0x0842, 
	0x1841, 0x2060, 0x2880, 0x2880, 0x28a1, 0x28c1, 0x1840, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1840, 0x2880, 0x30a0, 
	0x38a0, 0x38c0, 0x40e0, 0x40e0, 0x40e0, 0x40e1, 0x38c1, 0x30a1, 0x2060, 0x1820, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 
	0x2000, 0x2020, 0x2020, 0x2020, 0x2020, 0x2000, 0x1800, 0x2000, 0x2020, 0x2020, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x2000, 
	0x3080, 0x38a0, 0x40a0, 0x3860, 0x48a0, 0x79c1, 0x9263, 0x9263, 0x92c4, 0xac8a, 0xb50b, 0x9c48, 0x93c6, 0x8345, 0x8ba7, 0x9c69, 
	0x944a, 0x4a46, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0xef10, 
	0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 
	0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0xef10, 0x0083, 0x0083, 0x0083, 0x0083, 
	